/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NullAppendable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil
extends FileUtilRt {
    public static final int REGEX_PATTERN_FLAGS;
    public static final TObjectHashingStrategy<String> PATH_HASHING_STRATEGY;
    public static final TObjectHashingStrategy<File> FILE_HASHING_STRATEGY;
    private static final Logger LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] loadFileBytes(@NotNull File file) throws IOException {
        byte[] bytes;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "loadFileBytes"));
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            long len = file.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (FileUtil.isTooLarge((long)len)) {
                throw new FileTooBigException("Attempt to load '" + file + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        finally {
            ((InputStream)stream).close();
        }
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadFileBytes"));
        }
        return bytes;
    }

    public static boolean delete(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "delete"));
        }
        if (FileUtilRt.NIOReflect.IS_AVAILABLE) {
            return FileUtil.deleteRecursivelyNIO(file);
        }
        return FileUtil.deleteRecursively(file);
    }

    private static boolean deleteRecursively(@NotNull File file) {
        File[] files;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "deleteRecursively"));
        }
        FileAttributes attributes = FileSystemUtil.getAttributes(file);
        if (attributes == null) {
            return true;
        }
        if (attributes.isDirectory() && !attributes.isSymLink() && (files = file.listFiles()) != null) {
            for (File child : files) {
                if (FileUtil.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtil.deleteFile(file);
    }

    public static boolean createParentDirs(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "createParentDirs"));
        }
        return FileUtilRt.createParentDirs(file);
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtil", "createDirectory"));
        }
        return FileUtilRt.createDirectory(path);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "ensureCanCreateFile"));
        }
        return FileUtilRt.ensureCanCreateFile(file);
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/FileUtil", "copy"));
        }
        if (outputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/intellij/openapi/util/io/FileUtil", "copy"));
        }
        FileUtilRt.copy(inputStream, outputStream);
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aFileName", "com/intellij/openapi/util/io/FileUtil", "toSystemDependentName"));
        }
        String string = FileUtilRt.toSystemDependentName(aFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "toSystemDependentName"));
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aFileName", "com/intellij/openapi/util/io/FileUtil", "toSystemIndependentName"));
        }
        String string = FileUtilRt.toSystemIndependentName(aFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "toSystemIndependentName"));
        }
        return string;
    }

    @Contract(value="null -> null")
    public static String toCanonicalPath(@Nullable String path) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true);
    }

    @Contract(value="null, _, _ -> null")
    private static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash) {
        return FileUtil.toCanonicalPath(path, separatorChar, removeLastSlash, false);
    }

    @Contract(value="null, _, _, _ -> null")
    private static String toCanonicalPath(@Nullable String path, final char separatorChar, final boolean removeLastSlash, boolean resolveSymlinks) {
        char next;
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (StringUtil.startsWithChar(path, '.')) {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/' || c == separatorChar) {
                path = path.substring(2);
            }
        }
        path = path.replace(separatorChar, '/');
        int index = -1;
        do {
            char c = next = (index = path.indexOf(47, index + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index + 1);
        } while (next != '.' && next != '/' && index != -1);
        if (index == -1) {
            if (removeLastSlash) {
                int start = FileUtil.processRoot(path, NullAppendable.INSTANCE);
                int slashIndex = path.lastIndexOf(47);
                return slashIndex != -1 && slashIndex > start ? StringUtil.trimEnd(path, '/') : path;
            }
            return path;
        }
        final String finalPath = path;
        NotNullProducer<String> realCanonicalPath = resolveSymlinks ? new NotNullProducer<String>(){

            @Override
            @NotNull
            public String produce() {
                String string;
                try {
                    string = new File(finalPath).getCanonicalPath().replace(separatorChar, '/');
                }
                catch (IOException ignore) {
                    String string2 = FileUtil.access$000((String)finalPath, (char)separatorChar, (boolean)removeLastSlash, (boolean)false);
                    if (string2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil$4", "produce"));
                    }
                    return string2;
                }
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil$4", "produce"));
                }
                return string;
            }
        } : null;
        StringBuilder result = new StringBuilder(path.length());
        int start = FileUtil.processRoot(path, result);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    if (!FileUtil.processDots(result, dots, start, resolveSymlinks)) {
                        return (String)realCanonicalPath.produce();
                    }
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result.append('.');
                }
                separator = false;
                continue;
            }
            if (dots > 0) {
                StringUtil.repeatSymbol(result, '.', dots);
                dots = 0;
            }
            result.append(c);
            separator = false;
        }
        if (dots > 0 && !FileUtil.processDots(result, dots, start, resolveSymlinks)) {
            return (String)realCanonicalPath.produce();
        }
        int lastChar = result.length() - 1;
        if (removeLastSlash && lastChar >= 0 && result.charAt(lastChar) == '/' && lastChar > start) {
            result.deleteCharAt(lastChar);
        }
        return result.toString();
    }

    private static int processRoot(@NotNull String path, @NotNull Appendable result) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtil", "processRoot"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/util/io/FileUtil", "processRoot"));
        }
        try {
            if (SystemInfo.isWindows && path.length() > 1 && path.charAt(0) == '/' && path.charAt(1) == '/') {
                int shareStart;
                int hostStart;
                result.append("//");
                for (hostStart = 2; hostStart < path.length() && path.charAt(hostStart) == '/'; ++hostStart) {
                }
                if (hostStart == path.length()) {
                    return hostStart;
                }
                int hostEnd = path.indexOf(47, hostStart);
                if (hostEnd < 0) {
                    hostEnd = path.length();
                }
                result.append(path, hostStart, hostEnd);
                result.append('/');
                for (shareStart = hostEnd; shareStart < path.length() && path.charAt(shareStart) == '/'; ++shareStart) {
                }
                if (shareStart == path.length()) {
                    return shareStart;
                }
                int shareEnd = path.indexOf(47, shareStart);
                if (shareEnd < 0) {
                    shareEnd = path.length();
                }
                result.append(path, shareStart, shareEnd);
                result.append('/');
                return shareEnd;
            }
            if (!path.isEmpty() && path.charAt(0) == '/') {
                result.append('/');
                return 1;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
                result.append(path, 0, 3);
                return 3;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    @Contract(value="_, _, _, false -> true")
    private static boolean processDots(@NotNull StringBuilder result, int dots, int start, boolean resolveSymlinks) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/util/io/FileUtil", "processDots"));
        }
        if (dots == 2) {
            int pos = -1;
            if (!StringUtil.endsWith(result, "/../") && !StringUtil.equals(result, "../")) {
                pos = StringUtil.lastIndexOf(result, '/', start, result.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                if (resolveSymlinks && FileSystemUtil.isSymLink(new File(result.toString()))) {
                    return false;
                }
                result.delete(pos, result.length());
            } else {
                result.append("../");
            }
        } else if (dots != 1) {
            StringUtil.repeatSymbol(result, '.', dots);
            result.append('/');
        }
        return true;
    }

    @NotNull
    public static String unquote(@NotNull String urlString) {
        if (urlString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlString", "com/intellij/openapi/util/io/FileUtil", "unquote"));
        }
        urlString = urlString.replace('/', File.separatorChar);
        String string = URLUtil.unescapePercentSequences(urlString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "unquote"));
        }
        return string;
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        return FileUtil.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtil.toCanonicalPath(path1);
        path2 = FileUtil.toCanonicalPath(path2);
        return PATH_HASHING_STRATEGY.equals(path1, path2);
    }

    public static int fileHashCode(@Nullable File file) {
        return FileUtil.pathHashCode(file == null ? null : file.getPath());
    }

    public static int pathHashCode(@Nullable String path) {
        return StringUtil.isEmpty(path) ? 0 : PATH_HASHING_STRATEGY.computeHashCode(FileUtil.toCanonicalPath(path));
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        FileUtil.writeToFile(file, text, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text, boolean append) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        FileUtil.writeToFile(file, text, 0, text.length, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(@NotNull File file, @NotNull byte[] text, int off, int len, boolean append) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        FileUtil.createParentDirs(file);
        FileOutputStream stream = new FileOutputStream(file, append);
        try {
            ((OutputStream)stream).write(text, off, len);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    @NotNull
    public static String expandUserHome(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtil", "expandUserHome"));
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "expandUserHome"));
        }
        return string;
    }

    @NotNull
    public static String getTempDirectory() {
        String string = FileUtilRt.getTempDirectory();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "getTempDirectory"));
        }
        return string;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtil", "loadBytes"));
        }
        byte[] byArray = FileUtilRt.loadBytes(stream);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadBytes"));
        }
        return byArray;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtil", "loadBytes"));
        }
        byte[] byArray = FileUtilRt.loadBytes(stream, length);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadBytes"));
        }
        return byArray;
    }

    static {
        boolean bl = $assertionsDisabled = !FileUtil.class.desiredAssertionStatus();
        if (!Patches.USE_REFLECTION_TO_ACCESS_JDK7) {
            throw new RuntimeException("Please migrate FileUtilRt to JDK8");
        }
        REGEX_PATTERN_FLAGS = SystemInfo.isFileSystemCaseSensitive ? 0 : 2;
        PATH_HASHING_STRATEGY = FilePathHashingStrategy.create();
        FILE_HASHING_STRATEGY = SystemInfo.isFileSystemCaseSensitive ? ContainerUtil.canonicalStrategy() : new TObjectHashingStrategy<File>(){

            @Override
            public int computeHashCode(File object) {
                return FileUtil.fileHashCode(object);
            }

            @Override
            public boolean equals(File o1, File o2) {
                return FileUtil.filesEqual(o1, o2);
            }
        };
        LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileUtil");
    }
}

