/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ID<K, V> {
    private static final ConcurrentIntObjectMap<ID> ourRegistry = ContainerUtil.createConcurrentIntObjectMap();
    private static final TObjectIntHashMap<String> ourNameToIdRegistry = new TObjectIntHashMap();

    private static File getEnumFile() {
        File indexFolder = PathManager.getIndexRoot();
        return new File(indexFolder, "indices.enum");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEnumFile() {
        try {
            File f = ID.getEnumFile();
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            try {
                final String[] names = new String[ourNameToIdRegistry.size()];
                ourNameToIdRegistry.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String key, int value) {
                        names[value - 1] = key;
                        return true;
                    }
                });
                for (String name : names) {
                    w.write(name);
                    w.newLine();
                }
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File indices = ID.getEnumFile();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(indices));
            TObjectIntHashMap<String> nameToIdRegistry = new TObjectIntHashMap<String>();
            try {
                int cnt = 0;
                while (true) {
                    ++cnt;
                    String name = reader.readLine();
                    if (name == null) {
                        break;
                    }
                    nameToIdRegistry.put(name, cnt);
                }
            }
            finally {
                reader.close();
            }
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.ensureCapacity(nameToIdRegistry.size());
                nameToIdRegistry.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String name, int index) {
                        ourNameToIdRegistry.put(name, index);
                        return true;
                    }
                });
            }
        }
        catch (IOException e) {
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.clear();
                ID.writeEnumFile();
            }
        }
    }
}

