/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Iterators;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import java.io.File;
import java.util.Iterator;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.EnumConstant;
import lombok.ast.Expression;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeDeclaration;
import lombok.ast.VariableReference;

public class JavaContext
extends Context {
    static final String SUPPRESS_COMMENT_PREFIX = "//noinspection ";
    @Deprecated
    private Node compilationUnit;
    private PsiJavaFile javaFile;
    private final JavaParser parser;
    private boolean testSource;

    public JavaContext(LintDriver driver, Project project, Project main, File file, JavaParser parser) {
        super(driver, project, main, file);
        this.parser = parser;
    }

    public Location getLocation(Node node) {
        return this.parser.getLocation(this, node);
    }

    public Location getRangeLocation(Node from, int fromDelta, Node to, int toDelta) {
        return this.parser.getRangeLocation(this, from, fromDelta, to, toDelta);
    }

    public Location getRangeLocation(PsiElement from, int fromDelta, PsiElement to, int toDelta) {
        return this.parser.getRangeLocation(this, from, fromDelta, to, toDelta);
    }

    public Location getRangeLocation(PsiElement from, int fromDelta, int length) {
        return this.parser.getRangeLocation(this, from, fromDelta, fromDelta + length);
    }

    public Location getNameLocation(Node node) {
        return this.parser.getNameLocation(this, node);
    }

    public Location getNameLocation(PsiElement element) {
        if (element instanceof PsiSwitchStatement) {
            return this.parser.getRangeLocation(this, element, 0, 6);
        }
        return this.parser.getNameLocation(this, element);
    }

    public Location getLocation(PsiElement node) {
        return this.parser.getLocation(this, node);
    }

    public JavaParser getParser() {
        return this.parser;
    }

    public JavaEvaluator getEvaluator() {
        return this.parser.getEvaluator();
    }

    public Node getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(Node compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public PsiJavaFile getJavaFile() {
        return this.javaFile;
    }

    public void setJavaFile(PsiJavaFile javaFile) {
        this.javaFile = javaFile;
    }

    @Override
    public void report(Issue issue, Location location, String message) {
        if (this.driver.isSuppressed(this, issue, (PsiElement)this.javaFile)) {
            return;
        }
        super.report(issue, location, message);
    }

    public void report(Issue issue, Node scope, Location location, String message) {
        if (scope != null && this.driver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message);
    }

    public void report(Issue issue, PsiElement scope, Location location, String message) {
        if (scope != null && this.driver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message);
    }

    @Deprecated
    public void report(Issue issue, Node scope, Location location, String message, Object data) {
        this.report(issue, scope, location, message);
    }

    @Deprecated
    public static Node findSurroundingMethod(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == MethodDeclaration.class || type == ConstructorDeclaration.class) {
                return scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Deprecated
    public static ClassDeclaration findSurroundingClass(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == ClassDeclaration.class) {
                return (ClassDeclaration)scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Override
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    @Deprecated
    public boolean isSuppressedWithComment(Node scope, Issue issue) {
        CharSequence contents = this.getContents();
        assert (contents != null);
        Position position = scope.getPosition();
        if (position == null) {
            return false;
        }
        int start = position.getStart();
        return this.isSuppressedWithComment(start, issue);
    }

    public boolean isSuppressedWithComment(PsiElement scope, Issue issue) {
        CharSequence contents = this.getContents();
        assert (contents != null);
        TextRange textRange = scope.getTextRange();
        if (textRange == null) {
            return false;
        }
        int start = textRange.getStartOffset();
        return this.isSuppressedWithComment(start, issue);
    }

    @Deprecated
    public Location.Handle createLocationHandle(Node node) {
        return this.parser.createLocationHandle(this, node);
    }

    @Deprecated
    public JavaParser.ResolvedNode resolve(Node node) {
        return this.parser.resolve(this, node);
    }

    @Deprecated
    public JavaParser.ResolvedClass findClass(String fullyQualifiedName) {
        return this.parser.findClass(this, fullyQualifiedName);
    }

    @Deprecated
    public JavaParser.TypeDescriptor getType(Node node) {
        return this.parser.getType(this, node);
    }

    @Deprecated
    public static String getMethodName(Node call) {
        if (call instanceof MethodInvocation) {
            return ((MethodInvocation)call).astName().astValue();
        }
        if (call instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)call).astTypeReference().getTypeName();
        }
        if (call instanceof EnumConstant) {
            return ((EnumConstant)call).astName().astValue();
        }
        return null;
    }

    public static String getMethodName(PsiElement call) {
        if (call instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)call).getMethodExpression().getReferenceName();
        }
        if (call instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)call).getClassReference();
            if (classReference != null) {
                return classReference.getReferenceName();
            }
            return null;
        }
        if (call instanceof PsiEnumConstant) {
            return ((PsiEnumConstant)call).getName();
        }
        return null;
    }

    @Deprecated
    public static Node findNameNode(Node node) {
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).astName();
        }
        if (node instanceof MethodDeclaration) {
            return ((MethodDeclaration)node).astMethodName();
        }
        if (node instanceof ConstructorDeclaration) {
            return ((ConstructorDeclaration)node).astTypeName();
        }
        if (node instanceof MethodInvocation) {
            return ((MethodInvocation)node).astName();
        }
        if (node instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)node).astTypeReference();
        }
        if (node instanceof EnumConstant) {
            return ((EnumConstant)node).astName();
        }
        if (node instanceof AnnotationElement) {
            return ((AnnotationElement)node).astName();
        }
        if (node instanceof AnnotationMethodDeclaration) {
            return ((AnnotationMethodDeclaration)node).astMethodName();
        }
        if (node instanceof VariableReference) {
            return ((VariableReference)node).astIdentifier();
        }
        if (node instanceof LabelledStatement) {
            return ((LabelledStatement)node).astLabel();
        }
        return null;
    }

    public static PsiElement findNameElement(PsiElement element) {
        if (element instanceof PsiClass) {
            if (element instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)element).getBaseClassReference();
            }
            return ((PsiClass)element).getNameIdentifier();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getNameIdentifier();
        }
        if (element instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)element).getMethodExpression().getReferenceNameElement();
        }
        if (element instanceof PsiNewExpression) {
            return ((PsiNewExpression)element).getClassReference();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getNameIdentifier();
        }
        if (element instanceof PsiAnnotation) {
            return ((PsiAnnotation)element).getNameReferenceElement();
        }
        if (element instanceof PsiReferenceExpression) {
            return ((PsiReferenceExpression)element).getReferenceNameElement();
        }
        if (element instanceof PsiLabeledStatement) {
            return ((PsiLabeledStatement)element).getLabelIdentifier();
        }
        return null;
    }

    @Deprecated
    public static Iterator<Expression> getParameters(Node call) {
        if (call instanceof MethodInvocation) {
            return ((MethodInvocation)call).astArguments().iterator();
        }
        if (call instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)call).astArguments().iterator();
        }
        if (call instanceof EnumConstant) {
            return ((EnumConstant)call).astArguments().iterator();
        }
        return Iterators.emptyIterator();
    }

    @Deprecated
    public static Node getParameter(Node call, int parameter) {
        Iterator<Expression> iterator = JavaContext.getParameters(call);
        for (int i = 0; i < parameter - 1; ++i) {
            if (!iterator.hasNext()) {
                return null;
            }
            iterator.next();
        }
        return iterator.hasNext() ? (Node)iterator.next() : null;
    }

    @Deprecated
    public boolean isContextMethod(MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedClass containingClass;
        JavaParser.ResolvedNode resolved = this.resolve((Node)node);
        return resolved instanceof JavaParser.ResolvedMethod && (containingClass = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf("android.content.Context", false);
    }

    @Deprecated
    public static <T extends Node> T getParentOfType(Node element, Class<T> clz) {
        return JavaContext.getParentOfType(element, clz, true);
    }

    @Deprecated
    public static <T extends Node> T getParentOfType(Node element, Class<T> clz, boolean strict) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null) {
            if (clz.isInstance(element)) {
                return (T)element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Deprecated
    public static <T extends Node> T getParentOfType(Node element, Class<T> clz, boolean strict, Class<? extends Node> ... terminators) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null && !clz.isInstance(element)) {
            for (Class<? extends Node> terminator : terminators) {
                if (!terminator.isInstance(element)) continue;
                return null;
            }
            element = element.getParent();
        }
        return (T)element;
    }

    @Deprecated
    public static <T extends Node> T getNextSiblingOfType(Node sibling, Class<T> clz) {
        if (sibling == null) {
            return null;
        }
        Node parent = sibling.getParent();
        if (parent == null) {
            return null;
        }
        Iterator iterator = parent.getChildren().iterator();
        while (iterator.hasNext() && iterator.next() != sibling) {
        }
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (!clz.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Deprecated
    public static Node getArgumentNode(MethodInvocation call, int index) {
        int i = 0;
        for (Expression parameter : call.astArguments()) {
            if (i == index) {
                return parameter;
            }
            ++i;
        }
        throw new IllegalArgumentException(Integer.toString(index));
    }

    public boolean isTestSource() {
        return this.testSource;
    }

    public void setTestSource(boolean testSource) {
        this.testSource = testSource;
    }
}

