/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.Nullable;
import com.android.tools.lint.checks.Api;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiClass {
    private final String mName;
    private final int mSince;
    private final List<Pair<String, Integer>> mSuperClasses = Lists.newArrayList();
    private final List<Pair<String, Integer>> mInterfaces = Lists.newArrayList();
    private final Map<String, Integer> mFields = new HashMap<String, Integer>();
    private final Map<String, Integer> mMethods = new HashMap<String, Integer>();

    ApiClass(String name, int since) {
        this.mName = name;
        this.mSince = since;
    }

    String getName() {
        return this.mName;
    }

    int getSince() {
        return this.mSince;
    }

    Integer getField(String name, Api info) {
        int tmp;
        ApiClass superClass;
        int min = Integer.MAX_VALUE;
        Integer i = this.mFields.get(name);
        if (i != null) {
            min = i;
        }
        for (Pair<String, Integer> superClassPair : this.mSuperClasses) {
            superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null || (i = superClass.getField(name, info)) == null || (tmp = ((Integer)superClassPair.getSecond() > i ? (Integer)superClassPair.getSecond() : i).intValue()) >= min) continue;
            min = tmp;
        }
        for (Pair<String, Integer> superClassPair : this.mInterfaces) {
            superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null || (i = superClass.getField(name, info)) == null || (tmp = ((Integer)superClassPair.getSecond() > i ? (Integer)superClassPair.getSecond() : i).intValue()) >= min) continue;
            min = tmp;
        }
        return min;
    }

    int getMethod(String methodSignature, Api info) {
        int tmp;
        ApiClass superClass;
        int min = Integer.MAX_VALUE;
        Integer i = this.mMethods.get(methodSignature);
        if (i != null) {
            min = i;
            if (methodSignature.startsWith("<init>")) {
                return i;
            }
        }
        for (Pair<String, Integer> superClassPair : this.mSuperClasses) {
            superClass = info.getClass((String)superClassPair.getFirst());
            if (superClass == null || (i = Integer.valueOf(superClass.getMethod(methodSignature, info))) == null || (tmp = ((Integer)superClassPair.getSecond() > i ? (Integer)superClassPair.getSecond() : i).intValue()) >= min) continue;
            min = tmp;
        }
        for (Pair<String, Integer> interfacePair : this.mInterfaces) {
            superClass = info.getClass((String)interfacePair.getFirst());
            if (superClass == null || (i = Integer.valueOf(superClass.getMethod(methodSignature, info))) == null || (tmp = ((Integer)interfacePair.getSecond() > i ? (Integer)interfacePair.getSecond() : i).intValue()) >= min) continue;
            min = tmp;
        }
        return min;
    }

    void addField(String name, int since) {
        Integer i = this.mFields.get(name);
        if (i == null || i > since) {
            this.mFields.put(name, since);
        }
    }

    void addMethod(String name, int since) {
        Integer i;
        int index = name.indexOf(41);
        if (index != -1) {
            name = name.substring(0, index + 1);
        }
        if ((i = this.mMethods.get(name)) == null || i > since) {
            this.mMethods.put(name, since);
        }
    }

    void addSuperClass(String superClass, int since) {
        this.addToArray(this.mSuperClasses, superClass, since);
    }

    void addInterface(String interfaceClass, int since) {
        this.addToArray(this.mInterfaces, interfaceClass, since);
    }

    void addToArray(List<Pair<String, Integer>> list, String name, int value) {
        for (Pair<String, Integer> pair : list) {
            if (!name.equals(pair.getFirst())) continue;
            return;
        }
        list.add((Pair<String, Integer>)Pair.of((Object)name, (Object)value));
    }

    @Nullable
    public String getPackage() {
        int index = this.mName.lastIndexOf(47);
        if (index != -1) {
            return this.mName.substring(0, index);
        }
        return null;
    }

    public String toString() {
        return this.mName;
    }

    Set<String> getAllMethods(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllMethods(info, members, true);
        return members;
    }

    private void addAllMethods(Api info, Set<String> set, boolean includeConstructors) {
        ApiClass clz;
        if (!includeConstructors) {
            for (String string : this.mMethods.keySet()) {
                if (string.startsWith("<init>")) continue;
                set.add(string);
            }
        } else {
            for (String string : this.mMethods.keySet()) {
                set.add(string);
            }
        }
        for (Pair pair : this.mSuperClasses) {
            clz = info.getClass((String)pair.getFirst());
            assert (clz != null) : (Integer)pair.getSecond();
            if (clz == null) continue;
            clz.addAllMethods(info, set, false);
        }
        for (Pair pair : this.mInterfaces) {
            clz = info.getClass((String)pair.getFirst());
            assert (clz != null) : (Integer)pair.getSecond();
            if (clz == null) continue;
            clz.addAllMethods(info, set, false);
        }
    }

    Set<String> getAllFields(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllFields(info, members);
        return members;
    }

    private void addAllFields(Api info, Set<String> set) {
        ApiClass clz;
        for (String string : this.mFields.keySet()) {
            set.add(string);
        }
        for (Pair pair : this.mSuperClasses) {
            clz = info.getClass((String)pair.getFirst());
            assert (clz != null) : (Integer)pair.getSecond();
            if (clz == null) continue;
            clz.addAllFields(info, set);
        }
        for (Pair pair : this.mInterfaces) {
            clz = info.getClass((String)pair.getFirst());
            assert (clz != null) : (Integer)pair.getSecond();
            if (clz == null) continue;
            clz.addAllFields(info, set);
        }
    }
}

