/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.prefs.AndroidLocation;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.ArraySizeDetector;
import com.android.tools.lint.checks.ButtonDetector;
import com.android.tools.lint.checks.ChildCountDetector;
import com.android.tools.lint.checks.CleanupDetector;
import com.android.tools.lint.checks.ColorUsageDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.DetectMissingPrefix;
import com.android.tools.lint.checks.DosLineEndingDetector;
import com.android.tools.lint.checks.DuplicateIdDetector;
import com.android.tools.lint.checks.DuplicateResourceDetector;
import com.android.tools.lint.checks.ExtraTextDetector;
import com.android.tools.lint.checks.FieldGetterDetector;
import com.android.tools.lint.checks.FragmentDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.HandlerDetector;
import com.android.tools.lint.checks.HardcodedDebugModeDetector;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.InvalidPackageDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.JavaScriptInterfaceDetector;
import com.android.tools.lint.checks.LabelForDetector;
import com.android.tools.lint.checks.LayoutConsistencyDetector;
import com.android.tools.lint.checks.LocaleDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.ManifestTypoDetector;
import com.android.tools.lint.checks.MathDetector;
import com.android.tools.lint.checks.MergeRootFrameLayoutDetector;
import com.android.tools.lint.checks.MissingClassDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.NestedScrollingWidgetDetector;
import com.android.tools.lint.checks.NonInternationalizedSmsDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.OnClickDetector;
import com.android.tools.lint.checks.OverdrawDetector;
import com.android.tools.lint.checks.OverrideDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.checks.PluralsDetector;
import com.android.tools.lint.checks.PrivateKeyDetector;
import com.android.tools.lint.checks.PrivateResourceDetector;
import com.android.tools.lint.checks.ProguardDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.RegistrationDetector;
import com.android.tools.lint.checks.RequiredAttributeDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SdCardDetector;
import com.android.tools.lint.checks.SecureRandomDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.ServiceCastDetector;
import com.android.tools.lint.checks.SetJavaScriptEnabledDetector;
import com.android.tools.lint.checks.SharedPrefsDetector;
import com.android.tools.lint.checks.StateListDetector;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.checks.StyleCycleDetector;
import com.android.tools.lint.checks.SystemPermissionsDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TitleDetector;
import com.android.tools.lint.checks.ToastDetector;
import com.android.tools.lint.checks.TooManyViewsDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UseCompoundDrawableDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.ViewConstructorDetector;
import com.android.tools.lint.checks.ViewTagDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.checks.WakelockDetector;
import com.android.tools.lint.checks.WrongCallDetector;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.checks.WrongIdDetector;
import com.android.tools.lint.checks.WrongImportDetector;
import com.android.tools.lint.checks.WrongLocationDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BuiltinIssueRegistry
extends IssueRegistry {
    private static final String LINT_FOLDER = "lint";
    private static final String MF_LINT_REGISTRY = "Lint-Registry";
    private static final List<Issue> sIssues;
    private static Set<Issue> sAdtFixes;

    @NonNull
    public List<Issue> getIssues() {
        return sIssues;
    }

    private static void addCustomIssues(List<Issue> issues) {
        String lintClassPath;
        HashSet<Object> files = null;
        try {
            File[] list;
            File lint = new File(AndroidLocation.getFolder() + File.separator + LINT_FOLDER);
            if (lint.exists() && (list = lint.listFiles()) != null) {
                for (File jarFile : list) {
                    if (!LintUtils.endsWith((String)jarFile.getName(), (String)".jar")) continue;
                    if (files == null) {
                        files = new HashSet<Object>();
                    }
                    files.add(jarFile);
                    BuiltinIssueRegistry.addIssuesFromJar(jarFile, issues);
                }
            }
        }
        catch (AndroidLocation.AndroidLocationException e) {
            // empty catch block
        }
        if ((lintClassPath = System.getenv("ANDROID_LINT_JARS")) != null && !lintClassPath.isEmpty()) {
            String[] paths = lintClassPath.split(File.pathSeparator);
            for (String path : paths) {
                File jarFile = new File(path);
                if (!jarFile.exists() || files != null && files.contains(jarFile)) continue;
                BuiltinIssueRegistry.addIssuesFromJar(jarFile, issues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addIssuesFromJar(File jarFile, List<Issue> issues) {
        block17: {
            JarFile jarfile = null;
            try {
                jarfile = new JarFile(jarFile);
                Manifest manifest = jarfile.getManifest();
                Attributes attrs = manifest.getMainAttributes();
                Object object = attrs.get(new Attributes.Name(MF_LINT_REGISTRY));
                if (!(object instanceof String)) break block17;
                String className = (String)object;
                try {
                    URL url = jarFile.toURI().toURL();
                    URLClassLoader loader = new URLClassLoader(new URL[]{url}, BuiltinIssueRegistry.class.getClassLoader());
                    try {
                        Class<?> registryClass = Class.forName(className, true, loader);
                        IssueRegistry registry = (IssueRegistry)registryClass.newInstance();
                        for (Issue issue : registry.getIssues()) {
                            issues.add(issue);
                        }
                    }
                    catch (Throwable e) {
                        BuiltinIssueRegistry.log(e);
                    }
                }
                catch (MalformedURLException e) {
                    BuiltinIssueRegistry.log(e);
                }
            }
            catch (IOException e) {
                BuiltinIssueRegistry.log(e);
            }
            finally {
                if (jarfile != null) {
                    try {
                        jarfile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void log(Throwable e) {
        e.printStackTrace();
    }

    @Beta
    public boolean hasAutoFix(String tool, Issue issue) {
        assert (tool.equals("adt"));
        return BuiltinIssueRegistry.getIssuesWithFixes().contains(issue);
    }

    private static Set<Issue> getIssuesWithFixes() {
        if (sAdtFixes == null) {
            sAdtFixes = Sets.newHashSetWithExpectedSize((int)25);
            sAdtFixes.add(InefficientWeightDetector.INEFFICIENT_WEIGHT);
            sAdtFixes.add(AccessibilityDetector.ISSUE);
            sAdtFixes.add(InefficientWeightDetector.BASELINE_WEIGHTS);
            sAdtFixes.add(HardcodedValuesDetector.ISSUE);
            sAdtFixes.add(UselessViewDetector.USELESS_LEAF);
            sAdtFixes.add(UselessViewDetector.USELESS_PARENT);
            sAdtFixes.add(PxUsageDetector.PX_ISSUE);
            sAdtFixes.add(TextFieldDetector.ISSUE);
            sAdtFixes.add(SecurityDetector.EXPORTED_SERVICE);
            sAdtFixes.add(DetectMissingPrefix.MISSING_NAMESPACE);
            sAdtFixes.add(ScrollViewChildDetector.ISSUE);
            sAdtFixes.add(ObsoleteLayoutParamsDetector.ISSUE);
            sAdtFixes.add(TypographyDetector.DASHES);
            sAdtFixes.add(TypographyDetector.ELLIPSIS);
            sAdtFixes.add(TypographyDetector.FRACTIONS);
            sAdtFixes.add(TypographyDetector.OTHER);
            sAdtFixes.add(TypographyDetector.QUOTES);
            sAdtFixes.add(UseCompoundDrawableDetector.ISSUE);
            sAdtFixes.add(ApiDetector.UNSUPPORTED);
            sAdtFixes.add(ApiDetector.INLINED);
            sAdtFixes.add(TypoDetector.ISSUE);
            sAdtFixes.add(ManifestDetector.ALLOW_BACKUP);
            sAdtFixes.add(MissingIdDetector.ISSUE);
            sAdtFixes.add(TranslationDetector.MISSING);
            sAdtFixes.add(DosLineEndingDetector.ISSUE);
        }
        return sAdtFixes;
    }

    public static void reset() {
        IssueRegistry.reset();
    }

    static {
        int initialCapacity = 157;
        ArrayList<Issue> issues = new ArrayList<Issue>(157);
        issues.add(AccessibilityDetector.ISSUE);
        issues.add(LabelForDetector.ISSUE);
        issues.add(MathDetector.ISSUE);
        issues.add(FieldGetterDetector.ISSUE);
        issues.add(SdCardDetector.ISSUE);
        issues.add(ApiDetector.UNSUPPORTED);
        issues.add(ApiDetector.INLINED);
        issues.add(ApiDetector.OVERRIDE);
        issues.add(InvalidPackageDetector.ISSUE);
        issues.add(DuplicateIdDetector.CROSS_LAYOUT);
        issues.add(DuplicateIdDetector.WITHIN_LAYOUT);
        issues.add(DuplicateResourceDetector.ISSUE);
        issues.add(WrongIdDetector.UNKNOWN_ID);
        issues.add(WrongIdDetector.UNKNOWN_ID_LAYOUT);
        issues.add(WrongIdDetector.NOT_SIBLING);
        issues.add(WrongIdDetector.INVALID);
        issues.add(LayoutConsistencyDetector.INCONSISTENT_IDS);
        issues.add(StateListDetector.ISSUE);
        issues.add(StyleCycleDetector.ISSUE);
        issues.add(InefficientWeightDetector.INEFFICIENT_WEIGHT);
        issues.add(InefficientWeightDetector.NESTED_WEIGHTS);
        issues.add(InefficientWeightDetector.BASELINE_WEIGHTS);
        issues.add(InefficientWeightDetector.WRONG_0DP);
        issues.add(InefficientWeightDetector.ORIENTATION);
        issues.add(ScrollViewChildDetector.ISSUE);
        issues.add(DeprecationDetector.ISSUE);
        issues.add(ObsoleteLayoutParamsDetector.ISSUE);
        issues.add(MergeRootFrameLayoutDetector.ISSUE);
        issues.add(NestedScrollingWidgetDetector.ISSUE);
        issues.add(ChildCountDetector.SCROLLVIEW_ISSUE);
        issues.add(ChildCountDetector.ADAPTER_VIEW_ISSUE);
        issues.add(UseCompoundDrawableDetector.ISSUE);
        issues.add(UselessViewDetector.USELESS_PARENT);
        issues.add(UselessViewDetector.USELESS_LEAF);
        issues.add(TooManyViewsDetector.TOO_MANY);
        issues.add(TooManyViewsDetector.TOO_DEEP);
        issues.add(GridLayoutDetector.ISSUE);
        issues.add(OverrideDetector.ISSUE);
        issues.add(OnClickDetector.ISSUE);
        issues.add(ViewTagDetector.ISSUE);
        issues.add(LocaleDetector.STRING_LOCALE);
        issues.add(LocaleDetector.DATE_FORMAT);
        issues.add(RegistrationDetector.ISSUE);
        issues.add(MissingClassDetector.MISSING);
        issues.add(MissingClassDetector.INSTANTIATABLE);
        issues.add(MissingClassDetector.INNERCLASS);
        issues.add(MissingIdDetector.ISSUE);
        issues.add(WrongCaseDetector.WRONG_CASE);
        issues.add(HandlerDetector.ISSUE);
        issues.add(FragmentDetector.ISSUE);
        issues.add(TranslationDetector.EXTRA);
        issues.add(TranslationDetector.MISSING);
        issues.add(PluralsDetector.MISSING);
        issues.add(PluralsDetector.EXTRA);
        issues.add(HardcodedValuesDetector.ISSUE);
        issues.add(Utf8Detector.ISSUE);
        issues.add(DosLineEndingDetector.ISSUE);
        issues.add(CommentDetector.EASTER_EGG);
        issues.add(CommentDetector.STOP_SHIP);
        issues.add(ProguardDetector.WRONG_KEEP);
        issues.add(ProguardDetector.SPLIT_CONFIG);
        issues.add(PxUsageDetector.PX_ISSUE);
        issues.add(PxUsageDetector.DP_ISSUE);
        issues.add(PxUsageDetector.IN_MM_ISSUE);
        issues.add(PxUsageDetector.SMALL_SP_ISSUE);
        issues.add(TextFieldDetector.ISSUE);
        issues.add(TextViewDetector.ISSUE);
        issues.add(TextViewDetector.SELECTABLE);
        issues.add(UnusedResourceDetector.ISSUE);
        issues.add(UnusedResourceDetector.ISSUE_IDS);
        issues.add(ExtraTextDetector.ISSUE);
        issues.add(PrivateResourceDetector.ISSUE);
        issues.add(ArraySizeDetector.INCONSISTENT);
        issues.add(HardcodedDebugModeDetector.ISSUE);
        issues.add(ManifestDetector.ORDER);
        issues.add(ManifestDetector.USES_SDK);
        issues.add(ManifestDetector.MULTIPLE_USES_SDK);
        issues.add(ManifestDetector.WRONG_PARENT);
        issues.add(ManifestDetector.DUPLICATE_ACTIVITY);
        issues.add(ManifestDetector.TARGET_NEWER);
        issues.add(ManifestDetector.ALLOW_BACKUP);
        issues.add(ManifestDetector.UNIQUE_PERMISSION);
        issues.add(ManifestDetector.SET_VERSION);
        issues.add(ManifestDetector.ILLEGAL_REFERENCE);
        issues.add(ManifestDetector.DUPLICATE_USES_FEATURE);
        issues.add(ManifestDetector.APPLICATION_ICON);
        issues.add(ManifestDetector.DEVICE_ADMIN);
        issues.add(ManifestTypoDetector.ISSUE);
        issues.add(SecurityDetector.EXPORTED_PROVIDER);
        issues.add(SecurityDetector.EXPORTED_SERVICE);
        issues.add(SecurityDetector.EXPORTED_RECEIVER);
        issues.add(SecurityDetector.OPEN_PROVIDER);
        issues.add(SecurityDetector.WORLD_READABLE);
        issues.add(SecurityDetector.WORLD_WRITEABLE);
        issues.add(SecureRandomDetector.ISSUE);
        issues.add(IconDetector.GIF_USAGE);
        issues.add(IconDetector.ICON_DENSITIES);
        issues.add(IconDetector.ICON_MISSING_FOLDER);
        issues.add(IconDetector.ICON_DIP_SIZE);
        issues.add(IconDetector.ICON_EXPECTED_SIZE);
        issues.add(IconDetector.ICON_LOCATION);
        issues.add(IconDetector.DUPLICATES_NAMES);
        issues.add(IconDetector.DUPLICATES_CONFIGURATIONS);
        issues.add(IconDetector.ICON_NODPI);
        issues.add(IconDetector.ICON_MIX_9PNG);
        issues.add(IconDetector.ICON_EXTENSION);
        issues.add(IconDetector.ICON_COLORS);
        issues.add(IconDetector.ICON_XML_AND_PNG);
        issues.add(IconDetector.ICON_LAUNCHER_SHAPE);
        issues.add(TypographyDetector.DASHES);
        issues.add(TypographyDetector.QUOTES);
        issues.add(TypographyDetector.FRACTIONS);
        issues.add(TypographyDetector.ELLIPSIS);
        issues.add(TypographyDetector.OTHER);
        issues.add(ButtonDetector.ORDER);
        issues.add(ButtonDetector.CASE);
        issues.add(ButtonDetector.BACK_BUTTON);
        issues.add(ButtonDetector.STYLE);
        issues.add(DetectMissingPrefix.MISSING_NAMESPACE);
        issues.add(OverdrawDetector.ISSUE);
        issues.add(StringFormatDetector.INVALID);
        issues.add(StringFormatDetector.ARG_COUNT);
        issues.add(StringFormatDetector.ARG_TYPES);
        issues.add(TypoDetector.ISSUE);
        issues.add(ViewTypeDetector.ISSUE);
        issues.add(ServiceCastDetector.ISSUE);
        issues.add(ParcelDetector.ISSUE);
        issues.add(WrongImportDetector.ISSUE);
        issues.add(WrongLocationDetector.ISSUE);
        issues.add(ViewConstructorDetector.ISSUE);
        issues.add(NamespaceDetector.CUSTOM_VIEW);
        issues.add(NamespaceDetector.UNUSED);
        issues.add(NamespaceDetector.TYPO);
        issues.add(NamespaceDetector.RES_AUTO);
        issues.add(AlwaysShowActionDetector.ISSUE);
        issues.add(TitleDetector.ISSUE);
        issues.add(ColorUsageDetector.ISSUE);
        issues.add(JavaPerformanceDetector.PAINT_ALLOC);
        issues.add(JavaPerformanceDetector.USE_VALUE_OF);
        issues.add(JavaPerformanceDetector.USE_SPARSE_ARRAY);
        issues.add(WakelockDetector.ISSUE);
        issues.add(CleanupDetector.RECYCLE_RESOURCE);
        issues.add(CleanupDetector.COMMIT_FRAGMENT);
        issues.add(SetJavaScriptEnabledDetector.ISSUE);
        issues.add(JavaScriptInterfaceDetector.ISSUE);
        issues.add(ToastDetector.ISSUE);
        issues.add(SharedPrefsDetector.ISSUE);
        issues.add(CutPasteDetector.ISSUE);
        issues.add(NonInternationalizedSmsDetector.ISSUE);
        issues.add(PrivateKeyDetector.ISSUE);
        issues.add(AnnotationDetector.ISSUE);
        issues.add(SystemPermissionsDetector.ISSUE);
        issues.add(RequiredAttributeDetector.ISSUE);
        issues.add(WrongCallDetector.ISSUE);
        issues.add(RtlDetector.COMPAT);
        issues.add(RtlDetector.ENABLED);
        issues.add(RtlDetector.USE_START);
        assert (157 >= issues.size()) : issues.size();
        BuiltinIssueRegistry.addCustomIssues(issues);
        sIssues = Collections.unmodifiableList(issues);
        if (LintUtils.assertionsEnabled()) {
            HashSet<String> ids = new HashSet<String>();
            for (Issue issue : sIssues) {
                String id = issue.getId();
                assert (!ids.contains(id)) : "Duplicate id " + id;
                ids.add(id);
            }
        }
    }
}

