/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import org.objectweb.asm.tree.ClassNode;

public class HandlerDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"HandlerLeak", (String)"Handler reference leaks", (String)"Ensures that Handler classes do not hold on to a reference to an outer class", (String)"In Android, Handler classes should be static or leaks might occur. Messages enqueued on the application thread's MessageQueue also retain their target Handler. If the Handler is an inner class, its outer class will be retained as well. To avoid leaking the outer class, declare the Handler as a static nested class with a WeakReference to its outer class.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, (Implementation)new Implementation(HandlerDetector.class, Scope.CLASS_FILE_SCOPE));

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if (classNode.name.indexOf(36) == -1) {
            return;
        }
        if (context.getDriver().isSubclassOf(classNode, "android/os/Handler") && !LintUtils.isStaticInnerClass((ClassNode)classNode)) {
            Location location = context.getLocation(classNode);
            context.report(ISSUE, location, String.format("This Handler class should be static or leaks might occur (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
        }
    }
}

