/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class ParcelDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"ParcelCreator", (String)"Missing Parcelable `CREATOR` field", (String)"Checks that classes implementing `Parcelable` also provide a `CREATOR` field", (String)"According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.", (Category)Category.USABILITY, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(ParcelDetector.class, Scope.CLASS_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcelable.html");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        List interfaces = classNode.interfaces;
        if (interfaces != null) {
            for (Object o : interfaces) {
                if (!"android/os/Parcelable".equals(o)) continue;
                if (this.hasCreatorField(context, classNode)) break;
                Location location = context.getLocation(classNode);
                context.report(ISSUE, location, "This class implements Parcelable but does not provide a CREATOR field", null);
                break;
            }
        }
    }

    private boolean hasCreatorField(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        List fields = classNode.fields;
        if (fields != null) {
            for (FieldNode field : fields) {
                if (!field.name.equals("CREATOR")) continue;
                String desc = field.desc;
                return true;
            }
        }
        return false;
    }
}

