/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.TextFormat;
import java.util.Arrays;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class AppCompatCallDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"AppCompatMethod", (String)"Using Wrong AppCompat Method", (String)"When using the appcompat library, there are some methods you should be calling instead of the normal ones; for example, `getSupportActionBar()` instead of `getActionBar()`. This lint check looks for calls to the wrong method.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(AppCompatCallDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/tools/support-library/index.html");
    private static final String GET_ACTION_BAR = "getActionBar";
    private static final String START_ACTION_MODE = "startActionMode";
    private static final String SET_PROGRESS_BAR_VIS = "setProgressBarVisibility";
    private static final String SET_PROGRESS_BAR_IN_VIS = "setProgressBarIndeterminateVisibility";
    private static final String SET_PROGRESS_BAR_INDETERMINATE = "setProgressBarIndeterminate";
    private static final String REQUEST_WINDOW_FEATURE = "requestWindowFeature";
    private static final String ERROR_MESSAGE_FORMAT = "Should use `%1$s` instead of `%2$s` name";
    private boolean mDependsOnAppCompat;

    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    public void beforeCheckProject(@NonNull Context context) {
        Boolean dependsOnAppCompat = context.getProject().dependsOn("com.android.support:appcompat-v7");
        this.mDependsOnAppCompat = dependsOnAppCompat != null && dependsOnAppCompat != false;
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(GET_ACTION_BAR, START_ACTION_MODE, SET_PROGRESS_BAR_VIS, SET_PROGRESS_BAR_IN_VIS, SET_PROGRESS_BAR_INDETERMINATE, REQUEST_WINDOW_FEATURE);
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        if (this.mDependsOnAppCompat && AppCompatCallDetector.isAppBarActivityCall(context, node)) {
            String name = node.astName().astValue();
            String replace = null;
            if (GET_ACTION_BAR.equals(name)) {
                replace = "getSupportActionBar";
            } else if (START_ACTION_MODE.equals(name)) {
                replace = "startSupportActionMode";
            } else if (SET_PROGRESS_BAR_VIS.equals(name)) {
                replace = "setSupportProgressBarVisibility";
            } else if (SET_PROGRESS_BAR_IN_VIS.equals(name)) {
                replace = "setSupportProgressBarIndeterminateVisibility";
            } else if (SET_PROGRESS_BAR_INDETERMINATE.equals(name)) {
                replace = "setSupportProgressBarIndeterminate";
            } else if (REQUEST_WINDOW_FEATURE.equals(name)) {
                replace = "supportRequestWindowFeature";
            }
            if (replace != null) {
                String message = String.format(ERROR_MESSAGE_FORMAT, replace, name);
                context.report(ISSUE, (Node)node, context.getLocation((Node)node), message);
            }
        }
    }

    private static boolean isAppBarActivityCall(@NonNull JavaContext context, @NonNull MethodInvocation node) {
        ClassDeclaration surroundingClass;
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedClass containingClass;
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (resolved instanceof JavaParser.ResolvedMethod && (containingClass = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf("android.app.Activity", false) && (surroundingClass = JavaContext.findSurroundingClass((Node)node)) != null) {
            JavaParser.ResolvedNode clz = context.resolve((Node)surroundingClass);
            return clz instanceof JavaParser.ResolvedClass && ((JavaParser.ResolvedClass)clz).isSubclassOf("android.support.v7.app.ActionBarActivity", false);
        }
        return false;
    }

    @Nullable
    public static String getOldCall(@NonNull String errorMessage, @NonNull TextFormat format) {
        return AppCompatCallDetector.getMessagePart(errorMessage, 2, format);
    }

    @Nullable
    public static String getNewCall(@NonNull String errorMessage, @NonNull TextFormat format) {
        return AppCompatCallDetector.getMessagePart(errorMessage, 1, format);
    }

    @Nullable
    private static String getMessagePart(@NonNull String errorMessage, int group, @NonNull TextFormat format) {
        List parameters = LintUtils.getFormattedParameters((String)TextFormat.RAW.convertTo(ERROR_MESSAGE_FORMAT, format), (String)errorMessage);
        if (parameters.size() == 2 && group <= 2) {
            return (String)parameters.get(group - 1);
        }
        return null;
    }
}

