/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class PrivateResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"PrivateResource", (String)"Using private resources", (String)"Private resources should not be referenced; the may not be present everywhere, and even where they are they may disappear without notice.\n\nTo fix this, copy the resource into your own project. You can find the platform resources under `$ANDROID_SK/platforms/android-$VERSION/data/res/.`", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.FATAL, (Implementation)new Implementation(PrivateResourceDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String value = attribute.getNodeValue();
        if (value.startsWith("@*android:")) {
            context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), "Illegal resource reference: `@*android` resources are private and not always present");
        }
    }
}

