/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.Revision;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GradleDetector
extends Detector
implements Detector.GradleScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
    public static final Issue DEPENDENCY = Issue.create((String)"GradleDependency", (String)"Obsolete Gradle Dependency", (String)"This detector looks for usages of libraries where the version you are using is not the current stable release. Using older versions is fine, and there are cases where you deliberately want to stick with an older version. However, you may simply not be aware that a more recent version is available, and that is what this lint check helps find.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue DEPRECATED = Issue.create((String)"GradleDeprecated", (String)"Deprecated Gradle Construct", (String)"This detector looks for deprecated Gradle constructs which currently work but will likely stop working in a future update.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue GRADLE_PLUGIN_COMPATIBILITY = Issue.create((String)"GradlePluginVersion", (String)"Incompatible Android Gradle Plugin", (String)"Not all versions of the Android Gradle plugin are compatible with all versions of the SDK. If you update your tools, or if you are trying to open a project that was built with an old version of the tools, you may need to update your plugin version number.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue PATH = Issue.create((String)"GradlePath", (String)"Gradle Path Issues", (String)"Gradle build scripts are meant to be cross platform, so file paths use Unix-style path separators (a forward slash) rather than Windows path separators (a backslash). Similarly, to keep projects portable and repeatable, avoid using absolute paths on the system; keep files within the project instead. To share code between projects, consider creating an android-library and an AAR dependency", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue IDE_SUPPORT = Issue.create((String)"GradleIdeError", (String)"Gradle IDE Support Issues", (String)"Gradle is highly flexible, and there are things you can do in Gradle files which can make it hard or impossible for IDEs to properly handle the project. This lint check looks for constructs that potentially break IDE support.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue PLUS = Issue.create((String)"GradleDynamicVersion", (String)"Gradle Dynamic Version", (String)"Using `+` in dependencies lets you automatically pick up the latest available version rather than a specific, named version. However, this is not recommended; your builds are not repeatable; you may have tested with a slightly different version than what the build server used. (Using a dynamic version as the major version number is more problematic than using it in the minor version position.)", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue GRADLE_GETTER = Issue.create((String)"GradleGetter", (String)"Gradle Implicit Getter Call", (String)"Gradle will let you replace specific constants in your build scripts with method calls, so you can for example dynamically compute a version string based on your current version control revision number, rather than hardcoding a number.\n\nWhen computing a version name, it's tempting to for example call the method to do that `getVersionName`. However, when you put that method call inside the `defaultConfig` block, you will actually be calling the Groovy getter for the `versionName` property instead. Therefore, you need to name your method something which does not conflict with the existing implicit getters. Consider using `compute` as a prefix instead of `get`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue COMPATIBILITY = Issue.create((String)"GradleCompatible", (String)"Incompatible Gradle Versions", (String)"There are some combinations of libraries, or tools and libraries, that are incompatible, or can lead to bugs. One such incompatibility is compiling with a version of the Android support libraries that is not the latest version (or in particular, a version lower than your `targetSdkVersion`.)", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue STRING_INTEGER = Issue.create((String)"StringShouldBeInt", (String)"String should be int", (String)"The properties `compileSdkVersion`, `minSdkVersion` and `targetSdkVersion` are usually numbers, but can be strings when you are using an add-on (in the case of `compileSdkVersion`) or a preview platform (for the other two properties).\n\nHowever, you can not use a number as a string (e.g. \"19\" instead of 19); that will result in a platform not found error message at build/sync time.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue NOT_INTERPOLATED = Issue.create((String)"NotInterpolated", (String)"Incorrect Interpolation", (String)"To insert the value of a variable, you can use `${variable}` inside a string literal, but *only* if you are using double quotes!", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("http://www.groovy-lang.org/syntax.html#_string_interpolation");
    public static final Issue REMOTE_VERSION = Issue.create((String)"NewerVersionAvailable", (String)"Newer Library Versions Available", (String)"This detector checks with a central repository to see if there are newer versions available for the dependencies used by this project. This is similar to the `GradleDependency` check, which checks for newer versions available in the Android SDK tools and libraries, but this works with any MavenCentral dependency, and connects to the library every time, which makes it more flexible but also *much* slower.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue ACCIDENTAL_OCTAL = Issue.create((String)"AccidentalOctal", (String)"Accidental Octal", (String)"In Groovy, an integer literal that starts with a leading 0 will be interpreted as an octal number. That is usually (always?) an accident and can lead to subtle bugs, for example when used in the `versionCode` of an app.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final String APP_PLUGIN_ID = "com.android.application";
    public static final String LIB_PLUGIN_ID = "com.android.library";
    public static final String OLD_APP_PLUGIN_ID = "android";
    public static final String OLD_LIB_PLUGIN_ID = "android-library";
    public static final String GMS_GROUP_ID = "com.google.android.gms";
    private int mMinSdkVersion;
    private int mCompileSdkVersion;
    private int mTargetSdkVersion;
    private static int sMajorBuildTools;
    private static Revision sLatestBuildTools;
    static Map<String, String> sMockData;
    private boolean mCheckedGms;

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public Speed getSpeed(Issue issue) {
        return issue == REMOTE_VERSION ? Speed.REALLY_SLOW : Speed.NORMAL;
    }

    public void visitBuildScript(Context context, Map<String, Object> sharedData) {
    }

    protected static boolean isInterestingBlock(String parent, String parentParent) {
        return parent.equals("defaultConfig") || parent.equals(OLD_APP_PLUGIN_ID) || parent.equals("dependencies") || parent.equals("repositories") || parentParent != null && parentParent.equals("buildTypes");
    }

    protected static boolean isInterestingStatement(String statement, String parent) {
        return parent == null && statement.equals("apply");
    }

    protected static boolean isInterestingProperty(String property, String parent, String parentParent) {
        return property.equals("targetSdkVersion") || property.equals("buildToolsVersion") || property.equals("versionName") || property.equals("versionCode") || property.equals("compileSdkVersion") || property.equals("minSdkVersion") || property.equals("applicationIdSuffix") || property.equals("packageName") || property.equals("packageNameSuffix") || parent.equals("dependencies");
    }

    protected void checkOctal(Context context, String value, Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || value.charAt(1) >= '8' && GradleDetector.isInteger(value)) && context.isEnabled(ACCIDENTAL_OCTAL)) {
            String message = "The leading 0 turns this number into octal which is probably not what was intended";
            try {
                long numericValue = Long.decode(value);
                message = message + " (interpreted as " + numericValue + ")";
            }
            catch (NumberFormatException nufe) {
                message = message + " (and it is not a valid octal number)";
            }
            this.report(context, cookie, ACCIDENTAL_OCTAL, message);
        }
    }

    protected void checkDslPropertyAssignment(Context context, String property, String value, String parent, String parentParent, Object valueCookie, Object statementCookie) {
        String suffix;
        if (parent.equals("defaultConfig")) {
            int version;
            if (property.equals("targetSdkVersion")) {
                version = GradleDetector.getIntLiteralValue(value, -1);
                if (version > 0 && version < context.getClient().getHighestKnownApiLevel()) {
                    String message = "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the android.os.Build.VERSION_CODES javadoc for details.";
                    this.report(context, valueCookie, ManifestDetector.TARGET_NEWER, message);
                }
                if (version > 0) {
                    this.mTargetSdkVersion = version;
                    this.checkTargetCompatibility(context, valueCookie);
                } else {
                    this.checkIntegerAsString(context, value, valueCookie);
                }
            } else if (property.equals("minSdkVersion")) {
                version = GradleDetector.getIntLiteralValue(value, -1);
                if (version > 0) {
                    this.mMinSdkVersion = version;
                } else {
                    this.checkIntegerAsString(context, value, valueCookie);
                }
            }
            if (value.startsWith("0")) {
                this.checkOctal(context, value, valueCookie);
            }
            if (property.equals("versionName") || property.equals("versionCode") && !GradleDetector.isInteger(value) || !GradleDetector.isStringLiteral(value)) {
                if (value.equals("getVersionCode") || value.equals("getVersionName")) {
                    String message = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                    this.report(context, valueCookie, GRADLE_GETTER, message);
                }
            } else if (property.equals("packageName")) {
                if (GradleDetector.isModelOlderThan011(context)) {
                    return;
                }
                String message = "Deprecated: Replace 'packageName' with 'applicationId'";
                this.report(context, this.getPropertyKeyCookie(valueCookie), DEPRECATED, message);
            }
        } else if (property.equals("compileSdkVersion") && parent.equals(OLD_APP_PLUGIN_ID)) {
            int version = GradleDetector.getIntLiteralValue(value, -1);
            if (version > 0) {
                this.mCompileSdkVersion = version;
                this.checkTargetCompatibility(context, valueCookie);
            } else {
                this.checkIntegerAsString(context, value, valueCookie);
            }
        } else if (property.equals("buildToolsVersion") && parent.equals(OLD_APP_PLUGIN_ID)) {
            Revision recommended;
            Revision version;
            String versionString = GradleDetector.getStringLiteralValue(value);
            if (versionString != null && (version = GradleDetector.parseRevisionSilently(versionString)) != null && (recommended = GradleDetector.getLatestBuildTools(context.getClient(), version.getMajor())) != null && version.compareTo(recommended) < 0) {
                String message = "Old buildToolsVersion " + version + "; recommended version is " + recommended + " or later";
                this.report(context, valueCookie, DEPENDENCY, message);
            }
        } else if (parent.equals("dependencies")) {
            if (value.startsWith("files('") && value.endsWith("')")) {
                String path = value.substring("files('".length(), value.length() - 2);
                if (path.contains("\\\\")) {
                    String message = "Do not use Windows file separators in .gradle files; use / instead";
                    this.report(context, valueCookie, PATH, message);
                } else if (new File(path.replace('/', File.separatorChar)).isAbsolute()) {
                    String message = "Avoid using absolute paths in .gradle files";
                    this.report(context, valueCookie, PATH, message);
                }
            } else {
                String dependency = GradleDetector.getStringLiteralValue(value);
                if (dependency == null) {
                    dependency = GradleDetector.getNamedDependency(value);
                }
                if (dependency != null) {
                    String message;
                    GradleCoordinate gc = GradleCoordinate.parseCoordinateString((String)dependency);
                    if (gc != null && dependency.contains("$")) {
                        if (value.startsWith("'") && value.endsWith("'") && context.isEnabled(NOT_INTERPOLATED)) {
                            message = "It looks like you are trying to substitute a version variable, but using single quotes ('). For Groovy string interpolation you must use double quotes (\").";
                            this.report(context, statementCookie, NOT_INTERPOLATED, message);
                        }
                        gc = GradleDetector.resolveCoordinate(context, gc);
                    }
                    if (gc != null) {
                        if (gc.acceptsGreaterRevisions()) {
                            message = "Avoid using + in version numbers; can lead to unpredictable and unrepeatable builds (" + dependency + ")";
                            this.report(context, valueCookie, PLUS, message);
                        }
                        if (!dependency.startsWith("com.android.tools.build:gradle:") || !this.checkGradlePluginDependency(context, gc, valueCookie)) {
                            this.checkDependency(context, gc, valueCookie);
                        }
                    }
                }
            }
        } else if (property.equals("packageNameSuffix")) {
            if (GradleDetector.isModelOlderThan011(context)) {
                return;
            }
            String message = "Deprecated: Replace 'packageNameSuffix' with 'applicationIdSuffix'";
            this.report(context, this.getPropertyKeyCookie(valueCookie), DEPRECATED, message);
        } else if (property.equals("applicationIdSuffix") && (suffix = GradleDetector.getStringLiteralValue(value)) != null && !suffix.startsWith(".")) {
            String message = "Package suffix should probably start with a \".\"";
            this.report(context, valueCookie, PATH, message);
        }
    }

    private static GradleCoordinate resolveCoordinate(Context context, GradleCoordinate gc) {
        assert (gc.getRevision().contains("$")) : gc.getRevision();
        Variant variant = context.getProject().getCurrentVariant();
        if (variant != null) {
            Dependencies dependencies = variant.getMainArtifact().getDependencies();
            for (AndroidLibrary library : dependencies.getLibraries()) {
                MavenCoordinates mc = library.getResolvedCoordinates();
                if (mc == null || !mc.getGroupId().equals(gc.getGroupId()) || !mc.getArtifactId().equals(gc.getArtifactId())) continue;
                List revisions = GradleCoordinate.parseRevisionNumber((String)mc.getVersion());
                if (revisions.isEmpty()) break;
                return new GradleCoordinate(mc.getGroupId(), mc.getArtifactId(), revisions, null);
            }
        }
        return null;
    }

    static String getNamedDependency(String expression) {
        if (expression.indexOf(44) != -1 && expression.contains("version:")) {
            String artifact = null;
            String group = null;
            String version = null;
            Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
            for (String property : splitter.split((CharSequence)expression)) {
                int valueEnd;
                int colon = property.indexOf(58);
                if (colon == -1) {
                    return null;
                }
                int quote = 39;
                int valueStart = property.indexOf(quote, colon + 1);
                if (valueStart == -1) {
                    quote = 34;
                    valueStart = property.indexOf(quote, colon + 1);
                }
                if (valueStart == -1) continue;
                if ((valueEnd = property.indexOf(quote, ++valueStart)) == -1) {
                    return null;
                }
                String value = property.substring(valueStart, valueEnd);
                if (property.startsWith("group:")) {
                    group = value;
                    continue;
                }
                if (property.startsWith("name:")) {
                    artifact = value;
                    continue;
                }
                if (!property.startsWith("version:")) continue;
                version = value;
            }
            if (artifact != null && group != null && version != null) {
                return group + ':' + artifact + ':' + version;
            }
        }
        return null;
    }

    private void checkIntegerAsString(Context context, String value, Object valueCookie) {
        String string = GradleDetector.getStringLiteralValue(value);
        if (GradleDetector.isNumberString(string)) {
            String quote = Character.toString(value.charAt(0));
            String message = String.format("Use an integer rather than a string here (replace %1$s%2$s%1$s with just %2$s)", quote, string);
            this.report(context, valueCookie, STRING_INTEGER, message);
        }
    }

    public static String getOldValue(Issue issue, String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        if (issue == DEPENDENCY) {
            if (errorMessage.startsWith("A newer ")) {
                return LintUtils.findSubstring((String)errorMessage, (String)" than ", (String)" ");
            }
            if (errorMessage.startsWith("Old buildToolsVersion ")) {
                return LintUtils.findSubstring((String)errorMessage, (String)"Old buildToolsVersion ", (String)";");
            }
            return LintUtils.findSubstring((String)errorMessage, (String)"targetSdkVersion (", (String)")");
        }
        if (issue == STRING_INTEGER) {
            return LintUtils.findSubstring((String)errorMessage, (String)"replace ", (String)" with ");
        }
        if (issue == DEPRECATED) {
            if (errorMessage.contains(APP_PLUGIN_ID) && errorMessage.contains(OLD_APP_PLUGIN_ID)) {
                return OLD_APP_PLUGIN_ID;
            }
            if (errorMessage.contains(LIB_PLUGIN_ID) && errorMessage.contains(OLD_LIB_PLUGIN_ID)) {
                return OLD_LIB_PLUGIN_ID;
            }
            return LintUtils.findSubstring((String)errorMessage, (String)"Replace '", (String)"'");
        }
        if (issue == PLUS) {
            return LintUtils.findSubstring((String)errorMessage, (String)"(", (String)")");
        }
        if (issue == COMPATIBILITY && errorMessage.startsWith("Version 5.2.08")) {
            return "5.2.08";
        }
        return null;
    }

    public static String getNewValue(Issue issue, String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        if (issue == DEPENDENCY) {
            if (errorMessage.startsWith("A newer ")) {
                return LintUtils.findSubstring((String)errorMessage, (String)" is available: ", null);
            }
            if (errorMessage.startsWith("Old buildToolsVersion ")) {
                return LintUtils.findSubstring((String)errorMessage, (String)" version is ", (String)" ");
            }
            return LintUtils.findSubstring((String)errorMessage, (String)"compileSdkVersion (", (String)")");
        }
        if (issue == STRING_INTEGER) {
            return LintUtils.findSubstring((String)errorMessage, (String)" just ", (String)")");
        }
        if (issue == DEPRECATED) {
            if (errorMessage.contains(APP_PLUGIN_ID) && errorMessage.contains(OLD_APP_PLUGIN_ID)) {
                return APP_PLUGIN_ID;
            }
            if (errorMessage.contains(LIB_PLUGIN_ID) && errorMessage.contains(OLD_LIB_PLUGIN_ID)) {
                return LIB_PLUGIN_ID;
            }
            return LintUtils.findSubstring((String)errorMessage, (String)" with '", (String)"'");
        }
        if (issue == COMPATIBILITY && errorMessage.startsWith("Version 5.2.08")) {
            return LintUtils.findSubstring((String)errorMessage, (String)"Use version ", (String)" ");
        }
        return null;
    }

    private static boolean isNumberString(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void checkMethodCall(Context context, String statement, String parent, Map<String, String> namedArguments, List<String> unnamedArguments, Object cookie) {
        boolean isOldAppPlugin;
        String plugin = namedArguments.get("plugin");
        if (statement.equals("apply") && parent == null && ((isOldAppPlugin = OLD_APP_PLUGIN_ID.equals(plugin)) || OLD_LIB_PLUGIN_ID.equals(plugin))) {
            String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
            String message = String.format("'%1$s' is deprecated; use '%2$s' instead", plugin, replaceWith);
            this.report(context, cookie, DEPRECATED, message);
        }
    }

    private static Revision parseRevisionSilently(String versionString) {
        try {
            return Revision.parseRevision((String)versionString);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean isModelOlderThan011(Context context) {
        return LintUtils.isModelOlderThan((AndroidProject)context.getProject().getGradleProjectModel(), (int)0, (int)11, (int)0);
    }

    private static Revision getLatestBuildTools(LintClient client, int major) {
        if (major != sMajorBuildTools) {
            File[] dirs;
            sMajorBuildTools = major;
            ArrayList revisions = Lists.newArrayList();
            if (major == 23) {
                revisions.add(new Revision(23, 0, 1));
            } else if (major == 22) {
                revisions.add(new Revision(22, 0, 1));
            } else if (major == 21) {
                revisions.add(new Revision(21, 1, 2));
            } else if (major == 20) {
                revisions.add(new Revision(20));
            } else if (major == 19) {
                revisions.add(new Revision(19, 1));
            } else if (major == 18) {
                revisions.add(new Revision(18, 1, 1));
            }
            File sdkHome = client.getSdkHome();
            if (sdkHome != null && (dirs = new File(sdkHome, "build-tools").listFiles()) != null) {
                for (File dir : dirs) {
                    Revision v;
                    String name = dir.getName();
                    if (!dir.isDirectory() || !Character.isDigit(name.charAt(0)) || (v = GradleDetector.parseRevisionSilently(name)) == null || v.getMajor() != major) continue;
                    revisions.add(v);
                }
            }
            if (!revisions.isEmpty()) {
                sLatestBuildTools = (Revision)Collections.max(revisions);
            }
        }
        return sLatestBuildTools;
    }

    private void checkTargetCompatibility(Context context, Object cookie) {
        if (this.mCompileSdkVersion > 0 && this.mTargetSdkVersion > 0 && this.mTargetSdkVersion > this.mCompileSdkVersion) {
            String message = "The targetSdkVersion (" + this.mTargetSdkVersion + ") should not be higher than the compileSdkVersion (" + this.mCompileSdkVersion + ")";
            this.report(context, cookie, DEPENDENCY, message);
        }
    }

    private static String getStringLiteralValue(String value) {
        if (value.length() > 2 && (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\""))) {
            return value.substring(1, value.length() - 1);
        }
        return null;
    }

    private static int getIntLiteralValue(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static boolean isInteger(String token) {
        return token.matches("\\d+");
    }

    private static boolean isStringLiteral(String token) {
        return token.startsWith("\"") && token.endsWith("\"") || token.startsWith("'") && token.endsWith("'");
    }

    private void checkDependency(Context context, GradleCoordinate dependency, Object cookie) {
        Revision latest;
        if ("com.android.support".equals(dependency.getGroupId())) {
            this.checkSupportLibraries(context, dependency, cookie);
            if (this.mMinSdkVersion >= 14 && "appcompat-v7".equals(dependency.getArtifactId()) && this.mCompileSdkVersion >= 1 && this.mCompileSdkVersion < 21) {
                this.report(context, cookie, DEPENDENCY, "Using the appcompat library when minSdkVersion >= 14 and compileSdkVersion < 21 is not necessary");
            }
            return;
        }
        if (GMS_GROUP_ID.equals(dependency.getGroupId()) && dependency.getArtifactId() != null) {
            if ("5.2.08".equals(dependency.getRevision()) && context.isEnabled(COMPATIBILITY)) {
                GradleCoordinate max;
                String version = "6.1.11";
                File sdkHome = context.getClient().getSdkHome();
                File repository = SdkMavenRepository.GOOGLE.getRepositoryLocation(sdkHome, true);
                if (repository != null && (max = SdkMavenRepository.getHighestInstalledVersion((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (File)repository, null, (boolean)false)) != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, max) < 0) {
                    version = max.getRevision();
                }
                String message = String.format("Version `5.2.08` should not be used; the app can not be published with this version. Use version `%1$s` instead.", version);
                this.report(context, cookie, COMPATIBILITY, message);
            }
            this.checkPlayServices(context, dependency, cookie);
            return;
        }
        Revision version = null;
        Issue issue = DEPENDENCY;
        if ("com.android.tools.build".equals(dependency.getGroupId()) && "gradle".equals(dependency.getArtifactId())) {
            try {
                Revision v = Revision.parseRevision((String)"2.1.2");
                if (!v.isPreview()) {
                    version = GradleDetector.getNewerRevision(dependency, v);
                }
            }
            catch (NumberFormatException e) {
                context.log((Throwable)e, null, new Object[0]);
            }
        } else if ("com.google.guava".equals(dependency.getGroupId()) && "guava".equals(dependency.getArtifactId())) {
            version = GradleDetector.getNewerRevision(dependency, new Revision(18, 0));
        } else if ("com.google.code.gson".equals(dependency.getGroupId()) && "gson".equals(dependency.getArtifactId())) {
            version = GradleDetector.getNewerRevision(dependency, new Revision(2, 4));
        } else if ("org.apache.httpcomponents".equals(dependency.getGroupId()) && "httpclient".equals(dependency.getArtifactId())) {
            version = GradleDetector.getNewerRevision(dependency, new Revision(4, 3, 5));
        }
        if (context.getScope().size() > 1 && context.isEnabled(REMOTE_VERSION) && (latest = GradleDetector.getLatestVersionFromRemoteRepo(context.getClient(), dependency, dependency.isPreview())) != null && GradleDetector.isOlderThan(dependency, latest.getMajor(), latest.getMinor(), latest.getMicro())) {
            version = latest;
            issue = REMOTE_VERSION;
        }
        if (version != null) {
            String message = GradleDetector.getNewerVersionAvailableMessage(dependency, version);
            this.report(context, cookie, issue, message);
        }
    }

    private static String getNewerVersionAvailableMessage(GradleCoordinate dependency, Revision version) {
        return GradleDetector.getNewerVersionAvailableMessage(dependency, version.toString());
    }

    private static String getNewerVersionAvailableMessage(GradleCoordinate dependency, String version) {
        return "A newer version of " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " than " + dependency.getRevision() + " is available: " + version;
    }

    public static Revision getLatestVersionFromRemoteRepo(LintClient client, GradleCoordinate dependency, boolean allowPreview) {
        return GradleDetector.getLatestVersionFromRemoteRepo(client, dependency, true, allowPreview);
    }

    private static Revision getLatestVersionFromRemoteRepo(LintClient client, GradleCoordinate dependency, boolean firstRowOnly, boolean allowPreview) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        if (groupId == null || artifactId == null) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        String encoding = Charsets.UTF_8.name();
        try {
            query.append("http://search.maven.org/solrsearch/select?q=g:%22");
            query.append(URLEncoder.encode(groupId, encoding));
            query.append("%22+AND+a:%22");
            query.append(URLEncoder.encode(artifactId, encoding));
        }
        catch (UnsupportedEncodingException ee) {
            return null;
        }
        query.append("%22&core=gav");
        if (firstRowOnly) {
            query.append("&rows=1");
        }
        query.append("&wt=json");
        String response = GradleDetector.readUrlData(client, dependency, query.toString());
        if (response == null) {
            return null;
        }
        boolean foundPreview = false;
        int index = response.indexOf("\"response\"");
        while (index != -1) {
            Revision revision;
            int start;
            int end;
            if ((index = response.indexOf("\"v\":", index)) == -1 || (end = response.indexOf(34, (start = response.indexOf(34, index += 4) + 1) + 1)) <= start || start < 0 || (revision = GradleDetector.parseRevisionSilently(response.substring(start, end))) == null) continue;
            foundPreview = revision.isPreview();
            if (!allowPreview && foundPreview) continue;
            return revision;
        }
        if (!allowPreview && foundPreview && firstRowOnly) {
            return GradleDetector.getLatestVersionFromRemoteRepo(client, dependency, false, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static String readUrlData(LintClient client, GradleCoordinate dependency, String query) {
        if (sMockData != null) {
            String value = sMockData.get(query);
            assert (value != null) : query;
            return value;
        }
        try {
            URL url = new URL(query);
            URLConnection connection = client.openConnection(url);
            if (connection == null) {
                return null;
            }
            try {
                String string;
                InputStream is = connection.getInputStream();
                if (is == null) {
                    String string2 = null;
                    return string2;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
                try {
                    String line;
                    StringBuilder sb = new StringBuilder(500);
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                        sb.append('\n');
                    }
                    string = sb.toString();
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return string;
            }
            finally {
                client.closeConnection(connection);
            }
        }
        catch (IOException ioe) {
            client.log((Throwable)ioe, "Could not connect to maven central to look up the latest available version for %1$s", new Object[]{dependency});
            return null;
        }
    }

    private boolean checkGradlePluginDependency(Context context, GradleCoordinate dependency, Object cookie) {
        GradleCoordinate latestPlugin = GradleCoordinate.parseCoordinateString((String)"com.android.tools.build:gradle:1.0.0");
        if (GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, latestPlugin) < 0) {
            String message = "You must use a newer version of the Android Gradle plugin. The minimum supported version is 1.0.0 and the recommended version is 2.1.2";
            this.report(context, cookie, GRADLE_PLUGIN_COMPATIBILITY, message);
            return true;
        }
        return false;
    }

    private void checkSupportLibraries(Context context, GradleCoordinate dependency, Object cookie) {
        String message;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        assert (groupId != null && artifactId != null);
        if (this.mCompileSdkVersion >= 18 && dependency.getMajorVersion() != this.mCompileSdkVersion && dependency.getMajorVersion() != -1 && !dependency.getArtifactId().startsWith("multidex") && context.isEnabled(COMPATIBILITY)) {
            message = "This support library should not use a different version (" + dependency.getMajorVersion() + ") than the `compileSdkVersion` (" + this.mCompileSdkVersion + ")";
            this.report(context, cookie, COMPATIBILITY, message);
        } else if (this.mTargetSdkVersion > 0 && dependency.getMajorVersion() < this.mTargetSdkVersion && dependency.getMajorVersion() != -1 && !dependency.getArtifactId().startsWith("multidex") && context.isEnabled(COMPATIBILITY)) {
            message = "This support library should not use a lower version (" + dependency.getMajorVersion() + ") than the `targetSdkVersion` (" + this.mTargetSdkVersion + ")";
            this.report(context, cookie, COMPATIBILITY, message);
        }
        File sdkHome = context.getClient().getSdkHome();
        File repository = SdkMavenRepository.ANDROID.getRepositoryLocation(sdkHome, true);
        if (repository == null) {
            this.report(context, cookie, DEPENDENCY, "Dependency on a support library, but the SDK installation does not have the \"Extras > Android Support Repository\" installed. Open the SDK manager and install it.");
        } else {
            this.checkLocalMavenVersions(context, dependency, cookie, groupId, artifactId, repository);
        }
    }

    private void checkPlayServices(Context context, GradleCoordinate dependency, Object cookie) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        assert (groupId != null && artifactId != null);
        File sdkHome = context.getClient().getSdkHome();
        File repository = SdkMavenRepository.GOOGLE.getRepositoryLocation(sdkHome, true);
        if (repository == null) {
            this.report(context, cookie, DEPENDENCY, "Dependency on Play Services, but the SDK installation does not have the \"Extras > Google Repository\" installed. Open the SDK manager and install it.");
        } else {
            this.checkLocalMavenVersions(context, dependency, cookie, groupId, artifactId, repository);
        }
        if (!this.mCheckedGms) {
            this.mCheckedGms = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
                this.checkConsistentPlayServices(context, cookie);
            }
        }
    }

    private void checkConsistentPlayServices(Context context, Object cookie) {
        Project project = context.getMainProject();
        if (!project.isGradleProject()) {
            return;
        }
        Variant variant = project.getCurrentVariant();
        if (variant == null) {
            return;
        }
        AndroidArtifact artifact = variant.getMainArtifact();
        Collection libraries = artifact.getDependencies().getLibraries();
        ArrayListMultimap versionToCoordinate = ArrayListMultimap.create();
        for (AndroidLibrary library : libraries) {
            GradleDetector.addGmsLibraryVersions((Multimap<String, MavenCoordinates>)versionToCoordinate, library);
        }
        Set versions = versionToCoordinate.keySet();
        if (versions.size() > 1) {
            ArrayList sortedVersions = Lists.newArrayList((Iterable)versions);
            Collections.sort(sortedVersions, Collections.reverseOrder());
            MavenCoordinates c1 = (MavenCoordinates)versionToCoordinate.get(sortedVersions.get(0)).iterator().next();
            MavenCoordinates c2 = (MavenCoordinates)versionToCoordinate.get(sortedVersions.get(1)).iterator().next();
            String example1 = c1.getGroupId() + ":" + c1.getArtifactId() + ":" + c1.getVersion();
            String example2 = c2.getGroupId() + ":" + c2.getArtifactId() + ":" + c2.getVersion();
            String message = "All com.google.android.gms libraries must use the exact same version specification (mixing versions can lead to runtime crashes). Found versions " + Joiner.on((String)", ").join((Iterable)sortedVersions) + ". " + "Examples include " + example1 + " and " + example2;
            if (cookie != null) {
                this.report(context, cookie, COMPATIBILITY, message);
            } else {
                context.report(COMPATIBILITY, LintUtils.guessGradleLocation((Project)context.getProject()), message);
            }
        }
    }

    private static void addGmsLibraryVersions(Multimap<String, MavenCoordinates> versions, AndroidLibrary library) {
        MavenCoordinates coordinates = library.getResolvedCoordinates();
        if (coordinates != null && coordinates.getGroupId().equals(GMS_GROUP_ID)) {
            versions.put((Object)coordinates.getVersion(), (Object)coordinates);
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            GradleDetector.addGmsLibraryVersions(versions, dependency);
        }
    }

    public void afterCheckProject(Context context) {
        if (context.getProject() == context.getMainProject() && context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            this.checkConsistentPlayServices(context, null);
        }
    }

    private void checkLocalMavenVersions(Context context, GradleCoordinate dependency, Object cookie, String groupId, String artifactId, File repository) {
        GradleCoordinate max = SdkMavenRepository.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)repository, null, (boolean)false);
        if (max != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, max) < 0 && context.isEnabled(DEPENDENCY)) {
            String message = GradleDetector.getNewerVersionAvailableMessage(dependency, max.getRevision());
            this.report(context, cookie, DEPENDENCY, message);
        }
    }

    private static Revision getNewerRevision(GradleCoordinate dependency, Revision revision) {
        GradleCoordinate coordinate;
        assert (dependency.getGroupId() != null);
        assert (dependency.getArtifactId() != null);
        if (revision.isPreview()) {
            String coordinateString = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + revision.toString();
            coordinate = GradleCoordinate.parseCoordinateString((String)coordinateString);
        } else {
            coordinate = new GradleCoordinate(dependency.getGroupId(), dependency.getArtifactId(), new int[]{revision.getMajor(), revision.getMinor(), revision.getMicro()});
        }
        if (GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, coordinate) < 0) {
            return revision;
        }
        return null;
    }

    private static boolean isOlderThan(GradleCoordinate dependency, int major, int minor, int micro) {
        assert (dependency.getGroupId() != null);
        assert (dependency.getArtifactId() != null);
        return GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, new GradleCoordinate(dependency.getGroupId(), dependency.getArtifactId(), new int[]{major, minor, micro})) < 0;
    }

    private void report(Context context, Object cookie, Issue issue, String message) {
        if (context.isEnabled(issue)) {
            int startOffset;
            boolean checkComments = context.containsCommentSuppress();
            if (checkComments && (startOffset = this.getStartOffset(context, cookie)) >= 0 && context.isSuppressedWithComment(startOffset, issue)) {
                return;
            }
            context.report(issue, this.createLocation(context, cookie), message);
        }
    }

    protected Object getPropertyKeyCookie(Object cookie) {
        return cookie;
    }

    protected Object getPropertyPairCookie(Object cookie) {
        return cookie;
    }

    protected int getStartOffset(Context context, Object cookie) {
        return -1;
    }

    protected Location createLocation(Context context, Object cookie) {
        return null;
    }
}

