/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.detector.api.JavaContext;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;

public class PermissionFinder {
    private final JavaContext mContext;
    private final Operation mOperation;

    public static Result findRequiredPermissions(Operation operation, JavaContext context, PsiElement parameter) {
        return new PermissionFinder(context, operation).search(parameter);
    }

    private PermissionFinder(JavaContext context, Operation operation) {
        this.mContext = context;
        this.mOperation = operation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result search(PsiElement node) {
        if (node instanceof PsiLiteral && "null".equals(node.getText())) {
            return null;
        }
        if (node instanceof PsiConditionalExpression) {
            Result result;
            PsiConditionalExpression expression = (PsiConditionalExpression)node;
            if (expression.getThenExpression() != null && (result = this.search((PsiElement)expression.getThenExpression())) != null) {
                return result;
            }
            if (expression.getElseExpression() == null) return null;
            result = this.search((PsiElement)expression.getElseExpression());
            if (result == null) return null;
            return result;
        }
        if (node instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
            PsiExpression operand = cast.getOperand();
            if (operand == null) return null;
            return this.search((PsiElement)operand);
        }
        if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parens = (PsiParenthesizedExpression)node;
            PsiExpression expression = parens.getExpression();
            if (expression == null) return null;
            return this.search((PsiElement)expression);
        }
        if (node instanceof PsiNewExpression && this.mOperation == Operation.ACTION) {
            PsiNewExpression call = (PsiNewExpression)node;
            PsiJavaCodeReferenceElement classReference = call.getClassReference();
            String type = classReference != null ? classReference.getQualifiedName() : null;
            if (!"android.content.Intent".equals(type)) return null;
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList == null) return null;
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length <= 0) return null;
            PsiExpression action = expressions[0];
            if (action == null) return null;
            return this.search((PsiElement)action);
        }
        if (!(node instanceof PsiReferenceExpression)) return null;
        PsiElement resolved = ((PsiReferenceExpression)node).resolve();
        if (resolved instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            if (this.mOperation == Operation.ACTION) {
                PsiModifierList modifierList = field.getModifierList();
                if (modifierList == null) return null;
                PsiAnnotation psiAnnotation = modifierList.findAnnotation("android.support.annotation.RequiresPermission");
                PsiAnnotation annotation = psiAnnotation;
                if (annotation == null) return null;
                return this.getPermissionRequirement(field, annotation);
            }
            if (this.mOperation == Operation.READ || this.mOperation == Operation.WRITE) {
                String fqn = this.mOperation == Operation.READ ? "android.support.annotation.RequiresPermission.Read" : "android.support.annotation.RequiresPermission.Write";
                PsiModifierList modifierList = field.getModifierList();
                if (modifierList == null) return null;
                PsiAnnotation psiAnnotation = modifierList.findAnnotation(fqn);
                PsiAnnotation annotation = psiAnnotation;
                if (annotation == null) return null;
                PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
                PsiNameValuePair o = attributes.length == 1 ? attributes[0] : null;
                if (o == null) return this.getPermissionRequirement(field, annotation);
                if (!(o.getValue() instanceof PsiAnnotation)) return this.getPermissionRequirement(field, annotation);
                annotation = (PsiAnnotation)o.getValue();
                if (!"android.support.annotation.RequiresPermission".equals(annotation.getQualifiedName())) return null;
                return this.getPermissionRequirement(field, annotation);
            }
            assert (false) : this.mOperation;
            return null;
        }
        if (!(resolved instanceof PsiLocalVariable)) return null;
        PsiLocalVariable variable = (PsiLocalVariable)resolved;
        String targetName = variable.getName();
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
        if (statement == null) return null;
        if (targetName == null) return null;
        PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
        while (prev != null) {
            PsiReferenceExpression reference;
            PsiAssignmentExpression assign;
            PsiExpression lhs;
            PsiExpression expression;
            if (prev instanceof PsiDeclarationStatement) {
                for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                    if (!variable.equals(element)) continue;
                    if (variable.getInitializer() != null) {
                        return this.search((PsiElement)variable.getInitializer());
                    }
                    break;
                }
            } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                if (assign.getRExpression() == null) return null;
                return this.search((PsiElement)assign.getRExpression());
            }
            prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
        }
        return null;
    }

    private Result getPermissionRequirement(PsiField field, PsiAnnotation annotation) {
        String name;
        PermissionRequirement requirement = PermissionRequirement.create(this.mContext, annotation);
        PsiClass containingClass = field.getContainingClass();
        String string = name = containingClass != null ? containingClass.getName() + "." + field.getName() : field.getName();
        assert (name != null);
        return new Result(this.mOperation, requirement, name);
    }

    public static class Result {
        public final PermissionRequirement requirement;
        public final String name;
        public final Operation operation;

        public Result(Operation operation, PermissionRequirement requirement, String name) {
            this.operation = operation;
            this.requirement = requirement;
            this.name = name;
        }
    }

    public static enum Operation {
        CALL,
        ACTION,
        READ,
        WRITE;


        public String prefix() {
            switch (this) {
                case ACTION: {
                    return "by intent";
                }
                case READ: {
                    return "to read";
                }
                case WRITE: {
                    return "to write";
                }
            }
            return "by";
        }
    }
}

