/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class RecyclerViewDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(RecyclerViewDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue FIXED_POSITION = Issue.create((String)"RecyclerView", (String)"RecyclerView Problems", (String)"`RecyclerView` will *not* call `onBindViewHolder` again when the position of the item changes in the data set unless the item itself is invalidated or the new position cannot be determined.\n\nFor this reason, you should *only* use the position parameter while acquiring the related data item inside this method, and should *not* keep a copy of it.\n\nIf you need the position of an item later on (e.g. in a click listener), use `getAdapterPosition()` which will have the updated adapter position.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue DATA_BINDER = Issue.create((String)"PendingBindings", (String)"Missing Pending Bindings", (String)"When using a `ViewDataBinding` in a `onBindViewHolder` method, you *must* call `executePendingBindings()` before the method exits; otherwise the data binding runtime will update the UI in the next animation frame causing a delayed update and potential jumps if the item resizes.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    private static final String VIEW_ADAPTER = "android.support.v7.widget.RecyclerView.Adapter";
    private static final String ON_BIND_VIEW_HOLDER = "onBindViewHolder";

    public List<String> applicableSuperClasses() {
        return Collections.singletonList(VIEW_ADAPTER);
    }

    public void checkClass(JavaContext context, PsiClass declaration) {
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : declaration.findMethodsByName(ON_BIND_VIEW_HOLDER, false)) {
            int size = evaluator.getParameterCount(method);
            if (size != 2 && size != 3) continue;
            RecyclerViewDetector.checkMethod(context, method, declaration);
        }
    }

    private static void checkMethod(JavaContext context, PsiMethod declaration, PsiClass cls) {
        PsiParameter[] parameters = declaration.getParameterList().getParameters();
        PsiParameter viewHolder = parameters[0];
        PsiParameter parameter = parameters[1];
        ParameterEscapesVisitor visitor = new ParameterEscapesVisitor(context, cls, parameter);
        declaration.accept((PsiElementVisitor)visitor);
        if (visitor.variableEscapes()) {
            RecyclerViewDetector.reportError(context, viewHolder, parameter);
        }
        List<PsiMethodCallExpression> dataBinderReferences = visitor.getDataBinders();
        RecyclerViewDetector.checkDataBinders(context, declaration, dataBinderReferences);
    }

    private static void reportError(JavaContext context, PsiParameter viewHolder, PsiParameter parameter) {
        String variablePrefix = viewHolder.getName();
        if (variablePrefix == null) {
            variablePrefix = "ViewHolder";
        }
        String message = String.format("Do not treat position as fixed; only use immediately and call `%1$s.getAdapterPosition()` to look it up later", variablePrefix);
        context.report(FIXED_POSITION, (PsiElement)parameter, context.getLocation((PsiElement)parameter), message);
    }

    private static void checkDataBinders(JavaContext context, PsiMethod declaration, List<PsiMethodCallExpression> references) {
        if (references != null && !references.isEmpty()) {
            ArrayList targets = Lists.newArrayList();
            ArrayList sources = Lists.newArrayList();
            for (PsiMethodCallExpression ref : references) {
                if (RecyclerViewDetector.isExecutePendingBindingsCall(ref)) {
                    targets.add(ref);
                    continue;
                }
                sources.add(ref);
            }
            HashMap parentToChildren = Maps.newHashMap();
            for (PsiMethodCallExpression reference : sources) {
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiStatement.class);
                if (statement == null) continue;
                parentToChildren.put(statement.getParent(), reference);
            }
            for (PsiMethodCallExpression source : parentToChildren.values()) {
                PsiExpression sourceBinderReference = source.getMethodExpression().getQualifierExpression();
                PsiField sourceDataBinder = RecyclerViewDetector.getDataBinderReference((PsiElement)sourceBinderReference);
                assert (sourceDataBinder != null);
                boolean reachesTarget = false;
                for (PsiMethodCallExpression target : targets) {
                    if (!sourceDataBinder.equals(RecyclerViewDetector.getDataBinderReference((PsiElement)target.getMethodExpression().getQualifierExpression())) || !CutPasteDetector.isReachableFrom(declaration, (PsiElement)source, (PsiElement)target)) continue;
                    reachesTarget = true;
                    break;
                }
                if (reachesTarget) continue;
                String message = String.format("You must call `%1$s.executePendingBindings()` before the `onBind` method exits, otherwise, the DataBinding library will update the UI in the next animation frame causing a delayed update & potential jumps if the item resizes.", sourceBinderReference.getText());
                context.report(DATA_BINDER, (PsiElement)source, context.getLocation((PsiElement)source), message);
            }
        }
    }

    private static boolean isExecutePendingBindingsCall(PsiMethodCallExpression call) {
        return "executePendingBindings".equals(call.getMethodExpression().getReferenceName());
    }

    private static PsiField getDataBinderReference(PsiElement element) {
        PsiField field;
        PsiElement resolved;
        if (element instanceof PsiReference && (resolved = ((PsiReference)element).resolve()) instanceof PsiField && "dataBinder".equals((field = (PsiField)resolved).getName())) {
            return field;
        }
        return null;
    }

    private static class ParameterEscapesVisitor
    extends JavaRecursiveElementVisitor {
        protected final JavaContext mContext;
        protected final List<PsiVariable> mVariables;
        private final PsiClass mBindClass;
        private boolean mEscapes;
        private boolean mFoundInnerClass;
        private List<PsiMethodCallExpression> mDataBinders = null;

        public ParameterEscapesVisitor(JavaContext context, PsiClass bindClass, PsiParameter variable) {
            this.mContext = context;
            this.mVariables = Lists.newArrayList((Object[])new PsiVariable[]{variable});
            this.mBindClass = bindClass;
        }

        public boolean variableEscapes() {
            return this.mEscapes;
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            PsiElement resolved;
            PsiExpression initializer = variable.getInitializer();
            if (initializer instanceof PsiReference && (resolved = ((PsiReference)initializer).resolve()) != null && this.mVariables.contains(resolved)) {
                if (resolved instanceof PsiLocalVariable) {
                    this.mVariables.add((PsiVariable)variable);
                } else if (resolved instanceof PsiField) {
                    this.mEscapes = true;
                }
            }
            super.visitLocalVariable(variable);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression node) {
            PsiElement resolved;
            PsiExpression rhs = node.getRExpression();
            boolean clearLhs = true;
            if (rhs instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)rhs).resolve()) != null && this.mVariables.contains(resolved)) {
                clearLhs = false;
                PsiElement resolvedLhs = this.mContext.getEvaluator().resolve((PsiElement)node.getLExpression());
                if (resolvedLhs instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)resolvedLhs;
                    this.mVariables.add((PsiVariable)variable);
                } else if (resolvedLhs instanceof PsiField) {
                    this.mEscapes = true;
                }
            }
            if (clearLhs && (resolved = this.mContext.getEvaluator().resolve((PsiElement)node.getLExpression())) != null && this.mVariables.contains(resolved)) {
                this.mVariables.remove(resolved);
            }
            super.visitAssignmentExpression(node);
        }

        public void visitReferenceExpression(PsiReferenceExpression node) {
            PsiClass outer;
            PsiElement resolved;
            if (this.mFoundInnerClass && (resolved = this.mContext.getEvaluator().resolve((PsiElement)node)) != null && this.mVariables.contains(resolved) && !this.mBindClass.equals(outer = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)node, PsiClass.class, (boolean)true))) {
                this.mEscapes = true;
            }
            super.visitReferenceExpression(node);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            if (expression.getAnonymousClass() != null) {
                this.mFoundInnerClass = true;
            }
            super.visitNewExpression(expression);
        }

        public List<PsiMethodCallExpression> getDataBinders() {
            return this.mDataBinders;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiField dataBinder = RecyclerViewDetector.getDataBinderReference((PsiElement)qualifier);
            if (dataBinder != null) {
                if (this.mDataBinders == null) {
                    this.mDataBinders = Lists.newArrayList();
                }
                this.mDataBinders.add(expression);
            }
        }
    }
}

