/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import java.util.Collections;
import java.util.List;

public class CallSuperDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final String CALL_SUPER_ANNOTATION = "android.support.annotation.CallSuper";
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";
    private static final Implementation IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"MissingSuperCall", (String)"Missing Super Call", (String)"Some methods, such as `View#onDetachedFromWindow`, require that you also call the super implementation as part of your method.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiMethod.class);
    }

    public JavaElementVisitor createPsiVisitor(final JavaContext context) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                CallSuperDetector.checkCallSuper(context, method);
            }
        };
    }

    private static void checkCallSuper(JavaContext context, PsiMethod method) {
        PsiMethod superMethod = CallSuperDetector.getRequiredSuperMethod(context, method);
        if (superMethod != null && !SuperCallVisitor.callsSuper(method, superMethod)) {
            String methodName = method.getName();
            String message = "Overriding method should call `super." + methodName + "`";
            Location location = context.getNameLocation((PsiElement)method);
            context.report(ISSUE, (PsiElement)method, location, message);
        }
    }

    private static PsiMethod getRequiredSuperMethod(JavaContext context, PsiMethod method) {
        PsiAnnotation[] annotations;
        JavaEvaluator evaluator = context.getEvaluator();
        PsiMethod directSuper = evaluator.getSuperMethod(method);
        if (directSuper == null) {
            return null;
        }
        String name = method.getName();
        if (ON_DETACHED_FROM_WINDOW.equals(name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
                return null;
            }
            return directSuper;
        }
        if (ON_VISIBILITY_CHANGED.equals(name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.support.wearable.watchface.WatchFaceService.Engine", false)) {
                return null;
            }
            return directSuper;
        }
        for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)directSuper, true)) {
            String signature = annotation.getQualifiedName();
            if (!CALL_SUPER_ANNOTATION.equals(signature) && (signature == null || !signature.endsWith(".OverrideMustInvoke") && !signature.endsWith(".OverridingMethodsMustInvokeSuper"))) continue;
            return directSuper;
        }
        return null;
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiMethod mMethod;
        private boolean mCallsSuper;

        public static boolean callsSuper(PsiMethod method, PsiMethod superMethod) {
            SuperCallVisitor visitor = new SuperCallVisitor(superMethod);
            method.accept((PsiElementVisitor)visitor);
            return visitor.mCallsSuper;
        }

        private SuperCallVisitor(PsiMethod method) {
            this.mMethod = method;
        }

        public void visitSuperExpression(PsiSuperExpression node) {
            PsiElement resolved;
            super.visitSuperExpression(node);
            PsiElement parent = LintUtils.skipParentheses((PsiElement)node.getParent());
            if (parent instanceof PsiReferenceExpression && this.mMethod.equals(resolved = ((PsiReferenceExpression)parent).resolve())) {
                this.mCallsSuper = true;
            }
        }
    }
}

