/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FirebaseAnalyticsDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final int EVENT_NAME_MAX_LENGTH = 32;
    private static final int EVENT_PARAM_NAME_MAX_LENGTH = 24;
    private static final Implementation IMPLEMENTATION = new Implementation(FirebaseAnalyticsDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INVALID_NAME = Issue.create((String)"InvalidAnalyticsName", (String)"Invalid Analytics Name", (String)"Event names and parameters must follow the naming conventions defined in the`FirebaseAnalytics#logEvent()` documentation.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("http://firebase.google.com/docs/reference/android/com/google/firebase/analytics/FirebaseAnalytics#logEvent(java.lang.String,%20android.os.Bundle)");

    private static boolean isReservedEventName(String name) {
        switch (name) {
            case "app_clear_data": 
            case "app_uninstall": 
            case "app_update": 
            case "error": 
            case "first_open": 
            case "in_app_purchase": 
            case "notification_dismiss": 
            case "notification_foreground": 
            case "notification_open": 
            case "notification_receive": 
            case "os_update": 
            case "session_start": 
            case "user_engagement": {
                return true;
            }
        }
        return false;
    }

    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        PsiExpression secondParameter;
        List<BundleModification> bundleModifications;
        String firebaseAnalytics = "com.google.firebase.analytics.FirebaseAnalytics";
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, firebaseAnalytics)) {
            return;
        }
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        if (expressions.length < 2) {
            return;
        }
        PsiExpression firstArgumentExpression = expressions[0];
        String value = ConstantEvaluator.evaluateString((JavaContext)context, (PsiElement)firstArgumentExpression, (boolean)false);
        if (value == null) {
            return;
        }
        String error = FirebaseAnalyticsDetector.getErrorForEventName(value);
        if (error != null) {
            context.report(INVALID_NAME, (PsiElement)call, context.getLocation((PsiElement)call), error);
        }
        if ((bundleModifications = FirebaseAnalyticsDetector.getBundleModifications(context, secondParameter = expressions[1])) != null && !bundleModifications.isEmpty()) {
            FirebaseAnalyticsDetector.validateEventParameters(context, bundleModifications, (PsiElement)call);
        }
    }

    private static void validateEventParameters(JavaContext context, List<BundleModification> parameters, PsiElement call) {
        for (BundleModification bundleModification : parameters) {
            String error = FirebaseAnalyticsDetector.getErrorForEventParameterName(bundleModification.mName);
            if (error == null) continue;
            Location location = context.getLocation(call);
            location.withSecondary(context.getLocation((PsiElement)bundleModification.mLocation), error);
            context.report(INVALID_NAME, call, location, "Bundle with invalid Analytics event parameters passed to logEvent.");
        }
    }

    private static List<BundleModification> getBundleModifications(JavaContext context, PsiExpression secondParameter) {
        PsiType type = secondParameter.getType();
        if (type != null && !type.getCanonicalText().equals("android.os.Bundle")) {
            return null;
        }
        if (secondParameter instanceof PsiNewExpression) {
            return Collections.emptyList();
        }
        List<BundleModification> modifications = null;
        if (secondParameter instanceof PsiReferenceExpression) {
            PsiReferenceExpression bundleReference = (PsiReferenceExpression)secondParameter;
            modifications = BundleModificationFinder.find(context, bundleReference);
        }
        return modifications;
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("logEvent");
    }

    private static String getErrorForEventName(String eventName) {
        if (eventName.length() > 32) {
            String message = "Analytics event name must be less than %1$d characters (found %2$d)";
            return String.format(message, 32, eventName.length());
        }
        if (eventName.isEmpty()) {
            return "Analytics event name cannot be empty";
        }
        if (!Character.isAlphabetic(eventName.charAt(0))) {
            String message = "Analytics event name must start with an alphabetic character (found %1$s)";
            return String.format(message, eventName);
        }
        String message = "Analytics event name must only consist of letters, numbers and underscores (found %1$s)";
        for (int i = 0; i < eventName.length(); ++i) {
            char character = eventName.charAt(i);
            if (Character.isLetterOrDigit(character) || character == '_') continue;
            return String.format(message, eventName);
        }
        if (eventName.startsWith("firebase_")) {
            return "Analytics event name should not start with `firebase_`";
        }
        if (FirebaseAnalyticsDetector.isReservedEventName(eventName)) {
            return String.format("`%1$s` is a reserved Analytics event name and cannot be used", eventName);
        }
        return null;
    }

    private static String getErrorForEventParameterName(String eventParameterName) {
        if (eventParameterName.length() > 24) {
            String message = "Analytics event parameter name must be %1$d characters or less (found %2$d)";
            return String.format(message, 24, eventParameterName.length());
        }
        if (eventParameterName.isEmpty()) {
            return "Analytics event parameter name cannot be empty";
        }
        if (!Character.isAlphabetic(eventParameterName.charAt(0))) {
            String message = "Analytics event parameter name must start with an alphabetic character (found %1$s)";
            return String.format(message, eventParameterName);
        }
        String message = "Analytics event name must only consist of letters, numbers and underscores (found %1$s)";
        for (int i = 0; i < eventParameterName.length(); ++i) {
            char character = eventParameterName.charAt(i);
            if (Character.isLetterOrDigit(character) || character == '_') continue;
            return String.format(message, eventParameterName);
        }
        if (eventParameterName.startsWith("firebase_")) {
            return "Analytics event parameter name cannot be start with `firebase_`";
        }
        return null;
    }

    private static class BundleModification {
        public final String mName;
        public final String mValue;
        public final PsiMethodCallExpression mLocation;

        public BundleModification(String name, String value, PsiMethodCallExpression location) {
            this.mName = name;
            this.mValue = value;
            this.mLocation = location;
        }
    }

    private static class ReturnReferenceExpressionFinder
    extends JavaRecursiveElementVisitor {
        private PsiReferenceExpression mReturnReference = null;

        private ReturnReferenceExpressionFinder() {
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiExpression returnExpression = statement.getReturnValue();
            if (returnExpression instanceof PsiReferenceExpression) {
                this.mReturnReference = (PsiReferenceExpression)returnExpression;
            }
        }

        static PsiReferenceExpression find(PsiMethod method) {
            ReturnReferenceExpressionFinder finder = new ReturnReferenceExpressionFinder();
            method.accept((PsiElementVisitor)finder);
            return finder.mReturnReference;
        }
    }

    private static class BundleModificationFinder
    extends JavaRecursiveElementVisitor {
        private final PsiReferenceExpression mBundleReference;
        private final JavaContext mContext;
        private final List<BundleModification> mParameters = new ArrayList<BundleModification>();

        private BundleModificationFinder(JavaContext context, PsiReferenceExpression bundleReference) {
            this.mContext = context;
            this.mBundleReference = bundleReference;
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            for (PsiElement element : statement.getDeclaredElements()) {
                PsiMethodCallExpression call;
                PsiReferenceExpression returnReference;
                PsiLocalVariable local;
                String name;
                if (!(element instanceof PsiLocalVariable) || (name = (local = (PsiLocalVariable)element).getName()) == null || !name.equals(this.mBundleReference.getText()) || !(local.getInitializer() instanceof PsiMethodCallExpression) || (returnReference = ReturnReferenceExpressionFinder.find((call = (PsiMethodCallExpression)local.getInitializer()).resolveMethod())) == null) continue;
                this.addParams(BundleModificationFinder.find(this.mContext, returnReference));
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            String method = expression.getMethodExpression().getCanonicalText();
            if (!(method.endsWith(".putString") || method.endsWith(".putLong") || method.endsWith(".putDouble"))) {
                return;
            }
            PsiElement token = expression.getMethodExpression().getQualifier();
            if (token == null || !this.mBundleReference.textMatches(token)) {
                return;
            }
            PsiExpression[] expressions = expression.getArgumentList().getExpressions();
            String evaluatedName = ConstantEvaluator.evaluateString((JavaContext)this.mContext, (PsiElement)expressions[0], (boolean)false);
            if (evaluatedName != null) {
                this.addParam(evaluatedName, expressions[1].getText(), expression);
            }
        }

        private void addParam(String key, String value, PsiMethodCallExpression location) {
            this.mParameters.add(new BundleModification(key, value, location));
        }

        private void addParams(Collection<BundleModification> bundleModifications) {
            this.mParameters.addAll(bundleModifications);
        }

        static List<BundleModification> find(JavaContext context, PsiReferenceExpression bundleReference) {
            BundleModificationFinder scanner = new BundleModificationFinder(context, bundleReference);
            PsiMethod enclosingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)bundleReference, PsiMethod.class);
            if (enclosingMethod == null) {
                return Collections.emptyList();
            }
            enclosingMethod.accept((PsiElementVisitor)scanner);
            return scanner.mParameters;
        }
    }
}

