/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PreferenceActivityDetector
extends Detector
implements Detector.XmlScanner,
Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"ExportedPreferenceActivity", (String)"PreferenceActivity should not be exported", (String)"Fragment injection gives anyone who can send your PreferenceActivity an intent the ability to load any fragment, with any arguments, in your process.", (Category)Category.SECURITY, (int)8, (Severity)Severity.WARNING, (Implementation)new Implementation(PreferenceActivityDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE))).addMoreInfo("http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection");
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    private final Map<String, Location.Handle> mExportedActivities = new HashMap<String, Location.Handle>();

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("activity");
    }

    public void visitElement(XmlContext context, Element element) {
        String fqcn;
        if (SecurityDetector.getExported(element) && (fqcn = PreferenceActivityDetector.getFqcn(element)) != null) {
            if (fqcn.equals(PREFERENCE_ACTIVITY) && !context.getDriver().isSuppressed(context, ISSUE, (Node)element)) {
                String message = "`PreferenceActivity` should not be exported";
                context.report(ISSUE, (Node)element, context.getLocation((Node)element), message);
            }
            this.mExportedActivities.put(fqcn, context.createLocationHandle((Node)element));
        }
    }

    private static String getFqcn(Element activityElement) {
        String activityClassName = activityElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (activityClassName == null || activityClassName.isEmpty()) {
            return null;
        }
        if (activityClassName.startsWith(".")) {
            String pkg = activityElement.getOwnerDocument().getDocumentElement().getAttribute("package");
            if (pkg != null) {
                return pkg + activityClassName;
            }
            return null;
        }
        return activityClassName;
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList(PREFERENCE_ACTIVITY);
    }

    public void checkClass(JavaContext context, PsiClass declaration) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        String className = declaration.getQualifiedName();
        if (evaluator.extendsClass(declaration, PREFERENCE_ACTIVITY, false) && this.mExportedActivities.containsKey(className)) {
            if (context.getMainProject().getTargetSdk() >= 19 && PreferenceActivityDetector.overridesIsValidFragment(evaluator, declaration)) {
                return;
            }
            String message = String.format("`PreferenceActivity` subclass `%1$s` should not be exported", className);
            Location location = this.mExportedActivities.get(className).resolve();
            context.report(ISSUE, (PsiElement)declaration, location, message);
        }
    }

    private static boolean overridesIsValidFragment(JavaEvaluator evaluator, PsiClass resolvedClass) {
        for (PsiMethod method : resolvedClass.findMethodsByName(IS_VALID_FRAGMENT, false)) {
            if (!evaluator.parametersMatch(method, new String[]{"java.lang.String"})) continue;
            return true;
        }
        return false;
    }
}

