/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"VectorRaster", (String)"Vector Image Generation", (String)"Vector icons require API 21, but when using Android Gradle plugin 1.4 or higher, vectors placed in the `drawable` folder are automatically moved to `drawable-*dpi-v21` and a bitmap image is generated each `drawable-*dpi` folder instead, for backwards compatibility (provided `minSdkVersion` is less than 21.).\n\nHowever, there are some limitations to this vector image generation, and this lint check flags elements and attributes that are not fully supported. You should manually check whether the generated output is acceptable for those older devices.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(VectorDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.DRAWABLE;
    }

    public static boolean isVectorGenerationSupported(Project project) {
        GradleVersion modelVersion = project.getGradleModelVersion();
        return modelVersion != null && (modelVersion.getMajor() >= 2 || modelVersion.getMinor() >= 4);
    }

    public void visitDocument(XmlContext context, Document document) {
        Project project = context.getMainProject();
        if (project.getMinSdkVersion().getFeatureLevel() >= 21) {
            return;
        }
        if (!project.isGradleProject()) {
            return;
        }
        if (!VectorDetector.isVectorGenerationSupported(project)) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root == null || !root.getTagName().equals("vector")) {
            return;
        }
        if (context.getFolderVersion() >= 21) {
            return;
        }
        if (VectorDetector.usingSupportLibVectors(project)) {
            return;
        }
        VectorDetector.checkSupported(context, root);
    }

    private static boolean usingSupportLibVectors(Project project) {
        GradleVersion version = project.getGradleModelVersion();
        if (version == null || version.getMajor() < 2) {
            return false;
        }
        Variant currentVariant = project.getCurrentVariant();
        return currentVariant != null && Boolean.TRUE.equals(currentVariant.getMergedFlavor().getVectorDrawables().getUseSupportLibrary());
    }

    private static void checkSupported(XmlContext context, Element element) {
        AndroidProject model;
        String tag = element.getTagName();
        if ("clip-path".equals(tag)) {
            String message = "This tag is not supported in images generated from this vector icon for API < 21; check generated icon to make sure it looks acceptable";
            context.report(ISSUE, (Node)element, context.getLocation((Node)element), message);
        } else if ("group".equals(tag) && (model = context.getMainProject().getGradleProjectModel()) != null && model.getModelVersion().startsWith("1.4.")) {
            String message = "Update Gradle plugin version to 1.5+ to correctly handle `<group>` tags in generated bitmaps";
            context.report(ISSUE, (Node)element, context.getLocation((Node)element), message);
        }
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String value;
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getLocalName();
            if (("autoMirrored".equals(name) || "trimPathStart".equals(name) || "trimPathEnd".equals(name) || "trimPathOffset".equals(name)) && "http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
                String message = "This attribute is not supported in images generated from this vector icon for API < 21; check generated icon to make sure it looks acceptable";
                context.report(ISSUE, (Node)attr, context.getNameLocation((Node)attr), message);
            }
            if (ResourceUrl.parse((String)(value = attr.getValue())) == null) continue;
            String message = "Resource references will not work correctly in images generated for this vector icon for API < 21; check generated icon to make sure it looks acceptable";
            context.report(ISSUE, (Node)attr, context.getValueLocation(attr), message);
        }
        NodeList children = element.getChildNodes();
        int n2 = children.getLength();
        for (int i = 0; i < n2; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            VectorDetector.checkSupported(context, (Element)child);
        }
    }
}

