/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.io.impl;

import com.android.repository.io.FileOp;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Stream;

public abstract class FileSystemFileOp
implements FileOp {
    protected boolean mIsWindows = System.getProperty("os.name").startsWith("Windows");

    public abstract FileSystem getFileSystem();

    @Override
    public final boolean isWindows() {
        return this.mIsWindows;
    }

    @Override
    public final String toString(File f, Charset c) throws IOException {
        return new String(Files.readAllBytes(this.toPath(f)), c);
    }

    @Override
    public final String[] list(File folder, FilenameFilter filenameFilter) {
        File[] contents = this.listFiles(folder);
        String[] names = new String[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            names[i] = contents[i].getName();
        }
        if (filenameFilter == null) {
            return names;
        }
        ArrayList result = Lists.newArrayList();
        for (String name : names) {
            if (!filenameFilter.accept(folder, name)) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public final File[] listFiles(File folder, FilenameFilter filenameFilter) {
        File[] contents = this.listFiles(folder);
        if (filenameFilter == null) {
            return contents;
        }
        ArrayList result = Lists.newArrayList();
        for (File f : contents) {
            if (!filenameFilter.accept(folder, f.getName())) continue;
            result.add(f);
        }
        return result.toArray(new File[result.size()]);
    }

    @Override
    public final boolean setLastModified(File file, long time) throws IOException {
        Files.setLastModifiedTime(this.toPath(file), FileTime.fromMillis(time));
        return true;
    }

    @Override
    public final void deleteFileOrFolder(File fileOrFolder) {
        if (this.isDirectory(fileOrFolder)) {
            for (File item : this.listFiles(fileOrFolder)) {
                this.deleteFileOrFolder(item);
            }
        }
        this.delete(fileOrFolder);
    }

    @Override
    public final void setExecutablePermission(File file) throws IOException {
        Path path = this.toPath(file);
        EnumSet<PosixFilePermission> permissions = EnumSet.copyOf(Files.getPosixFilePermissions(path, new LinkOption[0]));
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(path, permissions);
    }

    @Override
    public final boolean canExecute(File file) {
        return Files.isExecutable(this.toPath(file));
    }

    @Override
    public void setReadOnly(File file) throws IOException {
        Path path = this.toPath(file);
        EnumSet<PosixFilePermission> permissions = EnumSet.copyOf(Files.getPosixFilePermissions(path, new LinkOption[0]));
        permissions.remove((Object)PosixFilePermission.OWNER_WRITE);
        permissions.remove((Object)PosixFilePermission.GROUP_WRITE);
        permissions.remove((Object)PosixFilePermission.OTHERS_WRITE);
        Files.setPosixFilePermissions(path, permissions);
    }

    @Override
    public void copyFile(File source, File dest) throws IOException {
        Files.copy(this.toPath(source), this.toPath(dest), new CopyOption[0]);
    }

    @Override
    public final boolean isSameFile(File file1, File file2) throws IOException {
        return Files.isSameFile(this.toPath(file1), this.toPath(file2));
    }

    @Override
    public final boolean isFile(File file) {
        return Files.isRegularFile(this.toPath(file), new LinkOption[0]);
    }

    @Override
    public final boolean isDirectory(File file) {
        return Files.isDirectory(this.toPath(file), new LinkOption[0]);
    }

    @Override
    public boolean canWrite(File file) {
        return Files.isWritable(this.toPath(file));
    }

    @Override
    public final boolean exists(File file) {
        return Files.exists(this.toPath(file), new LinkOption[0]);
    }

    @Override
    public final long length(File file) throws IOException {
        return Files.size(this.toPath(file));
    }

    @Override
    public boolean delete(File file) {
        try {
            Files.delete(this.toPath(file));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public final boolean mkdirs(File file) {
        try {
            Files.createDirectories(this.toPath(file), new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final File[] listFiles(File file) {
        try (Stream<Path> children = Files.list(this.toPath(file));){
            File[] fileArray = (File[])children.map(path -> new File(path.toString())).toArray(File[]::new);
            return fileArray;
        }
        catch (IOException e) {
            return new File[0];
        }
    }

    @Override
    public boolean renameTo(File oldFile, File newFile) {
        try {
            Files.move(this.toPath(oldFile), this.toPath(newFile), new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public OutputStream newFileOutputStream(File file) throws IOException {
        return this.newFileOutputStream(file, false);
    }

    @Override
    public OutputStream newFileOutputStream(File file, boolean append) throws IOException {
        if (append) {
            return Files.newOutputStream(this.toPath(file), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        return Files.newOutputStream(this.toPath(file), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public final InputStream newFileInputStream(File file) throws IOException {
        return Files.newInputStream(this.toPath(file), new OpenOption[0]);
    }

    @Override
    public final long lastModified(File file) {
        try {
            return Files.getLastModifiedTime(this.toPath(file), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public final boolean createNewFile(File file) throws IOException {
        try {
            Path path = this.toPath(file);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    @Override
    public Path toPath(File file) {
        return this.getFileSystem().getPath(file.getPath(), new String[0]);
    }
}

