/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleVersion
implements Comparable<GradleVersion>,
Serializable {
    private static final String PLUS = "+";
    private static final Pattern PREVIEW_PATTERN = Pattern.compile("([a-zA-z]+)[\\-]?([\\d]+)?");
    private final String mRawValue;
    private final VersionSegment mMajorSegment;
    private final VersionSegment mMinorSegment;
    private final VersionSegment mMicroSegment;
    private final int mPreview;
    private final String mPreviewType;
    private final boolean mSnapshot;
    private final List<VersionSegment> mAdditionalSegments;

    public static GradleVersion tryParse(String value) {
        try {
            return GradleVersion.parse(value);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static GradleVersion parse(String value) {
        String version = value;
        String qualifiers = null;
        int dash = 45;
        int dashIndex = value.indexOf(dash);
        if (dashIndex != -1) {
            if (dashIndex < value.length() - 1) {
                qualifiers = value.substring(dashIndex + 1);
            }
            version = value.substring(0, dashIndex);
        }
        try {
            List<VersionSegment> parsedVersionSegments = GradleVersion.splitSegments(version);
            int segmentCount = parsedVersionSegments.size();
            VersionSegment minorSegment = null;
            VersionSegment microSegment = null;
            ArrayList additionalSegments = Lists.newArrayList();
            if (segmentCount > 0) {
                VersionSegment majorSegment = parsedVersionSegments.get(0);
                if (segmentCount > 1) {
                    minorSegment = parsedVersionSegments.get(1);
                }
                if (segmentCount >= 3) {
                    microSegment = parsedVersionSegments.get(2);
                }
                if (segmentCount > 3) {
                    additionalSegments.addAll(parsedVersionSegments.subList(3, segmentCount));
                }
                int preview = 0;
                String previewType = null;
                boolean snapshot = false;
                if (qualifiers != null) {
                    Matcher matcher;
                    if (GradleVersion.isSnapshotQualifier(qualifiers)) {
                        snapshot = true;
                        qualifiers = null;
                    } else {
                        String mayBeSnapshot;
                        int lastDashIndex = qualifiers.lastIndexOf(dash);
                        if (lastDashIndex != -1 && GradleVersion.isSnapshotQualifier(mayBeSnapshot = qualifiers.substring(lastDashIndex + 1))) {
                            snapshot = true;
                            qualifiers = qualifiers.substring(0, lastDashIndex);
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)qualifiers) && (matcher = PREVIEW_PATTERN.matcher(qualifiers)).matches()) {
                        String group;
                        previewType = matcher.group(1);
                        if (matcher.groupCount() == 2 && !Strings.isNullOrEmpty((String)(group = matcher.group(2)))) {
                            preview = Integer.parseInt(group);
                        }
                    }
                }
                return new GradleVersion(value, majorSegment, minorSegment, microSegment, additionalSegments, preview, previewType, snapshot);
            }
        }
        catch (NumberFormatException e) {
            throw GradleVersion.parsingFailure(value, e);
        }
        throw GradleVersion.parsingFailure(value);
    }

    private static List<VersionSegment> splitSegments(String version) {
        Iterable segments = Splitter.on((char)'.').split((CharSequence)version);
        ArrayList parsedSegments = Lists.newArrayListWithCapacity((int)3);
        for (String segment : segments) {
            parsedSegments.addAll(GradleVersion.parseSegment(segment));
        }
        return parsedSegments;
    }

    private static List<VersionSegment> parseSegment(String text) {
        int length = text.length();
        if (length > 1 && text.endsWith(PLUS)) {
            ArrayList segments = Lists.newArrayListWithCapacity((int)2);
            segments.add(new VersionSegment(text.substring(0, length - 1)));
            segments.add(new VersionSegment(PLUS));
            return segments;
        }
        return Collections.singletonList(new VersionSegment(text));
    }

    private static boolean isSnapshotQualifier(String value) {
        return "SNAPSHOT".equalsIgnoreCase(value) || "dev".equalsIgnoreCase(value);
    }

    private static IllegalArgumentException parsingFailure(String value) {
        return GradleVersion.parsingFailure(value, null);
    }

    private static IllegalArgumentException parsingFailure(String value, Throwable cause) {
        return new IllegalArgumentException(String.format("'%1$s' is not a valid version", value), cause);
    }

    public GradleVersion(int major, int minor, int micro) {
        this(major + "." + minor + "." + micro, new VersionSegment(major), new VersionSegment(minor), new VersionSegment(micro), Collections.emptyList(), 0, null, false);
    }

    private GradleVersion(String rawValue, VersionSegment majorSegment, VersionSegment minorSegment, VersionSegment microSegment, List<VersionSegment> additionalSegments, int preview, String previewType, boolean snapshot) {
        this.mRawValue = rawValue;
        this.mMajorSegment = majorSegment;
        this.mMinorSegment = minorSegment;
        this.mMicroSegment = microSegment;
        this.mAdditionalSegments = ImmutableList.copyOf(additionalSegments);
        this.mPreview = preview;
        this.mPreviewType = previewType;
        this.mSnapshot = snapshot;
    }

    public int getMajor() {
        return GradleVersion.valueOf(this.mMajorSegment);
    }

    public VersionSegment getMajorSegment() {
        return this.mMajorSegment;
    }

    public int getMinor() {
        return GradleVersion.valueOf(this.mMinorSegment);
    }

    public VersionSegment getMinorSegment() {
        return this.mMinorSegment;
    }

    public int getMicro() {
        return GradleVersion.valueOf(this.mMicroSegment);
    }

    private static int valueOf(VersionSegment segment) {
        return segment != null ? segment.getValue() : 0;
    }

    public VersionSegment getMicroSegment() {
        return this.mMicroSegment;
    }

    public int getPreview() {
        return this.mPreview;
    }

    public String getPreviewType() {
        return this.mPreviewType;
    }

    public boolean isSnapshot() {
        return this.mSnapshot;
    }

    @Override
    public int compareTo(String version) {
        return this.compareTo(GradleVersion.parse(version));
    }

    @Override
    public int compareTo(GradleVersion version) {
        return this.compareTo(version, false);
    }

    public int compareIgnoringQualifiers(String version) {
        return this.compareIgnoringQualifiers(GradleVersion.parse(version));
    }

    public int compareIgnoringQualifiers(GradleVersion version) {
        return this.compareTo(version, true);
    }

    private int compareTo(GradleVersion version, boolean ignoreQualifiers) {
        int delta = this.getMajor() - version.getMajor();
        if (delta != 0) {
            return delta;
        }
        delta = this.getMinor() - version.getMinor();
        if (delta != 0) {
            return delta;
        }
        delta = this.getMicro() - version.getMicro();
        if (delta != 0) {
            return delta;
        }
        if (!ignoreQualifiers) {
            if (this.mPreviewType == null) {
                if (version.mPreviewType != null) {
                    return 1;
                }
            } else {
                if (version.mPreviewType == null) {
                    return -1;
                }
                delta = this.mPreviewType.compareToIgnoreCase(version.mPreviewType);
            }
            if (delta != 0) {
                return delta;
            }
            delta = this.mPreview - version.mPreview;
            if (delta != 0) {
                return delta;
            }
            delta = this.mSnapshot == version.mSnapshot ? 0 : (this.mSnapshot ? -1 : 1);
        }
        return delta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleVersion that = (GradleVersion)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mMajorSegment, this.mMinorSegment, this.mMicroSegment, this.mPreview, this.mPreviewType, this.mSnapshot});
    }

    public String toString() {
        return this.mRawValue;
    }

    public List<VersionSegment> getAdditionalSegments() {
        return this.mAdditionalSegments;
    }

    public static class VersionSegment
    implements Serializable {
        private final String mText;
        private final int mValue;

        VersionSegment(int value) {
            this.mText = String.valueOf(value);
            this.mValue = value;
        }

        VersionSegment(String text) {
            this.mText = text;
            if (GradleVersion.PLUS.equals(text)) {
                this.mValue = Integer.MAX_VALUE;
            } else {
                int value;
                if (text.startsWith(GradleVersion.PLUS)) {
                    throw new NumberFormatException("Version segment cannot start with +");
                }
                try {
                    value = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    value = 0;
                }
                this.mValue = value;
            }
        }

        public String getText() {
            return this.mText;
        }

        public int getValue() {
            return this.mValue;
        }

        public boolean acceptsGreaterValue() {
            return GradleVersion.PLUS.equals(this.mText);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionSegment that = (VersionSegment)o;
            return Objects.equal((Object)this.mText, (Object)that.mText);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mText});
        }

        public String toString() {
            return this.mText;
        }
    }
}

