/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class FolderConfiguration
implements Comparable<FolderConfiguration> {
    private static final ResourceQualifier[] DEFAULT_QUALIFIERS;
    public static final Splitter QUALIFIER_SPLITTER;
    private final ResourceQualifier[] mQualifiers = new ResourceQualifier[21];
    private static final int INDEX_COUNTRY_CODE = 0;
    private static final int INDEX_NETWORK_CODE = 1;
    private static final int INDEX_LOCALE = 2;
    private static final int INDEX_LAYOUT_DIR = 3;
    private static final int INDEX_SMALLEST_SCREEN_WIDTH = 4;
    private static final int INDEX_SCREEN_WIDTH = 5;
    private static final int INDEX_SCREEN_HEIGHT = 6;
    private static final int INDEX_SCREEN_LAYOUT_SIZE = 7;
    private static final int INDEX_SCREEN_RATIO = 8;
    private static final int INDEX_SCREEN_ROUND = 9;
    private static final int INDEX_SCREEN_ORIENTATION = 10;
    private static final int INDEX_UI_MODE = 11;
    private static final int INDEX_NIGHT_MODE = 12;
    private static final int INDEX_PIXEL_DENSITY = 13;
    private static final int INDEX_TOUCH_TYPE = 14;
    private static final int INDEX_KEYBOARD_STATE = 15;
    private static final int INDEX_TEXT_INPUT_METHOD = 16;
    private static final int INDEX_NAVIGATION_STATE = 17;
    private static final int INDEX_NAVIGATION_METHOD = 18;
    private static final int INDEX_SCREEN_DIMENSION = 19;
    private static final int INDEX_VERSION = 20;
    private static final int INDEX_COUNT = 21;
    private static final ResourceQualifier[] NULL_QUALIFIERS;

    public FolderConfiguration() {
        this(NULL_QUALIFIERS);
    }

    private FolderConfiguration(ResourceQualifier[] qualifiers) {
        System.arraycopy(qualifiers, 0, this.mQualifiers, 0, 21);
    }

    public static FolderConfiguration getConfig(String[] folderSegments) {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])folderSegments);
        if (iterator.hasNext()) {
            iterator.next();
        }
        return FolderConfiguration.getConfigFromQualifiers((Iterator<String>)iterator);
    }

    public static FolderConfiguration getConfig(Iterable<String> folderSegments) {
        Iterator<String> iterator = folderSegments.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return FolderConfiguration.getConfigFromQualifiers(iterator);
    }

    public static FolderConfiguration getConfigFromQualifiers(Iterable<String> qualifiers) {
        return FolderConfiguration.getConfigFromQualifiers(qualifiers.iterator());
    }

    public static FolderConfiguration getConfigFromQualifiers(Iterator<String> qualifiers) {
        String seg;
        FolderConfiguration config = new FolderConfiguration();
        int qualifierIndex = 0;
        int qualifierCount = DEFAULT_QUALIFIERS.length;
        if (!qualifiers.hasNext()) {
            return config;
        }
        while (qualifiers.hasNext()) {
            seg = qualifiers.next();
            if (seg.isEmpty()) {
                return null;
            }
            seg = seg.toLowerCase(Locale.US);
            while (qualifierIndex < 2 && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                ++qualifierIndex;
            }
            if (qualifierIndex == 2) {
                boolean handle = true;
                if (DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                    ++qualifierIndex;
                    if (qualifiers.hasNext()) {
                        seg = qualifiers.next();
                        if (seg.isEmpty()) {
                            return null;
                        }
                        if (LocaleQualifier.isRegionSegment(seg)) {
                            LocaleQualifier localeQualifier = config.getLocaleQualifier();
                            assert (localeQualifier != null);
                            localeQualifier.setRegionSegment(seg);
                            handle = false;
                        } else {
                            seg = seg.toLowerCase(Locale.US);
                        }
                    } else {
                        return config;
                    }
                }
                if (!handle) break;
                while (qualifierIndex < qualifierCount && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                    ++qualifierIndex;
                }
                if (qualifierIndex == qualifierCount) {
                    return null;
                }
                ++qualifierIndex;
                break;
            }
            ++qualifierIndex;
        }
        while (qualifiers.hasNext()) {
            seg = qualifiers.next();
            if (seg.isEmpty()) {
                return null;
            }
            seg = seg.toLowerCase(Locale.US);
            while (qualifierIndex < qualifierCount && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                ++qualifierIndex;
            }
            if (qualifierIndex == qualifierCount) {
                return null;
            }
            ++qualifierIndex;
        }
        return config;
    }

    public static FolderConfiguration getConfigForFolder(String folderName) {
        return FolderConfiguration.getConfig(QUALIFIER_SPLITTER.split((CharSequence)folderName));
    }

    public static FolderConfiguration copyOf(FolderConfiguration original) {
        return new FolderConfiguration(original.mQualifiers);
    }

    public static FolderConfiguration getConfigForQualifierString(String qualifierString) {
        if (qualifierString.isEmpty()) {
            return new FolderConfiguration();
        }
        return FolderConfiguration.getConfigFromQualifiers(QUALIFIER_SPLITTER.split((CharSequence)qualifierString));
    }

    public static int getQualifierCount() {
        return 21;
    }

    public void set(FolderConfiguration config) {
        this.set(config, false);
    }

    public void set(FolderConfiguration config, boolean nonFakeValuesOnly) {
        if (config != null) {
            for (int i = 0; i < 21; ++i) {
                ResourceQualifier q = config.mQualifiers[i];
                if (nonFakeValuesOnly && q != null && q.hasFakeValue()) continue;
                this.mQualifiers[i] = q;
            }
        }
    }

    public void reset() {
        for (int i = 0; i < 21; ++i) {
            this.mQualifiers[i] = NULL_QUALIFIERS[i];
        }
    }

    public void substract(FolderConfiguration config) {
        for (int i = 0; i < 21; ++i) {
            if (!ResourceQualifier.isValid(config.mQualifiers[i])) continue;
            this.mQualifiers[i] = NULL_QUALIFIERS[i];
        }
    }

    public void add(FolderConfiguration config) {
        for (int i = 0; i < 21; ++i) {
            if (config.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            this.mQualifiers[i] = config.mQualifiers[i];
        }
    }

    public ResourceQualifier getInvalidQualifier() {
        for (int i = 0; i < 21; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i].isValid()) continue;
            return this.mQualifiers[i];
        }
        return null;
    }

    public void addQualifier(ResourceQualifier qualifier) {
        if (qualifier instanceof CountryCodeQualifier) {
            this.mQualifiers[0] = qualifier;
        } else if (qualifier instanceof NetworkCodeQualifier) {
            this.mQualifiers[1] = qualifier;
        } else if (qualifier instanceof LocaleQualifier) {
            this.mQualifiers[2] = qualifier;
        } else if (qualifier instanceof LayoutDirectionQualifier) {
            this.mQualifiers[3] = qualifier;
        } else if (qualifier instanceof SmallestScreenWidthQualifier) {
            this.mQualifiers[4] = qualifier;
        } else if (qualifier instanceof ScreenWidthQualifier) {
            this.mQualifiers[5] = qualifier;
        } else if (qualifier instanceof ScreenHeightQualifier) {
            this.mQualifiers[6] = qualifier;
        } else if (qualifier instanceof ScreenSizeQualifier) {
            this.mQualifiers[7] = qualifier;
        } else if (qualifier instanceof ScreenRatioQualifier) {
            this.mQualifiers[8] = qualifier;
        } else if (qualifier instanceof ScreenRoundQualifier) {
            this.mQualifiers[9] = qualifier;
        } else if (qualifier instanceof ScreenOrientationQualifier) {
            this.mQualifiers[10] = qualifier;
        } else if (qualifier instanceof UiModeQualifier) {
            this.mQualifiers[11] = qualifier;
        } else if (qualifier instanceof NightModeQualifier) {
            this.mQualifiers[12] = qualifier;
        } else if (qualifier instanceof DensityQualifier) {
            this.mQualifiers[13] = qualifier;
        } else if (qualifier instanceof TouchScreenQualifier) {
            this.mQualifiers[14] = qualifier;
        } else if (qualifier instanceof KeyboardStateQualifier) {
            this.mQualifiers[15] = qualifier;
        } else if (qualifier instanceof TextInputMethodQualifier) {
            this.mQualifiers[16] = qualifier;
        } else if (qualifier instanceof NavigationStateQualifier) {
            this.mQualifiers[17] = qualifier;
        } else if (qualifier instanceof NavigationMethodQualifier) {
            this.mQualifiers[18] = qualifier;
        } else if (qualifier instanceof ScreenDimensionQualifier) {
            this.mQualifiers[19] = qualifier;
        } else if (qualifier instanceof VersionQualifier) {
            this.mQualifiers[20] = qualifier;
        }
    }

    public void removeQualifier(ResourceQualifier qualifier) {
        for (int i = 0; i < 21; ++i) {
            if (this.mQualifiers[i] != qualifier) continue;
            this.mQualifiers[i] = NULL_QUALIFIERS[i];
            return;
        }
    }

    public ResourceQualifier getQualifier(int index) {
        return this.mQualifiers[index];
    }

    public void setCountryCodeQualifier(CountryCodeQualifier qualifier) {
        this.mQualifiers[0] = qualifier == null ? NULL_QUALIFIERS[0] : qualifier;
    }

    public CountryCodeQualifier getCountryCodeQualifier() {
        return (CountryCodeQualifier)this.mQualifiers[0];
    }

    public void setNetworkCodeQualifier(NetworkCodeQualifier qualifier) {
        this.mQualifiers[1] = qualifier == null ? NULL_QUALIFIERS[1] : qualifier;
    }

    public NetworkCodeQualifier getNetworkCodeQualifier() {
        return (NetworkCodeQualifier)this.mQualifiers[1];
    }

    public void setLocaleQualifier(LocaleQualifier qualifier) {
        this.mQualifiers[2] = qualifier == null ? NULL_QUALIFIERS[2] : qualifier;
    }

    public LocaleQualifier getLocaleQualifier() {
        return (LocaleQualifier)this.mQualifiers[2];
    }

    public void setLayoutDirectionQualifier(LayoutDirectionQualifier qualifier) {
        this.mQualifiers[3] = qualifier == null ? NULL_QUALIFIERS[3] : qualifier;
    }

    public LayoutDirectionQualifier getLayoutDirectionQualifier() {
        return (LayoutDirectionQualifier)this.mQualifiers[3];
    }

    public void setSmallestScreenWidthQualifier(SmallestScreenWidthQualifier qualifier) {
        this.mQualifiers[4] = qualifier == null ? NULL_QUALIFIERS[4] : qualifier;
    }

    public SmallestScreenWidthQualifier getSmallestScreenWidthQualifier() {
        return (SmallestScreenWidthQualifier)this.mQualifiers[4];
    }

    public void setScreenWidthQualifier(ScreenWidthQualifier qualifier) {
        this.mQualifiers[5] = qualifier == null ? NULL_QUALIFIERS[5] : qualifier;
    }

    public ScreenWidthQualifier getScreenWidthQualifier() {
        return (ScreenWidthQualifier)this.mQualifiers[5];
    }

    public void setScreenHeightQualifier(ScreenHeightQualifier qualifier) {
        this.mQualifiers[6] = qualifier == null ? NULL_QUALIFIERS[6] : qualifier;
    }

    public ScreenHeightQualifier getScreenHeightQualifier() {
        return (ScreenHeightQualifier)this.mQualifiers[6];
    }

    public void setScreenSizeQualifier(ScreenSizeQualifier qualifier) {
        this.mQualifiers[7] = qualifier == null ? NULL_QUALIFIERS[7] : qualifier;
    }

    public ScreenSizeQualifier getScreenSizeQualifier() {
        return (ScreenSizeQualifier)this.mQualifiers[7];
    }

    public void setScreenRatioQualifier(ScreenRatioQualifier qualifier) {
        this.mQualifiers[8] = qualifier == null ? NULL_QUALIFIERS[8] : qualifier;
    }

    public ScreenRatioQualifier getScreenRatioQualifier() {
        return (ScreenRatioQualifier)this.mQualifiers[8];
    }

    public void setScreenRoundQualifier(ScreenRoundQualifier qualifier) {
        this.mQualifiers[9] = qualifier == null ? NULL_QUALIFIERS[9] : qualifier;
    }

    public ScreenRoundQualifier getScreenRoundQualifier() {
        return (ScreenRoundQualifier)this.mQualifiers[9];
    }

    public void setScreenOrientationQualifier(ScreenOrientationQualifier qualifier) {
        this.mQualifiers[10] = qualifier == null ? NULL_QUALIFIERS[10] : qualifier;
    }

    public ScreenOrientationQualifier getScreenOrientationQualifier() {
        return (ScreenOrientationQualifier)this.mQualifiers[10];
    }

    public void setUiModeQualifier(UiModeQualifier qualifier) {
        this.mQualifiers[11] = qualifier == null ? NULL_QUALIFIERS[11] : qualifier;
    }

    public UiModeQualifier getUiModeQualifier() {
        return (UiModeQualifier)this.mQualifiers[11];
    }

    public void setNightModeQualifier(NightModeQualifier qualifier) {
        this.mQualifiers[12] = qualifier == null ? NULL_QUALIFIERS[12] : qualifier;
    }

    public NightModeQualifier getNightModeQualifier() {
        return (NightModeQualifier)this.mQualifiers[12];
    }

    public void setDensityQualifier(DensityQualifier qualifier) {
        this.mQualifiers[13] = qualifier == null ? NULL_QUALIFIERS[13] : qualifier;
    }

    public DensityQualifier getDensityQualifier() {
        return (DensityQualifier)this.mQualifiers[13];
    }

    public void setTouchTypeQualifier(TouchScreenQualifier qualifier) {
        this.mQualifiers[14] = qualifier == null ? NULL_QUALIFIERS[14] : qualifier;
    }

    public TouchScreenQualifier getTouchTypeQualifier() {
        return (TouchScreenQualifier)this.mQualifiers[14];
    }

    public void setKeyboardStateQualifier(KeyboardStateQualifier qualifier) {
        this.mQualifiers[15] = qualifier == null ? NULL_QUALIFIERS[15] : qualifier;
    }

    public KeyboardStateQualifier getKeyboardStateQualifier() {
        return (KeyboardStateQualifier)this.mQualifiers[15];
    }

    public void setTextInputMethodQualifier(TextInputMethodQualifier qualifier) {
        this.mQualifiers[16] = qualifier == null ? NULL_QUALIFIERS[16] : qualifier;
    }

    public TextInputMethodQualifier getTextInputMethodQualifier() {
        return (TextInputMethodQualifier)this.mQualifiers[16];
    }

    public void setNavigationStateQualifier(NavigationStateQualifier qualifier) {
        this.mQualifiers[17] = qualifier == null ? NULL_QUALIFIERS[17] : qualifier;
    }

    public NavigationStateQualifier getNavigationStateQualifier() {
        return (NavigationStateQualifier)this.mQualifiers[17];
    }

    public void setNavigationMethodQualifier(NavigationMethodQualifier qualifier) {
        this.mQualifiers[18] = qualifier == null ? NULL_QUALIFIERS[18] : qualifier;
    }

    public NavigationMethodQualifier getNavigationMethodQualifier() {
        return (NavigationMethodQualifier)this.mQualifiers[18];
    }

    public void setScreenDimensionQualifier(ScreenDimensionQualifier qualifier) {
        this.mQualifiers[19] = qualifier == null ? NULL_QUALIFIERS[19] : qualifier;
    }

    public ScreenDimensionQualifier getScreenDimensionQualifier() {
        return (ScreenDimensionQualifier)this.mQualifiers[19];
    }

    public void setVersionQualifier(VersionQualifier qualifier) {
        this.mQualifiers[20] = qualifier == null ? NULL_QUALIFIERS[20] : qualifier;
    }

    public VersionQualifier getVersionQualifier() {
        return (VersionQualifier)this.mQualifiers[20];
    }

    public void normalize() {
        int minSdk = 1;
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            int min;
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == NULL_QUALIFIERS[i] || (min = qualifier.since()) <= minSdk) continue;
            minSdk = min;
        }
        if (minSdk == 1) {
            return;
        }
        if (this.mQualifiers[20] == NULL_QUALIFIERS[20] || ((VersionQualifier)this.mQualifiers[20]).getVersion() < minSdk) {
            this.mQualifiers[20] = new VersionQualifier(minSdk);
        }
    }

    public void updateScreenWidthAndHeight() {
        ResourceQualifier sizeQ = this.mQualifiers[19];
        ResourceQualifier densityQ = this.mQualifiers[13];
        ResourceQualifier orientQ = this.mQualifiers[10];
        if (sizeQ != NULL_QUALIFIERS[19] && densityQ != NULL_QUALIFIERS[13] && orientQ != NULL_QUALIFIERS[10]) {
            int size2;
            Density density = ((DensityQualifier)densityQ).getValue();
            if (density == Density.NODPI || density == Density.ANYDPI) {
                return;
            }
            ScreenOrientation orientation = ((ScreenOrientationQualifier)orientQ).getValue();
            int size1 = ((ScreenDimensionQualifier)sizeQ).getValue1();
            if (size1 < (size2 = ((ScreenDimensionQualifier)sizeQ).getValue2())) {
                int a = size1;
                size1 = size2;
                size2 = a;
            }
            int dp1 = (int)Math.ceil(size1 * 160 / density.getDpiValue());
            int dp2 = (int)Math.ceil(size2 * 160 / density.getDpiValue());
            this.setSmallestScreenWidthQualifier(new SmallestScreenWidthQualifier(dp2));
            switch (orientation) {
                case PORTRAIT: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp2));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp1));
                    break;
                }
                case LANDSCAPE: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp1));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp2));
                    break;
                }
                case SQUARE: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp2));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp2));
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FolderConfiguration) {
            FolderConfiguration fc = (FolderConfiguration)obj;
            for (int i = 0; i < 21; ++i) {
                ResourceQualifier qualifier = this.mQualifiers[i];
                ResourceQualifier fcQualifier = fc.mQualifiers[i];
                if (Objects.equal((Object)qualifier, (Object)fcQualifier)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isDefault() {
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            ResourceQualifier irq = this.mQualifiers[i];
            if (irq == NULL_QUALIFIERS[i]) continue;
            return false;
        }
        return true;
    }

    public String getFolderName(ResourceFolderType folder) {
        StringBuilder result = new StringBuilder(folder.getName());
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            String segment;
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == NULL_QUALIFIERS[i] || (segment = qualifier.getFolderSegment()) == null || segment.isEmpty()) continue;
            result.append("-");
            result.append(segment);
        }
        return result.toString();
    }

    public String getUniqueKey() {
        StringBuilder result = new StringBuilder(100);
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            String segment;
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == NULL_QUALIFIERS[i] || (segment = qualifier.getFolderSegment()) == null || segment.isEmpty()) continue;
            result.append("-");
            result.append(segment);
        }
        return result.toString();
    }

    public String getQualifierString() {
        StringBuilder result = new StringBuilder(40);
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            String segment;
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == NULL_QUALIFIERS[i] || (segment = qualifier.getFolderSegment()) == null || segment.isEmpty()) continue;
            if (result.length() > 0) {
                result.append("-");
            }
            result.append(segment);
        }
        return result.toString();
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        if (this.isDefault()) {
            return "default";
        }
        StringBuilder result = null;
        int index = 0;
        while (index < 21) {
            ResourceQualifier qualifier = this.mQualifiers[index];
            if (qualifier == NULL_QUALIFIERS[index++]) continue;
            if (result == null) {
                result = new StringBuilder();
            } else {
                result.append(", ");
            }
            result.append(qualifier.getLongDisplayValue());
        }
        return result == null ? "" : result.toString();
    }

    public String toShortDisplayString() {
        if (this.isDefault()) {
            return "default";
        }
        StringBuilder result = new StringBuilder(100);
        int index = 0;
        while (index < 21) {
            ResourceQualifier qualifier = this.mQualifiers[index];
            if (qualifier == NULL_QUALIFIERS[index++]) continue;
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(qualifier.getShortDisplayValue());
        }
        return result.toString();
    }

    @Override
    public int compareTo(FolderConfiguration folderConfig) {
        if (this.isDefault()) {
            if (folderConfig.isDefault()) {
                return 0;
            }
            return -1;
        }
        for (int i = 0; i < 21; ++i) {
            ResourceQualifier qualifier1 = this.mQualifiers[i];
            ResourceQualifier qualifier2 = folderConfig.mQualifiers[i];
            if (Objects.equal((Object)qualifier1, (Object)qualifier2)) continue;
            if (qualifier1 != null && qualifier2 != null) {
                return qualifier1.compareTo(qualifier2);
            }
            return qualifier1 == NULL_QUALIFIERS[i] ? -1 : 1;
        }
        return 0;
    }

    public <T extends Configurable> T findMatchingConfigurable(List<T> configurables) {
        List<T> matches = this.findMatchingConfigurables(configurables);
        return (T)(matches.isEmpty() ? null : (Configurable)matches.get(0));
    }

    public <T extends Configurable> List<T> findMatchingConfigurables(List<T> configurables) {
        if (configurables == null) {
            return Collections.emptyList();
        }
        ArrayList<Configurable> matchingConfigurables = new ArrayList<Configurable>();
        for (Configurable res : configurables) {
            FolderConfiguration configuration = res.getConfiguration();
            if (configuration == null || !configuration.isMatchFor(this)) continue;
            matchingConfigurables.add(res);
        }
        if (matchingConfigurables.size() < 2) {
            return matchingConfigurables;
        }
        int count = FolderConfiguration.getQualifierCount();
        for (int q = 0; q < count; ++q) {
            ResourceQualifier referenceQualifier = this.getQualifier(q);
            if (referenceQualifier == NULL_QUALIFIERS[q] || referenceQualifier == null) continue;
            boolean found = false;
            ResourceQualifier bestMatch = null;
            for (Configurable configurable : matchingConfigurables) {
                ResourceQualifier qualifier = configurable.getConfiguration().getQualifier(q);
                if (qualifier == null) continue;
                found = true;
                if (!qualifier.isBetterMatchThan(bestMatch, referenceQualifier)) continue;
                bestMatch = qualifier;
            }
            if (!found) continue;
            int i = 0;
            while (i < matchingConfigurables.size()) {
                Configurable configurable;
                configurable = (Configurable)matchingConfigurables.get(i);
                FolderConfiguration configuration = configurable.getConfiguration();
                ResourceQualifier qualifier = configuration.getQualifier(q);
                if (qualifier == null) {
                    matchingConfigurables.remove(configurable);
                    continue;
                }
                if (bestMatch != null && !bestMatch.equals(qualifier)) {
                    matchingConfigurables.remove(configurable);
                    continue;
                }
                ++i;
            }
            if (matchingConfigurables.size() < 2) break;
        }
        return matchingConfigurables;
    }

    public boolean isMatchFor(FolderConfiguration referenceConfig) {
        if (referenceConfig == null) {
            return false;
        }
        for (int i = 0; i < 21; ++i) {
            ResourceQualifier testQualifier = this.mQualifiers[i];
            ResourceQualifier referenceQualifier = referenceConfig.mQualifiers[i];
            if (testQualifier == null || testQualifier == testQualifier.getNullQualifier() || referenceQualifier == null || referenceQualifier == referenceQualifier.getNullQualifier() || testQualifier.isMatchFor(referenceQualifier)) continue;
            return false;
        }
        return true;
    }

    public int getHighestPriorityQualifier(int startIndex) {
        for (int i = startIndex; i < 21; ++i) {
            if (this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            return i;
        }
        return -1;
    }

    public void createDefault() {
        this.mQualifiers[0] = new CountryCodeQualifier();
        this.mQualifiers[1] = new NetworkCodeQualifier();
        this.mQualifiers[2] = new LocaleQualifier();
        this.mQualifiers[3] = new LayoutDirectionQualifier();
        this.mQualifiers[4] = new SmallestScreenWidthQualifier();
        this.mQualifiers[5] = new ScreenWidthQualifier();
        this.mQualifiers[6] = new ScreenHeightQualifier();
        this.mQualifiers[7] = new ScreenSizeQualifier();
        this.mQualifiers[8] = new ScreenRatioQualifier();
        this.mQualifiers[9] = new ScreenRoundQualifier();
        this.mQualifiers[10] = new ScreenOrientationQualifier();
        this.mQualifiers[11] = new UiModeQualifier();
        this.mQualifiers[12] = new NightModeQualifier();
        this.mQualifiers[13] = new DensityQualifier();
        this.mQualifiers[14] = new TouchScreenQualifier();
        this.mQualifiers[15] = new KeyboardStateQualifier();
        this.mQualifiers[16] = new TextInputMethodQualifier();
        this.mQualifiers[17] = new NavigationStateQualifier();
        this.mQualifiers[18] = new NavigationMethodQualifier();
        this.mQualifiers[19] = new ScreenDimensionQualifier();
        this.mQualifiers[20] = new VersionQualifier();
    }

    public ResourceQualifier[] getQualifiers() {
        int count = 0;
        for (int i = 0; i < 21; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            ++count;
        }
        ResourceQualifier[] array = new ResourceQualifier[count];
        int index = 0;
        for (int i = 0; i < 21; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            array[index++] = this.mQualifiers[i];
        }
        return array;
    }

    static {
        QUALIFIER_SPLITTER = Splitter.on((char)'-');
        NULL_QUALIFIERS = new ResourceQualifier[21];
        FolderConfiguration defaultConfig = new FolderConfiguration();
        defaultConfig.createDefault();
        DEFAULT_QUALIFIERS = defaultConfig.mQualifiers;
        for (int i = 0; i < DEFAULT_QUALIFIERS.length; ++i) {
            FolderConfiguration.NULL_QUALIFIERS[i] = DEFAULT_QUALIFIERS[i].getNullQualifier();
        }
    }
}

