/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class FilteredClassLoader
extends ClassLoader {
    private final ImmutableSet<String> myFilteredClasses;

    FilteredClassLoader(ClassLoader parent, Set<String> filteredClasses) {
        super(parent);
        this.myFilteredClasses = ImmutableSet.copyOf(filteredClasses);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String lookupName = name;
        int dollarIdx = lookupName.indexOf("$");
        if (dollarIdx != -1) {
            lookupName = lookupName.substring(0, dollarIdx);
        }
        if (this.myFilteredClasses.contains((Object)lookupName)) {
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }
}

