/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import java.io.File;
import java.util.Properties;

public class LocalExtraPkgInfo
extends LocalPkgInfo {
    @NonNull
    private final IPkgDescExtra mDesc;

    public LocalExtraPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps, @NonNull IdDisplay vendor, @NonNull String path, @Nullable String displayName, @NonNull String[] oldPaths, @NonNull NoPreviewRevision revision) {
        super(localSdk, localDir, sourceProps);
        this.mDesc = (IPkgDescExtra)PkgDesc.Builder.newExtra(vendor, path, displayName, oldPaths, revision).create();
    }

    @Override
    @NonNull
    public IPkgDesc getDesc() {
        return this.mDesc;
    }

    @NonNull
    public String[] getOldPaths() {
        return this.mDesc.getOldPaths();
    }

    @Override
    @Nullable
    public Package getPackage() {
        Package pkg = super.getPackage();
        if (pkg == null) {
            try {
                pkg = ExtraPackage.create(null, this.getSourceProperties(), this.mDesc.getVendor().getId(), this.mDesc.getPath(), 0, null, null, null, this.getLocalDir().getPath());
                this.setPackage(pkg);
            }
            catch (Exception e) {
                this.appendLoadError("Failed to parse package: %1$s", e.toString());
            }
        }
        return pkg;
    }

    public static String getPrettyName(@Nullable IdDisplay vendor, @NonNull String extraPath) {
        String disp;
        String name = extraPath;
        String string = disp = vendor == null ? null : vendor.getDisplay();
        if (disp != null && disp.length() > 0 && name.startsWith(disp + "-")) {
            name = name.substring(disp.length() + 1);
        }
        if (name != null) {
            name = name.replaceAll("[ _\t\f-]+", " ").trim();
        }
        if (name == null || name.length() == 0) {
            name = "Unknown Extra";
        }
        if (disp != null && disp.length() > 0) {
            name = disp + " " + name;
            name = name.replaceAll("[ _\t\f-]+", " ").trim();
        }
        boolean changed = false;
        char[] chars = name.toCharArray();
        int n = chars.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!Character.isLowerCase(chars[i]) || i != 0 && chars[i - 1] != ' ') continue;
            chars[i] = Character.toUpperCase(chars[i]);
            changed = true;
        }
        if (changed) {
            name = new String(chars);
        }
        name = name.replaceAll(" Usb ", " USB ");
        name = name.replaceAll(" Api ", " API ");
        return name;
    }
}

