/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.hiddenapi;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.NonNull;
import com.anggrayudi.hiddenapi.ResourcesHolder;
import java.io.InputStream;
import java.lang.reflect.Method;

public final class InternalAccessor {
    public static final String ANIM = "anim";
    public static final String ARRAY = "array";
    public static final String ATTR = "attr";
    public static final String BOOL = "bool";
    public static final String COLOR = "color";
    public static final String DIMEN = "dimen";
    public static final String DRAWABLE = "drawable";
    public static final String ID = "id";
    public static final String INTEGER = "integer";
    public static final String LAYOUT = "layout";
    public static final String PLURALS = "plurals";
    public static final String RAW = "raw";
    public static final String STRING = "string";
    public static final String STYLE = "style";
    public static final String STYLEABLE = "styleable";
    public static final String XML = "xml";
    public static final String FRACTION = "fraction";
    public static final String INTERPOLATOR = "interpolator";
    public static final String MENU = "menu";
    public static final String MIPMAP = "mipmap";
    public static final String TRANSITION = "transition";

    private InternalAccessor() {
    }

    public static int getResourceId(@NonNull String clas, @NonNull String resName) {
        int id = Resources.getSystem().getIdentifier(resName, clas, "android");
        if (id == 0) {
            throw new Resources.NotFoundException("Cannot find '" + clas + "' for '" + resName + "', or this resource currently is not available for API " + Build.VERSION.SDK_INT);
        }
        return id;
    }

    public static XmlResourceParser getAnimation(@NonNull String resName) {
        return Resources.getSystem().getAnimation(InternalAccessor.getResourceId(ANIM, resName));
    }

    public static boolean getBoolean(@NonNull String resName) {
        return Resources.getSystem().getBoolean(InternalAccessor.getResourceId(BOOL, resName));
    }

    public static int getColor(@NonNull String resName) {
        return Resources.getSystem().getColor(InternalAccessor.getResourceId(COLOR, resName));
    }

    public static float getDimension(@NonNull String resName) {
        return Resources.getSystem().getDimension(InternalAccessor.getResourceId(DIMEN, resName));
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    public static Drawable getDrawable(@NonNull String resName) {
        return Resources.getSystem().getDrawable(InternalAccessor.getResourceId(DRAWABLE, resName));
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    @TargetApi(value=21)
    public static Drawable getDrawable(@NonNull String resName, Resources.Theme theme) {
        return Resources.getSystem().getDrawable(InternalAccessor.getResourceId(DRAWABLE, resName), theme);
    }

    @TargetApi(value=11)
    public static float getFraction(@NonNull String resName, int base, int pbase) {
        return Resources.getSystem().getFraction(InternalAccessor.getResourceId(FRACTION, resName), base, pbase);
    }

    public static int getInteger(@NonNull String resName) {
        return Resources.getSystem().getInteger(InternalAccessor.getResourceId(INTEGER, resName));
    }

    public static XmlResourceParser getLayout(@NonNull String resName) {
        return Resources.getSystem().getLayout(InternalAccessor.getResourceId(LAYOUT, resName));
    }

    @TargetApi(value=11)
    public static XmlResourceParser getMenu(@NonNull String resName) {
        return Resources.getSystem().getLayout(InternalAccessor.getResourceId(MENU, resName));
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    public static Drawable getMipmap(@NonNull String resName) {
        return Resources.getSystem().getDrawable(InternalAccessor.getResourceId(MIPMAP, resName));
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    @TargetApi(value=21)
    public static Drawable getMipmap(@NonNull String resName, Resources.Theme theme) {
        return Resources.getSystem().getDrawable(InternalAccessor.getResourceId(MIPMAP, resName), theme);
    }

    public static InputStream getRaw(@NonNull String resName) {
        return Resources.getSystem().openRawResource(InternalAccessor.getResourceId(RAW, resName));
    }

    public static int[] getIntArray(@NonNull String resName) {
        return Resources.getSystem().getIntArray(InternalAccessor.getResourceId(ARRAY, resName));
    }

    public static String[] getStringArray(@NonNull String resName) {
        return Resources.getSystem().getStringArray(InternalAccessor.getResourceId(ARRAY, resName));
    }

    public static String getString(@NonNull String resName) {
        return Resources.getSystem().getString(InternalAccessor.getResourceId(STRING, resName));
    }

    public static XmlResourceParser getXml(@NonNull String resName) {
        return Resources.getSystem().getXml(InternalAccessor.getResourceId(XML, resName));
    }

    public static boolean isClassExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isMethodExists(String className, String methodName, Class<?> ... parameterTypes) {
        try {
            Class<?> cls = Class.forName(className);
            cls.getMethod(methodName, parameterTypes);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isMethodExists(String className, String methodName) {
        try {
            Class<?> cls = Class.forName(className);
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static class Builder {
        final boolean saveToResourcesHolder;
        ResourcesHolder holder = new ResourcesHolder();

        public Builder(boolean saveToResourcesHolder) {
            this.saveToResourcesHolder = saveToResourcesHolder;
        }

        public ResourcesHolder getResourcesHolder() {
            return this.holder;
        }

        public XmlResourceParser getAnimation(@NonNull String resName) {
            XmlResourceParser anim = InternalAccessor.getAnimation(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, anim);
            }
            return anim;
        }

        public boolean getBoolean(@NonNull String resName) {
            boolean bol = InternalAccessor.getBoolean(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, bol);
            }
            return bol;
        }

        public int getColor(@NonNull String resName) {
            int color = InternalAccessor.getColor(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, color);
            }
            return color;
        }

        public float getDimension(@NonNull String resName) {
            float dimens = InternalAccessor.getDimension(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, dimens);
            }
            return dimens;
        }

        public Drawable getDrawable(@NonNull String resName) {
            Drawable drawable = InternalAccessor.getDrawable(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, drawable);
            }
            return drawable;
        }

        @TargetApi(value=11)
        public float getFraction(@NonNull String resName, int base, int pbase) {
            float fract = InternalAccessor.getFraction(resName, base, pbase);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, fract);
            }
            return fract;
        }

        public int getInteger(@NonNull String resName) {
            int integer = InternalAccessor.getInteger(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, integer);
            }
            return integer;
        }

        public XmlResourceParser getLayout(@NonNull String resName) {
            XmlResourceParser layout = InternalAccessor.getLayout(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, layout);
            }
            return layout;
        }

        @TargetApi(value=11)
        public XmlResourceParser getMenu(@NonNull String resName) {
            XmlResourceParser menu = InternalAccessor.getMenu(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, menu);
            }
            return menu;
        }

        @TargetApi(value=11)
        public Drawable getMipmap(@NonNull String resName) {
            Drawable mipmap = InternalAccessor.getMipmap(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, mipmap);
            }
            return mipmap;
        }

        public InputStream getRaw(@NonNull String resName) {
            InputStream stream = InternalAccessor.getRaw(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, stream);
            }
            return stream;
        }

        public int[] getIntArray(@NonNull String resName) {
            int[] ints = InternalAccessor.getIntArray(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, ints);
            }
            return ints;
        }

        public String[] getStringArray(@NonNull String resName) {
            String[] strings = InternalAccessor.getStringArray(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, strings);
            }
            return strings;
        }

        public String getString(@NonNull String resName) {
            String string = InternalAccessor.getString(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, string);
            }
            return string;
        }

        public XmlResourceParser getXml(@NonNull String resName) {
            XmlResourceParser xml = InternalAccessor.getXml(resName);
            if (this.saveToResourcesHolder) {
                this.holder.put(resName, xml);
            }
            return xml;
        }
    }
}

