/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.hiddenapi;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ResourcesHolder
implements Parcelable {
    public static final String ACTION_SEND_RESOURCES_HOLDER = "com.anggrayudi.hiddenapi.ACTION_SEND_RESOURCES_HOLDER";
    public static final Parcelable.Creator<ResourcesHolder> CREATOR = new Parcelable.Creator<ResourcesHolder>(){

        public ResourcesHolder createFromParcel(Parcel in) {
            return new ResourcesHolder(in);
        }

        public ResourcesHolder[] newArray(int size) {
            return new ResourcesHolder[size];
        }
    };
    private static final String TAG = "ResourcesHolder";
    private HashMap<String, Object> mValues = new HashMap();

    public ResourcesHolder() {
    }

    private ResourcesHolder(Parcel in) {
        this.mValues = (HashMap)in.readValue(HashMap.class.getClassLoader());
    }

    public ResourcesHolder put(String key, short value) {
        this.mValues.put(key, value);
        return this;
    }

    public ResourcesHolder put(String key, byte value) {
        this.mValues.put(key, value);
        return this;
    }

    public ResourcesHolder put(String key, char value) {
        this.mValues.put(key, Character.valueOf(value));
        return this;
    }

    public ResourcesHolder put(String key, boolean value) {
        this.mValues.put(key, value);
        return this;
    }

    public ResourcesHolder put(String key, int value) {
        this.mValues.put(key, value);
        return this;
    }

    public ResourcesHolder put(String key, long value) {
        this.mValues.put(key, value);
        return this;
    }

    public ResourcesHolder put(String key, float value) {
        this.mValues.put(key, Float.valueOf(value));
        return this;
    }

    public ResourcesHolder put(String key, double value) {
        this.mValues.put(key, value);
        return this;
    }

    public ResourcesHolder put(String key, String value) {
        this.mValues.put(key, value);
        return this;
    }

    public ResourcesHolder put(String key, Object object) {
        this.mValues.put(key, object);
        return this;
    }

    public short getAsShort(String key) {
        return this.isCompatibleCast(key, Short.class) ? (Short)this.mValues.get(key) : (short)0;
    }

    public byte getAsByte(String key) {
        return this.isCompatibleCast(key, Byte.class) ? (Byte)this.mValues.get(key) : (byte)0;
    }

    public char getAsChar(String key) {
        return this.isCompatibleCast(key, Character.class) ? ((Character)this.mValues.get(key)).charValue() : (char)'\u0000';
    }

    public boolean getAsBoolean(String key) {
        return this.isCompatibleCast(key, Boolean.class) && (Boolean)this.mValues.get(key) != false;
    }

    public int getAsInteger(String key) {
        return this.isCompatibleCast(key, Integer.class) ? (Integer)this.mValues.get(key) : 0;
    }

    public long getAsLong(String key) {
        return this.isCompatibleCast(key, Long.class) ? (Long)this.mValues.get(key) : 0L;
    }

    public float getAsFloat(String key) {
        return this.isCompatibleCast(key, Float.class) ? ((Float)this.mValues.get(key)).floatValue() : 0.0f;
    }

    public double getAsDouble(String key) {
        return this.isCompatibleCast(key, Double.class) ? (Double)this.mValues.get(key) : 0.0;
    }

    public String getAsString(String key) {
        return this.isCompatibleCast(key, String.class) ? (String)this.mValues.get(key) : null;
    }

    public short[] getAsShortArray(String key) {
        return this.isCompatibleCast(key, short[].class) ? (short[])this.mValues.get(key) : null;
    }

    public byte[] getAsByteArray(String key) {
        return this.isCompatibleCast(key, byte[].class) ? (byte[])this.mValues.get(key) : null;
    }

    public char[] getAsCharArray(String key) {
        return this.isCompatibleCast(key, char[].class) ? (char[])this.mValues.get(key) : null;
    }

    public boolean[] getAsBooleanArray(String key) {
        return this.isCompatibleCast(key, boolean[].class) ? (boolean[])this.mValues.get(key) : null;
    }

    public int[] getAsIntArray(String key) {
        return this.isCompatibleCast(key, int[].class) ? (int[])this.mValues.get(key) : null;
    }

    public long[] getAsLongArray(String key) {
        return this.isCompatibleCast(key, long[].class) ? (long[])this.mValues.get(key) : null;
    }

    public float[] getAsFloatArray(String key) {
        return this.isCompatibleCast(key, float[].class) ? (float[])this.mValues.get(key) : null;
    }

    public double[] getAsDoubleArray(String key) {
        return this.isCompatibleCast(key, double[].class) ? (double[])this.mValues.get(key) : null;
    }

    public String[] getAsStringArray(String key) {
        return this.isCompatibleCast(key, String[].class) ? (String[])this.mValues.get(key) : null;
    }

    public Object getAsObject(String key) {
        return this.mValues.get(key);
    }

    public void sendBroadcast(Context context, @NonNull String key) {
        Intent intent = new Intent(ACTION_SEND_RESOURCES_HOLDER);
        intent.putExtra(key, (Parcelable)this);
        context.sendBroadcast(intent);
    }

    public void sendViaLocalBroadcastManager(Context context, @NonNull String key) {
        Intent intent = new Intent(ACTION_SEND_RESOURCES_HOLDER);
        intent.putExtra(key, (Parcelable)this);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }

    public void clear() {
        this.mValues.clear();
    }

    public int size() {
        return this.mValues.size();
    }

    public boolean containsKey(String key) {
        return this.mValues.containsKey(key);
    }

    public void remove(String key) {
        this.mValues.remove(key);
    }

    public void sort(boolean descending) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(this.mValues);
        if (descending) {
            treeMap.descendingMap();
        }
        this.mValues.clear();
        this.mValues.putAll(treeMap);
    }

    public Set<Map.Entry<String, Object>> valueSet() {
        return this.mValues.entrySet();
    }

    public Set<String> keySet() {
        return this.mValues.keySet();
    }

    public void printAll() {
        for (Map.Entry<String, Object> entry : this.mValues.entrySet()) {
            Object value = entry.getValue();
            String toPrint = value.toString();
            if (value.getClass().isArray()) {
                if (value instanceof boolean[]) {
                    toPrint = Arrays.toString((boolean[])value);
                } else if (value instanceof int[]) {
                    toPrint = Arrays.toString((int[])value);
                } else if (value instanceof long[]) {
                    toPrint = Arrays.toString((long[])value);
                } else if (value instanceof float[]) {
                    toPrint = Arrays.toString((float[])value);
                } else if (value instanceof double[]) {
                    toPrint = Arrays.toString((double[])value);
                } else if (value instanceof String[]) {
                    toPrint = Arrays.toString((String[])value);
                } else if (value instanceof short[]) {
                    toPrint = Arrays.toString((short[])value);
                } else if (value instanceof byte[]) {
                    toPrint = Arrays.toString((byte[])value);
                } else if (value instanceof char[]) {
                    toPrint = Arrays.toString((char[])value);
                }
            }
            Log.d((String)TAG, (String)("key = " + entry.getKey() + ", value = " + toPrint));
        }
    }

    private boolean isCompatibleCast(String key, Class<?> classToCast) {
        Object obj = this.mValues.get(key);
        try {
            if (this.mValues.get(key) instanceof Number && obj == null) {
                Log.e((String)TAG, (String)("Cannot cast null value to a " + classToCast.getSimpleName() + " number format."));
                return false;
            }
            classToCast.cast(obj);
            return true;
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)("Cannot cast object value from " + obj + " to " + classToCast.getSimpleName() + " for key '" + key + "'"), (Throwable)e);
            return false;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue(this.mValues);
    }
}

