/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.UriPermission;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import androidx.activity.ComponentActivity;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.core.content.ContextCompat;
import androidx.documentfile.provider.DocumentFile;
import androidx.fragment.app.Fragment;
import com.anggrayudi.storage.ActivityWrapper;
import com.anggrayudi.storage.ComponentActivityWrapper;
import com.anggrayudi.storage.ComponentWrapper;
import com.anggrayudi.storage.FragmentWrapper;
import com.anggrayudi.storage.callback.CreateFileCallback;
import com.anggrayudi.storage.callback.FilePickerCallback;
import com.anggrayudi.storage.callback.FileReceiverCallback;
import com.anggrayudi.storage.callback.FolderPickerCallback;
import com.anggrayudi.storage.callback.StorageAccessCallback;
import com.anggrayudi.storage.extension.ContextUtils;
import com.anggrayudi.storage.extension.UriUtils;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.StorageType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u000b\u0018\u0000 s2\u00020\u0001:\u0001sB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0002\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u001eJ\b\u0010N\u001a\u00020LH\u0002J&\u0010O\u001a\u00020L2\u0006\u0010P\u001a\u00020\u001a2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010R\u001a\u000204H\u0007J\u0018\u0010S\u001a\u00020L2\u0006\u0010R\u001a\u0002042\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010V\u001a\u00020L2\u0006\u0010R\u001a\u0002042\u0006\u0010W\u001a\u00020\u001eH\u0002J\u0018\u0010X\u001a\u00020L2\u0006\u0010R\u001a\u0002042\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010Y\u001a\u00020L2\u0006\u0010R\u001a\u0002042\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[2\b\u0010M\u001a\u0004\u0018\u00010\u001eH\u0002J\u000e\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u001aJ \u0010`\u001a\u00020L2\u0006\u0010R\u001a\u0002042\u0006\u0010a\u001a\u0002042\b\u0010W\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010b\u001a\u00020L2\u0006\u0010c\u001a\u00020\u0005J\u000e\u0010d\u001a\u00020L2\u0006\u0010e\u001a\u00020\u0005J5\u0010f\u001a\u00020L2\b\b\u0002\u0010R\u001a\u0002042\b\b\u0002\u0010g\u001a\u00020^2\u0012\u0010h\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0i\"\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010jJ\u0012\u0010k\u001a\u00020L2\b\b\u0002\u0010R\u001a\u000204H\u0007J\b\u0010l\u001a\u00020LH\u0007J0\u0010m\u001a\u00020L2\b\b\u0002\u0010R\u001a\u0002042\b\b\u0002\u0010n\u001a\u00020\u001c2\b\b\u0002\u0010o\u001a\u00020\u001c2\b\b\u0002\u0010p\u001a\u00020\u001aH\u0007J\u0010\u0010q\u001a\u00020^2\u0006\u0010r\u001a\u00020UH\u0002R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R$\u00105\u001a\u0002042\u0006\u00103\u001a\u000204@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010:\u001a\u0002042\u0006\u00103\u001a\u000204@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00107\"\u0004\b<\u00109R$\u0010=\u001a\u0002042\u0006\u00103\u001a\u000204@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u00107\"\u0004\b?\u00109R$\u0010@\u001a\u0002042\u0006\u00103\u001a\u000204@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u00107\"\u0004\bB\u00109R\u0014\u0010C\u001a\u00020\u001e8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010 R\u001c\u0010E\u001a\u0004\u0018\u00010FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006t"}, d2={"Lcom/anggrayudi/storage/SimpleStorage;", "", "activity", "Landroid/app/Activity;", "savedState", "Landroid/os/Bundle;", "(Landroid/app/Activity;Landroid/os/Bundle;)V", "Landroidx/activity/ComponentActivity;", "(Landroidx/activity/ComponentActivity;Landroid/os/Bundle;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;Landroid/os/Bundle;)V", "wrapper", "Lcom/anggrayudi/storage/ComponentWrapper;", "(Lcom/anggrayudi/storage/ComponentWrapper;)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "createFileCallback", "Lcom/anggrayudi/storage/callback/CreateFileCallback;", "getCreateFileCallback", "()Lcom/anggrayudi/storage/callback/CreateFileCallback;", "setCreateFileCallback", "(Lcom/anggrayudi/storage/callback/CreateFileCallback;)V", "expectedBasePathForAccessRequest", "", "expectedStorageTypeForAccessRequest", "Lcom/anggrayudi/storage/file/StorageType;", "externalStorageRootAccessIntent", "Landroid/content/Intent;", "getExternalStorageRootAccessIntent", "()Landroid/content/Intent;", "filePickerCallback", "Lcom/anggrayudi/storage/callback/FilePickerCallback;", "getFilePickerCallback", "()Lcom/anggrayudi/storage/callback/FilePickerCallback;", "setFilePickerCallback", "(Lcom/anggrayudi/storage/callback/FilePickerCallback;)V", "fileReceiverCallback", "Lcom/anggrayudi/storage/callback/FileReceiverCallback;", "getFileReceiverCallback", "()Lcom/anggrayudi/storage/callback/FileReceiverCallback;", "setFileReceiverCallback", "(Lcom/anggrayudi/storage/callback/FileReceiverCallback;)V", "folderPickerCallback", "Lcom/anggrayudi/storage/callback/FolderPickerCallback;", "getFolderPickerCallback", "()Lcom/anggrayudi/storage/callback/FolderPickerCallback;", "setFolderPickerCallback", "(Lcom/anggrayudi/storage/callback/FolderPickerCallback;)V", "value", "", "requestCodeCreateFile", "getRequestCodeCreateFile", "()I", "setRequestCodeCreateFile", "(I)V", "requestCodeFilePicker", "getRequestCodeFilePicker", "setRequestCodeFilePicker", "requestCodeFolderPicker", "getRequestCodeFolderPicker", "setRequestCodeFolderPicker", "requestCodeStorageAccess", "getRequestCodeStorageAccess", "setRequestCodeStorageAccess", "sdCardRootAccessIntent", "getSdCardRootAccessIntent", "storageAccessCallback", "Lcom/anggrayudi/storage/callback/StorageAccessCallback;", "getStorageAccessCallback", "()Lcom/anggrayudi/storage/callback/StorageAccessCallback;", "setStorageAccessCallback", "(Lcom/anggrayudi/storage/callback/StorageAccessCallback;)V", "checkIfFileReceived", "", "intent", "checkRequestCode", "createFile", "mimeType", "fileName", "requestCode", "handleActivityResultForCreateFile", "uri", "Landroid/net/Uri;", "handleActivityResultForFilePicker", "data", "handleActivityResultForFolderPicker", "handleActivityResultForStorageAccess", "intentToDocumentFiles", "", "Landroidx/documentfile/provider/DocumentFile;", "isStorageAccessGranted", "", "storageId", "onActivityResult", "resultCode", "onRestoreInstanceState", "savedInstanceState", "onSaveInstanceState", "outState", "openFilePicker", "allowMultiple", "filterMimeTypes", "", "(IZ[Ljava/lang/String;)V", "openFolderPicker", "requestFullStorageAccess", "requestStorageAccess", "initialRootPath", "expectedStorageType", "expectedBasePath", "saveUriPermission", "root", "Companion", "storage_release"})
public final class SimpleStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentWrapper wrapper;
    @Nullable
    private StorageAccessCallback storageAccessCallback;
    @Nullable
    private FolderPickerCallback folderPickerCallback;
    @Nullable
    private FilePickerCallback filePickerCallback;
    @Nullable
    private CreateFileCallback createFileCallback;
    @Nullable
    private FileReceiverCallback fileReceiverCallback;
    private int requestCodeStorageAccess;
    private int requestCodeFolderPicker;
    private int requestCodeFilePicker;
    private int requestCodeCreateFile;
    @NotNull
    private StorageType expectedStorageTypeForAccessRequest;
    @Nullable
    private String expectedBasePathForAccessRequest;
    @NotNull
    private static final String KEY_REQUEST_CODE_STORAGE_ACCESS = "com.anggrayudi.storage.requestCodeStorageAccess";
    @NotNull
    private static final String KEY_REQUEST_CODE_FOLDER_PICKER = "com.anggrayudi.storage.requestCodeFolderPicker";
    @NotNull
    private static final String KEY_REQUEST_CODE_FILE_PICKER = "com.anggrayudi.storage.requestCodeFilePicker";
    @NotNull
    private static final String KEY_REQUEST_CODE_CREATE_FILE = "com.anggrayudi.storage.requestCodeCreateFile";
    @NotNull
    private static final String KEY_REQUEST_CODE_FRAGMENT_PICKER = "com.anggrayudi.storage.requestCodeFragmentPicker";
    @NotNull
    private static final String KEY_EXPECTED_STORAGE_TYPE_FOR_ACCESS_REQUEST = "com.anggrayudi.storage.expectedStorageTypeForAccessRequest";
    @NotNull
    private static final String KEY_EXPECTED_BASE_PATH_FOR_ACCESS_REQUEST = "com.anggrayudi.storage.expectedBasePathForAccessRequest";

    private SimpleStorage(ComponentWrapper wrapper) {
        this.wrapper = wrapper;
        this.requestCodeStorageAccess = 1;
        this.requestCodeFolderPicker = 2;
        this.requestCodeFilePicker = 3;
        this.requestCodeCreateFile = 4;
        this.expectedStorageTypeForAccessRequest = StorageType.UNKNOWN;
    }

    public SimpleStorage(@NotNull Activity activity, @Nullable Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(new ActivityWrapper(activity));
        Bundle bundle = savedState;
        if (bundle != null) {
            Bundle bundle2 = bundle;
            boolean bl = false;
            boolean bl2 = false;
            Bundle it = bundle2;
            boolean bl3 = false;
            this.onRestoreInstanceState(it);
        }
    }

    public /* synthetic */ SimpleStorage(Activity activity, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        this(activity, bundle);
    }

    public SimpleStorage(@NotNull ComponentActivity activity, @Nullable Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(new ComponentActivityWrapper(activity));
        Bundle bundle = savedState;
        if (bundle != null) {
            Bundle bundle2 = bundle;
            boolean bl = false;
            boolean bl2 = false;
            Bundle it = bundle2;
            boolean bl3 = false;
            this.onRestoreInstanceState(it);
        }
        ((ComponentActivityWrapper)this.wrapper).setStorage(this);
    }

    public /* synthetic */ SimpleStorage(ComponentActivity componentActivity, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        this(componentActivity, bundle);
    }

    public SimpleStorage(@NotNull Fragment fragment, @Nullable Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment));
        Bundle bundle = savedState;
        if (bundle != null) {
            Bundle bundle2 = bundle;
            boolean bl = false;
            boolean bl2 = false;
            Bundle it = bundle2;
            boolean bl3 = false;
            this.onRestoreInstanceState(it);
        }
        ((FragmentWrapper)this.wrapper).setStorage(this);
    }

    public /* synthetic */ SimpleStorage(Fragment fragment, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        this(fragment, bundle);
    }

    @Nullable
    public final StorageAccessCallback getStorageAccessCallback() {
        return this.storageAccessCallback;
    }

    public final void setStorageAccessCallback(@Nullable StorageAccessCallback storageAccessCallback) {
        this.storageAccessCallback = storageAccessCallback;
    }

    @Nullable
    public final FolderPickerCallback getFolderPickerCallback() {
        return this.folderPickerCallback;
    }

    public final void setFolderPickerCallback(@Nullable FolderPickerCallback folderPickerCallback) {
        this.folderPickerCallback = folderPickerCallback;
    }

    @Nullable
    public final FilePickerCallback getFilePickerCallback() {
        return this.filePickerCallback;
    }

    public final void setFilePickerCallback(@Nullable FilePickerCallback filePickerCallback) {
        this.filePickerCallback = filePickerCallback;
    }

    @Nullable
    public final CreateFileCallback getCreateFileCallback() {
        return this.createFileCallback;
    }

    public final void setCreateFileCallback(@Nullable CreateFileCallback createFileCallback) {
        this.createFileCallback = createFileCallback;
    }

    @Nullable
    public final FileReceiverCallback getFileReceiverCallback() {
        return this.fileReceiverCallback;
    }

    public final void setFileReceiverCallback(@Nullable FileReceiverCallback fileReceiverCallback) {
        this.fileReceiverCallback = fileReceiverCallback;
    }

    public final int getRequestCodeStorageAccess() {
        return this.requestCodeStorageAccess;
    }

    public final void setRequestCodeStorageAccess(int value) {
        this.requestCodeStorageAccess = value;
        this.checkRequestCode();
    }

    public final int getRequestCodeFolderPicker() {
        return this.requestCodeFolderPicker;
    }

    public final void setRequestCodeFolderPicker(int value) {
        this.requestCodeFolderPicker = value;
        this.checkRequestCode();
    }

    public final int getRequestCodeFilePicker() {
        return this.requestCodeFilePicker;
    }

    public final void setRequestCodeFilePicker(int value) {
        this.requestCodeFilePicker = value;
        this.checkRequestCode();
    }

    public final int getRequestCodeCreateFile() {
        return this.requestCodeCreateFile;
    }

    public final void setRequestCodeCreateFile(int value) {
        this.requestCodeCreateFile = value;
        this.checkRequestCode();
    }

    @NotNull
    public final Context getContext() {
        return this.wrapper.getContext();
    }

    private final Intent getExternalStorageRootAccessIntent() {
        Intent intent;
        if (Build.VERSION.SDK_INT >= 29) {
            Object object = this.getContext().getSystemService("storage");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.os.storage.StorageManager");
            }
            StorageManager sm = (StorageManager)object;
            Intent intent2 = sm.getPrimaryStorageVolume().createOpenDocumentTreeIntent();
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n            val sm = context.getSystemService(Context.STORAGE_SERVICE) as StorageManager\n            sm.primaryStorageVolume.createOpenDocumentTreeIntent()\n        }");
            intent = intent2;
        } else {
            intent = Companion.getDefaultExternalStorageIntent();
        }
        return intent;
    }

    @RequiresApi(api=24)
    private final Intent getSdCardRootAccessIntent() {
        Intent intent;
        Object v0;
        List list;
        Object object;
        block4: {
            object = this.getContext().getSystemService("storage");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.os.storage.StorageManager");
            }
            StorageManager sm = (StorageManager)object;
            list = sm.getStorageVolumes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sm.storageVolumes");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StorageVolume it = (StorageVolume)element$iv;
                boolean bl = false;
                if (!it.isRemovable()) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        StorageVolume storageVolume = v0;
        if (storageVolume == null) {
            intent = null;
        } else {
            list = storageVolume;
            boolean bl = false;
            boolean bl2 = false;
            List it = list;
            boolean bl3 = false;
            intent = Build.VERSION.SDK_INT >= 29 ? it.createOpenDocumentTreeIntent() : (it.isPrimary() ? Companion.getDefaultExternalStorageIntent() : it.createAccessIntent(null));
        }
        object = intent;
        return object == null ? Companion.getDefaultExternalStorageIntent() : object;
    }

    public final boolean isStorageAccessGranted(@NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.isAccessGranted(this.getContext(), storageId);
    }

    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @NotNull StorageType initialRootPath, @NotNull StorageType expectedStorageType, @NotNull String expectedBasePath) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)((Object)initialRootPath), (String)"initialRootPath");
        Intrinsics.checkNotNullParameter((Object)((Object)expectedStorageType), (String)"expectedStorageType");
        Intrinsics.checkNotNullParameter((Object)expectedBasePath, (String)"expectedBasePath");
        if (initialRootPath == StorageType.DATA || expectedStorageType == StorageType.DATA) {
            throw new IllegalArgumentException("Cannot use StorageType.DATA because it is never available in Storage Access Framework's folder selector.");
        }
        if (Build.VERSION.SDK_INT < 29 && !Companion.hasStoragePermission(this.getContext())) {
            StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
            if (storageAccessCallback != null) {
                storageAccessCallback.onStoragePermissionDenied(requestCode);
            }
            return;
        }
        if (initialRootPath == StorageType.EXTERNAL && expectedStorageType.isExpected(initialRootPath) && Build.VERSION.SDK_INT < 29 && !Companion.isSdCardPresent()) {
            Object object = DocumentFileCompat.getRootDocumentFile$default(this.getContext(), "primary", true, false, 8, null);
            if (object == null) {
                return;
            }
            DocumentFile root = object;
            object = root.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"root.uri");
            this.saveUriPermission((Uri)object);
            object = this.storageAccessCallback;
            if (object != null) {
                object.onRootPathPermissionGranted(requestCode, root);
            }
            return;
        }
        Intent intent2 = intent = initialRootPath == StorageType.SD_CARD && Build.VERSION.SDK_INT >= 24 ? this.getSdCardRootAccessIntent() : this.getExternalStorageRootAccessIntent();
        if (this.wrapper.startActivityForResult(intent, requestCode)) {
            this.setRequestCodeStorageAccess(requestCode);
            this.expectedStorageTypeForAccessRequest = expectedStorageType;
            this.expectedBasePathForAccessRequest = expectedBasePath;
        } else {
            StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
            if (storageAccessCallback != null) {
                storageAccessCallback.onActivityHandlerNotFound(requestCode, intent);
            }
        }
    }

    public static /* synthetic */ void requestStorageAccess$default(SimpleStorage simpleStorage, int n, StorageType storageType, StorageType storageType2, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorage.requestCodeStorageAccess;
        }
        if ((n2 & 2) != 0) {
            storageType = StorageType.EXTERNAL;
        }
        if ((n2 & 4) != 0) {
            storageType2 = StorageType.UNKNOWN;
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        simpleStorage.requestStorageAccess(n, storageType, storageType2, string);
    }

    @RequiresPermission(value="android.permission.MANAGE_EXTERNAL_STORAGE")
    @RequiresApi(value=30)
    public final void requestFullStorageAccess() {
        this.getContext().startActivity(new Intent("android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION"));
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType, @Nullable String fileName, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        this.setRequestCodeCreateFile(requestCode);
        Object object = new Intent("android.intent.action.CREATE_DOCUMENT").setType(mimeType);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Intent(Intent.ACTION_CREATE_DOCUMENT).setType(mimeType)");
        Intent intent = object;
        object = fileName;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            intent.putExtra("android.intent.extra.TITLE", (String)it);
        }
        if (!this.wrapper.startActivityForResult(intent, requestCode) && (object = this.createFileCallback) != null) {
            object.onActivityHandlerNotFound(requestCode, intent);
        }
    }

    public static /* synthetic */ void createFile$default(SimpleStorage simpleStorage, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            n = simpleStorage.requestCodeCreateFile;
        }
        simpleStorage.createFile(string, string2, n);
    }

    @SuppressLint(value={"InlinedApi"})
    @JvmOverloads
    public final void openFolderPicker(int requestCode) {
        this.setRequestCodeFolderPicker(requestCode);
        if (Build.VERSION.SDK_INT > 28 || Companion.hasStoragePermission(this.getContext())) {
            FolderPickerCallback folderPickerCallback;
            Intent intent;
            Intent intent2 = intent = Build.VERSION.SDK_INT < 30 ? new Intent("android.intent.action.OPEN_DOCUMENT_TREE") : this.getExternalStorageRootAccessIntent();
            if (!this.wrapper.startActivityForResult(intent, requestCode) && (folderPickerCallback = this.folderPickerCallback) != null) {
                folderPickerCallback.onActivityHandlerNotFound(requestCode, intent);
            }
        } else {
            FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
            if (folderPickerCallback != null) {
                folderPickerCallback.onStoragePermissionDenied(requestCode);
            }
        }
    }

    public static /* synthetic */ void openFolderPicker$default(SimpleStorage simpleStorage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorage.requestCodeFolderPicker;
        }
        simpleStorage.openFolderPicker(n);
    }

    @JvmOverloads
    public final void openFilePicker(int requestCode, boolean allowMultiple, String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        this.setRequestCodeFilePicker(requestCode);
        if (Companion.hasStorageReadPermission(this.getContext())) {
            Object object = new Intent("android.intent.action.OPEN_DOCUMENT").putExtra("android.intent.extra.ALLOW_MULTIPLE", allowMultiple);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Intent(Intent.ACTION_OPEN_DOCUMENT)\n                .putExtra(Intent.EXTRA_ALLOW_MULTIPLE, allowMultiple)");
            Intent intent = object;
            if (filterMimeTypes.length > 1) {
                intent.setType("*/*").putExtra("android.intent.extra.MIME_TYPES", filterMimeTypes);
            } else {
                object = (String)ArraysKt.firstOrNull((Object[])filterMimeTypes);
                intent.setType((String)(object == null ? "*/*" : object));
            }
            if (!this.wrapper.startActivityForResult(intent, requestCode) && (object = this.filePickerCallback) != null) {
                object.onActivityHandlerNotFound(requestCode, intent);
            }
        } else {
            FilePickerCallback filePickerCallback = this.filePickerCallback;
            if (filePickerCallback != null) {
                filePickerCallback.onStoragePermissionDenied(requestCode, null);
            }
        }
    }

    public static /* synthetic */ void openFilePicker$default(SimpleStorage simpleStorage, int n, boolean bl, String[] stringArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorage.requestCodeFilePicker;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        simpleStorage.openFilePicker(n, bl, stringArray);
    }

    private final void handleActivityResultForStorageAccess(int requestCode, Uri uri) {
        StorageAccessCallback rootPath2;
        Object object;
        String storageId;
        block38: {
            StorageType storageType;
            block36: {
                DocumentFile selectedFolder;
                block37: {
                    storageId = UriUtils.getStorageId(uri, this.getContext());
                    storageType = StorageType.Companion.fromStorageId(storageId);
                    if (Build.VERSION.SDK_INT <= 29) break block36;
                    DocumentFile documentFile = DocumentFile.fromTreeUri((Context)this.getContext(), (Uri)uri);
                    if (documentFile == null) {
                        return;
                    }
                    object = documentFile;
                    selectedFolder = object;
                    if (!this.expectedStorageTypeForAccessRequest.isExpected(storageType)) break block37;
                    object = this.expectedBasePathForAccessRequest;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (object == null || object.length() == 0 || Intrinsics.areEqual((Object)DocumentFileUtils.getBasePath(selectedFolder, this.getContext()), (Object)this.expectedBasePathForAccessRequest)) break block38;
                }
                if ((object = this.storageAccessCallback) != null) {
                    String string = this.expectedBasePathForAccessRequest;
                    Intrinsics.checkNotNull((Object)string);
                    object.onExpectedStorageNotSelected(requestCode, selectedFolder, storageType, string, this.expectedStorageTypeForAccessRequest);
                }
                return;
            }
            if (!this.expectedStorageTypeForAccessRequest.isExpected(storageType)) {
                Object object2 = ContextUtils.fromTreeUri(this.getContext(), uri);
                object2 = object2 == null ? null : DocumentFileUtils.getAbsolutePath((DocumentFile)object2, this.getContext());
                boolean bl = false;
                Object object3 = object2;
                if (object3 == null) {
                    object3 = "";
                }
                DocumentFile rootPath2 = object3;
                object2 = this.storageAccessCallback;
                if (object2 != null) {
                    object2.onRootPathNotSelected(requestCode, (String)rootPath2, uri, storageType, this.expectedStorageTypeForAccessRequest);
                }
                return;
            }
        }
        if (UriUtils.isDownloadsDocument(uri)) {
            if (Intrinsics.areEqual((Object)uri.toString(), (Object)"content://com.android.providers.downloads.documents/tree/downloads")) {
                this.saveUriPermission(uri);
                rootPath2 = this.storageAccessCallback;
                if (rootPath2 != null) {
                    object = ContextUtils.fromTreeUri(this.getContext(), uri);
                    if (object == null) {
                        return;
                    }
                    rootPath2.onRootPathPermissionGranted(requestCode, (DocumentFile)object);
                }
            } else {
                rootPath2 = this.storageAccessCallback;
                if (rootPath2 != null) {
                    rootPath2.onRootPathNotSelected(requestCode, Companion.getExternalStoragePath() + '/' + Environment.DIRECTORY_DOWNLOADS, uri, StorageType.EXTERNAL, this.expectedStorageTypeForAccessRequest);
                }
            }
            return;
        }
        if (Build.VERSION.SDK_INT < 30 && !UriUtils.isExternalStorageDocument(uri)) {
            rootPath2 = this.storageAccessCallback;
            if (rootPath2 != null) {
                rootPath2.onRootPathNotSelected(requestCode, Companion.getExternalStoragePath(), uri, StorageType.EXTERNAL, this.expectedStorageTypeForAccessRequest);
            }
            return;
        }
        if (Build.VERSION.SDK_INT < 29 && Intrinsics.areEqual((Object)storageId, (Object)"primary")) {
            this.saveUriPermission(uri);
            rootPath2 = this.storageAccessCallback;
            if (rootPath2 != null) {
                object = ContextUtils.fromTreeUri(this.getContext(), uri);
                if (object == null) {
                    return;
                }
                rootPath2.onRootPathPermissionGranted(requestCode, (DocumentFile)object);
            }
            return;
        }
        if (Build.VERSION.SDK_INT >= 30 || DocumentFileCompat.isRootUri(uri)) {
            if (this.saveUriPermission(uri)) {
                rootPath2 = this.storageAccessCallback;
                if (rootPath2 != null) {
                    object = ContextUtils.fromTreeUri(this.getContext(), uri);
                    if (object == null) {
                        return;
                    }
                    rootPath2.onRootPathPermissionGranted(requestCode, (DocumentFile)object);
                }
            } else {
                rootPath2 = this.storageAccessCallback;
                if (rootPath2 != null) {
                    rootPath2.onStoragePermissionDenied(requestCode);
                }
            }
        } else if (Intrinsics.areEqual((Object)storageId, (Object)"primary")) {
            rootPath2 = this.storageAccessCallback;
            if (rootPath2 != null) {
                rootPath2.onRootPathNotSelected(requestCode, Companion.getExternalStoragePath(), uri, StorageType.EXTERNAL, this.expectedStorageTypeForAccessRequest);
            }
        } else {
            StorageAccessCallback storageAccessCallback;
            if (Build.VERSION.SDK_INT >= 24 && Build.VERSION.SDK_INT < 29) {
                Object v2;
                Object it;
                List list;
                block35: {
                    object = this.getContext().getSystemService("storage");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.os.storage.StorageManager");
                    }
                    StorageManager sm = (StorageManager)object;
                    list = sm.getStorageVolumes();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sm.storageVolumes");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (StorageVolume)element$iv;
                        boolean bl = false;
                        if (!it.isRemovable()) continue;
                        v2 = element$iv;
                        break block35;
                    }
                    v2 = null;
                }
                object = v2;
                if (object != null && (list = object.createAccessIntent(null)) != null) {
                    StorageAccessCallback storageAccessCallback2;
                    List list2 = list;
                    boolean bl = false;
                    boolean bl3 = false;
                    it = list2;
                    boolean bl4 = false;
                    if (!this.wrapper.startActivityForResult((Intent)it, requestCode) && (storageAccessCallback2 = this.getStorageAccessCallback()) != null) {
                        storageAccessCallback2.onActivityHandlerNotFound(requestCode, (Intent)it);
                    }
                    return;
                }
            }
            if ((storageAccessCallback = this.storageAccessCallback) != null) {
                storageAccessCallback.onRootPathNotSelected(requestCode, Intrinsics.stringPlus((String)"/storage/", (Object)storageId), uri, StorageType.SD_CARD, this.expectedStorageTypeForAccessRequest);
            }
        }
    }

    private final void handleActivityResultForFolderPicker(int requestCode, Uri uri) {
        DocumentFile folder = ContextUtils.fromTreeUri(this.getContext(), uri);
        String storageId = UriUtils.getStorageId(uri, this.getContext());
        StorageType storageType = StorageType.Companion.fromStorageId(storageId);
        if (folder == null || !DocumentFileUtils.canModify(folder, this.getContext())) {
            FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
            if (folderPickerCallback != null) {
                folderPickerCallback.onStorageAccessDenied(requestCode, folder, storageType);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)uri.toString(), (Object)"content://com.android.providers.downloads.documents/tree/downloads") || DocumentFileCompat.isRootUri(uri) && (Build.VERSION.SDK_INT < 24 && storageType == StorageType.SD_CARD || Build.VERSION.SDK_INT == 29) && !DocumentFileCompat.isStorageUriPermissionGranted$default(this.getContext(), storageId, null, 4, null)) {
            this.saveUriPermission(uri);
        }
        if (Build.VERSION.SDK_INT < 29 && storageType == StorageType.EXTERNAL || Build.VERSION.SDK_INT >= 30 && this.saveUriPermission(uri) || !UriUtils.isExternalStorageDocument(uri) && DocumentFileUtils.canModify(folder, this.getContext()) || DocumentFileCompat.isStorageUriPermissionGranted$default(this.getContext(), storageId, null, 4, null)) {
            FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
            if (folderPickerCallback != null) {
                folderPickerCallback.onFolderSelected(requestCode, folder);
            }
        } else {
            FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
            if (folderPickerCallback != null) {
                folderPickerCallback.onStorageAccessDenied(requestCode, folder, storageType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocumentFile> intentToDocumentFiles(Intent intent) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List list;
        boolean bl;
        Object object;
        Object object2;
        List list2;
        Intent intent2 = intent;
        if (intent2 == null) {
            list2 = null;
        } else {
            object2 = intent2.getClipData();
            if (object2 == null) {
                list2 = null;
            } else {
                int i;
                ClipData clipData = object2;
                boolean bl2 = false;
                boolean bl3 = false;
                ClipData $this$intentToDocumentFiles_u24lambda_u2d9 = clipData;
                boolean bl4 = false;
                int n = 0;
                List list3 = new ArrayList();
                n = 0;
                int n2 = $this$intentToDocumentFiles_u24lambda_u2d9.getItemCount();
                if (n < n2) {
                    do {
                        i = n++;
                        Uri uri = $this$intentToDocumentFiles_u24lambda_u2d9.getItemAt(i).getUri();
                        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getItemAt(i).uri");
                        list3.add(uri);
                    } while (n < n2);
                }
                List list4 = list3;
                n2 = 0;
                i = 0;
                List it = list4;
                boolean bl5 = false;
                object = it;
                bl = false;
                list2 = !object.isEmpty() ? list4 : null;
            }
        }
        List list5 = list2;
        if (list5 == null) {
            object2 = intent;
            Uri uri = intent2 = object2 == null ? null : object2.getData();
            if (intent2 == null) {
                return CollectionsKt.emptyList();
            }
            list = CollectionsKt.listOf((Object)intent2);
        } else {
            list = list5;
        }
        List uris = list;
        Iterable $this$mapNotNull$iv = uris;
        boolean $i$f$mapNotNull = false;
        object2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl4 = $this$forEach$iv$iv$iv.iterator();
        while (bl4.hasNext()) {
            DocumentFile documentFile;
            String bl5;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl4.next();
            boolean bl6 = false;
            Uri uri = (Uri)element$iv$iv;
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
            if (UriUtils.isDownloadsDocument(uri) && Build.VERSION.SDK_INT < 28 && ((bl5 = uri.getPath()) == null ? false : StringsKt.startsWith$default((String)bl5, (String)"/document/raw:", (boolean)false, (int)2, null))) {
                object = uri.getPath();
                bl = false;
                Object object3 = object;
                if (object3 == null) {
                    object3 = "";
                }
                String fullPath = StringsKt.substringAfterLast$default((String)object3, (String)"/document/raw:", null, (int)2, null);
                documentFile = DocumentFile.fromFile((File)new File(fullPath));
            } else {
                documentFile = ContextUtils.fromSingleUri(this.getContext(), uri);
            }
            if (documentFile == null) continue;
            DocumentFile documentFile2 = documentFile;
            boolean bl8 = false;
            boolean bl9 = false;
            DocumentFile it$iv$iv = documentFile2;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DocumentFile it = (DocumentFile)element$iv$iv;
            boolean bl11 = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void checkIfFileReceived(@Nullable Intent intent) {
        Intent intent2 = intent;
        String string = intent2 == null ? null : intent2.getAction();
        if (Intrinsics.areEqual((Object)string, (Object)"android.intent.action.SEND") ? true : Intrinsics.areEqual((Object)string, (Object)"android.intent.action.SEND_MULTIPLE")) {
            List<DocumentFile> files = this.intentToDocumentFiles(intent);
            if (files.isEmpty()) {
                FileReceiverCallback fileReceiverCallback = this.fileReceiverCallback;
                if (fileReceiverCallback != null) {
                    fileReceiverCallback.onNonFileReceived(intent);
                }
            } else {
                FileReceiverCallback fileReceiverCallback;
                boolean bl;
                block11: {
                    Iterable $this$all$iv = files;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            DocumentFile it = (DocumentFile)element$iv;
                            boolean bl2 = false;
                            if (it.canRead()) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    fileReceiverCallback = this.fileReceiverCallback;
                    if (fileReceiverCallback != null) {
                        fileReceiverCallback.onFileReceived(files);
                    }
                } else {
                    fileReceiverCallback = this.fileReceiverCallback;
                    if (fileReceiverCallback != null) {
                        fileReceiverCallback.onStoragePermissionDenied(files);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleActivityResultForFilePicker(int requestCode, Intent data) {
        List<DocumentFile> files = this.intentToDocumentFiles(data);
        Object object = files;
        boolean bl = false;
        if (!object.isEmpty()) {
            boolean bl2;
            block7: {
                Iterable $this$all$iv = files;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        DocumentFile it = (DocumentFile)element$iv;
                        boolean bl3 = false;
                        if (it.canRead()) continue;
                        bl2 = false;
                        break block7;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                object = this.filePickerCallback;
                if (object == null) {
                    return;
                }
                object.onFileSelected(requestCode, files);
                return;
            }
        }
        if ((object = this.filePickerCallback) == null) {
            return;
        }
        object.onStoragePermissionDenied(requestCode, files);
    }

    private final void handleActivityResultForCreateFile(int requestCode, Uri uri) {
        DocumentFile documentFile = DocumentFileCompat.fromUri(this.getContext(), uri);
        if (documentFile != null) {
            DocumentFile documentFile2 = documentFile;
            boolean bl = false;
            boolean bl2 = false;
            DocumentFile it = documentFile2;
            boolean bl3 = false;
            CreateFileCallback createFileCallback = this.getCreateFileCallback();
            if (createFileCallback != null) {
                createFileCallback.onFileCreated(requestCode, it);
            }
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        this.checkRequestCode();
        int n = requestCode;
        if (n == this.requestCodeStorageAccess) {
            if (resultCode == -1) {
                Uri uri;
                Intent intent = data;
                Uri uri2 = uri = intent == null ? null : intent.getData();
                if (uri == null) {
                    return;
                }
                Uri uri3 = uri;
                this.handleActivityResultForStorageAccess(requestCode, uri3);
            } else {
                StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                if (storageAccessCallback != null) {
                    storageAccessCallback.onCanceledByUser(requestCode);
                }
            }
        } else if (n == this.requestCodeFolderPicker) {
            if (resultCode == -1) {
                Uri uri;
                Intent intent = data;
                Uri uri4 = uri = intent == null ? null : intent.getData();
                if (uri == null) {
                    return;
                }
                Uri uri5 = uri;
                this.handleActivityResultForFolderPicker(requestCode, uri5);
            } else {
                FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
                if (folderPickerCallback != null) {
                    folderPickerCallback.onCanceledByUser(requestCode);
                }
            }
        } else if (n == this.requestCodeFilePicker) {
            if (resultCode == -1) {
                Intent intent = data;
                if (intent == null) {
                    return;
                }
                this.handleActivityResultForFilePicker(requestCode, intent);
            } else {
                FilePickerCallback filePickerCallback = this.filePickerCallback;
                if (filePickerCallback != null) {
                    filePickerCallback.onCanceledByUser(requestCode);
                }
            }
        } else if (n == this.requestCodeCreateFile) {
            Uri uri;
            Object object = data;
            Uri uri6 = uri = object == null ? null : object.getData();
            if (uri != null) {
                this.handleActivityResultForCreateFile(requestCode, uri);
            } else {
                object = this.createFileCallback;
                if (object != null) {
                    object.onCanceledByUser(requestCode);
                }
            }
        }
    }

    public final void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putString(KEY_EXPECTED_BASE_PATH_FOR_ACCESS_REQUEST, this.expectedBasePathForAccessRequest);
        outState.putInt(KEY_REQUEST_CODE_STORAGE_ACCESS, this.expectedStorageTypeForAccessRequest.ordinal());
        outState.putInt(KEY_REQUEST_CODE_STORAGE_ACCESS, this.requestCodeStorageAccess);
        outState.putInt(KEY_REQUEST_CODE_FOLDER_PICKER, this.requestCodeFolderPicker);
        outState.putInt(KEY_REQUEST_CODE_FILE_PICKER, this.requestCodeFilePicker);
        outState.putInt(KEY_REQUEST_CODE_CREATE_FILE, this.requestCodeCreateFile);
        if (this.wrapper instanceof FragmentWrapper) {
            outState.putInt(KEY_REQUEST_CODE_FRAGMENT_PICKER, ((FragmentWrapper)this.wrapper).getRequestCode());
        }
    }

    public final void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)savedInstanceState, (String)"savedInstanceState");
        this.expectedBasePathForAccessRequest = savedInstanceState.getString(KEY_EXPECTED_BASE_PATH_FOR_ACCESS_REQUEST);
        this.expectedStorageTypeForAccessRequest = StorageType.values()[savedInstanceState.getInt(KEY_EXPECTED_STORAGE_TYPE_FOR_ACCESS_REQUEST)];
        this.setRequestCodeStorageAccess(savedInstanceState.getInt(KEY_REQUEST_CODE_STORAGE_ACCESS));
        this.setRequestCodeFolderPicker(savedInstanceState.getInt(KEY_REQUEST_CODE_FOLDER_PICKER));
        this.setRequestCodeFilePicker(savedInstanceState.getInt(KEY_REQUEST_CODE_FILE_PICKER));
        this.setRequestCodeCreateFile(savedInstanceState.getInt(KEY_REQUEST_CODE_CREATE_FILE));
        if (this.wrapper instanceof FragmentWrapper && savedInstanceState.containsKey(KEY_REQUEST_CODE_FRAGMENT_PICKER)) {
            ((FragmentWrapper)this.wrapper).setRequestCode(savedInstanceState.getInt(KEY_REQUEST_CODE_FRAGMENT_PICKER));
        }
    }

    private final void checkRequestCode() {
        Object[] objectArray = new Integer[]{this.requestCodeFilePicker, this.requestCodeFolderPicker, this.requestCodeStorageAccess, this.requestCodeCreateFile};
        Set set = SetsKt.setOf((Object[])objectArray);
        if (set.size() < 4) {
            throw new IllegalArgumentException("Request codes must be unique. File picker=" + this.requestCodeFilePicker + ", Folder picker=" + this.requestCodeFolderPicker + ", Storage access=" + this.requestCodeStorageAccess + ", Create file=" + this.requestCodeCreateFile);
        }
    }

    private final boolean saveUriPermission(Uri root) {
        boolean bl;
        try {
            int writeFlags = 3;
            this.getContext().getContentResolver().takePersistableUriPermission(root, writeFlags);
            Context context = this.getContext().getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context.applicationContext");
            Companion.cleanupRedundantUriPermissions(context);
            bl = true;
        }
        catch (SecurityException e) {
            bl = false;
        }
        return bl;
    }

    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @NotNull StorageType initialRootPath, @NotNull StorageType expectedStorageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialRootPath), (String)"initialRootPath");
        Intrinsics.checkNotNullParameter((Object)((Object)expectedStorageType), (String)"expectedStorageType");
        SimpleStorage.requestStorageAccess$default(this, requestCode, initialRootPath, expectedStorageType, null, 8, null);
    }

    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @NotNull StorageType initialRootPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialRootPath), (String)"initialRootPath");
        SimpleStorage.requestStorageAccess$default(this, requestCode, initialRootPath, null, null, 12, null);
    }

    @JvmOverloads
    public final void requestStorageAccess(int requestCode) {
        SimpleStorage.requestStorageAccess$default(this, requestCode, null, null, null, 14, null);
    }

    @JvmOverloads
    public final void requestStorageAccess() {
        SimpleStorage.requestStorageAccess$default(this, 0, null, null, null, 15, null);
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        SimpleStorage.createFile$default(this, mimeType, fileName, 0, 4, null);
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        SimpleStorage.createFile$default(this, mimeType, null, 0, 6, null);
    }

    @SuppressLint(value={"InlinedApi"})
    @JvmOverloads
    public final void openFolderPicker() {
        SimpleStorage.openFolderPicker$default(this, 0, 1, null);
    }

    @JvmOverloads
    public final void openFilePicker(int requestCode, String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        SimpleStorage.openFilePicker$default(this, requestCode, false, filterMimeTypes, 2, null);
    }

    @JvmOverloads
    public final void openFilePicker(String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        SimpleStorage.openFilePicker$default(this, 0, false, filterMimeTypes, 3, null);
    }

    @NotNull
    public static final String getExternalStoragePath() {
        return Companion.getExternalStoragePath();
    }

    public static final boolean isSdCardPresent() {
        return Companion.isSdCardPresent();
    }

    @SuppressLint(value={"InlinedApi"})
    @NotNull
    public static final Intent getDefaultExternalStorageIntent() {
        return Companion.getDefaultExternalStorageIntent();
    }

    @JvmStatic
    public static final boolean hasStoragePermission(@NotNull Context context) {
        return Companion.hasStoragePermission(context);
    }

    @JvmStatic
    public static final boolean hasStorageReadPermission(@NotNull Context context) {
        return Companion.hasStorageReadPermission(context);
    }

    @JvmStatic
    public static final boolean hasFullDiskAccess(@NotNull Context context, @NotNull String storageId) {
        return Companion.hasFullDiskAccess(context, storageId);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean hasStorageAccess(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess) {
        return Companion.hasStorageAccess(context, fullPath, requiresWriteAccess);
    }

    @JvmStatic
    public static final void cleanupRedundantUriPermissions(@NotNull Context context) {
        Companion.cleanupRedundantUriPermissions(context);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean hasStorageAccess(@NotNull Context context, @NotNull String fullPath) {
        return Companion.hasStorageAccess(context, fullPath);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\"\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u0015H\u0007J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\f8GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u00158FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0014\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/anggrayudi/storage/SimpleStorage$Companion;", "", "()V", "KEY_EXPECTED_BASE_PATH_FOR_ACCESS_REQUEST", "", "KEY_EXPECTED_STORAGE_TYPE_FOR_ACCESS_REQUEST", "KEY_REQUEST_CODE_CREATE_FILE", "KEY_REQUEST_CODE_FILE_PICKER", "KEY_REQUEST_CODE_FOLDER_PICKER", "KEY_REQUEST_CODE_FRAGMENT_PICKER", "KEY_REQUEST_CODE_STORAGE_ACCESS", "defaultExternalStorageIntent", "Landroid/content/Intent;", "getDefaultExternalStorageIntent$annotations", "getDefaultExternalStorageIntent", "()Landroid/content/Intent;", "externalStoragePath", "getExternalStoragePath$annotations", "getExternalStoragePath", "()Ljava/lang/String;", "isSdCardPresent", "", "isSdCardPresent$annotations", "()Z", "cleanupRedundantUriPermissions", "", "context", "Landroid/content/Context;", "hasFullDiskAccess", "storageId", "hasStorageAccess", "fullPath", "requiresWriteAccess", "hasStoragePermission", "hasStorageReadPermission", "storage_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getExternalStoragePath() {
            String string = Environment.getExternalStorageDirectory().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalStorageDirectory().absolutePath");
            return string;
        }

        @JvmStatic
        public static /* synthetic */ void getExternalStoragePath$annotations() {
        }

        public final boolean isSdCardPresent() {
            return Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted");
        }

        @JvmStatic
        public static /* synthetic */ void isSdCardPresent$annotations() {
        }

        @SuppressLint(value={"InlinedApi"})
        @NotNull
        public final Intent getDefaultExternalStorageIntent() {
            Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$_get_defaultExternalStorageIntent__u24lambda_u2d0 = intent;
            boolean bl3 = false;
            if (Build.VERSION.SDK_INT >= 26) {
                $this$_get_defaultExternalStorageIntent__u24lambda_u2d0.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)DocumentFileCompat.createDocumentUri$default("primary", null, 2, null));
            }
            return intent;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultExternalStorageIntent$annotations() {
        }

        @JvmStatic
        public final boolean hasStoragePermission(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0 && this.hasStorageReadPermission(context);
        }

        @JvmStatic
        public final boolean hasStorageReadPermission(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        }

        @JvmStatic
        public final boolean hasFullDiskAccess(@NotNull Context context, @NotNull String storageId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
            return com.anggrayudi.storage.SimpleStorage$Companion.hasStorageAccess$default(this, context, DocumentFileCompat.buildAbsolutePath(context, storageId, ""), false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean hasStorageAccess(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
            return (requiresWriteAccess && this.hasStoragePermission(context) || !requiresWriteAccess && this.hasStorageReadPermission(context)) && DocumentFileCompat.getAccessibleRootDocumentFile$default(context, fullPath, requiresWriteAccess, false, 8, null) != null;
        }

        public static /* synthetic */ boolean hasStorageAccess$default(Companion companion, Context context, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.hasStorageAccess(context, string, bl);
        }

        @JvmStatic
        public final void cleanupRedundantUriPermissions(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke() {
                    resolver = this.$context.getContentResolver();
                    var3_2 = resolver.getPersistedUriPermissions();
                    Intrinsics.checkNotNullExpressionValue((Object)var3_2, (String)"resolver.persistedUriPermissions");
                    $this$filter$iv = var3_2;
                    $i$f$filter = false;
                    var5_6 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (UriPermission)element$iv$iv;
                        $i$a$-filter-SimpleStorage$Companion$cleanupRedundantUriPermissions$1$persistedUris$1 = false;
                        if (!it.isReadPermission() || !it.isWritePermission()) ** GOTO lbl-1000
                        var12_19 = it.getUri();
                        Intrinsics.checkNotNullExpressionValue((Object)var12_19, (String)"it.uri");
                        if (UriUtils.isExternalStorageDocument((Uri)var12_19)) {
                            v0 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = false;
                        }
                        if (!v0) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (UriPermission)item$iv$iv;
                        var24_20 = destination$iv$iv;
                        $i$a$-map-SimpleStorage$Companion$cleanupRedundantUriPermissions$1$persistedUris$2 = false;
                        var25_21 /* !! */  = it.getUri();
                        var24_20.add(var25_21 /* !! */ );
                    }
                    persistedUris = (List)destination$iv$iv;
                    writeFlags = 3;
                    $this$mapTo$iv$iv = persistedUris;
                    var24_20 = this.$context;
                    $i$f$mapNotNull = false;
                    $i$f$mapTo = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var12_19 = $this$forEach$iv$iv$iv.iterator();
                    while (var12_19.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = var12_19.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (Uri)element$iv$iv;
                        $i$a$-mapNotNull-SimpleStorage$Companion$cleanupRedundantUriPermissions$1$uniqueUriParents$1 = false;
                        var18_29 = it.getPath();
                        if ((var18_29 == null ? null : StringsKt.substringAfter$default((String)var18_29, (String)"/tree/", null, (int)2, null)) == null) continue;
                        var19_30 = var19_30;
                        var20_31 = false;
                        var21_32 = false;
                        it$iv$iv = var19_30;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    var25_21 /* !! */  = (List)destination$iv$iv;
                    uniqueUriParents = DocumentFileCompat.findUniqueParents((Context)var24_20, (Collection)var25_21 /* !! */ );
                    $this$mapNotNull$iv = persistedUris;
                    var6_9 = this.$context;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (Uri)element$iv;
                        $i$a$-forEach-SimpleStorage$Companion$cleanupRedundantUriPermissions$1$1 = false;
                        var12_19 = it.getPath();
                        var13_24 = false;
                        v1 = var12_19;
                        if (v1 == null) {
                            v1 = "";
                        }
                        if (uniqueUriParents.contains(DocumentFileCompat.buildAbsolutePath(var6_9, StringsKt.substringAfter$default((String)v1, (String)"/tree/", null, (int)2, null)))) continue;
                        resolver.releasePersistableUriPermission((Uri)it, writeFlags);
                        Timber.d((String)Intrinsics.stringPlus((String)"Removed redundant URI permission => ", (Object)it), (Object[])new Object[0]);
                    }
                }
            }), (int)31, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean hasStorageAccess(@NotNull Context context, @NotNull String fullPath) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
            return com.anggrayudi.storage.SimpleStorage$Companion.hasStorageAccess$default(this, context, fullPath, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

