/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;
import androidx.activity.ComponentActivity;
import androidx.appcompat.app.AlertDialog;
import androidx.documentfile.provider.DocumentFile;
import androidx.fragment.app.Fragment;
import com.anggrayudi.storage.R;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.SimpleStorageHelper;
import com.anggrayudi.storage.callback.CreateFileCallback;
import com.anggrayudi.storage.callback.FilePickerCallback;
import com.anggrayudi.storage.callback.FileReceiverCallback;
import com.anggrayudi.storage.callback.FolderPickerCallback;
import com.anggrayudi.storage.callback.StorageAccessCallback;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.StorageType;
import com.anggrayudi.storage.permission.ActivityPermissionRequest;
import com.anggrayudi.storage.permission.FragmentPermissionRequest;
import com.anggrayudi.storage.permission.PermissionCallback;
import com.anggrayudi.storage.permission.PermissionReport;
import com.anggrayudi.storage.permission.PermissionRequest;
import com.anggrayudi.storage.permission.PermissionResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ^2\u00020\u0001:\u0002^_B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nB\u001b\b\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\rJ&\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020\u00102\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007J\b\u0010G\u001a\u00020\u0018H\u0002J\u0012\u0010H\u001a\u00020\u00182\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J)\u0010I\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00100=2\u0006\u0010K\u001a\u00020L\u00a2\u0006\u0002\u0010MJ\u000e\u0010N\u001a\u00020\u00182\u0006\u0010O\u001a\u00020\u0007J\u000e\u0010P\u001a\u00020\u00182\u0006\u0010Q\u001a\u00020\u0007J5\u0010R\u001a\u00020\u00182\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010S\u001a\u00020/2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100=\"\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010TJ\u0012\u0010U\u001a\u00020\u00182\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007J0\u0010V\u001a\u00020\u00182\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010W\u001a\u00020X2\b\b\u0002\u0010Y\u001a\u00020X2\b\b\u0002\u0010Z\u001a\u00020\u0010H\u0007J\u001c\u0010[\u001a\u00020\u00182\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00180.H\u0002J\b\u0010]\u001a\u00020\u0018H\u0002R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0088\u0001\u0010\u0019\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001228\u0010\u0011\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0094\u0001\u0010&\u001a:\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00160$\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00122>\u0010\u0011\u001a:\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00160$\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001b\"\u0004\b(\u0010\u001dR\u0088\u0001\u0010*\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001228\u0010\u0011\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001b\"\u0004\b,\u0010\u001dR\u001c\u0010-\u001a\u0010\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u0018\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000RL\u00100\u001a4\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001b\"\u0004\b3\u0010\u001dR\u000e\u00104\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010C\u00a8\u0006`"}, d2={"Lcom/anggrayudi/storage/SimpleStorageHelper;", "", "activity", "Landroid/app/Activity;", "requestCodeForPermissionDialog", "", "savedState", "Landroid/os/Bundle;", "(Landroid/app/Activity;ILandroid/os/Bundle;)V", "Landroidx/activity/ComponentActivity;", "(Landroidx/activity/ComponentActivity;Landroid/os/Bundle;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;Landroid/os/Bundle;)V", "filterMimeTypes", "", "", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "requestCode", "Landroidx/documentfile/provider/DocumentFile;", "file", "", "onFileCreated", "getOnFileCreated", "()Lkotlin/jvm/functions/Function2;", "setOnFileCreated", "(Lkotlin/jvm/functions/Function2;)V", "Lcom/anggrayudi/storage/SimpleStorageHelper$OnFileReceived;", "onFileReceived", "getOnFileReceived", "()Lcom/anggrayudi/storage/SimpleStorageHelper$OnFileReceived;", "setOnFileReceived", "(Lcom/anggrayudi/storage/SimpleStorageHelper$OnFileReceived;)V", "", "files", "onFileSelected", "getOnFileSelected", "setOnFileSelected", "folder", "onFolderSelected", "getOnFolderSelected", "setOnFolderSelected", "onPermissionsResult", "Lkotlin/Function1;", "", "onStorageAccessGranted", "root", "getOnStorageAccessGranted", "setOnStorageAccessGranted", "originalRequestCode", "permissionCallback", "Lcom/anggrayudi/storage/permission/PermissionCallback;", "getPermissionCallback", "()Lcom/anggrayudi/storage/permission/PermissionCallback;", "permissionRequest", "Lcom/anggrayudi/storage/permission/PermissionRequest;", "pickerToOpenOnceGranted", "rwPermission", "", "getRwPermission", "()[Ljava/lang/String;", "storage", "Lcom/anggrayudi/storage/SimpleStorage;", "getStorage", "()Lcom/anggrayudi/storage/SimpleStorage;", "createFile", "mimeType", "fileName", "handleMissingActivityHandler", "init", "onRequestPermissionsResult", "permissions", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onRestoreInstanceState", "savedInstanceState", "onSaveInstanceState", "outState", "openFilePicker", "allowMultiple", "(IZ[Ljava/lang/String;)V", "openFolderPicker", "requestStorageAccess", "initialRootPath", "Lcom/anggrayudi/storage/file/StorageType;", "expectedStorageType", "expectedBasePath", "requestStoragePermission", "onResult", "reset", "Companion", "OnFileReceived", "storage_release"})
public final class SimpleStorageHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleStorage storage;
    @NotNull
    private final PermissionRequest permissionRequest;
    private int originalRequestCode;
    private int pickerToOpenOnceGranted;
    @Nullable
    private Set<String> filterMimeTypes;
    @Nullable
    private Function1<? super Boolean, Unit> onPermissionsResult;
    @Nullable
    private Function2<? super Integer, ? super DocumentFile, Unit> onStorageAccessGranted;
    @Nullable
    private Function2<? super Integer, ? super DocumentFile, Unit> onFolderSelected;
    @Nullable
    private Function2<? super Integer, ? super List<? extends DocumentFile>, Unit> onFileSelected;
    @Nullable
    private Function2<? super Integer, ? super DocumentFile, Unit> onFileCreated;
    @Nullable
    private OnFileReceived onFileReceived;
    public static final int TYPE_FILE_PICKER = 1;
    public static final int TYPE_FOLDER_PICKER = 2;
    @NotNull
    private static final String KEY_OPEN_FOLDER_PICKER_ONCE_GRANTED = "com.anggrayudi.storage.pickerToOpenOnceGranted";
    @NotNull
    private static final String KEY_ORIGINAL_REQUEST_CODE = "com.anggrayudi.storage.originalRequestCode";
    @NotNull
    private static final String KEY_FILTER_MIME_TYPES = "com.anggrayudi.storage.filterMimeTypes";

    @NotNull
    public final SimpleStorage getStorage() {
        return this.storage;
    }

    @JvmOverloads
    public SimpleStorageHelper(@NotNull Activity activity, int requestCodeForPermissionDialog, @Nullable Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.storage = new SimpleStorage(activity, null, 2, null);
        this.init(savedState);
        String[] stringArray = this.getRwPermission();
        this.permissionRequest = new ActivityPermissionRequest.Builder(activity, requestCodeForPermissionDialog).withPermissions(Arrays.copyOf(stringArray, stringArray.length)).withCallback(this.getPermissionCallback()).build();
    }

    public /* synthetic */ SimpleStorageHelper(Activity activity, int n, Bundle bundle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bundle = null;
        }
        this(activity, n, bundle);
    }

    @JvmOverloads
    public SimpleStorageHelper(@NotNull ComponentActivity activity, @Nullable Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.storage = new SimpleStorage(activity, null, 2, null);
        this.init(savedState);
        String[] stringArray = this.getRwPermission();
        this.permissionRequest = new ActivityPermissionRequest.Builder(activity).withPermissions(Arrays.copyOf(stringArray, stringArray.length)).withCallback(this.getPermissionCallback()).build();
    }

    public /* synthetic */ SimpleStorageHelper(ComponentActivity componentActivity, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        this(componentActivity, bundle);
    }

    @JvmOverloads
    public SimpleStorageHelper(@NotNull Fragment fragment, @Nullable Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.storage = new SimpleStorage(fragment, null, 2, null);
        this.init(savedState);
        String[] stringArray = this.getRwPermission();
        this.permissionRequest = new FragmentPermissionRequest.Builder(fragment).withPermissions(Arrays.copyOf(stringArray, stringArray.length)).withCallback(this.getPermissionCallback()).build();
    }

    public /* synthetic */ SimpleStorageHelper(Fragment fragment, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        this(fragment, bundle);
    }

    @Nullable
    public final Function2<Integer, DocumentFile, Unit> getOnStorageAccessGranted() {
        return this.onStorageAccessGranted;
    }

    public final void setOnStorageAccessGranted(@Nullable Function2<? super Integer, ? super DocumentFile, Unit> function2) {
        this.onStorageAccessGranted = function2;
    }

    @Nullable
    public final Function2<Integer, DocumentFile, Unit> getOnFolderSelected() {
        return this.onFolderSelected;
    }

    public final void setOnFolderSelected(@Nullable Function2<? super Integer, ? super DocumentFile, Unit> callback) {
        this.onFolderSelected = callback;
        this.storage.setFolderPickerCallback(new FolderPickerCallback(this, callback){
            final /* synthetic */ SimpleStorageHelper this$0;
            final /* synthetic */ Function2<Integer, DocumentFile, Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onFolderSelected(int requestCode, @NotNull DocumentFile folder) {
                Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
                SimpleStorageHelper.access$reset(this.this$0);
                Function2<Integer, DocumentFile, Unit> function2 = this.$callback;
                if (function2 != null) {
                    function2.invoke((Object)requestCode, (Object)folder);
                }
            }

            public void onStorageAccessDenied(int requestCode, @Nullable DocumentFile folder, @NotNull StorageType storageType) {
                Intrinsics.checkNotNullParameter((Object)((Object)storageType), (String)"storageType");
                if (storageType == StorageType.UNKNOWN) {
                    this.onStoragePermissionDenied(requestCode);
                    return;
                }
                new AlertDialog.Builder(this.this$0.getStorage().getContext()).setCancelable(false).setMessage(R.string.ss_storage_access_denied_confirm).setNegativeButton(0x1040000, (arg_0, arg_1) -> onFolderSelected.1.onStorageAccessDenied$lambda-0(this.this$0, arg_0, arg_1)).setPositiveButton(17039370, (arg_0, arg_1) -> onFolderSelected.1.onStorageAccessDenied$lambda-1(this.this$0, storageType, arg_0, arg_1)).show();
            }

            public void onStoragePermissionDenied(int requestCode) {
                SimpleStorageHelper.access$requestStoragePermission(this.this$0, (Function1)new Function1<Boolean, Unit>(this.this$0){
                    final /* synthetic */ SimpleStorageHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        if (it) {
                            SimpleStorage.openFolderPicker$default(this.this$0.getStorage(), 0, 1, null);
                        } else {
                            SimpleStorageHelper.access$reset(this.this$0);
                        }
                    }
                });
            }

            public void onCanceledByUser(int requestCode) {
                SimpleStorageHelper.access$reset(this.this$0);
            }

            public void onActivityHandlerNotFound(int requestCode, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                SimpleStorageHelper.access$handleMissingActivityHandler(this.this$0);
            }

            private static final void onStorageAccessDenied$lambda-0(SimpleStorageHelper this$0, DialogInterface $noName_0, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                SimpleStorageHelper.access$reset(this$0);
            }

            private static final void onStorageAccessDenied$lambda-1(SimpleStorageHelper this$0, StorageType $storageType, DialogInterface $noName_0, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)$storageType), (String)"$storageType");
                SimpleStorage.requestStorageAccess$default(this$0.getStorage(), 0, $storageType, null, null, 13, null);
            }
        });
    }

    @Nullable
    public final Function2<Integer, List<? extends DocumentFile>, Unit> getOnFileSelected() {
        return this.onFileSelected;
    }

    public final void setOnFileSelected(@Nullable Function2<? super Integer, ? super List<? extends DocumentFile>, Unit> callback) {
        this.onFileSelected = callback;
        this.storage.setFilePickerCallback(new FilePickerCallback(this, callback){
            final /* synthetic */ SimpleStorageHelper this$0;
            final /* synthetic */ Function2<Integer, List<? extends DocumentFile>, Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onStoragePermissionDenied(int requestCode, @Nullable List<? extends DocumentFile> files) {
                SimpleStorageHelper.access$requestStoragePermission(this.this$0, (Function1)new Function1<Boolean, Unit>(this.this$0){
                    final /* synthetic */ SimpleStorageHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        if (it) {
                            SimpleStorage.openFilePicker$default(this.this$0.getStorage(), 0, false, new String[0], 3, null);
                        } else {
                            SimpleStorageHelper.access$reset(this.this$0);
                        }
                    }
                });
            }

            public void onFileSelected(int requestCode, @NotNull List<? extends DocumentFile> files) {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                SimpleStorageHelper.access$reset(this.this$0);
                Function2<Integer, List<? extends DocumentFile>, Unit> function2 = this.$callback;
                if (function2 != null) {
                    function2.invoke((Object)requestCode, files);
                }
            }

            public void onCanceledByUser(int requestCode) {
                SimpleStorageHelper.access$reset(this.this$0);
            }

            public void onActivityHandlerNotFound(int requestCode, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                SimpleStorageHelper.access$handleMissingActivityHandler(this.this$0);
            }
        });
    }

    @Nullable
    public final Function2<Integer, DocumentFile, Unit> getOnFileCreated() {
        return this.onFileCreated;
    }

    public final void setOnFileCreated(@Nullable Function2<? super Integer, ? super DocumentFile, Unit> callback) {
        this.onFileCreated = callback;
        this.storage.setCreateFileCallback(new CreateFileCallback(this, callback){
            final /* synthetic */ SimpleStorageHelper this$0;
            final /* synthetic */ Function2<Integer, DocumentFile, Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onCanceledByUser(int requestCode) {
                SimpleStorageHelper.access$reset(this.this$0);
            }

            public void onActivityHandlerNotFound(int requestCode, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                SimpleStorageHelper.access$handleMissingActivityHandler(this.this$0);
            }

            public void onFileCreated(int requestCode, @NotNull DocumentFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                SimpleStorageHelper.access$reset(this.this$0);
                Function2<Integer, DocumentFile, Unit> function2 = this.$callback;
                if (function2 != null) {
                    function2.invoke((Object)requestCode, (Object)file);
                }
            }
        });
    }

    @Nullable
    public final OnFileReceived getOnFileReceived() {
        return this.onFileReceived;
    }

    public final void setOnFileReceived(@Nullable OnFileReceived callback) {
        this.onFileReceived = callback;
        this.storage.setFileReceiverCallback(new FileReceiverCallback(callback, this){
            final /* synthetic */ OnFileReceived $callback;
            final /* synthetic */ SimpleStorageHelper this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onFileReceived(@NotNull List<? extends DocumentFile> files) {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                OnFileReceived onFileReceived2 = this.$callback;
                if (onFileReceived2 != null) {
                    onFileReceived2.onFileReceived(files);
                }
            }

            public void onNonFileReceived(@NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                OnFileReceived onFileReceived2 = this.$callback;
                if (onFileReceived2 != null) {
                    onFileReceived2.onNonFileReceived(intent);
                }
            }

            public void onStoragePermissionDenied(@NotNull List<? extends DocumentFile> files) {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                SimpleStorageHelper.access$requestStoragePermission(this.this$0, (Function1)new Function1<Boolean, Unit>(this.$callback, files, this.this$0){
                    final /* synthetic */ OnFileReceived $callback;
                    final /* synthetic */ List<DocumentFile> $files;
                    final /* synthetic */ SimpleStorageHelper this$0;
                    {
                        this.$callback = $callback;
                        this.$files = $files;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        if (it) {
                            OnFileReceived onFileReceived2 = this.$callback;
                            if (onFileReceived2 != null) {
                                onFileReceived2.onFileReceived(this.$files);
                            }
                        } else {
                            SimpleStorageHelper.access$reset(this.this$0);
                        }
                    }
                });
            }
        });
    }

    private final void init(Bundle savedState) {
        Bundle bundle = savedState;
        if (bundle != null) {
            Bundle bundle2 = bundle;
            boolean bl = false;
            boolean bl2 = false;
            Bundle it = bundle2;
            boolean bl3 = false;
            this.onRestoreInstanceState(it);
        }
        this.storage.setStorageAccessCallback(new StorageAccessCallback(this){
            final /* synthetic */ SimpleStorageHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRootPathNotSelected(int requestCode, @NotNull String rootPath, @NotNull Uri uri, @NotNull StorageType selectedStorageType, @NotNull StorageType expectedStorageType) {
                Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)((Object)selectedStorageType), (String)"selectedStorageType");
                Intrinsics.checkNotNullParameter((Object)((Object)expectedStorageType), (String)"expectedStorageType");
                StorageType storageType = expectedStorageType.isExpected(selectedStorageType) ? selectedStorageType : expectedStorageType;
                int messageRes = storageType == StorageType.SD_CARD ? R.string.ss_please_select_root_storage_sdcard : R.string.ss_please_select_root_storage_primary;
                new AlertDialog.Builder(this.this$0.getStorage().getContext()).setCancelable(false).setMessage(messageRes).setNegativeButton(0x1040000, (arg_0, arg_1) -> init.2.onRootPathNotSelected$lambda-0(this.this$0, arg_0, arg_1)).setPositiveButton(17039370, (arg_0, arg_1) -> init.2.onRootPathNotSelected$lambda-1(this.this$0, storageType, expectedStorageType, arg_0, arg_1)).show();
            }

            /*
             * WARNING - void declaration
             */
            public void onRootPathPermissionGranted(int requestCode, @NotNull DocumentFile root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                if (requestCode == SimpleStorageHelper.access$getOriginalRequestCode$p(this.this$0)) {
                    SimpleStorageHelper.access$reset(this.this$0);
                    Function2<Integer, DocumentFile, Unit> function2 = this.this$0.getOnStorageAccessGranted();
                    if (function2 != null) {
                        function2.invoke((Object)requestCode, (Object)root);
                    }
                    return;
                }
                Context context = this.this$0.getStorage().getContext();
                Function0 toastFilePicker2 = (Function0)new Function0<Unit>(context, root){
                    final /* synthetic */ Context $context;
                    final /* synthetic */ DocumentFile $root;
                    {
                        this.$context = $context;
                        this.$root = $root;
                        super(0);
                    }

                    public final void invoke() {
                        Object[] objectArray = new Object[]{DocumentFileUtils.getAbsolutePath(this.$root, this.$context)};
                        Toast.makeText((Context)this.$context, (CharSequence)this.$context.getString(R.string.ss_selecting_root_path_success_with_open_folder_picker, objectArray), (int)1).show();
                    }
                };
                int n = SimpleStorageHelper.access$getPickerToOpenOnceGranted$p(this.this$0);
                switch (n) {
                    case 1: {
                        void $this$toTypedArray$iv;
                        SimpleStorage simpleStorage = this.this$0.getStorage();
                        Collection<E> collection = SimpleStorageHelper.access$getFilterMimeTypes$p(this.this$0);
                        boolean bl = false;
                        Set set = collection;
                        if (set == null) {
                            set = SetsKt.emptySet();
                        }
                        collection = set;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        String[] stringArray2 = stringArray;
                        SimpleStorage.openFilePicker$default(simpleStorage, 0, false, Arrays.copyOf(stringArray2, stringArray2.length), 3, null);
                        toastFilePicker2.invoke();
                        break;
                    }
                    case 2: {
                        SimpleStorage.openFolderPicker$default(this.this$0.getStorage(), 0, 1, null);
                        toastFilePicker2.invoke();
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{DocumentFileUtils.getAbsolutePath(root, context)};
                        Toast.makeText((Context)context, (CharSequence)context.getString(R.string.ss_selecting_root_path_success_without_open_folder_picker, objectArray), (int)0).show();
                    }
                }
                SimpleStorageHelper.access$reset(this.this$0);
            }

            public void onExpectedStorageNotSelected(int requestCode, @NotNull DocumentFile selectedFolder, @NotNull StorageType selectedStorageType, @NotNull String expectedBasePath, @NotNull StorageType expectedStorageType) {
                int n;
                Intrinsics.checkNotNullParameter((Object)selectedFolder, (String)"selectedFolder");
                Intrinsics.checkNotNullParameter((Object)((Object)selectedStorageType), (String)"selectedStorageType");
                Intrinsics.checkNotNullParameter((Object)expectedBasePath, (String)"expectedBasePath");
                Intrinsics.checkNotNullParameter((Object)expectedStorageType, (String)"expectedStorageType");
                Context context = this.this$0.getStorage().getContext();
                Object[] objectArray = expectedStorageType;
                int n2 = init.WhenMappings.$EnumSwitchMapping$0[objectArray.ordinal()];
                switch (n2) {
                    case 1: {
                        n = R.string.ss_please_select_base_path_with_storage_type_primary;
                        break;
                    }
                    case 2: {
                        n = R.string.ss_please_select_base_path_with_storage_type_sd_card;
                        break;
                    }
                    default: {
                        n = R.string.ss_please_select_base_path;
                    }
                }
                objectArray = new Object[]{expectedBasePath};
                String string2 = context.getString(n, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"storage.context.getString(\n                    when (expectedStorageType) {\n                        StorageType.EXTERNAL -> R.string.ss_please_select_base_path_with_storage_type_primary\n                        StorageType.SD_CARD -> R.string.ss_please_select_base_path_with_storage_type_sd_card\n                        else -> R.string.ss_please_select_base_path\n                    }, expectedBasePath\n                )");
                String message = string2;
                new AlertDialog.Builder(this.this$0.getStorage().getContext()).setCancelable(false).setMessage((CharSequence)message).setNegativeButton(0x1040000, (arg_0, arg_1) -> init.2.onExpectedStorageNotSelected$lambda-2(this.this$0, arg_0, arg_1)).setPositiveButton(17039370, (arg_0, arg_1) -> init.2.onExpectedStorageNotSelected$lambda-3(this.this$0, (StorageType)expectedStorageType, expectedBasePath, arg_0, arg_1)).show();
            }

            public void onStoragePermissionDenied(int requestCode) {
                SimpleStorageHelper.access$requestStoragePermission(this.this$0, (Function1)new Function1<Boolean, Unit>(this.this$0){
                    final /* synthetic */ SimpleStorageHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        if (it) {
                            SimpleStorage.openFolderPicker$default(this.this$0.getStorage(), 0, 1, null);
                        } else {
                            SimpleStorageHelper.access$reset(this.this$0);
                        }
                    }
                });
            }

            public void onCanceledByUser(int requestCode) {
                SimpleStorageHelper.access$reset(this.this$0);
            }

            public void onActivityHandlerNotFound(int requestCode, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                SimpleStorageHelper.access$handleMissingActivityHandler(this.this$0);
            }

            private static final void onRootPathNotSelected$lambda-0(SimpleStorageHelper this$0, DialogInterface $noName_0, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                SimpleStorageHelper.access$reset(this$0);
            }

            private static final void onRootPathNotSelected$lambda-1(SimpleStorageHelper this$0, StorageType $storageType, StorageType $expectedStorageType, DialogInterface $noName_0, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)$storageType), (String)"$storageType");
                Intrinsics.checkNotNullParameter((Object)((Object)$expectedStorageType), (String)"$expectedStorageType");
                SimpleStorage.requestStorageAccess$default(this$0.getStorage(), 0, $storageType, $expectedStorageType, null, 9, null);
            }

            private static final void onExpectedStorageNotSelected$lambda-2(SimpleStorageHelper this$0, DialogInterface $noName_0, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                SimpleStorageHelper.access$reset(this$0);
            }

            private static final void onExpectedStorageNotSelected$lambda-3(SimpleStorageHelper this$0, StorageType $expectedStorageType, String $expectedBasePath, DialogInterface $noName_0, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)$expectedStorageType), (String)"$expectedStorageType");
                Intrinsics.checkNotNullParameter((Object)$expectedBasePath, (String)"$expectedBasePath");
                SimpleStorage.requestStorageAccess$default(this$0.getStorage(), 0, $expectedStorageType, $expectedStorageType, $expectedBasePath, 1, null);
            }
        });
    }

    private final void requestStoragePermission(Function1<? super Boolean, Unit> onResult) {
        this.onPermissionsResult = onResult;
        this.permissionRequest.check();
    }

    public final void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        if (this.permissionRequest instanceof ActivityPermissionRequest) {
            ((ActivityPermissionRequest)this.permissionRequest).onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private final PermissionCallback getPermissionCallback() {
        return new PermissionCallback(this){
            final /* synthetic */ SimpleStorageHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPermissionsChecked(@NotNull PermissionResult result, boolean fromSystemDialog) {
                Function1 function1;
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                boolean granted = result.getAreAllPermissionsGranted();
                if (!granted) {
                    Toast.makeText((Context)this.this$0.getStorage().getContext(), (int)R.string.ss_please_grant_storage_permission, (int)0).show();
                }
                if ((function1 = SimpleStorageHelper.access$getOnPermissionsResult$p(this.this$0)) != null) {
                    function1.invoke((Object)granted);
                }
                SimpleStorageHelper.access$setOnPermissionsResult$p(this.this$0, null);
            }

            public void onShouldRedirectToSystemSettings(@NotNull List<PermissionReport> blockedPermissions) {
                Intrinsics.checkNotNullParameter(blockedPermissions, (String)"blockedPermissions");
                SimpleStorageHelper.Companion.redirectToSystemSettings(this.this$0.getStorage().getContext());
                Function1 function1 = SimpleStorageHelper.access$getOnPermissionsResult$p(this.this$0);
                if (function1 != null) {
                    function1.invoke((Object)false);
                }
                SimpleStorageHelper.access$setOnPermissionsResult$p(this.this$0, null);
            }
        };
    }

    private final String[] getRwPermission() {
        String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        return stringArray;
    }

    private final void reset() {
        this.pickerToOpenOnceGranted = 0;
        this.originalRequestCode = 0;
        this.filterMimeTypes = null;
    }

    private final void handleMissingActivityHandler() {
        this.reset();
        Toast.makeText((Context)this.storage.getContext(), (int)R.string.ss_missing_saf_activity_handler, (int)0).show();
    }

    @JvmOverloads
    public final void openFolderPicker(int requestCode) {
        this.pickerToOpenOnceGranted = 2;
        this.originalRequestCode = requestCode;
        this.storage.openFolderPicker(requestCode);
    }

    public static /* synthetic */ void openFolderPicker$default(SimpleStorageHelper simpleStorageHelper, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorageHelper.storage.getRequestCodeFolderPicker();
        }
        simpleStorageHelper.openFolderPicker(n);
    }

    @JvmOverloads
    public final void openFilePicker(int requestCode, boolean allowMultiple, String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        this.pickerToOpenOnceGranted = 1;
        this.originalRequestCode = requestCode;
        Set set = ArraysKt.toSet((Object[])filterMimeTypes);
        boolean bl = false;
        boolean bl2 = false;
        Set it = set;
        boolean bl3 = false;
        this.filterMimeTypes = it;
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        this.getStorage().openFilePicker(requestCode, allowMultiple, Arrays.copyOf(stringArray2, stringArray2.length));
    }

    public static /* synthetic */ void openFilePicker$default(SimpleStorageHelper simpleStorageHelper, int n, boolean bl, String[] stringArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorageHelper.storage.getRequestCodeFilePicker();
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        simpleStorageHelper.openFilePicker(n, bl, stringArray);
    }

    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @NotNull StorageType initialRootPath, @NotNull StorageType expectedStorageType, @NotNull String expectedBasePath) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialRootPath), (String)"initialRootPath");
        Intrinsics.checkNotNullParameter((Object)((Object)expectedStorageType), (String)"expectedStorageType");
        Intrinsics.checkNotNullParameter((Object)expectedBasePath, (String)"expectedBasePath");
        this.pickerToOpenOnceGranted = 0;
        this.originalRequestCode = requestCode;
        this.storage.requestStorageAccess(requestCode, initialRootPath, expectedStorageType, expectedBasePath);
    }

    public static /* synthetic */ void requestStorageAccess$default(SimpleStorageHelper simpleStorageHelper, int n, StorageType storageType, StorageType storageType2, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorageHelper.storage.getRequestCodeStorageAccess();
        }
        if ((n2 & 2) != 0) {
            storageType = StorageType.EXTERNAL;
        }
        if ((n2 & 4) != 0) {
            storageType2 = StorageType.UNKNOWN;
        }
        if ((n2 & 8) != 0) {
            string2 = "";
        }
        simpleStorageHelper.requestStorageAccess(n, storageType, storageType2, string2);
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType, @Nullable String fileName, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        this.pickerToOpenOnceGranted = 0;
        this.originalRequestCode = requestCode;
        this.storage.createFile(mimeType, fileName, requestCode);
    }

    public static /* synthetic */ void createFile$default(SimpleStorageHelper simpleStorageHelper, String string2, String string3, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        if ((n2 & 4) != 0) {
            n = simpleStorageHelper.storage.getRequestCodeCreateFile();
        }
        simpleStorageHelper.createFile(string2, string3, n);
    }

    public final void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        this.storage.onSaveInstanceState(outState);
        outState.putInt(KEY_ORIGINAL_REQUEST_CODE, this.originalRequestCode);
        outState.putInt(KEY_OPEN_FOLDER_PICKER_ONCE_GRANTED, this.pickerToOpenOnceGranted);
        Set<String> set = this.filterMimeTypes;
        if (set != null) {
            Set<String> set2 = set;
            boolean bl = false;
            boolean bl2 = false;
            Set<String> it = set2;
            boolean bl3 = false;
            Collection $this$toTypedArray$iv = it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            outState.putStringArray(KEY_FILTER_MIME_TYPES, stringArray);
        }
    }

    public final void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)savedInstanceState, (String)"savedInstanceState");
        this.storage.onRestoreInstanceState(savedInstanceState);
        this.originalRequestCode = savedInstanceState.getInt(KEY_ORIGINAL_REQUEST_CODE);
        this.pickerToOpenOnceGranted = savedInstanceState.getInt(KEY_OPEN_FOLDER_PICKER_ONCE_GRANTED);
        Object[] objectArray = savedInstanceState.getStringArray(KEY_FILTER_MIME_TYPES);
        this.filterMimeTypes = objectArray == null ? null : ArraysKt.toSet((Object[])objectArray);
    }

    @JvmOverloads
    public SimpleStorageHelper(@NotNull Activity activity, int requestCodeForPermissionDialog) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(activity, requestCodeForPermissionDialog, null, 4, null);
    }

    @JvmOverloads
    public SimpleStorageHelper(@NotNull ComponentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(activity, null, 2, null);
    }

    @JvmOverloads
    public SimpleStorageHelper(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(fragment, null, 2, null);
    }

    @JvmOverloads
    public final void openFolderPicker() {
        SimpleStorageHelper.openFolderPicker$default(this, 0, 1, null);
    }

    @JvmOverloads
    public final void openFilePicker(int requestCode, String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        SimpleStorageHelper.openFilePicker$default(this, requestCode, false, filterMimeTypes, 2, null);
    }

    @JvmOverloads
    public final void openFilePicker(String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        SimpleStorageHelper.openFilePicker$default(this, 0, false, filterMimeTypes, 3, null);
    }

    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @NotNull StorageType initialRootPath, @NotNull StorageType expectedStorageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialRootPath), (String)"initialRootPath");
        Intrinsics.checkNotNullParameter((Object)((Object)expectedStorageType), (String)"expectedStorageType");
        SimpleStorageHelper.requestStorageAccess$default(this, requestCode, initialRootPath, expectedStorageType, null, 8, null);
    }

    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @NotNull StorageType initialRootPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialRootPath), (String)"initialRootPath");
        SimpleStorageHelper.requestStorageAccess$default(this, requestCode, initialRootPath, null, null, 12, null);
    }

    @JvmOverloads
    public final void requestStorageAccess(int requestCode) {
        SimpleStorageHelper.requestStorageAccess$default(this, requestCode, null, null, null, 14, null);
    }

    @JvmOverloads
    public final void requestStorageAccess() {
        SimpleStorageHelper.requestStorageAccess$default(this, 0, null, null, null, 15, null);
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        SimpleStorageHelper.createFile$default(this, mimeType, fileName, 0, 4, null);
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        SimpleStorageHelper.createFile$default(this, mimeType, null, 0, 6, null);
    }

    @JvmStatic
    public static final void redirectToSystemSettings(@NotNull Context context) {
        Companion.redirectToSystemSettings(context);
    }

    public static final /* synthetic */ void access$reset(SimpleStorageHelper $this) {
        $this.reset();
    }

    public static final /* synthetic */ void access$requestStoragePermission(SimpleStorageHelper $this, Function1 onResult) {
        $this.requestStoragePermission((Function1<? super Boolean, Unit>)onResult);
    }

    public static final /* synthetic */ void access$handleMissingActivityHandler(SimpleStorageHelper $this) {
        $this.handleMissingActivityHandler();
    }

    public static final /* synthetic */ int access$getOriginalRequestCode$p(SimpleStorageHelper $this) {
        return $this.originalRequestCode;
    }

    public static final /* synthetic */ int access$getPickerToOpenOnceGranted$p(SimpleStorageHelper $this) {
        return $this.pickerToOpenOnceGranted;
    }

    public static final /* synthetic */ Set access$getFilterMimeTypes$p(SimpleStorageHelper $this) {
        return $this.filterMimeTypes;
    }

    public static final /* synthetic */ Function1 access$getOnPermissionsResult$p(SimpleStorageHelper $this) {
        return $this.onPermissionsResult;
    }

    public static final /* synthetic */ void access$setOnPermissionsResult$p(SimpleStorageHelper $this, Function1 function1) {
        $this.onPermissionsResult = function1;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/anggrayudi/storage/SimpleStorageHelper$OnFileReceived;", "", "onFileReceived", "", "files", "", "Landroidx/documentfile/provider/DocumentFile;", "onNonFileReceived", "intent", "Landroid/content/Intent;", "storage_release"})
    public static interface OnFileReceived {
        public void onFileReceived(@NotNull List<? extends DocumentFile> var1);

        default public void onNonFileReceived(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/anggrayudi/storage/SimpleStorageHelper$Companion;", "", "()V", "KEY_FILTER_MIME_TYPES", "", "KEY_OPEN_FOLDER_PICKER_ONCE_GRANTED", "KEY_ORIGINAL_REQUEST_CODE", "TYPE_FILE_PICKER", "", "TYPE_FOLDER_PICKER", "redirectToSystemSettings", "", "context", "Landroid/content/Context;", "storage_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void redirectToSystemSettings(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            new AlertDialog.Builder(context).setMessage(R.string.ss_storage_permission_permanently_disabled).setNegativeButton(0x1040000, Companion::redirectToSystemSettings$lambda-0).setPositiveButton(17039370, (arg_0, arg_1) -> Companion.redirectToSystemSettings$lambda-1(context, arg_0, arg_1)).show();
        }

        private static final void redirectToSystemSettings$lambda-0(DialogInterface $noName_0, int $noName_1) {
        }

        private static final void redirectToSystemSettings$lambda-1(Context $context, DialogInterface $noName_0, int $noName_1) {
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)Intrinsics.stringPlus((String)"package:", (Object)$context.getPackageName()))).addCategory("android.intent.category.DEFAULT").setFlags(0x10000000);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS, Uri.parse(\"package:${context.packageName}\"))\n                        .addCategory(Intent.CATEGORY_DEFAULT)\n                        .setFlags(Intent.FLAG_ACTIVITY_NEW_TASK)");
            Intent intentSetting = intent;
            $context.startActivity(intentSetting);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

