/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.file;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.text.format.Formatter;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import androidx.core.content.FileProvider;
import androidx.core.content.MimeTypeFilter;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.callback.BaseFileCallback;
import com.anggrayudi.storage.callback.FileCallback;
import com.anggrayudi.storage.callback.FolderCallback;
import com.anggrayudi.storage.callback.MultipleFileCallback;
import com.anggrayudi.storage.extension.ContextUtils;
import com.anggrayudi.storage.extension.CoroutineExtKt;
import com.anggrayudi.storage.extension.IOUtils;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.extension.UriUtils;
import com.anggrayudi.storage.file.CreateMode;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.DocumentFileType;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.FileProperties;
import com.anggrayudi.storage.file.FileUtils;
import com.anggrayudi.storage.file.MimeType;
import com.anggrayudi.storage.file.PublicDirectory;
import com.anggrayudi.storage.file.StorageType;
import com.anggrayudi.storage.media.FileDescription;
import com.anggrayudi.storage.media.MediaFile;
import com.anggrayudi.storage.media.MediaStoreCompat;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u008a\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aV\u0010\u0018\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00022\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u0002H\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u00030 2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00190\"H\u0002\u001aC\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020&2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00190\"H\u0082\b\u001a<\u0010'\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020&H\u0002\u001a(\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020&H\u0002\u001a(\u0010/\u001a\u0002002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u000203H\u0002\u001a\u001c\u00104\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u0001H\u0007\u001a\u0012\u00106\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a$\u00107\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\fH\u0007\u001a(\u0010:\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u00012\b\b\u0002\u00108\u001a\u00020\fH\u0007\u001aD\u0010<\u001a\u00020\u0019*\u00020\u00022\u0006\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020?2\u0006\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020&H\u0002\u001a0\u0010D\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00022\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u001f\u001a\u00020&H\u0007\u001a8\u0010D\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00022\b\u0010)\u001a\u0004\u0018\u00010\u00012\b\u0010G\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020&H\u0002\u001a$\u0010D\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020&H\u0007\u001a,\u0010D\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020%2\u0006\u0010C\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020&H\u0002\u001a0\u0010D\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020H2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u001f\u001a\u00020&H\u0007\u001a0\u0010D\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020\u00012\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u001f\u001a\u00020&H\u0007\u001a.\u0010J\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u001f\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+H\u0007\u001a<\u0010K\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u001f\u001a\u00020&2\u0006\u0010L\u001a\u00020M2\u0006\u0010C\u001a\u00020\f2\u0006\u0010*\u001a\u00020+H\u0002\u001a.\u0010N\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u001f\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+H\u0007\u001a:\u0010O\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\b\b\u0002\u0010P\u001a\u00020\f2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u000203H\u0007\u001aB\u0010O\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\b\b\u0002\u0010P\u001a\u00020\f2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010\u00012\u0006\u0010R\u001a\u00020\f2\u0006\u0010\u001f\u001a\u000203H\u0002\u001a4\u0010S\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00020T2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\b\b\u0002\u0010P\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020UH\u0007\u001a<\u0010S\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00020T2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\b\b\u0002\u0010P\u001a\u00020\f2\u0006\u0010R\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020UH\u0002\u001a(\u0010V\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u00012\b\b\u0002\u0010*\u001a\u00020+H\u0007\u001a\u0012\u0010X\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001e\u0010Y\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010Z\u001a\u00020\fH\u0007\u001a0\u0010[\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00022\b\u0010)\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020&H\u0002\u001a0\u0010[\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\b\u0010Q\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u000203H\u0002\u001a>\u0010[\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020]\u0018\u00010\\*\b\u0012\u0004\u0012\u00020\u00020T2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020UH\u0002\u001a\u0014\u0010^\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010W\u001a\u00020\u0001\u001a-\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00020T*\u00020\u00022\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00010a2\b\b\u0002\u0010b\u001a\u00020c\u00a2\u0006\u0002\u0010d\u001a\u0014\u0010e\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010W\u001a\u00020\u0001\u001a\u001e\u0010f\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010Z\u001a\u00020\fH\u0007\u001a\u0012\u0010g\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010h\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001a\u0010i\u001a\n j*\u0004\u0018\u00010\u00010\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001c\u0010k\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020lH\u0007\u001a\u0012\u0010m\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a \u0010n\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u00108\u001a\u00020\fH\u0007\u001a\u0012\u0010o\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010p\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010q\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010r\u001a\u00020s*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001c\u0010t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010u\u001a\u00020\u0001H\u0002\u001a2\u0010/\u001a\n\u0012\u0004\u0012\u00020v\u0018\u00010T*\b\u0012\u0004\u0012\u00020\u00020T2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020UH\u0002\u001a\u001a\u0010w\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010x\u001a\u00020\u0002\u001a\u0012\u0010y\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010z\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010{\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001a\u0010|\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010}\u001a\u00020\u0002\u001a\u0012\u0010~\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0014\u0010\u007f\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u001a\u0013\u0010\u0080\u0001\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0013\u0010\u0081\u0001\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0013\u0010\u0082\u0001\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0013\u0010\u0083\u0001\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a5\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u00012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010*\u001a\u00020+H\u0007\u001a)\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u00012\b\b\u0002\u0010*\u001a\u00020+H\u0007\u001a\"\u0010\u0086\u0001\u001a\u00020\f*\u00020\u00022\r\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020\u00010aH\u0002\u00a2\u0006\u0003\u0010\u0088\u0001\u001a1\u0010\u0089\u0001\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00022\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u001f\u001a\u00020&H\u0007\u001a9\u0010\u0089\u0001\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00022\b\u0010)\u001a\u0004\u0018\u00010\u00012\b\u0010G\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020&H\u0002\u001a%\u0010\u0089\u0001\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020&H\u0007\u001a1\u0010\u0089\u0001\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020H2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u001f\u001a\u00020&H\u0007\u001a1\u0010\u0089\u0001\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020\u00012\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u001f\u001a\u00020&H\u0007\u001a/\u0010\u008a\u0001\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u001f\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+H\u0007\u001a/\u0010\u008b\u0001\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u001f\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020+H\u0007\u001a;\u0010\u008c\u0001\u001a\u00020\u0019*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\b\b\u0002\u0010P\u001a\u00020\f2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u000203H\u0007\u001a5\u0010\u008d\u0001\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00020T2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00022\b\b\u0002\u0010P\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020UH\u0007\u001a\u001f\u0010\u008e\u0001\u001a\u00030\u008f\u0001*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0007\u0010\u0090\u0001\u001a\u00020\u0001H\u0007\u001a\u0017\u0010\u0091\u0001\u001a\u0004\u0018\u00010#*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u001a\"\u0010\u0092\u0001\u001a\u0004\u0018\u00010$*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\t\b\u0002\u0010\u0093\u0001\u001a\u00020\fH\u0007\u001a\u0017\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010W\u001a\u00020\u0001H\u0007\u001a)\u0010\u0095\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u0006\u0010W\u001a\u00020\u0001H\u0007\u001a\u0015\u0010\u0098\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001aY\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020T*\u00020\u00022\t\b\u0002\u0010\u009a\u0001\u001a\u00020\f2\b\b\u0002\u0010b\u001a\u00020c2\u0011\b\u0002\u0010\u009b\u0001\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010a2\b\b\u0002\u0010W\u001a\u00020\u00012\f\b\u0002\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u0001H\u0007\u00a2\u0006\u0003\u0010\u009e\u0001\u001a\u001d\u0010\u009f\u0001\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\fH\u0007\u001a\u0015\u0010\u00a0\u0001\u001a\u00020\f*\u00020\u00022\u0006\u0010\u001f\u001a\u00020&H\u0002\u001a\u001f\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\fH\u0007\u001a\u0014\u0010\u00a2\u0001\u001a\u00030\u00a3\u0001*\b0\u00a4\u0001j\u0003`\u00a5\u0001H\u0000\u001a\u0014\u0010\u00a6\u0001\u001a\u00030\u00a7\u0001*\b0\u00a4\u0001j\u0003`\u00a5\u0001H\u0002\u001a\u0015\u0010\u00a8\u0001\u001a\u0004\u0018\u00010%*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0014\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001*\b0\u00a4\u0001j\u0003`\u00a5\u0001H\u0002\u001a\u0015\u0010\u00ab\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0015\u0010\u00ac\u0001\u001a\u0004\u0018\u00010H*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0015\u0010\u00ad\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0017\u0010\u00ae\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u001aC\u0010\u00af\u0001\u001a\u0004\u0018\u00010?*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0007\u0010\u00b0\u0001\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u00012\u0006\u0010P\u001a\u00020\f2\b\u0010Q\u001a\u0004\u0018\u00010\u00012\u0007\u0010\u00b1\u0001\u001a\u000200H\u0002\u001a\u001b\u0010\u00b2\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020T*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0013\u0010\u00b3\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020T*\u00020\u0002H\u0002\u001a\u0013\u0010\u00b4\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020T*\u00020\u0002H\u0002\u001a\u0013\u0010\u00b5\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020T*\u00020\u0002H\u0002\u001a!\u0010\u00b6\u0001\u001a\u00020\u0019*\u00020\u00022\b\u0010\u00b7\u0001\u001a\u00030\u00b8\u00012\b\u0010\u00b9\u0001\u001a\u00030\u00ba\u0001H\u0002\u001aO\u0010\u00bb\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020T*\u00020\u00022\u0006\u0010b\u001a\u00020c2\r\u0010\u009b\u0001\u001a\b\u0012\u0004\u0012\u00020\u00010a2\u0007\u0010\u00bc\u0001\u001a\u00020\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\b\u0010\u00b9\u0001\u001a\u00030\u00ba\u0001H\u0002\u00a2\u0006\u0003\u0010\u00bd\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\"\u0015\u0010\u000e\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\r\"\u0015\u0010\u000f\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\"\u0015\u0010\u0010\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\"\u0015\u0010\u0011\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\"\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0004\"\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0004\"\u0015\u0010\u0016\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0004\u00a8\u0006\u00be\u0001"}, d2={"baseName", "", "Landroidx/documentfile/provider/DocumentFile;", "getBaseName", "(Landroidx/documentfile/provider/DocumentFile;)Ljava/lang/String;", "extension", "getExtension", "fullName", "getFullName", "id", "getId", "isDownloadsDocument", "", "(Landroidx/documentfile/provider/DocumentFile;)Z", "isExternalStorageDocument", "isMediaDocument", "isRawFile", "isTreeDocumentFile", "mimeType", "getMimeType", "mimeTypeByFileName", "getMimeTypeByFileName", "rootId", "getRootId", "createFileStreams", "", "Enum", "context", "Landroid/content/Context;", "sourceFile", "targetFile", "callback", "Lcom/anggrayudi/storage/callback/BaseFileCallback;", "onStreamsReady", "Lkotlin/Function2;", "Ljava/io/InputStream;", "Ljava/io/OutputStream;", "Lcom/anggrayudi/storage/media/MediaFile;", "Lcom/anggrayudi/storage/callback/FileCallback;", "createTargetFile", "targetFolder", "newFilenameInTargetPath", "mode", "Lcom/anggrayudi/storage/file/CreateMode;", "handleFileConflict", "Lcom/anggrayudi/storage/callback/FileCallback$ConflictResolution;", "targetFileName", "handleParentFolderConflict", "Lcom/anggrayudi/storage/callback/FolderCallback$ConflictResolution;", "targetParentFolder", "targetFolderParentName", "Lcom/anggrayudi/storage/callback/FolderCallback;", "autoIncrementFileName", "filename", "canModify", "checkRequirements", "requiresWriteAccess", "considerRawFile", "child", "path", "copyFileStream", "inputStream", "outputStream", "", "watchProgress", "reportInterval", "", "deleteSourceFileWhenComplete", "copyFileTo", "fileDescription", "Lcom/anggrayudi/storage/media/FileDescription;", "newMimeTypeInTargetPath", "Ljava/io/File;", "targetFolderAbsolutePath", "copyFileToDownloadMedia", "copyFileToMedia", "publicDirectory", "Lcom/anggrayudi/storage/file/PublicDirectory;", "copyFileToPictureMedia", "copyFolderTo", "skipEmptyFiles", "newFolderNameInTargetPath", "deleteSourceWhenComplete", "copyTo", "", "Lcom/anggrayudi/storage/callback/MultipleFileCallback;", "createBinaryFile", "name", "deleteEmptyFolders", "deleteRecursively", "childrenOnly", "doesMeetCopyRequirements", "Lkotlin/Pair;", "", "findFileLiterally", "findFiles", "names", "", "documentType", "Lcom/anggrayudi/storage/file/DocumentFileType;", "(Landroidx/documentfile/provider/DocumentFile;[Ljava/lang/String;Lcom/anggrayudi/storage/file/DocumentFileType;)Ljava/util/List;", "findFolder", "forceDelete", "getAbsolutePath", "getBasePath", "getFormattedSize", "kotlin.jvm.PlatformType", "getProperties", "Lcom/anggrayudi/storage/file/FileProperties$CalculationCallback;", "getRelativePath", "getRootDocumentFile", "getRootPath", "getSimplePath", "getStorageId", "getStorageType", "Lcom/anggrayudi/storage/file/StorageType;", "getSubPath", "otherFolderAbsolutePath", "Lcom/anggrayudi/storage/callback/MultipleFileCallback$ParentConflict;", "hasParent", "parent", "inDataStorage", "inInternalStorage", "inPrimaryStorage", "inSameMountPointWith", "file", "inSdCardStorage", "isEmpty", "isExternalStorageManager", "isReadOnly", "isRootUriPermissionGranted", "isWritable", "makeFile", "makeFolder", "matchesMimeTypes", "filterMimeTypes", "(Landroidx/documentfile/provider/DocumentFile;[Ljava/lang/String;)Z", "moveFileTo", "moveFileToDownloadMedia", "moveFileToPictureMedia", "moveFolderTo", "moveTo", "openFileIntent", "Landroid/content/Intent;", "authority", "openInputStream", "openOutputStream", "append", "quickFindRawFile", "quickFindTreeFile", "resolver", "Landroid/content/ContentResolver;", "recreateFile", "search", "recursive", "mimeTypes", "regex", "Lkotlin/text/Regex;", "(Landroidx/documentfile/provider/DocumentFile;ZLcom/anggrayudi/storage/file/DocumentFileType;[Ljava/lang/String;Ljava/lang/String;Lkotlin/text/Regex;)Ljava/util/List;", "shouldWritable", "simpleCheckSourceFile", "takeIfWritable", "toFileCallbackErrorCode", "Lcom/anggrayudi/storage/callback/FileCallback$ErrorCode;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "toFolderCallbackErrorCode", "Lcom/anggrayudi/storage/callback/FolderCallback$ErrorCode;", "toMediaFile", "toMultipleFileCallbackErrorCode", "Lcom/anggrayudi/storage/callback/MultipleFileCallback$ErrorCode;", "toRawDocumentFile", "toRawFile", "toTreeDocumentFile", "toWritableDownloadsDocumentFile", "tryMoveFolderByRenamingPath", "writableTargetParentFolder", "conflictResolution", "walkFileTree", "walkFileTreeAndDeleteEmptyFolders", "walkFileTreeAndSkipEmptyFiles", "walkFileTreeForDeletion", "walkFileTreeForInfo", "properties", "Lcom/anggrayudi/storage/file/FileProperties;", "thread", "Ljava/lang/Thread;", "walkFileTreeForSearch", "nameFilter", "(Landroidx/documentfile/provider/DocumentFile;Lcom/anggrayudi/storage/file/DocumentFileType;[Ljava/lang/String;Ljava/lang/String;Lkotlin/text/Regex;Ljava/lang/Thread;)Ljava/util/List;", "storage_release"})
@JvmName(name="DocumentFileUtils")
public final class DocumentFileUtils {
    @NotNull
    public static final String getStorageId(@NotNull DocumentFile $this$getStorageId, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getStorageId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = $this$getStorageId.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return UriUtils.getStorageId(uri, context);
    }

    public static final boolean isTreeDocumentFile(@NotNull DocumentFile $this$isTreeDocumentFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isTreeDocumentFile, (String)"<this>");
        Uri uri = $this$isTreeDocumentFile.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return UriUtils.isTreeDocumentFile(uri);
    }

    public static final boolean isExternalStorageDocument(@NotNull DocumentFile $this$isExternalStorageDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalStorageDocument, (String)"<this>");
        Uri uri = $this$isExternalStorageDocument.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return UriUtils.isExternalStorageDocument(uri);
    }

    public static final boolean isDownloadsDocument(@NotNull DocumentFile $this$isDownloadsDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$isDownloadsDocument, (String)"<this>");
        Uri uri = $this$isDownloadsDocument.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return UriUtils.isDownloadsDocument(uri);
    }

    public static final boolean isMediaDocument(@NotNull DocumentFile $this$isMediaDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$isMediaDocument, (String)"<this>");
        Uri uri = $this$isMediaDocument.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return UriUtils.isMediaDocument(uri);
    }

    public static final boolean isReadOnly(@NotNull DocumentFile $this$isReadOnly, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$isReadOnly, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$isReadOnly.canRead() && !DocumentFileUtils.isWritable($this$isReadOnly, context);
    }

    @NotNull
    public static final String getId(@NotNull DocumentFile $this$id) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        String string2 = DocumentsContract.getDocumentId((Uri)$this$id.getUri());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDocumentId(uri)");
        return string2;
    }

    @NotNull
    public static final String getRootId(@NotNull DocumentFile $this$rootId) {
        Intrinsics.checkNotNullParameter((Object)$this$rootId, (String)"<this>");
        String string2 = DocumentsContract.getRootId((Uri)$this$rootId.getUri());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRootId(uri)");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExternalStorageManager(@NotNull DocumentFile $this$isExternalStorageManager, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalStorageManager, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!DocumentFileUtils.isRawFile($this$isExternalStorageManager)) return false;
        String string2 = $this$isExternalStorageManager.getUri().getPath();
        Intrinsics.checkNotNull((Object)string2);
        if (!FileUtils.isExternalStorageManager(new File(string2), context)) return false;
        return true;
    }

    @NotNull
    public static final String getFullName(@NotNull DocumentFile $this$fullName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$fullName, (String)"<this>");
        if (DocumentFileUtils.isRawFile($this$fullName) || DocumentFileUtils.isExternalStorageDocument($this$fullName) || $this$fullName.isDirectory()) {
            String string3 = $this$fullName.getName();
            boolean bl = false;
            string2 = string3;
            if (string2 == null) {
                string2 = "";
            }
        } else {
            String string4 = $this$fullName.getName();
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                string5 = "";
            }
            string2 = MimeType.getFullFileName(string5, $this$fullName.getType());
        }
        return string2;
    }

    public static final boolean inSameMountPointWith(@NotNull DocumentFile $this$inSameMountPointWith, @NotNull Context context, @NotNull DocumentFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$inSameMountPointWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String storageId1 = DocumentFileUtils.getStorageId($this$inSameMountPointWith, context);
        String storageId2 = DocumentFileUtils.getStorageId(file, context);
        return Intrinsics.areEqual((Object)storageId1, (Object)storageId2) || (Intrinsics.areEqual((Object)storageId1, (Object)"primary") || Intrinsics.areEqual((Object)storageId1, (Object)"data")) && (Intrinsics.areEqual((Object)storageId2, (Object)"primary") || Intrinsics.areEqual((Object)storageId2, (Object)"data"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"NewApi"})
    public static final boolean isEmpty(@NotNull DocumentFile $this$isEmpty, @NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$isEmpty.isFile()) {
            if ($this$isEmpty.length() == 0L) return true;
        }
        if (!$this$isEmpty.isDirectory()) return false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (DocumentFileUtils.isRawFile($this$isEmpty)) {
            String[] stringArray = DocumentFileUtils.toRawFile($this$isEmpty, context);
            if (stringArray == null) {
                return true;
            }
            String[] stringArray2 = stringArray.list();
            stringArray = stringArray2;
            boolean bl5 = false;
            boolean bl6 = false;
            if (stringArray == null) return true;
            String[] stringArray3 = stringArray;
            boolean bl7 = false;
            if (stringArray3.length != 0) return false;
            return true;
        }
        try {
            boolean bl8;
            boolean bl9;
            Uri childrenUri = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)$this$isEmpty.getUri(), (String)DocumentFileUtils.getId($this$isEmpty));
            String[] stringArray = new String[]{"document_id"};
            Cursor cursor = context.getContentResolver().query(childrenUri, stringArray, null, null, null);
            if (cursor == null) {
                return true;
            }
            Closeable closeable = (Closeable)cursor;
            boolean bl10 = false;
            boolean bl11 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl12 = false;
                bl9 = it.getCount() == 0;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            boolean bl13 = bl8 = bl9;
            bl = bl13;
        }
        catch (Exception e) {
            return true;
        }
        boolean bl14 = bl;
        if (!bl14) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static final void getProperties(@NotNull DocumentFile $this$getProperties, @NotNull Context context, @NotNull FileProperties.CalculationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$getProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!$this$getProperties.canRead()) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi22 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileProperties.CalculationCallback $callback$inlined;
                {
                    this.$callback$inlined = calculationCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onError();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else if ($this$getProperties.isDirectory()) {
            void it;
            String $i$f$postToUi22 = $this$getProperties.getName();
            boolean bl = false;
            String string2 = $i$f$postToUi22;
            if (string2 == null) {
                string2 = "";
            }
            long $i$f$postToUi22 = $this$getProperties.lastModified();
            bl = false;
            boolean bl2 = false;
            long l = $i$f$postToUi22;
            boolean bl3 = $this$getProperties.isVirtual();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl4 = true;
            long l2 = 0L;
            String string3 = DocumentFileUtils.getAbsolutePath($this$getProperties, context);
            String string4 = string2;
            boolean bl5 = false;
            Date date = it > 0L ? new Date((long)it) : null;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n5 = 244;
            Date date2 = date;
            boolean bl6 = bl3;
            int n6 = n;
            int n7 = n2;
            int n8 = n3;
            int n9 = n4;
            boolean bl7 = bl4;
            long l3 = l2;
            String string5 = string3;
            String string6 = string4;
            FileProperties properties = new FileProperties(string6, string5, l3, bl7, n9, n8, n7, n6, bl6, date2, n5, defaultConstructorMarker);
            if (DocumentFileUtils.isEmpty($this$getProperties, context)) {
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, properties){
                    int label;
                    final /* synthetic */ FileProperties.CalculationCallback $callback$inlined;
                    final /* synthetic */ FileProperties $properties$inlined;
                    {
                        this.$callback$inlined = calculationCallback;
                        this.$properties$inlined = fileProperties;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onComplete(this.$properties$inlined);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                Job timer2 = callback.getUpdateInterval() < 1L ? null : CoroutineExtKt.startCoroutineTimer$default(0L, callback.getUpdateInterval(), false, (Function0)new Function0<Unit>(callback, properties){
                    final /* synthetic */ FileProperties.CalculationCallback $callback;
                    final /* synthetic */ FileProperties $properties;
                    {
                        this.$callback = $callback;
                        this.$properties = $properties;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$postToUi$iv;
                        CoroutineScope coroutineScope = this.$callback.getUiScope();
                        FileProperties.CalculationCallback calculationCallback = this.$callback;
                        FileProperties fileProperties = this.$properties;
                        boolean $i$f$postToUi = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, calculationCallback, fileProperties){
                            int label;
                            final /* synthetic */ FileProperties.CalculationCallback $callback$inlined;
                            final /* synthetic */ FileProperties $properties$inlined;
                            {
                                this.$callback$inlined = calculationCallback;
                                this.$properties$inlined = fileProperties;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onUpdate(this.$properties$inlined);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                }, 5, null);
                Thread thread = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
                DocumentFileUtils.walkFileTreeForInfo($this$getProperties, properties, thread);
                Job job = timer2;
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                }
                boolean interrupted = thread.isInterrupted();
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, interrupted, callback, properties){
                    int label;
                    final /* synthetic */ boolean $interrupted$inlined;
                    final /* synthetic */ FileProperties.CalculationCallback $callback$inlined;
                    final /* synthetic */ FileProperties $properties$inlined;
                    {
                        this.$interrupted$inlined = bl;
                        this.$callback$inlined = calculationCallback;
                        this.$properties$inlined = fileProperties;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                if (this.$interrupted$inlined) {
                                    this.$callback$inlined.onCanceled(this.$properties$inlined);
                                } else {
                                    this.$callback$inlined.onComplete(this.$properties$inlined);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        } else if ($this$getProperties.isFile()) {
            void it;
            long timer2 = $this$getProperties.lastModified();
            boolean thread = false;
            boolean bl = false;
            long $this$postToUi$iv = timer2;
            boolean bl8 = $this$getProperties.isVirtual();
            int n = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            boolean bl9 = false;
            long l = $this$getProperties.length();
            String string7 = DocumentFileUtils.getAbsolutePath($this$getProperties, context);
            String string8 = DocumentFileUtils.getFullName($this$getProperties);
            boolean bl10 = false;
            Date date = it > 0L ? new Date((long)it) : null;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n13 = 248;
            Date date3 = date;
            boolean bl11 = bl8;
            int n14 = n;
            int n15 = n10;
            int n16 = n11;
            int n17 = n12;
            boolean bl12 = bl9;
            long l4 = l;
            String string9 = string7;
            String string10 = string8;
            FileProperties properties = new FileProperties(string10, string9, l4, bl12, n17, n16, n15, n14, bl11, date3, n13, defaultConstructorMarker);
            CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, properties){
                int label;
                final /* synthetic */ FileProperties.CalculationCallback $callback$inlined;
                final /* synthetic */ FileProperties $properties$inlined;
                {
                    this.$callback$inlined = calculationCallback;
                    this.$properties$inlined = fileProperties;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onComplete(this.$properties$inlined);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private static final void walkFileTreeForInfo(DocumentFile $this$walkFileTreeForInfo, FileProperties properties, Thread thread) {
        Object object = $this$walkFileTreeForInfo.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"listFiles()");
        DocumentFile[] list = object;
        object = list;
        int n = 0;
        if (((DocumentFile[])object).length == 0) {
            object = properties;
            n = ((FileProperties)object).getEmptyFolders();
            ((FileProperties)object).setEmptyFolders(n + 1);
            return;
        }
        DocumentFile[] $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        DocumentFile[] documentFileArray = $this$forEach$iv;
        int n2 = documentFileArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            FileProperties fileProperties;
            DocumentFile element$iv;
            DocumentFile it = element$iv = documentFileArray[i];
            boolean bl = false;
            if (thread.isInterrupted()) {
                return;
            }
            if (it.isFile()) {
                fileProperties = properties;
                n3 = fileProperties.getFiles();
                fileProperties.setFiles(n3 + 1);
                long size = it.length();
                FileProperties fileProperties2 = properties;
                fileProperties2.setSize(fileProperties2.getSize() + size);
                if (size != 0L) continue;
                fileProperties2 = properties;
                int n4 = fileProperties2.getEmptyFiles();
                fileProperties2.setEmptyFiles(n4 + 1);
                continue;
            }
            fileProperties = properties;
            n3 = fileProperties.getFolders();
            fileProperties.setFolders(n3 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            DocumentFileUtils.walkFileTreeForInfo(it, properties, thread);
        }
    }

    @NotNull
    public static final StorageType getStorageType(@NotNull DocumentFile $this$getStorageType, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getStorageType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileUtils.isTreeDocumentFile($this$getStorageType) ? (DocumentFileUtils.inPrimaryStorage($this$getStorageType, context) ? StorageType.EXTERNAL : StorageType.SD_CARD) : (DocumentFileUtils.inSdCardStorage($this$getStorageType, context) ? StorageType.SD_CARD : (DocumentFileUtils.inDataStorage($this$getStorageType, context) ? StorageType.DATA : StorageType.UNKNOWN));
    }

    public static final boolean inInternalStorage(@NotNull DocumentFile $this$inInternalStorage, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$inInternalStorage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = DocumentFileUtils.getStorageId($this$inInternalStorage, context);
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        return Intrinsics.areEqual((Object)it, (Object)"primary") || Intrinsics.areEqual((Object)it, (Object)"data");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean inPrimaryStorage(@NotNull DocumentFile $this$inPrimaryStorage, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$inPrimaryStorage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isTreeDocumentFile($this$inPrimaryStorage)) {
            if (Intrinsics.areEqual((Object)DocumentFileUtils.getStorageId($this$inPrimaryStorage, context), (Object)"primary")) return true;
        }
        if (!DocumentFileUtils.isRawFile($this$inPrimaryStorage)) return false;
        String string2 = $this$inPrimaryStorage.getUri().getPath();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        if (!StringsKt.startsWith$default((String)string3, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean inSdCardStorage(@NotNull DocumentFile $this$inSdCardStorage, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$inSdCardStorage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isTreeDocumentFile($this$inSdCardStorage)) {
            if (!Intrinsics.areEqual((Object)DocumentFileUtils.getStorageId($this$inSdCardStorage, context), (Object)"primary")) return true;
        }
        if (!DocumentFileUtils.isRawFile($this$inSdCardStorage)) return false;
        String string2 = $this$inSdCardStorage.getUri().getPath();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        if (!StringsKt.startsWith$default((String)string3, (String)Intrinsics.stringPlus((String)"/storage/", (Object)DocumentFileUtils.getStorageId($this$inSdCardStorage, context)), (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean inDataStorage(@NotNull DocumentFile $this$inDataStorage, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$inDataStorage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!DocumentFileUtils.isRawFile($this$inDataStorage)) return false;
        String string2 = $this$inDataStorage.getUri().getPath();
        Intrinsics.checkNotNull((Object)string2);
        if (!FileUtils.inDataStorage(new File(string2), context)) return false;
        return true;
    }

    public static final boolean isRawFile(@NotNull DocumentFile $this$isRawFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isRawFile, (String)"<this>");
        Uri uri = $this$isRawFile.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return UriUtils.isRawFile(uri);
    }

    @NotNull
    public static final String getBaseName(@NotNull DocumentFile $this$baseName) {
        Intrinsics.checkNotNullParameter((Object)$this$baseName, (String)"<this>");
        return StringsKt.substringBeforeLast$default((String)DocumentFileUtils.getFullName($this$baseName), (char)'.', null, (int)2, null);
    }

    @NotNull
    public static final String getExtension(@NotNull DocumentFile $this$extension) {
        Intrinsics.checkNotNullParameter((Object)$this$extension, (String)"<this>");
        return StringsKt.substringAfterLast((String)DocumentFileUtils.getFullName($this$extension), (char)'.', (String)"");
    }

    @Nullable
    public static final String getMimeType(@NotNull DocumentFile $this$mimeType) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$mimeType, (String)"<this>");
        return $this$mimeType.isFile() ? ((string2 = $this$mimeType.getType()) == null ? MimeType.getMimeTypeFromExtension(DocumentFileUtils.getExtension($this$mimeType)) : string2) : null;
    }

    @Nullable
    public static final String getMimeTypeByFileName(@NotNull DocumentFile $this$mimeTypeByFileName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$mimeTypeByFileName, (String)"<this>");
        if ($this$mimeTypeByFileName.isDirectory()) {
            string2 = null;
        } else {
            String string3 = $this$mimeTypeByFileName.getName();
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                string4 = "";
            }
            String extension = StringsKt.substringAfterLast((String)string4, (char)'.', (String)"");
            String mimeType = MimeType.getMimeTypeFromExtension(extension);
            string2 = Intrinsics.areEqual((Object)mimeType, (Object)"*/*") ? $this$mimeTypeByFileName.getType() : string3;
        }
        return string2;
    }

    @Nullable
    public static final File toRawFile(@NotNull DocumentFile $this$toRawFile, @NotNull Context context) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$toRawFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isRawFile($this$toRawFile)) {
            String string2 = $this$toRawFile.getUri().getPath();
            if (string2 == null) {
                return null;
            }
            File file2 = new File(string2);
            file = file2;
        } else if (DocumentFileUtils.inPrimaryStorage($this$toRawFile, context)) {
            file = new File(SimpleStorage.Companion.getExternalStoragePath() + '/' + DocumentFileUtils.getBasePath($this$toRawFile, context));
        } else {
            CharSequence charSequence = DocumentFileUtils.getStorageId($this$toRawFile, context);
            boolean bl = false;
            file = charSequence.length() > 0 ? new File("/storage/" + DocumentFileUtils.getStorageId($this$toRawFile, context) + '/' + DocumentFileUtils.getBasePath($this$toRawFile, context)) : null;
        }
        return file;
    }

    @Nullable
    public static final DocumentFile toRawDocumentFile(@NotNull DocumentFile $this$toRawDocumentFile, @NotNull Context context) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)$this$toRawDocumentFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isRawFile($this$toRawDocumentFile)) {
            documentFile = $this$toRawDocumentFile;
        } else {
            File file = DocumentFileUtils.toRawFile($this$toRawDocumentFile, context);
            if (file == null) {
                return null;
            }
            documentFile = DocumentFile.fromFile((File)file);
        }
        return documentFile;
    }

    @Nullable
    public static final DocumentFile toTreeDocumentFile(@NotNull DocumentFile $this$toTreeDocumentFile, @NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toTreeDocumentFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isRawFile($this$toTreeDocumentFile)) {
            File file = DocumentFileUtils.toRawFile($this$toTreeDocumentFile, context);
            if (file == null) {
                return null;
            }
            object = DocumentFileCompat.fromFile$default(context, file, null, false, false, 12, null);
        } else {
            DocumentFile documentFile = $this$toTreeDocumentFile;
            boolean bl = false;
            boolean bl2 = false;
            DocumentFile it = documentFile;
            boolean bl3 = false;
            object = DocumentFileUtils.isTreeDocumentFile(it) ? documentFile : null;
        }
        return object;
    }

    @Nullable
    public static final MediaFile toMediaFile(@NotNull DocumentFile $this$toMediaFile, @NotNull Context context) {
        MediaFile mediaFile;
        Intrinsics.checkNotNullParameter((Object)$this$toMediaFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isTreeDocumentFile($this$toMediaFile)) {
            mediaFile = null;
        } else {
            Uri uri = $this$toMediaFile.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
            MediaFile mediaFile2 = new MediaFile(context, uri);
            mediaFile = mediaFile2;
        }
        return mediaFile;
    }

    @JvmOverloads
    @Nullable
    public static final DocumentFile child(@NotNull DocumentFile $this$child, @NotNull Context context, @NotNull String path, boolean requiresWriteAccess) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = path;
        boolean bl = false;
        if (charSequence.length() == 0) {
            object = $this$child;
        } else if ($this$child.isDirectory()) {
            DocumentFile file;
            DocumentFile documentFile;
            if (DocumentFileUtils.isRawFile($this$child)) {
                documentFile = DocumentFileUtils.quickFindRawFile($this$child, path);
            } else {
                DocumentFile currentDirectory = null;
                currentDirectory = $this$child;
                ContentResolver resolver = context.getContentResolver();
                Iterable $this$forEach$iv = DocumentFileCompat.INSTANCE.getDirectorySequence$storage_release(path);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"resolver");
                    DocumentFile documentFile2 = DocumentFileUtils.quickFindTreeFile(currentDirectory, context, resolver, it);
                    if (documentFile2 == null) {
                        return null;
                    }
                    DocumentFile directory = documentFile2;
                    if (directory.canRead()) {
                        currentDirectory = directory;
                        continue;
                    }
                    return null;
                }
                documentFile = currentDirectory;
            }
            DocumentFile documentFile3 = file = documentFile;
            object = documentFile3 == null ? null : DocumentFileUtils.takeIfWritable(documentFile3, context, requiresWriteAccess);
        } else {
            object = null;
        }
        return object;
    }

    public static /* synthetic */ DocumentFile child$default(DocumentFile documentFile, Context context, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DocumentFileUtils.child(documentFile, context, string2, bl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static final DocumentFile quickFindRawFile(@NotNull DocumentFile $this$quickFindRawFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$quickFindRawFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = $this$quickFindRawFile.getUri().getPath();
        Intrinsics.checkNotNull((Object)string2);
        DocumentFile documentFile = DocumentFile.fromFile((File)new File(string2, name));
        boolean bl = false;
        boolean bl2 = false;
        DocumentFile it = documentFile;
        boolean bl3 = false;
        return it.canRead() ? documentFile : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"NewApi"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static final DocumentFile quickFindTreeFile(@NotNull DocumentFile $this$quickFindTreeFile, @NotNull Context context, @NotNull ContentResolver resolver, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$quickFindTreeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            Uri childrenUri = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)$this$quickFindTreeFile.getUri(), (String)DocumentFileUtils.getId($this$quickFindTreeFile));
            Object object = new String[]{"document_id"};
            Cursor cursor = resolver.query(childrenUri, object, null, null, null);
            if (cursor == null) {
                return null;
            }
            object = (Closeable)cursor;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)object;
                boolean bl3 = false;
                String[] stringArray = new String[]{"_display_name"};
                String[] columnName = stringArray;
                while (it.moveToNext()) {
                    try {
                        Throwable throwable2;
                        Closeable closeable;
                        block19: {
                            Uri documentUri = DocumentsContract.buildDocumentUriUsingTree((Uri)$this$quickFindTreeFile.getUri(), (String)it.getString(0));
                            Cursor cursor2 = resolver.query(documentUri, columnName, null, null, null);
                            if (cursor2 == null) continue;
                            closeable = (Closeable)cursor2;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            throwable2 = null;
                            Cursor childCursor = (Cursor)closeable;
                            boolean bl6 = false;
                            if (!childCursor.moveToFirst() || !Intrinsics.areEqual((Object)name, (Object)childCursor.getString(0))) break block19;
                            Intrinsics.checkNotNullExpressionValue((Object)documentUri, (String)"documentUri");
                            DocumentFile documentFile = ContextUtils.fromTreeUri(context, documentUri);
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                            DocumentFile documentFile2 = documentFile;
                            return documentFile2;
                        }
                        try {
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                    }
                    catch (Exception exception) {}
                }
                Unit unit = Unit.INSTANCE;
                return null;
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final boolean shouldWritable(@NotNull DocumentFile $this$shouldWritable, @NotNull Context context, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return requiresWriteAccess && DocumentFileUtils.isWritable($this$shouldWritable, context) || !requiresWriteAccess;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static final DocumentFile takeIfWritable(@NotNull DocumentFile $this$takeIfWritable, @NotNull Context context, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$takeIfWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DocumentFile documentFile = $this$takeIfWritable;
        boolean bl = false;
        boolean bl2 = false;
        DocumentFile it = documentFile;
        boolean bl3 = false;
        return DocumentFileUtils.shouldWritable(it, context, requiresWriteAccess) ? documentFile : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final boolean checkRequirements(@NotNull DocumentFile $this$checkRequirements, @NotNull Context context, boolean requiresWriteAccess, boolean considerRawFile) {
        Intrinsics.checkNotNullParameter((Object)$this$checkRequirements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$checkRequirements.canRead() && (considerRawFile || DocumentFileUtils.isExternalStorageManager($this$checkRequirements, context)) && DocumentFileUtils.shouldWritable($this$checkRequirements, context, requiresWriteAccess);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final String getBasePath(@NotNull DocumentFile $this$getBasePath, @NotNull Context context) {
        block12: {
            block14: {
                block15: {
                    block13: {
                        block11: {
                            Intrinsics.checkNotNullParameter((Object)$this$getBasePath, (String)"<this>");
                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                            var3_2 = $this$getBasePath.getUri().getPath();
                            var4_3 = false;
                            v0 = var3_2;
                            if (v0 == null) {
                                v0 = "";
                            }
                            path = v0;
                            storageID = DocumentFileUtils.getStorageId($this$getBasePath, context);
                            if (!DocumentFileUtils.isRawFile($this$getBasePath)) break block11;
                            v1 = FileUtils.getBasePath(new File(path), context);
                            break block12;
                        }
                        if (!DocumentFileUtils.isExternalStorageDocument($this$getBasePath) || !StringsKt.contains$default((CharSequence)path, (CharSequence)("/document/" + storageID + ':'), (boolean)false, (int)2, null)) break block13;
                        v1 = TextUtils.trimFileSeparator(StringsKt.substringAfterLast((String)path, (String)("/document/" + storageID + ':'), (String)""));
                        break block12;
                    }
                    if (!DocumentFileUtils.isDownloadsDocument($this$getBasePath)) break block14;
                    if (Build.VERSION.SDK_INT >= 28) break block15;
                    var4_4 = path;
                    var5_7 = new Regex("/document/\\d+");
                    var6_8 = false;
                    if (!var5_7.matches(var4_4)) break block15;
                    var6_9 = $this$getBasePath.getUri();
                    Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"uri");
                    var5_7 = new MediaFile(context, var6_9).getName();
                    if (var5_7 == null) {
                        return "";
                    }
                    fileName = var5_7;
                    v1 = Environment.DIRECTORY_DOWNLOADS + '/' + (String)fileName;
                    break block12;
                }
                if (Build.VERSION.SDK_INT < 29) ** GOTO lbl-1000
                fileName = path;
                var5_7 = new Regex("(.*?)/ms[f,d]:\\d+(.*?)");
                var6_8 = false;
                if (var5_7.matches(fileName)) {
                    if (DocumentFileUtils.isTreeDocumentFile($this$getBasePath)) {
                        var5_7 = new String[1];
                        var6_10 = $this$getBasePath.getName();
                        var7_11 = false;
                        v2 = var6_10;
                        if (v2 == null) {
                            v2 = "";
                        }
                        var5_7[0] = v2;
                        parentTree = CollectionsKt.mutableListOf((Object[])var5_7);
                        parent /* !! */  = null;
                        parent /* !! */  = $this$getBasePath;
                        while (true) {
                            if ((var6_10 = parent /* !! */ .getParentFile()) == null) {
                                v3 = null;
                            } else {
                                var7_12 = var6_10;
                                var8_13 = false;
                                var9_14 = false;
                                it = var7_12;
                                $i$a$-also-DocumentFileUtils$getBasePath$1 = false;
                                parent /* !! */  = it;
                                v3 = var7_12;
                            }
                            if (v3 == null) break;
                            var6_10 = parent /* !! */ .getName();
                            var7_11 = false;
                            v4 = var6_10;
                            if (v4 == null) {
                                v4 = "";
                            }
                            parentTree.add(v4);
                        }
                        v1 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)parentTree), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    } else {
                        v1 = "";
                    }
                } else lbl-1000:
                // 2 sources

                {
                    v1 = TextUtils.trimFileSeparator(StringsKt.substringAfterLast((String)path, (String)SimpleStorage.Companion.getExternalStoragePath(), (String)""));
                }
                break block12;
            }
            v1 = "";
        }
        return v1;
    }

    private static final String getSubPath(DocumentFile $this$getSubPath, Context context, String otherFolderAbsolutePath) {
        String a = DocumentFileUtils.getAbsolutePath($this$getSubPath, context);
        return a.length() > otherFolderAbsolutePath.length() ? TextUtils.trimFileSeparator(StringsKt.substringAfter((String)a, (String)StringsKt.substringAfterLast$default((String)otherFolderAbsolutePath, (char)'/', null, (int)2, null), (String)"")) : (otherFolderAbsolutePath.length() > a.length() ? TextUtils.trimFileSeparator(StringsKt.substringAfter((String)otherFolderAbsolutePath, (String)StringsKt.substringAfterLast$default((String)a, (char)'/', null, (int)2, null), (String)"")) : "");
    }

    @NotNull
    public static final String getRootPath(@NotNull DocumentFile $this$getRootPath, @NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getRootPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isRawFile($this$getRootPath)) {
            String string3;
            String string4 = $this$getRootPath.getUri().getPath();
            if (string4 == null) {
                string3 = null;
            } else {
                String string5 = string4;
                boolean bl = false;
                boolean bl2 = false;
                String it = string5;
                boolean bl3 = false;
                string3 = FileUtils.getRootPath(new File(it), context);
            }
            string4 = string3;
            boolean bl = false;
            string2 = string4;
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = !DocumentFileUtils.isTreeDocumentFile($this$getRootPath) ? "" : (DocumentFileUtils.inSdCardStorage($this$getRootPath, context) ? Intrinsics.stringPlus((String)"/storage/", (Object)DocumentFileUtils.getStorageId($this$getRootPath, context)) : SimpleStorage.Companion.getExternalStoragePath());
        }
        return string2;
    }

    @NotNull
    public static final String getRelativePath(@NotNull DocumentFile $this$getRelativePath, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getRelativePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.substringBeforeLast((String)DocumentFileUtils.getBasePath($this$getRelativePath, context), (char)'/', (String)"");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String getAbsolutePath(@NotNull DocumentFile $this$getAbsolutePath, @NotNull Context context) {
        String string2;
        Object object;
        Object object2;
        block15: {
            Object object3;
            boolean bl;
            Object object4;
            Object[] objectArray;
            block18: {
                String storageID;
                block13: {
                    Object object5;
                    String path;
                    block16: {
                        block17: {
                            CharSequence fileName;
                            block14: {
                                Intrinsics.checkNotNullParameter((Object)$this$getAbsolutePath, (String)"<this>");
                                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                String string3 = $this$getAbsolutePath.getUri().getPath();
                                boolean bl2 = false;
                                String string4 = string3;
                                if (string4 == null) {
                                    string4 = "";
                                }
                                path = string4;
                                storageID = DocumentFileUtils.getStorageId($this$getAbsolutePath, context);
                                if (DocumentFileUtils.isRawFile($this$getAbsolutePath)) {
                                    object2 = path;
                                    return object2;
                                }
                                if (DocumentFileUtils.isExternalStorageDocument($this$getAbsolutePath) && StringsKt.contains$default((CharSequence)path, (CharSequence)("/document/" + storageID + ':'), (boolean)false, (int)2, null)) {
                                    String basePath = TextUtils.trimFileSeparator(StringsKt.substringAfterLast((String)path, (String)("/document/" + storageID + ':'), (String)""));
                                    if (Intrinsics.areEqual((Object)storageID, (Object)"primary")) {
                                        char[] cArray = new char[]{'/'};
                                        object2 = StringsKt.trimEnd((String)(SimpleStorage.Companion.getExternalStoragePath() + '/' + basePath), (char[])cArray);
                                        return object2;
                                    }
                                    char[] cArray = new char[]{'/'};
                                    object2 = StringsKt.trimEnd((String)("/storage/" + storageID + '/' + basePath), (char[])cArray);
                                    return object2;
                                }
                                object = $this$getAbsolutePath.getUri().toString();
                                boolean bl3 = false;
                                boolean bl4 = false;
                                String it = object;
                                boolean bl5 = false;
                                boolean bl6 = Intrinsics.areEqual((Object)it, (Object)"content://com.android.providers.downloads.documents/tree/downloads") || Intrinsics.areEqual((Object)it, (Object)"content://com.android.providers.downloads.documents/tree/downloads/document/downloads");
                                if (bl6) {
                                    object = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS).absolutePath");
                                    object2 = object;
                                    return object2;
                                }
                                if (!DocumentFileUtils.isDownloadsDocument($this$getAbsolutePath)) break block13;
                                if (Build.VERSION.SDK_INT >= 28) break block14;
                                object5 = path;
                                Regex regex = new Regex("/document/\\d+");
                                boolean bl7 = false;
                                if (!regex.matches((CharSequence)object5)) break block14;
                                Uri uri = $this$getAbsolutePath.getUri();
                                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                                String string5 = new MediaFile(context, uri).getName();
                                if (string5 == null) {
                                    return "";
                                }
                                fileName = string5;
                                string2 = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), (String)fileName).getAbsolutePath();
                                break block15;
                            }
                            if (Build.VERSION.SDK_INT < 29) break block16;
                            fileName = path;
                            Regex regex = new Regex("(.*?)/ms[f,d]:\\d+(.*?)");
                            boolean bl8 = false;
                            if (!regex.matches(fileName)) break block16;
                            if (!DocumentFileUtils.isTreeDocumentFile($this$getAbsolutePath)) break block17;
                            objectArray = new String[1];
                            object4 = $this$getAbsolutePath.getName();
                            bl = false;
                            object3 = object4;
                            if (object3 == null) {
                                object3 = "";
                            }
                            break block18;
                        }
                        string2 = "";
                        break block15;
                    }
                    object5 = new char[1];
                    object5[0] = 47;
                    string2 = StringsKt.trimEnd((String)StringsKt.substringAfterLast((String)path, (String)"/document/raw:", (String)""), (char[])object5);
                    break block15;
                }
                if (!DocumentFileUtils.isTreeDocumentFile($this$getAbsolutePath)) {
                    return "";
                }
                if (DocumentFileUtils.inPrimaryStorage($this$getAbsolutePath, context)) {
                    object = new char[1];
                    object[0] = 47;
                    object2 = StringsKt.trimEnd((String)(SimpleStorage.Companion.getExternalStoragePath() + '/' + DocumentFileUtils.getBasePath($this$getAbsolutePath, context)), (char[])object);
                    return object2;
                }
                object = new char[1];
                object[0] = 47;
                object2 = StringsKt.trimEnd((String)("/storage/" + storageID + '/' + DocumentFileUtils.getBasePath($this$getAbsolutePath, context)), (char[])object);
                return object2;
            }
            objectArray[0] = object3;
            List parentTree = CollectionsKt.mutableListOf((Object[])objectArray);
            Object var6_16 = null;
            DocumentFile documentFile = $this$getAbsolutePath;
            while (true) {
                String string6;
                void var6_18;
                if ((object4 = var6_18.getParentFile()) == null) {
                    string6 = null;
                } else {
                    String string7 = object4;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    String it = string7;
                    boolean bl11 = false;
                    String string8 = it;
                    string6 = string7;
                }
                if (string6 == null) break;
                object4 = var6_18.getName();
                bl = false;
                Object object6 = object4;
                if (object6 == null) {
                    object6 = "";
                }
                parentTree.add(object6);
            }
            object4 = new char[1];
            object4[0] = 47;
            string2 = StringsKt.trimEnd((String)(SimpleStorage.Companion.getExternalStoragePath() + '/' + CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)parentTree), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null)), (char[])object4);
        }
        object = string2;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            when {\n                // API 26 - 27 => content://com.android.providers.downloads.documents/document/22\n                Build.VERSION.SDK_INT < Build.VERSION_CODES.P && path.matches(Regex(\"/document/\\\\d+\")) -> {\n                    val fileName = MediaFile(context, uri).name ?: return \"\"\n                    File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS), fileName).absolutePath\n                }\n\n                Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q && path.matches(Regex(\"(.*?)/ms[f,d]:\\\\d+(.*?)\")) -> {\n                    if (isTreeDocumentFile) {\n                        val parentTree = mutableListOf(name.orEmpty())\n                        var parent = this\n                        while (parent.parentFile?.also { parent = it } != null) {\n                            parentTree.add(parent.name.orEmpty())\n                        }\n                        \"${SimpleStorage.externalStoragePath}/${parentTree.reversed().joinToString(\"/\")}\".trimEnd('/')\n                    } else {\n                        // we can't use msf/msd ID as MediaFile ID to fetch relative path, so just return empty String\n                        \"\"\n                    }\n                }\n\n                else -> path.substringAfterLast(\"/document/raw:\", \"\").trimEnd('/')\n            }\n        }");
        object2 = object;
        return object2;
    }

    @NotNull
    public static final String getSimplePath(@NotNull DocumentFile $this$getSimplePath, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getSimplePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.removePrefix((String)(DocumentFileUtils.getStorageId($this$getSimplePath, context) + ':' + DocumentFileUtils.getBasePath($this$getSimplePath, context)), (CharSequence)":");
    }

    @Nullable
    public static final DocumentFile recreateFile(@NotNull DocumentFile $this$recreateFile, @NotNull Context context) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)$this$recreateFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$recreateFile.exists() && (DocumentFileUtils.isRawFile($this$recreateFile) || DocumentFileUtils.isExternalStorageDocument($this$recreateFile))) {
            DocumentFile parentFile;
            String string2 = $this$recreateFile.getName();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String filename = string3;
            DocumentFile documentFile2 = parentFile = $this$recreateFile.getParentFile();
            if (documentFile2 == null ? false : DocumentFileUtils.isWritable(documentFile2, context)) {
                String mimeType = $this$recreateFile.getType();
                DocumentFileUtils.forceDelete$default($this$recreateFile, context, false, 2, null);
                documentFile = DocumentFileUtils.makeFile$default(parentFile, context, filename, mimeType, null, 8, null);
            } else {
                documentFile = null;
            }
        } else {
            documentFile = null;
        }
        return documentFile;
    }

    @JvmOverloads
    @Nullable
    public static final DocumentFile getRootDocumentFile(@NotNull DocumentFile $this$getRootDocumentFile, @NotNull Context context, boolean requiresWriteAccess) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)$this$getRootDocumentFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isTreeDocumentFile($this$getRootDocumentFile)) {
            documentFile = DocumentFileCompat.getRootDocumentFile$default(context, DocumentFileUtils.getStorageId($this$getRootDocumentFile, context), requiresWriteAccess, false, 8, null);
        } else if (DocumentFileUtils.isRawFile($this$getRootDocumentFile)) {
            String string2 = $this$getRootDocumentFile.getUri().getPath();
            if (string2 == null) {
                documentFile = null;
            } else {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String $this$getRootDocumentFile_u24lambda_u2d21 = string3;
                boolean bl3 = false;
                File file = FileUtils.getRootRawFile(new File($this$getRootDocumentFile_u24lambda_u2d21), context, requiresWriteAccess);
                if (file == null) {
                    documentFile = null;
                } else {
                    File file2 = file;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    File it = file2;
                    boolean bl6 = false;
                    documentFile = DocumentFile.fromFile((File)it);
                }
            }
        } else {
            documentFile = null;
        }
        return documentFile;
    }

    public static /* synthetic */ DocumentFile getRootDocumentFile$default(DocumentFile documentFile, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DocumentFileUtils.getRootDocumentFile(documentFile, context, bl);
    }

    public static final boolean canModify(@NotNull DocumentFile $this$canModify, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$canModify, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$canModify.canRead() && DocumentFileUtils.isWritable($this$canModify, context);
    }

    public static final boolean isWritable(@NotNull DocumentFile $this$isWritable, @NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isRawFile($this$isWritable)) {
            String string2 = $this$isWritable.getUri().getPath();
            Intrinsics.checkNotNull((Object)string2);
            bl = FileUtils.isWritable(new File(string2), context);
        } else {
            bl = $this$isWritable.canWrite();
        }
        return bl;
    }

    public static final boolean isRootUriPermissionGranted(@NotNull DocumentFile $this$isRootUriPermissionGranted, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$isRootUriPermissionGranted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileUtils.isExternalStorageDocument($this$isRootUriPermissionGranted) && DocumentFileCompat.isStorageUriPermissionGranted$default(context, DocumentFileUtils.getStorageId($this$isRootUriPermissionGranted, context), null, 4, null);
    }

    public static final String getFormattedSize(@NotNull DocumentFile $this$getFormattedSize, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getFormattedSize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Formatter.formatFileSize((Context)context, (long)$this$getFormattedSize.length());
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public static final String autoIncrementFileName(@NotNull DocumentFile $this$autoIncrementFileName, @NotNull Context context, @NotNull String filename) {
        String string2;
        int n2;
        Object iterable;
        DocumentFile[] files;
        DocumentFile[] documentFileArray;
        block12: {
            DocumentFile[] documentFileArray2;
            DocumentFile[] it;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$autoIncrementFileName, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            DocumentFile[] documentFileArray3 = DocumentFileUtils.toRawFile($this$autoIncrementFileName, context);
            if (documentFileArray3 != null) {
                documentFileArray = documentFileArray3;
                boolean bl2 = false;
                bl = false;
                it = documentFileArray;
                boolean bl3 = false;
                if (it.canRead()) {
                    return FileUtils.autoIncrementFileName((File)it, filename);
                }
            }
            documentFileArray = $this$autoIncrementFileName.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles()");
            DocumentFile[] documentFileArray4 = files = documentFileArray;
            bl = false;
            it = documentFileArray4;
            boolean bl4 = false;
            iterable = it;
            n2 = ((DocumentFile[])iterable).length;
            for (int i = 0; i < n2; ++i) {
                DocumentFile[] object3;
                DocumentFile[] it2 = object3 = iterable[i];
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)filename)) continue;
                documentFileArray2 = object3;
                break block12;
            }
            documentFileArray2 = documentFileArray = null;
        }
        if (documentFileArray == null ? false : documentFileArray.exists()) {
            Object v3;
            void $this$filterTo$iv$iv;
            String baseName = StringsKt.substringBeforeLast$default((String)filename, (char)'.', null, (int)2, null);
            String ext = StringsKt.substringAfterLast((String)filename, (char)'.', (String)"");
            String prefix = Intrinsics.stringPlus((String)baseName, (Object)" (");
            DocumentFile[] $this$filter$iv = files;
            boolean $i$f$filter = false;
            Object object2 = $this$filter$iv;
            Collection collection = new ArrayList();
            boolean $i$f$filterTo = false;
            String bl5 = $this$filterTo$iv$iv;
            int n = ((void)bl5).length;
            for (int i = 0; i < n; ++i) {
                String name;
                void element$iv$iv;
                void it = element$iv$iv = bl5[i];
                boolean bl = false;
                String string3 = it.getName();
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    string4 = name = "";
                }
                boolean bl3 = StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null) && (DocumentFileCompat.INSTANCE.getFILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION().matches((CharSequence)name) || DocumentFileCompat.INSTANCE.getFILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION().matches((CharSequence)name));
                if (!bl3) continue;
                collection.add(element$iv$iv);
            }
            iterable = (List)collection;
            n2 = 0;
            object2 = iterable.iterator();
            if (!object2.hasNext()) {
                v3 = null;
            } else {
                void var12_21;
                DocumentFile documentFile = (DocumentFile)object2.next();
                boolean bl = false;
                bl5 = documentFile.getName();
                n = 0;
                String string5 = bl5;
                if (string5 == null) {
                    string5 = "";
                }
                Integer n3 = StringsKt.toIntOrNull((String)StringsKt.substringBefore((String)StringsKt.substringAfterLast((String)string5, (char)'(', (String)""), (char)')', (String)""));
                Comparable comparable = Integer.valueOf(n3 == null ? 0 : n3);
                while (object2.hasNext()) {
                    Integer n4;
                    Comparable comparable2;
                    DocumentFile it3 = (DocumentFile)object2.next();
                    boolean bl4 = false;
                    String string6 = it3.getName();
                    boolean bl6 = false;
                    String string7 = string6;
                    if (string7 == null) {
                        string7 = "";
                    }
                    if (var12_21.compareTo(comparable2 = (Comparable)Integer.valueOf((n4 = StringsKt.toIntOrNull((String)StringsKt.substringBefore((String)StringsKt.substringAfterLast((String)string7, (char)'(', (String)""), (char)')', (String)""))) == null ? 0 : n4)) >= 0) continue;
                    Comparable comparable3 = comparable2;
                }
                v3 = var12_21;
            }
            Object object4 = v3;
            int lastFileCount = object4 == null ? 0 : (Integer)object4;
            object4 = new char[1];
            object4[0] = 46;
            string2 = StringsKt.trimEnd((String)(baseName + " (" + ++lastFileCount + ")." + ext), (char[])object4);
        } else {
            string2 = filename;
        }
        return string2;
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final DocumentFile createBinaryFile(@NotNull DocumentFile $this$createBinaryFile, @NotNull Context context, @NotNull String name, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$createBinaryFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return DocumentFileUtils.makeFile($this$createBinaryFile, context, name, "application/octet-stream", mode);
    }

    public static /* synthetic */ DocumentFile createBinaryFile$default(DocumentFile documentFile, Context context, String string2, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return DocumentFileUtils.createBinaryFile(documentFile, context, string2, createMode);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final DocumentFile makeFile(@NotNull DocumentFile $this$makeFile, @NotNull Context context, @NotNull String name, @Nullable String mimeType, @NotNull CreateMode mode) {
        Object object;
        Object it;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)$this$makeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (!$this$makeFile.isDirectory() || !DocumentFileUtils.isWritable($this$makeFile, context)) {
            return null;
        }
        String cleanName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(name));
        String subFolder = StringsKt.substringBeforeLast((String)cleanName, (char)'/', (String)"");
        CharSequence charSequence = subFolder;
        boolean bl3 = false;
        if (charSequence.length() == 0) {
            object3 = $this$makeFile;
        } else {
            charSequence = DocumentFileUtils.makeFolder($this$makeFile, context, subFolder, mode);
            if (charSequence == null) {
                return null;
            }
            object3 = charSequence;
        }
        DocumentFile parent = object3;
        String filename = StringsKt.substringAfterLast$default((String)cleanName, (char)'/', null, (int)2, null);
        String extensionByName = StringsKt.substringAfterLast((String)cleanName, (char)'.', (String)"");
        CharSequence charSequence2 = extensionByName;
        boolean bl4 = false;
        String extension = charSequence2.length() > 0 && (mimeType == null || Intrinsics.areEqual((Object)mimeType, (Object)"*/*") || Intrinsics.areEqual((Object)mimeType, (Object)"application/octet-stream")) ? extensionByName : MimeType.getExtensionFromMimeTypeOrFileName(mimeType, cleanName);
        String baseFileName = StringsKt.removeSuffix((String)filename, (CharSequence)Intrinsics.stringPlus((String)".", (Object)extension));
        Object object4 = new char[]{'.'};
        String fullFileName = StringsKt.trimEnd((String)(baseFileName + '.' + extension), (char[])object4);
        if (mode != CreateMode.CREATE_NEW && (object4 = (Object)DocumentFileUtils.child$default(parent, context, fullFileName, false, 4, null)) != null) {
            object2 = object4;
            bl2 = false;
            bl = false;
            it = object2;
            boolean bl5 = false;
            if (mode == CreateMode.REPLACE) {
                DocumentFileUtils.recreateFile((DocumentFile)it, context);
            } else if (!it.isFile()) {
                // empty if block
            }
        }
        if (DocumentFileUtils.isRawFile($this$makeFile)) {
            object2 = DocumentFileUtils.toRawFile($this$makeFile, context);
            object4 = object2 == null ? null : FileUtils.makeFile((File)object2, context, cleanName, mimeType, mode);
            Object object5 = object4;
            if (object4 == null) {
                return null;
            }
            return DocumentFile.fromFile((File)object4);
        }
        object2 = MimeType.getMimeTypeFromExtension(extension);
        bl2 = false;
        bl = false;
        it = object2;
        boolean bl6 = false;
        Object correctMimeType = Intrinsics.areEqual((Object)it, (Object)"*/*") ? "application/octet-stream" : it;
        if (Build.VERSION.SDK_INT > 28) {
            object2 = parent.createFile((String)correctMimeType, baseFileName);
            if (object2 == null) {
                object = null;
            } else {
                Object object6 = object2;
                bl = false;
                boolean bl7 = false;
                Object it2 = object6;
                boolean bl8 = false;
                if (Intrinsics.areEqual((Object)correctMimeType, (Object)"application/octet-stream") && !Intrinsics.areEqual((Object)it2.getName(), (Object)fullFileName)) {
                    it2.renameTo(fullFileName);
                }
                object = object6;
            }
        } else {
            object = parent.createFile((String)correctMimeType, fullFileName);
        }
        return object;
    }

    public static /* synthetic */ DocumentFile makeFile$default(DocumentFile documentFile, Context context, String string2, String string3, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "*/*";
        }
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return DocumentFileUtils.makeFile(documentFile, context, string2, string3, createMode);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final DocumentFile makeFolder(@NotNull DocumentFile $this$makeFolder, @NotNull Context context, @NotNull String name, @NotNull CreateMode mode) {
        DocumentFile documentFile;
        DocumentFile documentFile2;
        DocumentFile documentFile3;
        DocumentFile documentFile4;
        Intrinsics.checkNotNullParameter((Object)$this$makeFolder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (!$this$makeFolder.isDirectory() || !DocumentFileUtils.isWritable($this$makeFolder, context)) {
            return null;
        }
        if (DocumentFileUtils.isRawFile($this$makeFolder)) {
            File file;
            File file2 = DocumentFileUtils.toRawFile($this$makeFolder, context);
            File file3 = file = file2 == null ? null : FileUtils.makeFolder(file2, context, name, mode);
            if (file == null) {
                return null;
            }
            return DocumentFile.fromFile((File)file);
        }
        List directorySequence = CollectionsKt.toMutableList((Collection)DocumentFileCompat.INSTANCE.getDirectorySequence$storage_release(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(name)));
        String string2 = (String)CollectionsKt.removeFirstOrNull((List)directorySequence);
        if (string2 == null) {
            return null;
        }
        String folderNameLevel1 = string2;
        DocumentFile currentDirectory = null;
        if (DocumentFileUtils.isDownloadsDocument($this$makeFolder) && DocumentFileUtils.isTreeDocumentFile($this$makeFolder)) {
            DocumentFile documentFile5 = DocumentFileUtils.toWritableDownloadsDocumentFile($this$makeFolder, context);
            if (documentFile5 == null) {
                return null;
            }
            documentFile4 = documentFile5;
        } else {
            documentFile4 = $this$makeFolder;
        }
        currentDirectory = documentFile4;
        DocumentFile folderLevel1 = DocumentFileUtils.child$default(currentDirectory, context, folderNameLevel1, false, 4, null);
        if (folderLevel1 == null || mode == CreateMode.CREATE_NEW) {
            documentFile3 = currentDirectory.createDirectory(folderNameLevel1);
            if (documentFile3 == null) {
                return null;
            }
            documentFile = documentFile2 = documentFile3;
        } else if (mode == CreateMode.REPLACE) {
            DocumentFileUtils.forceDelete(folderLevel1, context, true);
            if (folderLevel1.isDirectory()) {
                documentFile = folderLevel1;
            } else {
                documentFile3 = currentDirectory.createDirectory(folderNameLevel1);
                if (documentFile3 == null) {
                    return null;
                }
                documentFile = documentFile2 = documentFile3;
            }
        } else if (folderLevel1.isDirectory() && folderLevel1.canRead()) {
            documentFile = folderLevel1;
        } else {
            return null;
        }
        currentDirectory = documentFile;
        ContentResolver resolver = context.getContentResolver();
        Iterable $this$forEach$iv = directorySequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String folder = (String)element$iv;
            boolean bl = false;
            try {
                DocumentFile documentFile6;
                Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"resolver");
                DocumentFile directory = DocumentFileUtils.quickFindTreeFile(currentDirectory, context, resolver, folder);
                if (directory == null) {
                    DocumentFile documentFile7;
                    DocumentFile documentFile8 = currentDirectory.createDirectory(folder);
                    if (documentFile8 == null) {
                        return null;
                    }
                    documentFile6 = documentFile7 = documentFile8;
                } else if (directory.isDirectory() && directory.canRead()) {
                    documentFile6 = directory;
                } else {
                    return null;
                }
                currentDirectory = documentFile6;
            }
            catch (Exception e) {
                return null;
            }
        }
        return currentDirectory;
    }

    public static /* synthetic */ DocumentFile makeFolder$default(DocumentFile documentFile, Context context, String string2, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return DocumentFileUtils.makeFolder(documentFile, context, string2, createMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    @Nullable
    public static final DocumentFile toWritableDownloadsDocumentFile(@NotNull DocumentFile $this$toWritableDownloadsDocumentFile, @NotNull Context context) {
        DocumentFile documentFile;
        block9: {
            boolean bl;
            block11: {
                String path;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)$this$toWritableDownloadsDocumentFile, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    if (!DocumentFileUtils.isDownloadsDocument($this$toWritableDownloadsDocumentFile)) break block9;
                    String string2 = $this$toWritableDownloadsDocumentFile.getUri().getPath();
                    boolean bl2 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        string3 = "";
                    }
                    path = string3;
                    if (Intrinsics.areEqual((Object)$this$toWritableDownloadsDocumentFile.getUri().toString(), (Object)"content://com.android.providers.downloads.documents/tree/downloads/document/downloads")) {
                        DocumentFile documentFile2 = $this$toWritableDownloadsDocumentFile;
                        bl2 = false;
                        boolean bl3 = false;
                        DocumentFile documentFile3 = documentFile2;
                        boolean bl4 = false;
                        if (!DocumentFileUtils.isWritable(documentFile3, context)) return null;
                        documentFile = documentFile2;
                        return documentFile;
                    }
                    if (Build.VERSION.SDK_INT >= 29 && (StringsKt.startsWith$default((String)path, (String)"/tree/downloads/document/raw:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"/document/raw:", (boolean)false, (int)2, null))) {
                        DocumentFile documentFile4 = DocumentFileCompat.fromPublicFolder$default(context, PublicDirectory.DOWNLOADS, null, false, false, 12, null);
                        if (documentFile4 == null) {
                            return null;
                        }
                        DocumentFile documentFile5 = documentFile4;
                        String fullPath = StringsKt.substringAfterLast$default((String)path, (String)"/document/raw:", null, (int)2, null);
                        String subFile = StringsKt.substringAfter((String)fullPath, (String)Intrinsics.stringPlus((String)"/", (Object)Environment.DIRECTORY_DOWNLOADS), (String)"");
                        documentFile = DocumentFileUtils.child(documentFile5, context, subFile, true);
                        return documentFile;
                    }
                    if (Build.VERSION.SDK_INT < 29) break block10;
                    CharSequence charSequence = path;
                    Regex regex = new Regex("/document/ms[f,d]:\\d+");
                    bl = false;
                    if (regex.matches(charSequence)) break block11;
                    CharSequence charSequence2 = path;
                    regex = new Regex("/tree/ms[f,d]:\\d+(.*?)");
                    bl = false;
                    if (regex.matches(charSequence2)) break block11;
                    CharSequence charSequence3 = path;
                    regex = new Regex("/tree/downloads/document/ms[f,d]:\\d+");
                    bl = false;
                    if (regex.matches(charSequence3)) break block11;
                }
                if (Build.VERSION.SDK_INT >= 29) return null;
                if (!StringsKt.startsWith$default((String)path, (String)"/tree/raw:", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)path, (String)"/tree/downloads/document/raw:", (boolean)false, (int)2, null)) {
                    CharSequence charSequence = path;
                    Regex regex = new Regex("/document/\\d+");
                    bl = false;
                    if (!regex.matches(charSequence)) return null;
                }
            }
            DocumentFile documentFile6 = $this$toWritableDownloadsDocumentFile;
            boolean bl5 = false;
            bl = false;
            DocumentFile documentFile7 = documentFile6;
            boolean bl6 = false;
            if (!DocumentFileUtils.isWritable(documentFile7, context)) return null;
            documentFile = documentFile6;
            return documentFile;
        }
        documentFile = null;
        return documentFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DocumentFile> findFiles(@NotNull DocumentFile $this$findFiles, @NotNull String[] names, @NotNull DocumentFileType documentType) {
        List list;
        DocumentFile it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        Object object = $this$findFiles.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"listFiles()");
        Object[] $this$filter$iv = (Object[])object;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DocumentFile)element$iv$iv;
            boolean bl = false;
            if (!ArraysKt.contains((Object[])names, (Object)it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = (List)destination$iv$iv;
        object = documentType;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = files;
                boolean $i$f$filter2 = false;
                Iterable $i$f$filterTo2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (DocumentFile)element$iv$iv;
                    boolean bl = false;
                    if (!it.isFile()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                list = (List)destination$iv$iv2;
                break;
            }
            case 2: {
                Iterable $this$filter$iv2 = files;
                boolean $i$f$filter3 = false;
                Iterable $this$filterTo$iv$iv2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (DocumentFile)element$iv$iv;
                    boolean bl = false;
                    if (!it.isDirectory()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                list = (List)destination$iv$iv2;
                break;
            }
            default: {
                list = files;
            }
        }
        return list;
    }

    public static /* synthetic */ List findFiles$default(DocumentFile documentFile, String[] stringArray, DocumentFileType documentFileType, int n, Object object) {
        if ((n & 2) != 0) {
            documentFileType = DocumentFileType.ANY;
        }
        return DocumentFileUtils.findFiles(documentFile, stringArray, documentFileType);
    }

    @Nullable
    public static final DocumentFile findFolder(@NotNull DocumentFile $this$findFolder, @NotNull String name) {
        DocumentFile documentFile;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findFolder, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object[] objectArray = $this$findFolder.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"listFiles()");
            objectArray = objectArray;
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            Object[] objectArray3 = objectArray2;
            int n = objectArray3.length;
            for (int i = 0; i < n; ++i) {
                DocumentFile documentFile2;
                DocumentFile it = documentFile2 = objectArray3[i];
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && it.isDirectory())) continue;
                documentFile = documentFile2;
                break block1;
            }
            documentFile = null;
        }
        return documentFile;
    }

    @Nullable
    public static final DocumentFile findFileLiterally(@NotNull DocumentFile $this$findFileLiterally, @NotNull String name) {
        DocumentFile documentFile;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findFileLiterally, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object[] objectArray = $this$findFileLiterally.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"listFiles()");
            objectArray = objectArray;
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            Object[] objectArray3 = objectArray2;
            int n = objectArray3.length;
            for (int i = 0; i < n; ++i) {
                DocumentFile documentFile2;
                DocumentFile it = documentFile2 = objectArray3[i];
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && it.isFile())) continue;
                documentFile = documentFile2;
                break block1;
            }
            documentFile = null;
        }
        return documentFile;
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @WorkerThread
    @NotNull
    public static final List<DocumentFile> search(@NotNull DocumentFile $this$search, boolean recursive, @NotNull DocumentFileType documentType, @Nullable String[] mimeTypes, @NotNull String name, @Nullable Regex regex) {
        block24: {
            block21: {
                block25: {
                    block20: {
                        block23: {
                            Intrinsics.checkNotNullParameter((Object)$this$search, (String)"<this>");
                            Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            if ($this$search.isDirectory() && $this$search.canRead()) break block23;
                            v0 = CollectionsKt.emptyList();
                            break block24;
                        }
                        if (!recursive) break block25;
                        thread = Thread.currentThread();
                        var7_8 = mimeTypes;
                        var8_11 = false;
                        var9_13 = false;
                        if (var7_8 == null) ** GOTO lbl-1000
                        var9_14 = var7_8;
                        var10_18 = 0;
                        if (var9_14.length == 0) lbl-1000:
                        // 2 sources

                        {
                            v1 = true;
                        } else {
                            v1 = false;
                        }
                        if (v1) ** GOTO lbl-1000
                        $this$any$iv = mimeTypes;
                        $i$f$any = false;
                        var9_15 = $this$any$iv;
                        var10_18 = var9_15.length;
                        for (var11_24 = 0; var11_24 < var10_18; ++var11_24) {
                            it = element$iv = var9_15[var11_24];
                            $i$a$-any-DocumentFileUtils$search$1 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)"*/*")) continue;
                            v2 = true;
                            break block20;
                        }
                        v2 = false;
                    }
                    if (v2) lbl-1000:
                    // 2 sources

                    {
                        v3 = new String[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
                        v0 = DocumentFileUtils.walkFileTreeForSearch($this$search, documentType, v3, name, regex, thread);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
                        v0 = DocumentFileUtils.walkFileTreeForSearch($this$search, DocumentFileType.FILE, mimeTypes, name, regex, thread);
                    }
                    break block24;
                }
                $this$any$iv = $this$search.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"listFiles()");
                sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])$this$any$iv), (Function1)search.sequence.1.INSTANCE);
                if (regex != null) {
                    sequence = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<DocumentFile, Boolean>(regex){
                        final /* synthetic */ Regex $regex;
                        {
                            this.$regex = $regex;
                            super(1);
                        }

                        public final boolean invoke(DocumentFile it) {
                            String string2 = it.getName();
                            boolean bl = false;
                            String string3 = string2;
                            if (string3 == null) {
                                string3 = "";
                            }
                            return this.$regex.matches((CharSequence)string3);
                        }
                    }));
                }
                $i$f$any = mimeTypes;
                var9_16 = false;
                var10_19 = false;
                if ($i$f$any == null) ** GOTO lbl-1000
                var10_20 = $i$f$any;
                var11_25 = 0;
                if (var10_20.length == 0) lbl-1000:
                // 2 sources

                {
                    v4 = true;
                } else {
                    v4 = false;
                }
                if (v4) ** GOTO lbl-1000
                $this$any$iv = mimeTypes;
                $i$f$any = false;
                var10_21 = $this$any$iv;
                var11_25 = var10_21.length;
                for (element$iv = 0; element$iv < var11_25; ++element$iv) {
                    it = element$iv = var10_21[element$iv];
                    $i$a$-any-DocumentFileUtils$search$hasMimeTypeFilter$1 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)"*/*")) continue;
                    v5 = true;
                    break block21;
                }
                v5 = false;
            }
            if (!v5) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            hasMimeTypeFilter = v6;
            if (hasMimeTypeFilter || documentType == DocumentFileType.FILE) {
                sequence = SequencesKt.filter((Sequence)sequence, (Function1)search.3.INSTANCE);
            } else if (documentType == DocumentFileType.FOLDER) {
                sequence = SequencesKt.filter((Sequence)sequence, (Function1)search.4.INSTANCE);
            }
            if (hasMimeTypeFilter) {
                sequence = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<DocumentFile, Boolean>(mimeTypes){
                    final /* synthetic */ String[] $mimeTypes;
                    {
                        this.$mimeTypes = $mimeTypes;
                        super(1);
                    }

                    public final boolean invoke(DocumentFile it) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        Intrinsics.checkNotNull((Object)this.$mimeTypes);
                        return DocumentFileUtils.access$matchesMimeTypes(it, this.$mimeTypes);
                    }
                }));
            }
            result = SequencesKt.toList((Sequence)sequence);
            var9_17 = name;
            var10_22 = false;
            if (var9_17.length() == 0) {
                v0 = result;
            } else {
                block22: {
                    $this$firstOrNull$iv = result;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (DocumentFile)element$iv;
                        $i$a$-firstOrNull-DocumentFileUtils$search$6 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        v7 = element$iv;
                        break block22;
                    }
                    v7 = null;
                }
                var10_23 = v7;
                if (var10_23 == null) {
                    v8 = null;
                } else {
                    var11_26 = var10_23;
                    var12_28 = false;
                    var13_31 = false;
                    it = var11_26;
                    $i$a$-let-DocumentFileUtils$search$7 = false;
                    v8 = CollectionsKt.listOf((Object)it);
                }
                var9_17 = v8;
                v0 = var9_17 == null ? CollectionsKt.emptyList() : var9_17;
            }
        }
        return v0;
    }

    public static /* synthetic */ List search$default(DocumentFile documentFile, boolean bl, DocumentFileType documentFileType, String[] stringArray, String string2, Regex regex, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            documentFileType = DocumentFileType.ANY;
        }
        if ((n & 4) != 0) {
            stringArray = null;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            regex = null;
        }
        return DocumentFileUtils.search(documentFile, bl, documentFileType, stringArray, string2, regex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean matchesMimeTypes(DocumentFile $this$matchesMimeTypes, String[] filterMimeTypes) {
        Object object = filterMimeTypes;
        boolean bl = false;
        if (((String[])object).length == 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        object = MimeTypeFilter.matches((String)DocumentFileUtils.getMimeTypeByFileName($this$matchesMimeTypes), (String[])filterMimeTypes);
        bl = false;
        boolean bl3 = false;
        if (object == null) return false;
        if (object.length() != 0) return true;
        return false;
    }

    private static final List<DocumentFile> walkFileTreeForSearch(DocumentFile $this$walkFileTreeForSearch, DocumentFileType documentType, String[] mimeTypes, String nameFilter, Regex regex, Thread thread) {
        boolean bl = false;
        List fileTree = new ArrayList();
        DocumentFile[] documentFileArray = $this$walkFileTreeForSearch.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles()");
        DocumentFile[] documentFileArray2 = documentFileArray;
        int n = 0;
        int n2 = documentFileArray2.length;
        while (n < n2) {
            boolean bl2;
            CharSequence charSequence;
            DocumentFile file = documentFileArray2[n];
            ++n;
            if (thread.isInterrupted()) break;
            if (!$this$walkFileTreeForSearch.canRead()) continue;
            if (file.isFile()) {
                if (documentType == DocumentFileType.FOLDER) continue;
                charSequence = file.getName();
                bl2 = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    charSequence2 = "";
                }
                String filename = charSequence2;
                charSequence = nameFilter;
                bl2 = false;
                if (!(charSequence.length() == 0) && !Intrinsics.areEqual((Object)filename, (Object)nameFilter) || regex != null && !regex.matches((CharSequence)filename)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (!DocumentFileUtils.matchesMimeTypes(file, mimeTypes)) continue;
                fileTree.add(file);
                continue;
            }
            if (documentType != DocumentFileType.FILE) {
                charSequence = file.getName();
                bl2 = false;
                CharSequence charSequence3 = charSequence;
                if (charSequence3 == null) {
                    charSequence3 = "";
                }
                String folderName = charSequence3;
                charSequence = nameFilter;
                bl2 = false;
                if ((charSequence.length() == 0 || Intrinsics.areEqual((Object)folderName, (Object)nameFilter)) && (regex == null || regex.matches((CharSequence)folderName))) {
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    fileTree.add(file);
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            fileTree.addAll((Collection)DocumentFileUtils.walkFileTreeForSearch(file, documentType, mimeTypes, nameFilter, regex, thread));
        }
        return fileTree;
    }

    @WorkerThread
    @JvmOverloads
    public static final boolean deleteRecursively(@NotNull DocumentFile $this$deleteRecursively, @NotNull Context context, boolean childrenOnly) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$deleteRecursively.isDirectory() && $this$deleteRecursively.canRead()) {
            List<DocumentFile> list;
            if (DocumentFileUtils.isDownloadsDocument($this$deleteRecursively)) {
                DocumentFile documentFile = DocumentFileUtils.toWritableDownloadsDocumentFile($this$deleteRecursively, context);
                if (documentFile == null) {
                    return false;
                }
                list = DocumentFileUtils.walkFileTreeForDeletion(documentFile);
            } else {
                list = DocumentFileUtils.walkFileTreeForDeletion($this$deleteRecursively);
            }
            List<DocumentFile> files = list;
            int count = files.size();
            int n = files.size() - 1;
            if (0 <= n) {
                do {
                    int index;
                    if (!files.get(index = n--).delete()) continue;
                    int n2 = count;
                    count = n2 + -1;
                } while (0 <= n);
            }
            bl = count == 0 && (childrenOnly || $this$deleteRecursively.delete() || !$this$deleteRecursively.exists());
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean deleteRecursively$default(DocumentFile documentFile, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DocumentFileUtils.deleteRecursively(documentFile, context, bl);
    }

    @WorkerThread
    @JvmOverloads
    public static final boolean forceDelete(@NotNull DocumentFile $this$forceDelete, @NotNull Context context, boolean childrenOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$forceDelete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$forceDelete.isDirectory() ? DocumentFileUtils.deleteRecursively($this$forceDelete, context, childrenOnly) : $this$forceDelete.delete() || !$this$forceDelete.exists();
    }

    public static /* synthetic */ boolean forceDelete$default(DocumentFile documentFile, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DocumentFileUtils.forceDelete(documentFile, context, bl);
    }

    private static final List<DocumentFile> walkFileTreeForDeletion(DocumentFile $this$walkFileTreeForDeletion) {
        boolean bl = false;
        List fileTree = new ArrayList();
        DocumentFile[] documentFileArray = $this$walkFileTreeForDeletion.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles()");
        Object[] $this$forEach$iv = documentFileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentFile it = (DocumentFile)element$iv;
            boolean bl2 = false;
            if (!it.delete()) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                fileTree.add(it);
            }
            if (!it.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            fileTree.addAll((Collection)DocumentFileUtils.walkFileTreeForDeletion(it));
        }
        return fileTree;
    }

    public static final boolean deleteEmptyFolders(@NotNull DocumentFile $this$deleteEmptyFolders, @NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$deleteEmptyFolders, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (DocumentFileUtils.isRawFile($this$deleteEmptyFolders)) {
            String string2 = $this$deleteEmptyFolders.getUri().getPath();
            Intrinsics.checkNotNull((Object)string2);
            FileUtils.deleteEmptyFolders(new File(string2), context);
            bl = true;
        } else if ($this$deleteEmptyFolders.isDirectory() && DocumentFileUtils.isWritable($this$deleteEmptyFolders, context)) {
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)DocumentFileUtils.walkFileTreeAndDeleteEmptyFolders($this$deleteEmptyFolders));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DocumentFile it = (DocumentFile)element$iv;
                boolean bl2 = false;
                it.delete();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final List<DocumentFile> walkFileTreeAndDeleteEmptyFolders(DocumentFile $this$walkFileTreeAndDeleteEmptyFolders) {
        boolean bl = false;
        List fileTree = new ArrayList();
        DocumentFile[] documentFileArray = $this$walkFileTreeAndDeleteEmptyFolders.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles()");
        Object[] $this$forEach$iv = documentFileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentFile it = (DocumentFile)element$iv;
            boolean bl2 = false;
            if (!it.isDirectory() || it.delete()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            fileTree.add(it);
            fileTree.addAll((Collection)DocumentFileUtils.walkFileTreeAndDeleteEmptyFolders(it));
        }
        return fileTree;
    }

    @JvmOverloads
    @WorkerThread
    @Nullable
    public static final OutputStream openOutputStream(@NotNull DocumentFile $this$openOutputStream, @NotNull Context context, boolean append) {
        Intrinsics.checkNotNullParameter((Object)$this$openOutputStream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = $this$openOutputStream.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return UriUtils.openOutputStream(uri, context, append);
    }

    public static /* synthetic */ OutputStream openOutputStream$default(DocumentFile documentFile, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return DocumentFileUtils.openOutputStream(documentFile, context, bl);
    }

    @WorkerThread
    @Nullable
    public static final InputStream openInputStream(@NotNull DocumentFile $this$openInputStream, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$openInputStream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = $this$openInputStream.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        return UriUtils.openInputStream(uri, context);
    }

    @UiThread
    @NotNull
    public static final Intent openFileIntent(@NotNull DocumentFile $this$openFileIntent, @NotNull Context context, @NotNull String authority) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)$this$openFileIntent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Intent intent = new Intent("android.intent.action.VIEW");
        if (DocumentFileUtils.isRawFile($this$openFileIntent)) {
            String string2 = $this$openFileIntent.getUri().getPath();
            Intrinsics.checkNotNull((Object)string2);
            uri = FileProvider.getUriForFile((Context)context, (String)authority, (File)new File(string2));
        } else {
            uri = $this$openFileIntent.getUri();
        }
        Intent intent2 = intent.setData(uri).addFlags(1).addFlags(0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent(Intent.ACTION_VIEW)\n    .setData(if (isRawFile) FileProvider.getUriForFile(context, authority, File(uri.path!!)) else uri)\n    .addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)\n    .addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)");
        return intent2;
    }

    public static final boolean hasParent(@NotNull DocumentFile $this$hasParent, @NotNull Context context, @NotNull DocumentFile parent) {
        Intrinsics.checkNotNullParameter((Object)$this$hasParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return TextUtils.hasParent(DocumentFileUtils.getAbsolutePath($this$hasParent, context), DocumentFileUtils.getAbsolutePath(parent, context));
    }

    private static final List<DocumentFile> walkFileTree(DocumentFile $this$walkFileTree, Context context) {
        boolean bl = false;
        List fileTree = new ArrayList();
        DocumentFile[] documentFileArray = $this$walkFileTree.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles()");
        Object[] $this$forEach$iv = documentFileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentFile it = (DocumentFile)element$iv;
            boolean bl2 = false;
            if (it.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (DocumentFileUtils.isEmpty(it, context)) {
                    fileTree.add(it);
                    continue;
                }
                fileTree.addAll((Collection)DocumentFileUtils.walkFileTree(it, context));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            fileTree.add(it);
        }
        return fileTree;
    }

    private static final List<DocumentFile> walkFileTreeAndSkipEmptyFiles(DocumentFile $this$walkFileTreeAndSkipEmptyFiles) {
        boolean bl = false;
        List fileTree = new ArrayList();
        DocumentFile[] documentFileArray = $this$walkFileTreeAndSkipEmptyFiles.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)documentFileArray, (String)"listFiles()");
        Object[] $this$forEach$iv = documentFileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentFile it = (DocumentFile)element$iv;
            boolean bl2 = false;
            if (it.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                fileTree.addAll((Collection)DocumentFileUtils.walkFileTreeAndSkipEmptyFiles(it));
                continue;
            }
            if (it.length() <= 0L) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            fileTree.add(it);
        }
        return fileTree;
    }

    @WorkerThread
    public static final void moveTo(@NotNull List<? extends DocumentFile> $this$moveTo, @NotNull Context context, @NotNull DocumentFile targetParentFolder, boolean skipEmptyFiles, @NotNull MultipleFileCallback callback) {
        Intrinsics.checkNotNullParameter($this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetParentFolder, (String)"targetParentFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.copyTo($this$moveTo, context, targetParentFolder, skipEmptyFiles, true, callback);
    }

    public static /* synthetic */ void moveTo$default(List list, Context context, DocumentFile documentFile, boolean bl, MultipleFileCallback multipleFileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        DocumentFileUtils.moveTo(list, context, documentFile, bl, multipleFileCallback);
    }

    @WorkerThread
    public static final void copyTo(@NotNull List<? extends DocumentFile> $this$copyTo, @NotNull Context context, @NotNull DocumentFile targetParentFolder, boolean skipEmptyFiles, @NotNull MultipleFileCallback callback) {
        Intrinsics.checkNotNullParameter($this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetParentFolder, (String)"targetParentFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.copyTo($this$copyTo, context, targetParentFolder, skipEmptyFiles, false, callback);
    }

    public static /* synthetic */ void copyTo$default(List list, Context context, DocumentFile documentFile, boolean bl, MultipleFileCallback multipleFileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        DocumentFileUtils.copyTo(list, context, documentFile, bl, multipleFileCallback);
    }

    /*
     * WARNING - void declaration
     */
    private static final void copyTo(List<? extends DocumentFile> $this$copyTo, Context context, DocumentFile targetParentFolder, boolean skipEmptyFiles, boolean deleteSourceWhenComplete, MultipleFileCallback callback) {
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"com/anggrayudi/storage/file/DocumentFileUtils$copyTo$SourceInfo", "", "children", "", "Landroidx/documentfile/provider/DocumentFile;", "size", "", "totalFiles", "", "conflictResolution", "Lcom/anggrayudi/storage/callback/FolderCallback$ConflictResolution;", "(Ljava/util/List;JILcom/anggrayudi/storage/callback/FolderCallback$ConflictResolution;)V", "getChildren", "()Ljava/util/List;", "getConflictResolution", "()Lcom/anggrayudi/storage/callback/FolderCallback$ConflictResolution;", "getSize", "()J", "getTotalFiles", "()I", "storage_release"})
        public final class SourceInfo {
            @NotNull
            private final List<DocumentFile> children;
            private final long size;
            private final int totalFiles;
            @NotNull
            private final FolderCallback.ConflictResolution conflictResolution;

            public SourceInfo(@NotNull List<? extends DocumentFile> children, long size, int totalFiles, @NotNull FolderCallback.ConflictResolution conflictResolution) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                Intrinsics.checkNotNullParameter((Object)((Object)conflictResolution), (String)"conflictResolution");
                this.children = children;
                this.size = size;
                this.totalFiles = totalFiles;
                this.conflictResolution = conflictResolution;
            }

            @NotNull
            public final List<DocumentFile> getChildren() {
                return this.children;
            }

            public final long getSize() {
                return this.size;
            }

            public final int getTotalFiles() {
                return this.totalFiles;
            }

            @NotNull
            public final FolderCallback.ConflictResolution getConflictResolution() {
                return this.conflictResolution;
            }
        }
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Function0 finalize2;
        Object it;
        CreateMode mode;
        Iterator iterator;
        int n;
        Object $i$f$forEach22;
        boolean bl;
        Map.Entry it2;
        Object children;
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Pair<DocumentFile, List<DocumentFile>> pair = DocumentFileUtils.doesMeetCopyRequirements($this$copyTo, context, targetParentFolder, callback);
        if (pair == null) {
            return;
        }
        Pair<DocumentFile, List<DocumentFile>> pair2 = pair;
        CoroutineScope $this$postToUi$iv = callback.getUiScope();
        boolean $i$f$postToUi = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ MultipleFileCallback $callback$inlined;
            {
                this.$callback$inlined = multipleFileCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onPrepare();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        List validSources = (List)pair2.getSecond();
        DocumentFile writableTargetParentFolder = (DocumentFile)pair2.getFirst();
        Iterable<MultipleFileCallback.ParentConflict> iterable = DocumentFileUtils.handleParentFolderConflict(validSources, context, writableTargetParentFolder, callback);
        if (iterable == null) {
            return;
        }
        List<MultipleFileCallback.ParentConflict> conflictResolutions = iterable;
        iterable = conflictResolutions;
        Collection<Collection<DocumentFile>> collection = validSources;
        boolean $i$f$filter = false;
        void var12_17 = $this$filter$iv2;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            MultipleFileCallback.ParentConflict parentConflict = (MultipleFileCallback.ParentConflict)element$iv$iv;
            boolean bl2 = false;
            if (!(parentConflict.getSolution() == FolderCallback.ConflictResolution.SKIP)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<DocumentFile> collection2 = (List)destination$iv$iv;
        $this$filter$iv2 = collection2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv422 : $this$mapTo$iv$iv2) {
            MultipleFileCallback.ParentConflict parentConflict = (MultipleFileCallback.ParentConflict)item$iv$iv422;
            collection2 = destination$iv$iv;
            boolean bl3 = false;
            object = parentConflict.getSource();
            collection2.add((DocumentFile)object);
        }
        collection2 = (List)destination$iv$iv;
        collection.removeAll(collection2);
        if (validSources.isEmpty()) {
            return;
        }
        CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
        boolean $i$f$postToUi2 = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ MultipleFileCallback $callback$inlined;
            {
                this.$callback$inlined = multipleFileCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onCountingFiles();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Iterable $this$map$iv2 = validSources;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object e : $this$mapTo$iv$iv) {
            Object v0;
            long totalSizeToCopy;
            int totalFilesToCopy232;
            void src;
            block53: {
                int n2;
                Object element$iv22;
                DocumentFile bl3 = (DocumentFile)e;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                children = skipEmptyFiles ? DocumentFileUtils.walkFileTreeAndSkipEmptyFiles((DocumentFile)src) : DocumentFileUtils.walkFileTree((DocumentFile)src, context);
                totalFilesToCopy232 = 0;
                totalSizeToCopy = 0L;
                Iterable $this$forEach$iv = (Iterable)children;
                boolean $i$f$forEach22 = false;
                for (Object element$iv22 : $this$forEach$iv) {
                    DocumentFile it4 = (DocumentFile)element$iv22;
                    boolean bl5 = false;
                    if (!it4.isFile()) continue;
                    n2 = totalFilesToCopy232;
                    totalFilesToCopy232 = n2 + 1;
                    totalSizeToCopy += it4.length();
                }
                element$iv22 = conflictResolutions;
                boolean it4 = false;
                Object bl5 = element$iv22;
                n2 = 0;
                Iterator iterator2 = bl5.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    it2 = (MultipleFileCallback.ParentConflict)t;
                    bl = false;
                    if (!Intrinsics.areEqual((Object)((MultipleFileCallback.ParentConflict)((Object)it2)).getSource(), (Object)src)) continue;
                    v0 = t;
                    break block53;
                }
                v0 = null;
            }
            MultipleFileCallback.ParentConflict parentConflict = v0;
            $i$f$forEach22 = parentConflict == null ? null : parentConflict.getSolution();
            FolderCallback.ConflictResolution resolution22 = $i$f$forEach22 == null ? FolderCallback.ConflictResolution.CREATE_NEW : $i$f$forEach22;
            collection2 = new Pair((Object)src, (Object)new SourceInfo((List<? extends DocumentFile>)children, totalSizeToCopy, totalFilesToCopy232, resolution22));
            collection.add(collection2);
        }
        Map sourceInfos = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv2)));
        $i$f$map2 = false;
        Map results = new LinkedHashMap();
        if (deleteSourceWhenComplete) {
            Object src;
            Object item$iv$iv422;
            Map $this$forEach$iv = sourceInfos;
            boolean $i$f$forEach3 = false;
            destination$iv$iv2 = $this$forEach$iv;
            $i$f$mapTo222 = false;
            item$iv$iv422 = destination$iv$iv2.entrySet().iterator();
            while (item$iv$iv422.hasNext()) {
                MultipleFileCallback.ErrorCode errorCode;
                Map.Entry entry;
                Map.Entry $dstr$src$info = entry = (Map.Entry)item$iv$iv422.next();
                boolean bl6 = false;
                children = $dstr$src$info;
                boolean totalFilesToCopy232 = false;
                src = (DocumentFile)children.getKey();
                Map.Entry totalFilesToCopy232 = $dstr$src$info;
                boolean resolution22 = false;
                SourceInfo info = (SourceInfo)totalFilesToCopy232.getValue();
                Object result = DocumentFileUtils.tryMoveFolderByRenamingPath((DocumentFile)src, context, writableTargetParentFolder, DocumentFileUtils.getFullName((DocumentFile)src), skipEmptyFiles, null, info.getConflictResolution());
                if (result instanceof DocumentFile) {
                    Map resolution22 = results;
                    $i$f$forEach22 = result;
                    boolean bl2 = false;
                    resolution22.put(src, $i$f$forEach22);
                    continue;
                }
                if (!(result instanceof FolderCallback.ErrorCode)) continue;
                $i$f$forEach22 = (FolderCallback.ErrorCode)((Object)result);
                int n3 = WhenMappings.$EnumSwitchMapping$1[((Enum)$i$f$forEach22).ordinal()];
                switch (n3) {
                    case 1: {
                        errorCode = MultipleFileCallback.ErrorCode.INVALID_TARGET_FOLDER;
                        break;
                    }
                    case 2: {
                        errorCode = MultipleFileCallback.ErrorCode.STORAGE_PERMISSION_DENIED;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                MultipleFileCallback.ErrorCode errorCode2 = errorCode;
                CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
                boolean $i$f$postToUi3 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, errorCode2){
                    int label;
                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                    final /* synthetic */ MultipleFileCallback.ErrorCode $errorCode$inlined;
                    {
                        this.$callback$inlined = multipleFileCallback;
                        this.$errorCode$inlined = errorCode;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(this.$errorCode$inlined);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            int copiedFiles = 0;
            Map $this$forEach$iv2 = results;
            boolean $i$f$forEach4 = false;
            Map $i$f$mapTo222 = $this$forEach$iv2;
            boolean item$iv$iv422 = false;
            Iterator iterator3 = $i$f$mapTo222.entrySet().iterator();
            while (iterator3.hasNext()) {
                Unit unit;
                Map.Entry element$iv4;
                Map.Entry it5 = element$iv4 = iterator3.next();
                boolean bl8 = false;
                SourceInfo result = (SourceInfo)sourceInfos.remove(it5.getKey());
                if (result == null) {
                    unit = null;
                    continue;
                }
                src = result;
                boolean errorCode2 = false;
                boolean $this$postToUi$iv3 = false;
                Object $this$copyTo_u24lambda_u2d56_u24lambda_u2d55 = src;
                boolean bl9 = false;
                copiedFiles += ((SourceInfo)$this$copyTo_u24lambda_u2d56_u24lambda_u2d55).getTotalFiles();
                unit = Unit.INSTANCE;
            }
            if (sourceInfos.isEmpty()) {
                void $this$mapTo$iv$iv3;
                Map $this$map$iv3 = results;
                boolean $i$f$map3 = false;
                Map item$iv$iv422 = $this$map$iv3;
                Collection collection3 = new ArrayList($this$map$iv3.size());
                boolean $i$f$mapTo3 = false;
                void it5 = $this$mapTo$iv$iv3;
                boolean bl8 = false;
                Iterator result = it5.entrySet().iterator();
                while (result.hasNext()) {
                    void it6;
                    Map.Entry item$iv$iv3;
                    Map.Entry errorCode2 = item$iv$iv3 = result.next();
                    object = collection3;
                    boolean bl10 = false;
                    DocumentFile documentFile = (DocumentFile)it6.getValue();
                    object.add(documentFile);
                }
                object = (List)collection3;
                boolean bl3 = true;
                int n4 = copiedFiles;
                int n5 = copiedFiles;
                Object object2 = object;
                MultipleFileCallback.Result result2 = new MultipleFileCallback.Result((List<? extends DocumentFile>)object2, n5, n4, bl3);
                CoroutineScope $this$postToUi$iv4 = callback.getUiScope();
                boolean $i$f$postToUi4 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv4, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, result2){
                    int label;
                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                    final /* synthetic */ MultipleFileCallback.Result $result$inlined;
                    {
                        this.$callback$inlined = multipleFileCallback;
                        this.$result$inlined = result;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onCompleted(this.$result$inlined);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        Iterable $this$postToUi$iv4 = sourceInfos.values();
        boolean $i$f$postToUi4 = false;
        long $this$mapTo$iv$iv3 = 0L;
        for (Object it5 : $this$postToUi$iv4) {
            void it7;
            SourceInfo bl8 = (SourceInfo)it5;
            long l = $this$mapTo$iv$iv3;
            boolean bl12 = false;
            long l2 = it7.getSize();
            $this$mapTo$iv$iv3 = l + l2;
        }
        long totalSizeToCopy = $this$mapTo$iv$iv3;
        try {
            if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context, DocumentFileUtils.getStorageId(writableTargetParentFolder, context)), totalSizeToCopy)) {
                CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
                boolean $i$f$postToUi3 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                    {
                        this.$callback$inlined = multipleFileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        catch (Throwable e) {
            CoroutineScope $this$postToUi$iv5 = callback.getUiScope();
            boolean $i$f$postToUi5 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv5, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ MultipleFileCallback $callback$inlined;
                {
                    this.$callback$inlined = multipleFileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Thread thread = Thread.currentThread();
        Iterable $this$count$iv = validSources;
        boolean bl4 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                DocumentFile it2232 = (DocumentFile)element$iv;
                boolean bl13 = false;
                if (!it2232.isFile()) continue;
                int it2232 = ++count$iv;
                bl13 = false;
                if (it2232 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        $this$count$iv = sourceInfos.values();
        int n6 = n;
        boolean bl5 = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            void it3;
            SourceInfo it2232 = (SourceInfo)element$iv;
            int n7 = count$iv;
            boolean bl15 = false;
            int n8 = it3.getTotalFiles();
            count$iv = n7 + n8;
        }
        int n9 = count$iv;
        int totalFilesToCopy = n6 + n9;
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, sourceInfos, totalFilesToCopy, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ MultipleFileCallback $callback$inlined;
            final /* synthetic */ Map $sourceInfos$inlined;
            final /* synthetic */ int $totalFilesToCopy$inlined;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = multipleFileCallback;
                this.$sourceInfos$inlined = map;
                this.$totalFilesToCopy$inlined = n;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$sourceInfos$inlined, this.$totalFilesToCopy$inlined, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ MultipleFileCallback $callback$inlined;
                            final /* synthetic */ Map $sourceInfos$inlined;
                            final /* synthetic */ int $totalFilesToCopy$inlined;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = multipleFileCallback;
                                this.$sourceInfos$inlined = map;
                                this.$totalFilesToCopy$inlined = n;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Long l;
                                        Collection<DocumentFile> collection;
                                        void $this$mapTo$iv$iv;
                                        void $this$map$iv;
                                        ResultKt.throwOnFailure((Object)object);
                                        Result.Companion companion = Result.Companion;
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        Map map = this.$sourceInfos$inlined;
                                        MultipleFileCallback multipleFileCallback = this.$callback$inlined;
                                        boolean $i$f$map = false;
                                        void var9_11 = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                                        boolean $i$f$mapTo = false;
                                        void var12_14 = $this$mapTo$iv$iv;
                                        boolean bl2 = false;
                                        Iterator<Map.Entry<K, V>> iterator = var12_14.entrySet().iterator();
                                        while (iterator.hasNext()) {
                                            void it;
                                            Map.Entry<K, V> item$iv$iv;
                                            Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                                            collection = destination$iv$iv;
                                            boolean bl3 = false;
                                            DocumentFile documentFile = (DocumentFile)it.getKey();
                                            collection.add(documentFile);
                                        }
                                        collection = (List)destination$iv$iv;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        Long l2 = l = Boxing.boxLong((long)multipleFileCallback.onStart((List<? extends DocumentFile>)collection, this.$totalFilesToCopy$inlined, this.$thread$inlined));
                                        boolean bl4 = false;
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)l2));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        if (reportInterval < 0L) {
            return;
        }
        Ref.IntRef totalCopiedFiles = new Ref.IntRef();
        Ref.ObjectRef timer2 = new Ref.ObjectRef();
        Ref.LongRef bytesMoved = new Ref.LongRef();
        Ref.IntRef writeSpeed = new Ref.IntRef();
        Function1 startTimer2 = (Function1)new Function1<Boolean, Unit>(reportInterval, (Ref.ObjectRef<Job>)timer2, bytesMoved, totalSizeToCopy, writeSpeed, totalCopiedFiles, callback){
            final /* synthetic */ long $reportInterval;
            final /* synthetic */ Ref.ObjectRef<Job> $timer;
            final /* synthetic */ Ref.LongRef $bytesMoved;
            final /* synthetic */ long $totalSizeToCopy;
            final /* synthetic */ Ref.IntRef $writeSpeed;
            final /* synthetic */ Ref.IntRef $totalCopiedFiles;
            final /* synthetic */ MultipleFileCallback $callback;
            {
                this.$reportInterval = $reportInterval;
                this.$timer = $timer;
                this.$bytesMoved = $bytesMoved;
                this.$totalSizeToCopy = $totalSizeToCopy;
                this.$writeSpeed = $writeSpeed;
                this.$totalCopiedFiles = $totalCopiedFiles;
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(boolean start) {
                if (start && this.$reportInterval > 0L) {
                    this.$timer.element = CoroutineExtKt.startCoroutineTimer$default(0L, this.$reportInterval, false, (Function0)new Function0<Unit>(this.$bytesMoved, this.$totalSizeToCopy, this.$writeSpeed, this.$totalCopiedFiles, this.$callback){
                        final /* synthetic */ Ref.LongRef $bytesMoved;
                        final /* synthetic */ long $totalSizeToCopy;
                        final /* synthetic */ Ref.IntRef $writeSpeed;
                        final /* synthetic */ Ref.IntRef $totalCopiedFiles;
                        final /* synthetic */ MultipleFileCallback $callback;
                        {
                            this.$bytesMoved = $bytesMoved;
                            this.$totalSizeToCopy = $totalSizeToCopy;
                            this.$writeSpeed = $writeSpeed;
                            this.$totalCopiedFiles = $totalCopiedFiles;
                            this.$callback = $callback;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void $this$postToUi$iv;
                            MultipleFileCallback.Report report = new MultipleFileCallback.Report((float)this.$bytesMoved.element * 100.0f / (float)this.$totalSizeToCopy, this.$bytesMoved.element, this.$writeSpeed.element, this.$totalCopiedFiles.element);
                            CoroutineScope coroutineScope = this.$callback.getUiScope();
                            MultipleFileCallback multipleFileCallback = this.$callback;
                            boolean $i$f$postToUi = false;
                            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, multipleFileCallback, report){
                                int label;
                                final /* synthetic */ MultipleFileCallback $callback$inlined;
                                final /* synthetic */ MultipleFileCallback.Report $report$inlined;
                                {
                                    this.$callback$inlined = multipleFileCallback;
                                    this.$report$inlined = report;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            boolean bl = false;
                                            this.$callback$inlined.onReport(this.$report$inlined);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            this.$writeSpeed.element = 0;
                        }
                    }, 5, null);
                }
            }
        };
        startTimer2.invoke((Object)(totalSizeToCopy > 0xA00000L ? 1 : 0));
        Ref.ObjectRef targetFile = new Ref.ObjectRef();
        Ref.BooleanRef canceled = new Ref.BooleanRef();
        Function1 notifyCanceled2 = (Function1)new Function1<MultipleFileCallback.ErrorCode, Unit>(canceled, (Ref.ObjectRef<Job>)timer2, (Ref.ObjectRef<DocumentFile>)targetFile, (Map<DocumentFile, DocumentFile>)results, totalFilesToCopy, totalCopiedFiles, callback){
            final /* synthetic */ Ref.BooleanRef $canceled;
            final /* synthetic */ Ref.ObjectRef<Job> $timer;
            final /* synthetic */ Ref.ObjectRef<DocumentFile> $targetFile;
            final /* synthetic */ Map<DocumentFile, DocumentFile> $results;
            final /* synthetic */ int $totalFilesToCopy;
            final /* synthetic */ Ref.IntRef $totalCopiedFiles;
            final /* synthetic */ MultipleFileCallback $callback;
            {
                this.$canceled = $canceled;
                this.$timer = $timer;
                this.$targetFile = $targetFile;
                this.$results = $results;
                this.$totalFilesToCopy = $totalFilesToCopy;
                this.$totalCopiedFiles = $totalCopiedFiles;
                this.$callback = $callback;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MultipleFileCallback.ErrorCode errorCode) {
                Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
                if (!this.$canceled.element) {
                    void $this$postToUi$iv;
                    Collection<DocumentFile> collection;
                    void $this$mapTo$iv$iv;
                    this.$canceled.element = true;
                    Job job = (Job)this.$timer.element;
                    if (job != null) {
                        Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    }
                    job = (DocumentFile)this.$targetFile.element;
                    if (job != null) {
                        job.delete();
                    }
                    CoroutineScope $this$map$iv = this.$results;
                    boolean $i$f$map = false;
                    CoroutineScope coroutineScope = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    void var8_10 = $this$mapTo$iv$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = var8_10.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Map.Entry<K, V> item$iv$iv;
                        Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        DocumentFile documentFile = (DocumentFile)it.getValue();
                        collection.add(documentFile);
                    }
                    collection = (List)destination$iv$iv;
                    boolean bl3 = false;
                    int n = this.$totalCopiedFiles.element;
                    int n2 = this.$totalFilesToCopy;
                    List list = collection;
                    MultipleFileCallback.Result result = new MultipleFileCallback.Result(list, n2, n, bl3);
                    $this$map$iv = this.$callback.getUiScope();
                    MultipleFileCallback multipleFileCallback = this.$callback;
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, multipleFileCallback, errorCode, result){
                        int label;
                        final /* synthetic */ MultipleFileCallback $callback$inlined;
                        final /* synthetic */ MultipleFileCallback.ErrorCode $errorCode$inlined;
                        final /* synthetic */ MultipleFileCallback.Result $result$inlined;
                        {
                            this.$callback$inlined = multipleFileCallback;
                            this.$errorCode$inlined = errorCode;
                            this.$result$inlined = result;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(this.$errorCode$inlined);
                                    this.$callback$inlined.onCompleted(this.$result$inlined);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            }
        };
        byte[] buffer = new byte[1024];
        Ref.BooleanRef success = new Ref.BooleanRef();
        success.element = true;
        Function2 copy2 = (Function2)new Function2<DocumentFile, DocumentFile, Unit>(context, callback, totalCopiedFiles, deleteSourceWhenComplete, buffer, bytesMoved, writeSpeed){
            final /* synthetic */ Context $context;
            final /* synthetic */ MultipleFileCallback $callback;
            final /* synthetic */ Ref.IntRef $totalCopiedFiles;
            final /* synthetic */ boolean $deleteSourceWhenComplete;
            final /* synthetic */ byte[] $buffer;
            final /* synthetic */ Ref.LongRef $bytesMoved;
            final /* synthetic */ Ref.IntRef $writeSpeed;
            {
                this.$context = $context;
                this.$callback = $callback;
                this.$totalCopiedFiles = $totalCopiedFiles;
                this.$deleteSourceWhenComplete = $deleteSourceWhenComplete;
                this.$buffer = $buffer;
                this.$bytesMoved = $bytesMoved;
                this.$writeSpeed = $writeSpeed;
                super(2);
            }

            public final void invoke(@NotNull DocumentFile sourceFile, @NotNull DocumentFile destFile) {
                Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
                Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
                DocumentFileUtils.access$createFileStreams(this.$context, sourceFile, destFile, this.$callback, (Function2)new Function2<InputStream, OutputStream, Unit>(this.$buffer, this.$bytesMoved, this.$writeSpeed){
                    final /* synthetic */ byte[] $buffer;
                    final /* synthetic */ Ref.LongRef $bytesMoved;
                    final /* synthetic */ Ref.IntRef $writeSpeed;
                    {
                        this.$buffer = $buffer;
                        this.$bytesMoved = $bytesMoved;
                        this.$writeSpeed = $writeSpeed;
                        super(2);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                        try {
                            int read = inputStream.read(this.$buffer);
                            while (read != -1) {
                                outputStream.write(this.$buffer, 0, read);
                                this.$bytesMoved.element += (long)read;
                                this.$writeSpeed.element += read;
                                read = inputStream.read(this.$buffer);
                            }
                        }
                        finally {
                            IOUtils.closeStream(inputStream);
                            IOUtils.closeStream(outputStream);
                        }
                    }
                });
                int n = this.$totalCopiedFiles.element;
                this.$totalCopiedFiles.element = n + 1;
                if (this.$deleteSourceWhenComplete) {
                    sourceFile.delete();
                }
            }
        };
        Function1 handleError2 = (Function1)new Function1<Exception, Boolean>((Function1<? super MultipleFileCallback.ErrorCode, Unit>)notifyCanceled2, (Ref.ObjectRef<Job>)timer2, callback){
            final /* synthetic */ Function1<MultipleFileCallback.ErrorCode, Unit> $notifyCanceled;
            final /* synthetic */ Ref.ObjectRef<Job> $timer;
            final /* synthetic */ MultipleFileCallback $callback;
            {
                this.$notifyCanceled = $notifyCanceled;
                this.$timer = $timer;
                this.$callback = $callback;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull Exception it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MultipleFileCallback.ErrorCode errorCode = DocumentFileUtils.access$toMultipleFileCallbackErrorCode(it);
                if (errorCode == MultipleFileCallback.ErrorCode.CANCELED || errorCode == MultipleFileCallback.ErrorCode.UNKNOWN_IO_ERROR) {
                    this.$notifyCanceled.invoke((Object)((Object)errorCode));
                    bl = true;
                } else {
                    void $this$postToUi$iv;
                    Job job = (Job)this.$timer.element;
                    if (job != null) {
                        Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    }
                    job = this.$callback.getUiScope();
                    MultipleFileCallback multipleFileCallback = this.$callback;
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, multipleFileCallback, errorCode){
                        int label;
                        final /* synthetic */ MultipleFileCallback $callback$inlined;
                        final /* synthetic */ MultipleFileCallback.ErrorCode $errorCode$inlined;
                        {
                            this.$callback$inlined = multipleFileCallback;
                            this.$errorCode$inlined = errorCode;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(this.$errorCode$inlined);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    bl = false;
                }
                return bl;
            }
        };
        boolean bl6 = false;
        List conflictedFiles = new ArrayList();
        it2 = sourceInfos;
        bl = false;
        Iterator iterator4 = it2.entrySet().iterator();
        while (iterator4.hasNext()) {
            boolean $i$f$postToUi622;
            Object $this$postToUi$iv6;
            Map.Entry entry = it2 = iterator4.next();
            boolean bl7 = false;
            DocumentFile src = (DocumentFile)entry.getKey();
            iterator = it2;
            boolean bl8 = false;
            SourceInfo info = (SourceInfo)iterator.getValue();
            if (thread.isInterrupted()) {
                notifyCanceled2.invoke((Object)MultipleFileCallback.ErrorCode.CANCELED);
                return;
            }
            mode = info.getConflictResolution().toCreateMode();
            DocumentFile documentFile = writableTargetParentFolder;
            boolean bl9 = false;
            boolean bl10 = false;
            it = documentFile;
            boolean bl21 = false;
            DocumentFile targetRootFile = src.isDirectory() ? DocumentFileUtils.makeFolder((DocumentFile)it, context, DocumentFileUtils.getFullName(src), mode) : DocumentFileUtils.makeFile((DocumentFile)it, context, DocumentFileUtils.getFullName(src), DocumentFileUtils.getMimeType(src), mode);
            if (targetRootFile == null) {
                Unit unit;
                documentFile = (Job)timer2.element;
                if (documentFile == null) {
                    unit = null;
                } else {
                    Job.DefaultImpls.cancel$default((Job)documentFile, null, (int)1, null);
                    unit = Unit.INSTANCE;
                }
                $this$postToUi$iv6 = callback.getUiScope();
                $i$f$postToUi622 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv6, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                    {
                        this.$callback$inlined = multipleFileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            try {
                if (targetRootFile.isFile()) {
                    copy2.invoke((Object)src, (Object)targetRootFile);
                    $this$postToUi$iv6 = results;
                    $i$f$postToUi622 = false;
                    $this$postToUi$iv6.put(src, targetRootFile);
                    continue;
                }
                String targetFolderParentPath = DocumentFileUtils.getAbsolutePath(writableTargetParentFolder, context) + '/' + DocumentFileUtils.getFullName(src);
                for (DocumentFile sourceFile : info.getChildren()) {
                    if (thread.isInterrupted()) {
                        notifyCanceled2.invoke((Object)MultipleFileCallback.ErrorCode.CANCELED);
                        return;
                    }
                    if (!sourceFile.exists()) continue;
                    String subPath = StringsKt.substringBeforeLast((String)DocumentFileUtils.getSubPath(sourceFile, context, targetFolderParentPath), (char)'/', (String)"");
                    String filename = TextUtils.trimFileSeparator(subPath + '/' + DocumentFileUtils.getFullName(sourceFile));
                    if (sourceFile.isDirectory()) {
                        DocumentFile newFolder = DocumentFileUtils.makeFolder(targetRootFile, context, filename, CreateMode.REUSE);
                        if (newFolder != null) continue;
                        success.element = false;
                        break;
                    }
                    targetFile.element = DocumentFileUtils.makeFile(targetRootFile, context, filename, sourceFile.getType(), CreateMode.REUSE);
                    if (targetFile.element != null && ((DocumentFile)targetFile.element).length() > 0L) {
                        conflictedFiles.add(new FolderCallback.FileConflict(sourceFile, (DocumentFile)targetFile.element, null, 4, null));
                        continue;
                    }
                    if (targetFile.element == null) {
                        notifyCanceled2.invoke((Object)MultipleFileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                        return;
                    }
                    copy2.invoke((Object)sourceFile, targetFile.element);
                }
                Map $i$f$postToUi622 = results;
                boolean sourceFile = false;
                $i$f$postToUi622.put(src, targetRootFile);
            }
            catch (Exception e) {
                if (((Boolean)handleError2.invoke((Object)e)).booleanValue()) {
                    return;
                }
                success.element = false;
                break;
            }
        }
        if (((Boolean)(finalize2 = (Function0)new Function0<Boolean>((Ref.ObjectRef<Job>)timer2, success, (List<FolderCallback.FileConflict>)conflictedFiles, deleteSourceWhenComplete, (Map<DocumentFile, SourceInfo>)sourceInfos, (Map<DocumentFile, DocumentFile>)results, totalFilesToCopy, totalCopiedFiles, callback, context){
            final /* synthetic */ Ref.ObjectRef<Job> $timer;
            final /* synthetic */ Ref.BooleanRef $success;
            final /* synthetic */ List<FolderCallback.FileConflict> $conflictedFiles;
            final /* synthetic */ boolean $deleteSourceWhenComplete;
            final /* synthetic */ Map<DocumentFile, SourceInfo> $sourceInfos;
            final /* synthetic */ Map<DocumentFile, DocumentFile> $results;
            final /* synthetic */ int $totalFilesToCopy;
            final /* synthetic */ Ref.IntRef $totalCopiedFiles;
            final /* synthetic */ MultipleFileCallback $callback;
            final /* synthetic */ Context $context;
            {
                this.$timer = $timer;
                this.$success = $success;
                this.$conflictedFiles = $conflictedFiles;
                this.$deleteSourceWhenComplete = $deleteSourceWhenComplete;
                this.$sourceInfos = $sourceInfos;
                this.$results = $results;
                this.$totalFilesToCopy = $totalFilesToCopy;
                this.$totalCopiedFiles = $totalCopiedFiles;
                this.$callback = $callback;
                this.$context = $context;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                boolean bl;
                Object object = (Job)this.$timer.element;
                if (object != null) {
                    Job.DefaultImpls.cancel$default((Job)object, null, (int)1, null);
                }
                if (!this.$success.element || this.$conflictedFiles.isEmpty()) {
                    void $this$postToUi$iv;
                    Collection<DocumentFile> collection;
                    void $this$mapTo$iv$iv;
                    CoroutineScope coroutineScope;
                    if (this.$deleteSourceWhenComplete && this.$success.element) {
                        void $this$forEach$iv;
                        object = this.$sourceInfos;
                        Context context = this.$context;
                        boolean $i$f$forEach = false;
                        coroutineScope = $this$forEach$iv;
                        boolean bl2 = false;
                        Iterator<Map.Entry<DocumentFile, DocumentFile>> iterator = coroutineScope.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<DocumentFile, DocumentFile> element$iv;
                            Map.Entry<DocumentFile, DocumentFile> $dstr$src$_u24__u24 = element$iv = iterator.next();
                            boolean bl3 = false;
                            Map.Entry<DocumentFile, DocumentFile> entry = $dstr$src$_u24__u24;
                            boolean bl4 = false;
                            DocumentFile src = entry.getKey();
                            DocumentFileUtils.deleteRecursively$default(src, context, false, 2, null);
                        }
                    }
                    CoroutineScope $this$map$iv = this.$results;
                    boolean $i$f$map = false;
                    coroutineScope = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    void var7_11 = $this$mapTo$iv$iv;
                    boolean bl5 = false;
                    Iterator<Map.Entry<K, V>> iterator = var7_11.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Map.Entry<K, V> item$iv$iv;
                        Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                        collection = destination$iv$iv;
                        boolean bl6 = false;
                        DocumentFile documentFile = (DocumentFile)it.getValue();
                        collection.add(documentFile);
                    }
                    collection = (List)destination$iv$iv;
                    boolean bl7 = this.$success.element;
                    int n = this.$totalCopiedFiles.element;
                    int n2 = this.$totalFilesToCopy;
                    List list = collection;
                    MultipleFileCallback.Result result = new MultipleFileCallback.Result(list, n2, n, bl7);
                    $this$map$iv = this.$callback.getUiScope();
                    MultipleFileCallback multipleFileCallback = this.$callback;
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, multipleFileCallback, result){
                        int label;
                        final /* synthetic */ MultipleFileCallback $callback$inlined;
                        final /* synthetic */ MultipleFileCallback.Result $result$inlined;
                        {
                            this.$callback$inlined = multipleFileCallback;
                            this.$result$inlined = result;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onCompleted(this.$result$inlined);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }).invoke()).booleanValue()) {
            return;
        }
        Object uiScope$iv2 = callback.getUiScope();
        boolean $i$f$awaitUiResultWithPending = false;
        uiScope$iv2 = (Iterable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends FolderCallback.FileConflict>>, Object>(uiScope$iv2, null, callback, writableTargetParentFolder, conflictedFiles){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ MultipleFileCallback $callback$inlined;
            final /* synthetic */ DocumentFile $writableTargetParentFolder$inlined;
            final /* synthetic */ List $conflictedFiles$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = multipleFileCallback;
                this.$writableTargetParentFolder$inlined = documentFile;
                this.$conflictedFiles$inlined = list;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$writableTargetParentFolder$inlined, this.$conflictedFiles$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ MultipleFileCallback $callback$inlined;
                            final /* synthetic */ DocumentFile $writableTargetParentFolder$inlined;
                            final /* synthetic */ List $conflictedFiles$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = multipleFileCallback;
                                this.$writableTargetParentFolder$inlined = documentFile;
                                this.$conflictedFiles$inlined = list;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CancellableContinuation it = this.$it;
                                        boolean bl = false;
                                        this.$callback$inlined.onContentConflict(this.$writableTargetParentFolder$inlined, this.$conflictedFiles$inlined, new FolderCallback.FolderContentConflictAction((CancellableContinuation<? super List<FolderCallback.FileConflict>>)it));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends FolderCallback.FileConflict>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        boolean $i$f$filter2 = false;
        mode = $this$filter$iv;
        Collection destination$iv$iv2232 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        DocumentFile $i$f$postToUi622 = $this$filterTo$iv$iv.iterator();
        while ($i$f$postToUi622.hasNext()) {
            Object element$iv$iv = $i$f$postToUi622.next();
            it = (FolderCallback.FileConflict)element$iv$iv;
            boolean bl22 = false;
            if (((FolderCallback.FileConflict)it).getSolution() == FileCallback.ConflictResolution.SKIP) {
                if (deleteSourceWhenComplete) {
                    ((FolderCallback.FileConflict)it).getSource().delete();
                }
                int newFolder = totalCopiedFiles.element;
                totalCopiedFiles.element = newFolder + 1;
            }
            if (!(((FolderCallback.FileConflict)it).getSolution() != FileCallback.ConflictResolution.SKIP)) continue;
            destination$iv$iv2232.add(element$iv$iv);
        }
        List solutions = (List)destination$iv$iv2232;
        long leftoverSize = totalSizeToCopy - bytesMoved.element;
        iterator = solutions;
        boolean destination$iv$iv2232 = false;
        startTimer2.invoke((Object)(!iterator.isEmpty() && leftoverSize > 0xA00000L ? 1 : 0));
        for (FolderCallback.FileConflict conflict : solutions) {
            if (thread.isInterrupted()) {
                notifyCanceled2.invoke((Object)MultipleFileCallback.ErrorCode.CANCELED);
                return;
            }
            if (!conflict.getSource().isFile()) continue;
            String filename = DocumentFileUtils.getFullName(conflict.getTarget());
            if (conflict.getSolution() == FileCallback.ConflictResolution.REPLACE) {
                $i$f$postToUi622 = conflict.getTarget();
                boolean bl11 = false;
                boolean bl12 = false;
                DocumentFile it8 = $i$f$postToUi622;
                boolean bl25 = false;
                if (!it8.delete() || it8.exists()) continue;
            }
            Object object3 = targetFile.element = ($i$f$postToUi622 = conflict.getTarget().getParentFile()) == null ? null : DocumentFileUtils.makeFile$default($i$f$postToUi622, context, filename, null, null, 12, null);
            if (targetFile.element == null) {
                notifyCanceled2.invoke((Object)MultipleFileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                return;
            }
            try {
                copy2.invoke((Object)conflict.getSource(), targetFile.element);
            }
            catch (Exception e) {
                if (((Boolean)handleError2.invoke((Object)e)).booleanValue()) {
                    return;
                }
                success.element = false;
                break;
            }
        }
        finalize2.invoke();
    }

    static /* synthetic */ void copyTo$default(List list, Context context, DocumentFile documentFile, boolean bl, boolean bl2, MultipleFileCallback multipleFileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        DocumentFileUtils.copyTo(list, context, documentFile, bl, bl2, multipleFileCallback);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<DocumentFile, List<DocumentFile>> doesMeetCopyRequirements(List<? extends DocumentFile> $this$doesMeetCopyRequirements, Context context, DocumentFile targetParentFolder, MultipleFileCallback callback) {
        Collection<DocumentFile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$doesMeetCopyRequirements_u24lambda_u2d82;
        Object object;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        CoroutineScope $this$postToUi$iv = callback.getUiScope();
        boolean $i$f$postToUi = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ MultipleFileCallback $callback$inlined;
            {
                this.$callback$inlined = multipleFileCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onValidate();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        if (!targetParentFolder.isDirectory()) {
            $this$postToUi$iv = callback.getUiScope();
            $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ MultipleFileCallback $callback$inlined;
                {
                    this.$callback$inlined = multipleFileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.INVALID_TARGET_FOLDER);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        if (!DocumentFileUtils.isWritable(targetParentFolder, context)) {
            $this$postToUi$iv = callback.getUiScope();
            $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ MultipleFileCallback $callback$inlined;
                {
                    this.$callback$inlined = multipleFileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        String targetParentFolderPath = DocumentFileUtils.getAbsolutePath(targetParentFolder, context);
        Iterable $this$distinctBy$iv = $this$doesMeetCopyRequirements;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        Iterable list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            DocumentFile it = (DocumentFile)e$iv;
            boolean bl = false;
            String key$iv = it.getName();
            if (!set$iv.add(key$iv)) continue;
            ((ArrayList)list$iv).add(e$iv);
        }
        List sourceFiles = (List)list$iv;
        Object $this$mapNotNull$iv = sourceFiles;
        boolean $i$f$mapNotNull = false;
        list$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DocumentFile documentFile;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DocumentFile it = (DocumentFile)element$iv$iv;
            boolean bl2 = false;
            if ((!it.exists() ? new Pair((Object)it, (Object)FolderCallback.ErrorCode.SOURCE_FILE_NOT_FOUND) : (!it.canRead() ? new Pair((Object)it, (Object)FolderCallback.ErrorCode.STORAGE_PERMISSION_DENIED) : (Intrinsics.areEqual((Object)targetParentFolderPath, (documentFile = it.getParentFile()) == null ? null : DocumentFileUtils.getAbsolutePath(documentFile, context)) ? new Pair((Object)it, (Object)FolderCallback.ErrorCode.TARGET_FOLDER_CANNOT_HAVE_SAME_PATH_WITH_SOURCE_FOLDER) : null))) == null) continue;
            object = object;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair it$iv$iv = object;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map invalidSourceFiles = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $this$mapNotNull$iv = invalidSourceFiles;
        $i$f$mapNotNull = false;
        if (!$this$mapNotNull$iv.isEmpty()) {
            boolean $i$f$postToUi2;
            CoroutineScope $this$postToUi$iv2;
            CoroutineScope uiScope$iv = callback.getUiScope();
            boolean $i$f$awaitUiResultWithPending = false;
            boolean abort = (Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(uiScope$iv, null, callback, invalidSourceFiles){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CoroutineScope $uiScope;
                final /* synthetic */ MultipleFileCallback $callback$inlined;
                final /* synthetic */ Map $invalidSourceFiles$inlined;
                {
                    this.$uiScope = $uiScope;
                    this.$callback$inlined = multipleFileCallback;
                    this.$invalidSourceFiles$inlined = map;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope coroutineScope = this.$uiScope;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            this.L$0 = coroutineScope;
                            this.label = 1;
                            Continuation uCont$iv = (Continuation)this;
                            boolean bl = false;
                            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                            cancellable$iv.initCancellability();
                            CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                            boolean bl2 = false;
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$invalidSourceFiles$inlined){
                                int label;
                                final /* synthetic */ CancellableContinuation $it;
                                final /* synthetic */ MultipleFileCallback $callback$inlined;
                                final /* synthetic */ Map $invalidSourceFiles$inlined;
                                {
                                    this.$it = $it;
                                    this.$callback$inlined = multipleFileCallback;
                                    this.$invalidSourceFiles$inlined = map;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            CancellableContinuation it = this.$it;
                                            boolean bl = false;
                                            this.$callback$inlined.onInvalidSourceFilesFound(this.$invalidSourceFiles$inlined, new MultipleFileCallback.InvalidSourceFilesAction((CancellableContinuation<? super Boolean>)it));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            Object object3 = cancellable$iv.getResult();
                            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                            }
                            Object object4 = object3;
                            if (object3 != object2) return object4;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return object4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            if (abort) {
                $this$postToUi$iv2 = callback.getUiScope();
                $i$f$postToUi2 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                    {
                        this.$callback$inlined = multipleFileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.CANCELED);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return null;
            }
            if (invalidSourceFiles.size() == $this$doesMeetCopyRequirements.size()) {
                $this$postToUi$iv2 = callback.getUiScope();
                $i$f$postToUi2 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                    {
                        this.$callback$inlined = multipleFileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onCompleted(new MultipleFileCallback.Result(CollectionsKt.emptyList(), 0, 0, true));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return null;
            }
        }
        DocumentFile $this$postToUi$iv3 = targetParentFolder;
        boolean $i$f$postToUi3 = false;
        boolean bl = false;
        Object it = $this$postToUi$iv3;
        boolean bl6 = false;
        DocumentFile writableFolder = DocumentFileUtils.isDownloadsDocument(it) ? DocumentFileUtils.toWritableDownloadsDocumentFile(it, context) : it;
        if (writableFolder == null) {
            $this$postToUi$iv3 = callback.getUiScope();
            $i$f$postToUi3 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ MultipleFileCallback $callback$inlined;
                {
                    this.$callback$inlined = multipleFileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        List list = CollectionsKt.toMutableList((Collection)sourceFiles);
        boolean bl7 = false;
        bl = false;
        it = list;
        DocumentFile documentFile = writableFolder;
        boolean bl8 = false;
        Map $i$f$forEach22 = invalidSourceFiles;
        iterator = $this$doesMeetCopyRequirements_u24lambda_u2d82;
        boolean $i$f$map = false;
        element$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var19_37 = $this$mapTo$iv$iv;
        boolean bl9 = false;
        object = var19_37.entrySet().iterator();
        while (object.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
            collection = destination$iv$iv2;
            boolean bl10 = false;
            DocumentFile documentFile2 = (DocumentFile)it2.getKey();
            collection.add(documentFile2);
        }
        collection = (List)destination$iv$iv2;
        iterator.removeAll(collection);
        Unit unit = Unit.INSTANCE;
        List list2 = list;
        DocumentFile documentFile3 = documentFile;
        return new Pair((Object)documentFile3, (Object)list2);
    }

    private static final Object tryMoveFolderByRenamingPath(DocumentFile $this$tryMoveFolderByRenamingPath, Context context, DocumentFile writableTargetParentFolder, String targetFolderParentName, boolean skipEmptyFiles, String newFolderNameInTargetPath, FolderCallback.ConflictResolution conflictResolution) {
        if (DocumentFileUtils.inSameMountPointWith($this$tryMoveFolderByRenamingPath, context, writableTargetParentFolder)) {
            boolean bl;
            File file;
            File file2;
            File file3;
            if (DocumentFileUtils.inInternalStorage($this$tryMoveFolderByRenamingPath, context) && (file3 = DocumentFileUtils.toRawFile($this$tryMoveFolderByRenamingPath, context)) != null && (file2 = FileUtils.moveTo(file3, context, DocumentFileUtils.getAbsolutePath(writableTargetParentFolder, context), targetFolderParentName, conflictResolution.toFileConflictResolution())) != null) {
                File file4 = file2;
                boolean bl2 = false;
                boolean bl3 = false;
                File it = file4;
                boolean bl4 = false;
                if (skipEmptyFiles) {
                    FileUtils.deleteEmptyFolders(it, context);
                }
                return DocumentFile.fromFile((File)it);
            }
            if (DocumentFileUtils.isExternalStorageManager($this$tryMoveFolderByRenamingPath, context)) {
                file2 = DocumentFileUtils.toRawFile($this$tryMoveFolderByRenamingPath, context);
                if (file2 == null) {
                    return FolderCallback.ErrorCode.STORAGE_PERMISSION_DENIED;
                }
                File sourceFile = file2;
                file2 = DocumentFileUtils.toRawFile(writableTargetParentFolder, context);
                if (file2 != null) {
                    file = file2;
                    boolean bl5 = false;
                    bl = false;
                    File destinationFolder = file;
                    boolean bl6 = false;
                    File file5 = FileUtils.moveTo(sourceFile, context, destinationFolder, targetFolderParentName, conflictResolution.toFileConflictResolution());
                    if (file5 != null) {
                        File file6 = file5;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        File it = file6;
                        boolean bl9 = false;
                        if (skipEmptyFiles) {
                            FileUtils.deleteEmptyFolders(it, context);
                        }
                        return DocumentFile.fromFile((File)it);
                    }
                }
            }
            try {
                if (Build.VERSION.SDK_INT >= 24 && !DocumentFileUtils.isRawFile($this$tryMoveFolderByRenamingPath) && DocumentFileUtils.isTreeDocumentFile(writableTargetParentFolder)) {
                    Uri uri;
                    file2 = $this$tryMoveFolderByRenamingPath.getParentFile();
                    if (file2 == null) {
                        uri = null;
                    } else {
                        file = file2.getUri();
                        if (file == null) {
                            uri = null;
                        } else {
                            File file7 = file;
                            bl = false;
                            boolean bl10 = false;
                            File it = file7;
                            boolean bl11 = false;
                            uri = DocumentsContract.moveDocument((ContentResolver)context.getContentResolver(), (Uri)$this$tryMoveFolderByRenamingPath.getUri(), (Uri)it, (Uri)writableTargetParentFolder.getUri());
                        }
                    }
                    Uri movedFileUri = uri;
                    if (movedFileUri != null) {
                        FolderCallback.ErrorCode errorCode;
                        DocumentFile newFile = ContextUtils.fromTreeUri(context, movedFileUri);
                        if (newFile != null && newFile.isDirectory()) {
                            if (newFolderNameInTargetPath != null) {
                                newFile.renameTo(targetFolderParentName);
                            }
                            if (skipEmptyFiles) {
                                DocumentFileUtils.deleteEmptyFolders(newFile, context);
                            }
                            errorCode = newFile;
                        } else {
                            errorCode = FolderCallback.ErrorCode.INVALID_TARGET_FOLDER;
                        }
                        return errorCode;
                    }
                }
            }
            catch (Throwable e) {
                return FolderCallback.ErrorCode.STORAGE_PERMISSION_DENIED;
            }
        }
        return null;
    }

    @WorkerThread
    public static final void moveFolderTo(@NotNull DocumentFile $this$moveFolderTo, @NotNull Context context, @NotNull DocumentFile targetParentFolder, boolean skipEmptyFiles, @Nullable String newFolderNameInTargetPath, @NotNull FolderCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFolderTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetParentFolder, (String)"targetParentFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.copyFolderTo($this$moveFolderTo, context, targetParentFolder, skipEmptyFiles, newFolderNameInTargetPath, true, callback);
    }

    public static /* synthetic */ void moveFolderTo$default(DocumentFile documentFile, Context context, DocumentFile documentFile2, boolean bl, String string2, FolderCallback folderCallback, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        DocumentFileUtils.moveFolderTo(documentFile, context, documentFile2, bl, string2, folderCallback);
    }

    @WorkerThread
    public static final void copyFolderTo(@NotNull DocumentFile $this$copyFolderTo, @NotNull Context context, @NotNull DocumentFile targetParentFolder, boolean skipEmptyFiles, @Nullable String newFolderNameInTargetPath, @NotNull FolderCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFolderTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetParentFolder, (String)"targetParentFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.copyFolderTo($this$copyFolderTo, context, targetParentFolder, skipEmptyFiles, newFolderNameInTargetPath, false, callback);
    }

    public static /* synthetic */ void copyFolderTo$default(DocumentFile documentFile, Context context, DocumentFile documentFile2, boolean bl, String string2, FolderCallback folderCallback, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        DocumentFileUtils.copyFolderTo(documentFile, context, documentFile2, bl, string2, folderCallback);
    }

    /*
     * WARNING - void declaration
     */
    private static final void copyFolderTo(DocumentFile $this$copyFolderTo, Context context, DocumentFile targetParentFolder, boolean skipEmptyFiles, String newFolderNameInTargetPath, boolean deleteSourceWhenComplete, FolderCallback callback) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Function0 finalize2;
        DocumentFile newFolder;
        Iterator iterator;
        CoroutineScope $this$postToUi$iv;
        List<DocumentFile> filesToCopy;
        String string2;
        DocumentFile documentFile = DocumentFileUtils.doesMeetCopyRequirements($this$copyFolderTo, context, targetParentFolder, newFolderNameInTargetPath, callback);
        if (documentFile == null) {
            return;
        }
        DocumentFile writableTargetParentFolder = documentFile;
        CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
        boolean $i$f$postToUi22 = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ FolderCallback $callback$inlined;
            {
                this.$callback$inlined = folderCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onPrepare();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        String $i$f$postToUi22 = newFolderNameInTargetPath;
        if ($i$f$postToUi22 == null) {
            String string3 = $this$copyFolderTo.getName();
            boolean bl = false;
            string2 = string3;
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = $i$f$postToUi22;
        }
        String targetFolderParentName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(string2));
        FolderCallback.ConflictResolution conflictResolution = DocumentFileUtils.handleParentFolderConflict(context, targetParentFolder, targetFolderParentName, callback);
        if (conflictResolution == FolderCallback.ConflictResolution.SKIP) {
            return;
        }
        CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
        boolean $i$f$postToUi = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ FolderCallback $callback$inlined;
            {
                this.$callback$inlined = folderCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onCountingFiles();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        List<DocumentFile> list = filesToCopy = skipEmptyFiles ? DocumentFileUtils.walkFileTreeAndSkipEmptyFiles($this$copyFolderTo) : DocumentFileUtils.walkFileTree($this$copyFolderTo, context);
        if (filesToCopy.isEmpty()) {
            DocumentFile targetFolder = DocumentFileUtils.makeFolder(writableTargetParentFolder, context, targetFolderParentName, conflictResolution.toCreateMode());
            if (targetFolder == null) {
                CoroutineScope $this$postToUi$iv4 = callback.getUiScope();
                boolean $i$f$postToUi3 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv4, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FolderCallback $callback$inlined;
                    {
                        this.$callback$inlined = folderCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                if (deleteSourceWhenComplete) {
                    $this$copyFolderTo.delete();
                }
                CoroutineScope $this$postToUi$iv5 = callback.getUiScope();
                boolean $i$f$postToUi4 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv5, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, targetFolder){
                    int label;
                    final /* synthetic */ FolderCallback $callback$inlined;
                    final /* synthetic */ DocumentFile $targetFolder$inlined;
                    {
                        this.$callback$inlined = folderCallback;
                        this.$targetFolder$inlined = documentFile;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onCompleted(new FolderCallback.Result(this.$targetFolder$inlined, 0, 0, true));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            return;
        }
        Ref.IntRef totalFilesToCopy = new Ref.IntRef();
        Ref.LongRef totalSizeToCopy = new Ref.LongRef();
        Iterable $this$forEach$iv = filesToCopy;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentFile it = (DocumentFile)element$iv;
            boolean bl = false;
            if (!it.isFile()) continue;
            int n = totalFilesToCopy.element;
            totalFilesToCopy.element = n + 1;
            totalSizeToCopy.element += it.length();
        }
        Thread thread = Thread.currentThread();
        if (thread.isInterrupted()) {
            CoroutineScope $this$postToUi$iv6 = callback.getUiScope();
            boolean $i$f$postToUi5 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv6, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FolderCallback $callback$inlined;
                {
                    this.$callback$inlined = folderCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FolderCallback.ErrorCode.CANCELED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        if (deleteSourceWhenComplete) {
            Object result = DocumentFileUtils.tryMoveFolderByRenamingPath($this$copyFolderTo, context, writableTargetParentFolder, targetFolderParentName, skipEmptyFiles, newFolderNameInTargetPath, conflictResolution);
            if (result instanceof DocumentFile) {
                $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi6 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, result, totalFilesToCopy){
                    int label;
                    final /* synthetic */ FolderCallback $callback$inlined;
                    final /* synthetic */ Object $result$inlined;
                    final /* synthetic */ Ref.IntRef $totalFilesToCopy$inlined;
                    {
                        this.$callback$inlined = folderCallback;
                        this.$result$inlined = object;
                        this.$totalFilesToCopy$inlined = intRef;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onCompleted(new FolderCallback.Result((DocumentFile)this.$result$inlined, this.$totalFilesToCopy$inlined.element, this.$totalFilesToCopy$inlined.element, true));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            if (result instanceof FolderCallback.ErrorCode) {
                $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi7 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, result){
                    int label;
                    final /* synthetic */ FolderCallback $callback$inlined;
                    final /* synthetic */ Object $result$inlined;
                    {
                        this.$callback$inlined = folderCallback;
                        this.$result$inlined = object;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(this.$result$inlined);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        try {
            if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context, DocumentFileUtils.getStorageId(writableTargetParentFolder, context)), totalSizeToCopy.element)) {
                CoroutineScope $this$postToUi$iv7 = callback.getUiScope();
                boolean $i$f$postToUi8 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv7, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FolderCallback $callback$inlined;
                    {
                        this.$callback$inlined = folderCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FolderCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        catch (Throwable e) {
            $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi9 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FolderCallback $callback$inlined;
                {
                    this.$callback$inlined = folderCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FolderCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, $this$copyFolderTo, totalFilesToCopy, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FolderCallback $callback$inlined;
            final /* synthetic */ DocumentFile $this_copyFolderTo$inlined;
            final /* synthetic */ Ref.IntRef $totalFilesToCopy$inlined;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = folderCallback;
                this.$this_copyFolderTo$inlined = documentFile;
                this.$totalFilesToCopy$inlined = intRef;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$this_copyFolderTo$inlined, this.$totalFilesToCopy$inlined, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FolderCallback $callback$inlined;
                            final /* synthetic */ DocumentFile $this_copyFolderTo$inlined;
                            final /* synthetic */ Ref.IntRef $totalFilesToCopy$inlined;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = folderCallback;
                                this.$this_copyFolderTo$inlined = documentFile;
                                this.$totalFilesToCopy$inlined = intRef;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Long l;
                                        ResultKt.throwOnFailure((Object)object);
                                        Result.Companion companion = Result.Companion;
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        int n = this.$totalFilesToCopy$inlined.element;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        Long l2 = l = Boxing.boxLong((long)this.$callback$inlined.onStart(this.$this_copyFolderTo$inlined, n, this.$thread$inlined));
                                        boolean bl2 = false;
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)l2));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        if (reportInterval < 0L) {
            return;
        }
        DocumentFile targetFolder = DocumentFileUtils.makeFolder(writableTargetParentFolder, context, targetFolderParentName, conflictResolution.toCreateMode());
        if (targetFolder == null) {
            CoroutineScope $this$postToUi$iv8 = callback.getUiScope();
            boolean $i$f$postToUi10 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv8, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FolderCallback $callback$inlined;
                {
                    this.$callback$inlined = folderCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Ref.IntRef totalCopiedFiles = new Ref.IntRef();
        Ref.ObjectRef timer2 = new Ref.ObjectRef();
        Ref.LongRef bytesMoved = new Ref.LongRef();
        Ref.IntRef writeSpeed = new Ref.IntRef();
        Function1 startTimer2 = (Function1)new Function1<Boolean, Unit>(reportInterval, (Ref.ObjectRef<Job>)timer2, bytesMoved, totalSizeToCopy, writeSpeed, totalCopiedFiles, callback){
            final /* synthetic */ long $reportInterval;
            final /* synthetic */ Ref.ObjectRef<Job> $timer;
            final /* synthetic */ Ref.LongRef $bytesMoved;
            final /* synthetic */ Ref.LongRef $totalSizeToCopy;
            final /* synthetic */ Ref.IntRef $writeSpeed;
            final /* synthetic */ Ref.IntRef $totalCopiedFiles;
            final /* synthetic */ FolderCallback $callback;
            {
                this.$reportInterval = $reportInterval;
                this.$timer = $timer;
                this.$bytesMoved = $bytesMoved;
                this.$totalSizeToCopy = $totalSizeToCopy;
                this.$writeSpeed = $writeSpeed;
                this.$totalCopiedFiles = $totalCopiedFiles;
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(boolean start) {
                if (start && this.$reportInterval > 0L) {
                    this.$timer.element = CoroutineExtKt.startCoroutineTimer$default(0L, this.$reportInterval, false, (Function0)new Function0<Unit>(this.$bytesMoved, this.$totalSizeToCopy, this.$writeSpeed, this.$totalCopiedFiles, this.$callback){
                        final /* synthetic */ Ref.LongRef $bytesMoved;
                        final /* synthetic */ Ref.LongRef $totalSizeToCopy;
                        final /* synthetic */ Ref.IntRef $writeSpeed;
                        final /* synthetic */ Ref.IntRef $totalCopiedFiles;
                        final /* synthetic */ FolderCallback $callback;
                        {
                            this.$bytesMoved = $bytesMoved;
                            this.$totalSizeToCopy = $totalSizeToCopy;
                            this.$writeSpeed = $writeSpeed;
                            this.$totalCopiedFiles = $totalCopiedFiles;
                            this.$callback = $callback;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void $this$postToUi$iv;
                            FolderCallback.Report report = new FolderCallback.Report((float)this.$bytesMoved.element * 100.0f / (float)this.$totalSizeToCopy.element, this.$bytesMoved.element, this.$writeSpeed.element, this.$totalCopiedFiles.element);
                            CoroutineScope coroutineScope = this.$callback.getUiScope();
                            FolderCallback folderCallback = this.$callback;
                            boolean $i$f$postToUi = false;
                            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, folderCallback, report){
                                int label;
                                final /* synthetic */ FolderCallback $callback$inlined;
                                final /* synthetic */ FolderCallback.Report $report$inlined;
                                {
                                    this.$callback$inlined = folderCallback;
                                    this.$report$inlined = report;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            boolean bl = false;
                                            this.$callback$inlined.onReport(this.$report$inlined);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            this.$writeSpeed.element = 0;
                        }
                    }, 5, null);
                }
            }
        };
        startTimer2.invoke((Object)(totalSizeToCopy.element > 0xA00000L ? 1 : 0));
        Ref.ObjectRef targetFile = new Ref.ObjectRef();
        Ref.BooleanRef canceled = new Ref.BooleanRef();
        Function1 notifyCanceled2 = (Function1)new Function1<FolderCallback.ErrorCode, Unit>(canceled, (Ref.ObjectRef<Job>)timer2, (Ref.ObjectRef<DocumentFile>)targetFile, callback, targetFolder, totalFilesToCopy, totalCopiedFiles){
            final /* synthetic */ Ref.BooleanRef $canceled;
            final /* synthetic */ Ref.ObjectRef<Job> $timer;
            final /* synthetic */ Ref.ObjectRef<DocumentFile> $targetFile;
            final /* synthetic */ FolderCallback $callback;
            final /* synthetic */ DocumentFile $targetFolder;
            final /* synthetic */ Ref.IntRef $totalFilesToCopy;
            final /* synthetic */ Ref.IntRef $totalCopiedFiles;
            {
                this.$canceled = $canceled;
                this.$timer = $timer;
                this.$targetFile = $targetFile;
                this.$callback = $callback;
                this.$targetFolder = $targetFolder;
                this.$totalFilesToCopy = $totalFilesToCopy;
                this.$totalCopiedFiles = $totalCopiedFiles;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull FolderCallback.ErrorCode errorCode) {
                Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
                if (!this.$canceled.element) {
                    void $this$postToUi$iv;
                    this.$canceled.element = true;
                    Job job = (Job)this.$timer.element;
                    if (job != null) {
                        Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    }
                    job = (DocumentFile)this.$targetFile.element;
                    if (job != null) {
                        job.delete();
                    }
                    job = this.$callback.getUiScope();
                    FolderCallback folderCallback = this.$callback;
                    DocumentFile documentFile = this.$targetFolder;
                    Ref.IntRef intRef = this.$totalFilesToCopy;
                    Ref.IntRef intRef2 = this.$totalCopiedFiles;
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, folderCallback, errorCode, documentFile, intRef, intRef2){
                        int label;
                        final /* synthetic */ FolderCallback $callback$inlined;
                        final /* synthetic */ FolderCallback.ErrorCode $errorCode$inlined;
                        final /* synthetic */ DocumentFile $targetFolder$inlined;
                        final /* synthetic */ Ref.IntRef $totalFilesToCopy$inlined;
                        final /* synthetic */ Ref.IntRef $totalCopiedFiles$inlined;
                        {
                            this.$callback$inlined = folderCallback;
                            this.$errorCode$inlined = errorCode;
                            this.$targetFolder$inlined = documentFile;
                            this.$totalFilesToCopy$inlined = intRef;
                            this.$totalCopiedFiles$inlined = intRef2;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(this.$errorCode$inlined);
                                    this.$callback$inlined.onCompleted(new FolderCallback.Result(this.$targetFolder$inlined, this.$totalFilesToCopy$inlined.element, this.$totalCopiedFiles$inlined.element, false));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            }
        };
        String targetFolderParentPath = DocumentFileUtils.getAbsolutePath(writableTargetParentFolder, context) + '/' + targetFolderParentName;
        ArrayList<FolderCallback.FileConflict> conflictedFiles = new ArrayList<FolderCallback.FileConflict>(totalFilesToCopy.element);
        byte[] buffer = new byte[1024];
        Ref.BooleanRef success = new Ref.BooleanRef();
        success.element = true;
        Function2 copy2 = (Function2)new Function2<DocumentFile, DocumentFile, Unit>(context, callback, totalCopiedFiles, deleteSourceWhenComplete, buffer, bytesMoved, writeSpeed){
            final /* synthetic */ Context $context;
            final /* synthetic */ FolderCallback $callback;
            final /* synthetic */ Ref.IntRef $totalCopiedFiles;
            final /* synthetic */ boolean $deleteSourceWhenComplete;
            final /* synthetic */ byte[] $buffer;
            final /* synthetic */ Ref.LongRef $bytesMoved;
            final /* synthetic */ Ref.IntRef $writeSpeed;
            {
                this.$context = $context;
                this.$callback = $callback;
                this.$totalCopiedFiles = $totalCopiedFiles;
                this.$deleteSourceWhenComplete = $deleteSourceWhenComplete;
                this.$buffer = $buffer;
                this.$bytesMoved = $bytesMoved;
                this.$writeSpeed = $writeSpeed;
                super(2);
            }

            public final void invoke(@NotNull DocumentFile sourceFile, @NotNull DocumentFile destFile) {
                Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
                Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
                DocumentFileUtils.access$createFileStreams(this.$context, sourceFile, destFile, this.$callback, (Function2)new Function2<InputStream, OutputStream, Unit>(this.$buffer, this.$bytesMoved, this.$writeSpeed){
                    final /* synthetic */ byte[] $buffer;
                    final /* synthetic */ Ref.LongRef $bytesMoved;
                    final /* synthetic */ Ref.IntRef $writeSpeed;
                    {
                        this.$buffer = $buffer;
                        this.$bytesMoved = $bytesMoved;
                        this.$writeSpeed = $writeSpeed;
                        super(2);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                        try {
                            int read = inputStream.read(this.$buffer);
                            while (read != -1) {
                                outputStream.write(this.$buffer, 0, read);
                                this.$bytesMoved.element += (long)read;
                                this.$writeSpeed.element += read;
                                read = inputStream.read(this.$buffer);
                            }
                        }
                        finally {
                            IOUtils.closeStream(inputStream);
                            IOUtils.closeStream(outputStream);
                        }
                    }
                });
                int n = this.$totalCopiedFiles.element;
                this.$totalCopiedFiles.element = n + 1;
                if (this.$deleteSourceWhenComplete) {
                    sourceFile.delete();
                }
            }
        };
        Function1 handleError2 = (Function1)new Function1<Exception, Boolean>((Function1<? super FolderCallback.ErrorCode, Unit>)notifyCanceled2, (Ref.ObjectRef<Job>)timer2, callback){
            final /* synthetic */ Function1<FolderCallback.ErrorCode, Unit> $notifyCanceled;
            final /* synthetic */ Ref.ObjectRef<Job> $timer;
            final /* synthetic */ FolderCallback $callback;
            {
                this.$notifyCanceled = $notifyCanceled;
                this.$timer = $timer;
                this.$callback = $callback;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull Exception it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FolderCallback.ErrorCode errorCode = DocumentFileUtils.access$toFolderCallbackErrorCode(it);
                if (errorCode == FolderCallback.ErrorCode.CANCELED || errorCode == FolderCallback.ErrorCode.UNKNOWN_IO_ERROR) {
                    this.$notifyCanceled.invoke((Object)((Object)errorCode));
                    bl = true;
                } else {
                    void $this$postToUi$iv;
                    Job job = (Job)this.$timer.element;
                    if (job != null) {
                        Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    }
                    job = this.$callback.getUiScope();
                    FolderCallback folderCallback = this.$callback;
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, folderCallback, errorCode){
                        int label;
                        final /* synthetic */ FolderCallback $callback$inlined;
                        final /* synthetic */ FolderCallback.ErrorCode $errorCode$inlined;
                        {
                            this.$callback$inlined = folderCallback;
                            this.$errorCode$inlined = errorCode;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(this.$errorCode$inlined);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    bl = false;
                }
                return bl;
            }
        };
        for (DocumentFile sourceFile : filesToCopy) {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    notifyCanceled2.invoke((Object)FolderCallback.ErrorCode.CANCELED);
                    return;
                }
                if (!sourceFile.exists()) continue;
                String subPath = StringsKt.substringBeforeLast((String)DocumentFileUtils.getSubPath(sourceFile, context, targetFolderParentPath), (char)'/', (String)"");
                StringBuilder stringBuilder = new StringBuilder().append(subPath).append('/');
                iterator = sourceFile.getName();
                boolean bl = false;
                Object object = iterator;
                if (object == null) {
                    object = "";
                }
                String filename = TextUtils.trimFileSeparator(stringBuilder.append((String)object).toString());
                if (sourceFile.isDirectory()) {
                    newFolder = DocumentFileUtils.makeFolder(targetFolder, context, filename, CreateMode.REUSE);
                    if (newFolder != null) continue;
                    success.element = false;
                    break;
                }
                targetFile.element = DocumentFileUtils.makeFile(targetFolder, context, filename, sourceFile.getType(), CreateMode.REUSE);
                if (targetFile.element != null && ((DocumentFile)targetFile.element).length() > 0L) {
                    conflictedFiles.add(new FolderCallback.FileConflict(sourceFile, (DocumentFile)targetFile.element, null, 4, null));
                    continue;
                }
                if (targetFile.element == null) {
                    notifyCanceled2.invoke((Object)FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                    return;
                }
                copy2.invoke((Object)sourceFile, targetFile.element);
            }
            catch (Exception e) {
                if (((Boolean)handleError2.invoke((Object)e)).booleanValue()) {
                    return;
                }
                success.element = false;
                break;
            }
        }
        if (((Boolean)(finalize2 = (Function0)new Function0<Boolean>((Ref.ObjectRef<Job>)timer2, success, conflictedFiles, deleteSourceWhenComplete, $this$copyFolderTo, context, callback, targetFolder, totalFilesToCopy, totalCopiedFiles){
            final /* synthetic */ Ref.ObjectRef<Job> $timer;
            final /* synthetic */ Ref.BooleanRef $success;
            final /* synthetic */ ArrayList<FolderCallback.FileConflict> $conflictedFiles;
            final /* synthetic */ boolean $deleteSourceWhenComplete;
            final /* synthetic */ DocumentFile $this_copyFolderTo;
            final /* synthetic */ Context $context;
            final /* synthetic */ FolderCallback $callback;
            final /* synthetic */ DocumentFile $targetFolder;
            final /* synthetic */ Ref.IntRef $totalFilesToCopy;
            final /* synthetic */ Ref.IntRef $totalCopiedFiles;
            {
                this.$timer = $timer;
                this.$success = $success;
                this.$conflictedFiles = $conflictedFiles;
                this.$deleteSourceWhenComplete = $deleteSourceWhenComplete;
                this.$this_copyFolderTo = $receiver;
                this.$context = $context;
                this.$callback = $callback;
                this.$targetFolder = $targetFolder;
                this.$totalFilesToCopy = $totalFilesToCopy;
                this.$totalCopiedFiles = $totalCopiedFiles;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                boolean bl;
                Job job = (Job)this.$timer.element;
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                }
                if (!this.$success.element || this.$conflictedFiles.isEmpty()) {
                    void $this$postToUi$iv;
                    if (this.$deleteSourceWhenComplete && this.$success.element) {
                        DocumentFileUtils.forceDelete$default(this.$this_copyFolderTo, this.$context, false, 2, null);
                    }
                    job = this.$callback.getUiScope();
                    FolderCallback folderCallback = this.$callback;
                    DocumentFile documentFile = this.$targetFolder;
                    Ref.IntRef intRef = this.$totalFilesToCopy;
                    Ref.IntRef intRef2 = this.$totalCopiedFiles;
                    Ref.BooleanRef booleanRef = this.$success;
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, folderCallback, documentFile, intRef, intRef2, booleanRef){
                        int label;
                        final /* synthetic */ FolderCallback $callback$inlined;
                        final /* synthetic */ DocumentFile $targetFolder$inlined;
                        final /* synthetic */ Ref.IntRef $totalFilesToCopy$inlined;
                        final /* synthetic */ Ref.IntRef $totalCopiedFiles$inlined;
                        final /* synthetic */ Ref.BooleanRef $success$inlined;
                        {
                            this.$callback$inlined = folderCallback;
                            this.$targetFolder$inlined = documentFile;
                            this.$totalFilesToCopy$inlined = intRef;
                            this.$totalCopiedFiles$inlined = intRef2;
                            this.$success$inlined = booleanRef;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onCompleted(new FolderCallback.Result(this.$targetFolder$inlined, this.$totalFilesToCopy$inlined.element, this.$totalCopiedFiles$inlined.element, this.$success$inlined.element));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }).invoke()).booleanValue()) {
            return;
        }
        Object uiScope$iv2 = callback.getUiScope();
        boolean $i$f$awaitUiResultWithPending = false;
        uiScope$iv2 = (Iterable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends FolderCallback.FileConflict>>, Object>(uiScope$iv2, null, callback, targetFolder, conflictedFiles){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FolderCallback $callback$inlined;
            final /* synthetic */ DocumentFile $targetFolder$inlined;
            final /* synthetic */ ArrayList $conflictedFiles$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = folderCallback;
                this.$targetFolder$inlined = documentFile;
                this.$conflictedFiles$inlined = arrayList;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$targetFolder$inlined, this.$conflictedFiles$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FolderCallback $callback$inlined;
                            final /* synthetic */ DocumentFile $targetFolder$inlined;
                            final /* synthetic */ ArrayList $conflictedFiles$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = folderCallback;
                                this.$targetFolder$inlined = documentFile;
                                this.$conflictedFiles$inlined = arrayList;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CancellableContinuation it = this.$it;
                                        boolean bl = false;
                                        this.$callback$inlined.onContentConflict(this.$targetFolder$inlined, this.$conflictedFiles$inlined, new FolderCallback.FolderContentConflictAction((CancellableContinuation<? super List<FolderCallback.FileConflict>>)it));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends FolderCallback.FileConflict>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        boolean $i$f$filter = false;
        newFolder = $this$filter$iv;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FolderCallback.FileConflict it = (FolderCallback.FileConflict)element$iv$iv;
            boolean bl = false;
            if (it.getSolution() == FileCallback.ConflictResolution.SKIP) {
                if (deleteSourceWhenComplete) {
                    it.getSource().delete();
                }
                int n = totalCopiedFiles.element;
                totalCopiedFiles.element = n + 1;
            }
            if (!(it.getSolution() != FileCallback.ConflictResolution.SKIP)) continue;
            destination$iv$iv22.add(element$iv$iv);
        }
        List solutions = (List)destination$iv$iv22;
        long leftoverSize = totalSizeToCopy.element - bytesMoved.element;
        iterator = solutions;
        boolean destination$iv$iv22 = false;
        startTimer2.invoke((Object)(!iterator.isEmpty() && leftoverSize > 0xA00000L ? 1 : 0));
        for (FolderCallback.FileConflict conflict : solutions) {
            Object filename;
            if (Thread.currentThread().isInterrupted()) {
                notifyCanceled2.invoke((Object)FolderCallback.ErrorCode.CANCELED);
                return;
            }
            if (!conflict.getSource().isFile()) continue;
            Object object = conflict.getTarget().getName();
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                object2 = filename = "";
            }
            if (conflict.getSolution() == FileCallback.ConflictResolution.REPLACE) {
                object = conflict.getTarget();
                bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                if (!it.delete() || it.exists()) continue;
            }
            Object object3 = targetFile.element = (object = conflict.getTarget().getParentFile()) == null ? null : DocumentFileUtils.makeFile$default((DocumentFile)object, context, (String)filename, null, null, 12, null);
            if (targetFile.element == null) {
                notifyCanceled2.invoke((Object)FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                return;
            }
            try {
                copy2.invoke((Object)conflict.getSource(), targetFile.element);
            }
            catch (Exception e) {
                if (((Boolean)handleError2.invoke((Object)e)).booleanValue()) {
                    return;
                }
                success.element = false;
                break;
            }
        }
        finalize2.invoke();
    }

    static /* synthetic */ void copyFolderTo$default(DocumentFile documentFile, Context context, DocumentFile documentFile2, boolean bl, String string2, boolean bl2, FolderCallback folderCallback, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        DocumentFileUtils.copyFolderTo(documentFile, context, documentFile2, bl, string2, bl2, folderCallback);
    }

    private static final FolderCallback.ErrorCode toFolderCallbackErrorCode(Exception $this$toFolderCallbackErrorCode) {
        Exception exception = $this$toFolderCallbackErrorCode;
        return exception instanceof SecurityException ? FolderCallback.ErrorCode.STORAGE_PERMISSION_DENIED : ((exception instanceof InterruptedIOException ? true : exception instanceof InterruptedException) ? FolderCallback.ErrorCode.CANCELED : FolderCallback.ErrorCode.UNKNOWN_IO_ERROR);
    }

    private static final MultipleFileCallback.ErrorCode toMultipleFileCallbackErrorCode(Exception $this$toMultipleFileCallbackErrorCode) {
        Exception exception = $this$toMultipleFileCallbackErrorCode;
        return exception instanceof SecurityException ? MultipleFileCallback.ErrorCode.STORAGE_PERMISSION_DENIED : ((exception instanceof InterruptedIOException ? true : exception instanceof InterruptedException) ? MultipleFileCallback.ErrorCode.CANCELED : MultipleFileCallback.ErrorCode.UNKNOWN_IO_ERROR);
    }

    private static final DocumentFile doesMeetCopyRequirements(DocumentFile $this$doesMeetCopyRequirements, Context context, DocumentFile targetParentFolder, String newFolderNameInTargetPath, FolderCallback callback) {
        boolean bl;
        Object $this$postToUi$iv = callback.getUiScope();
        boolean $i$f$postToUi = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ FolderCallback $callback$inlined;
            {
                this.$callback$inlined = folderCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onValidate();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        if (!$this$doesMeetCopyRequirements.isDirectory()) {
            $this$postToUi$iv = callback.getUiScope();
            $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FolderCallback $callback$inlined;
                {
                    this.$callback$inlined = folderCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FolderCallback.ErrorCode.SOURCE_FOLDER_NOT_FOUND);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        if (!targetParentFolder.isDirectory()) {
            $this$postToUi$iv = callback.getUiScope();
            $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FolderCallback $callback$inlined;
                {
                    this.$callback$inlined = folderCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FolderCallback.ErrorCode.INVALID_TARGET_FOLDER);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        if (!$this$doesMeetCopyRequirements.canRead() || !DocumentFileUtils.isWritable(targetParentFolder, context)) {
            $this$postToUi$iv = callback.getUiScope();
            $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FolderCallback $callback$inlined;
                {
                    this.$callback$inlined = folderCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FolderCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        if (Intrinsics.areEqual((Object)DocumentFileUtils.getAbsolutePath(targetParentFolder, context), ($this$postToUi$iv = $this$doesMeetCopyRequirements.getParentFile()) == null ? null : DocumentFileUtils.getAbsolutePath((DocumentFile)$this$postToUi$iv, context))) {
            $this$postToUi$iv = newFolderNameInTargetPath;
            $i$f$postToUi = false;
            bl = false;
            if ($this$postToUi$iv == null || $this$postToUi$iv.length() == 0 || Intrinsics.areEqual((Object)$this$doesMeetCopyRequirements.getName(), (Object)newFolderNameInTargetPath)) {
                $this$postToUi$iv = callback.getUiScope();
                $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FolderCallback $callback$inlined;
                    {
                        this.$callback$inlined = folderCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FolderCallback.ErrorCode.TARGET_FOLDER_CANNOT_HAVE_SAME_PATH_WITH_SOURCE_FOLDER);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return null;
            }
        }
        DocumentFile $i$f$postToUi2 = targetParentFolder;
        bl = false;
        boolean bl2 = false;
        DocumentFile it = $i$f$postToUi2;
        boolean bl3 = false;
        DocumentFile writableFolder = DocumentFileUtils.isDownloadsDocument(it) ? DocumentFileUtils.toWritableDownloadsDocumentFile(it, context) : it;
        if (writableFolder == null) {
            CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
            boolean $i$f$postToUi3 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FolderCallback $callback$inlined;
                {
                    this.$callback$inlined = folderCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FolderCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return writableFolder;
    }

    @WorkerThread
    public static final void copyFileTo(@NotNull DocumentFile $this$copyFileTo, @NotNull Context context, @NotNull File targetFolder, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String string2 = targetFolder.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetFolder.absolutePath");
        DocumentFileUtils.copyFileTo($this$copyFileTo, context, string2, fileDescription, callback);
    }

    public static /* synthetic */ void copyFileTo$default(DocumentFile documentFile, Context context, File file, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            fileDescription = null;
        }
        DocumentFileUtils.copyFileTo(documentFile, context, file, fileDescription, fileCallback);
    }

    @WorkerThread
    public static final void copyFileTo(@NotNull DocumentFile $this$copyFileTo, @NotNull Context context, @NotNull String targetFolderAbsolutePath, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolderAbsolutePath, (String)"targetFolderAbsolutePath");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFile targetFolder = DocumentFileCompat.mkdirs$default(context, targetFolderAbsolutePath, true, false, 8, null);
        if (targetFolder == null) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            DocumentFileUtils.copyFileTo($this$copyFileTo, context, targetFolder, fileDescription, callback);
        }
    }

    public static /* synthetic */ void copyFileTo$default(DocumentFile documentFile, Context context, String string2, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            fileDescription = null;
        }
        DocumentFileUtils.copyFileTo(documentFile, context, string2, fileDescription, fileCallback);
    }

    @WorkerThread
    public static final void copyFileTo(@NotNull DocumentFile $this$copyFileTo, @NotNull Context context, @NotNull DocumentFile targetFolder, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Object object = fileDescription;
        object = object == null ? null : ((FileDescription)object).getSubFolder();
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || object.length() == 0) {
            object = fileDescription;
            String string2 = object == null ? null : ((FileDescription)object).getName();
            object = fileDescription;
            DocumentFileUtils.copyFileTo($this$copyFileTo, context, targetFolder, string2, object == null ? null : ((FileDescription)object).getMimeType(), callback);
        } else {
            Object object2 = fileDescription;
            object2 = object2 == null ? null : ((FileDescription)object2).getSubFolder();
            bl2 = false;
            Object object3 = object2;
            if (object3 == null) {
                object3 = "";
            }
            DocumentFile targetDirectory = DocumentFileUtils.makeFolder(targetFolder, context, (String)object3, CreateMode.REUSE);
            if (targetDirectory == null) {
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                object2 = fileDescription;
                String string3 = object2 == null ? null : ((FileDescription)object2).getName();
                object2 = fileDescription;
                DocumentFileUtils.copyFileTo($this$copyFileTo, context, targetDirectory, string3, object2 == null ? null : ((FileDescription)object2).getMimeType(), callback);
            }
        }
    }

    public static /* synthetic */ void copyFileTo$default(DocumentFile documentFile, Context context, DocumentFile documentFile2, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            fileDescription = null;
        }
        DocumentFileUtils.copyFileTo(documentFile, context, documentFile2, fileDescription, fileCallback);
    }

    private static final void copyFileTo(DocumentFile $this$copyFileTo, Context context, DocumentFile targetFolder, String newFilenameInTargetPath, String newMimeTypeInTargetPath, FileCallback callback) {
        String string2;
        DocumentFile documentFile = DocumentFileUtils.doesMeetCopyRequirements($this$copyFileTo, context, targetFolder, newFilenameInTargetPath, callback);
        if (documentFile == null) {
            return;
        }
        DocumentFile writableTargetFolder = documentFile;
        CoroutineScope $this$postToUi$iv = callback.getUiScope();
        boolean $i$f$postToUi = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ FileCallback $callback$inlined;
            {
                this.$callback$inlined = fileCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onPrepare();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        try {
            if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context, DocumentFileUtils.getStorageId(writableTargetFolder, context)), $this$copyFileTo.length())) {
                $this$postToUi$iv = callback.getUiScope();
                $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        catch (Throwable e) {
            CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
            boolean $i$f$postToUi2 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        String $this$postToUi$iv2 = newFilenameInTargetPath;
        if ($this$postToUi$iv2 == null) {
            String $i$f$postToUi2 = $this$copyFileTo.getName();
            boolean bl = false;
            string2 = $i$f$postToUi2;
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = $this$postToUi$iv2;
        }
        $this$postToUi$iv2 = newMimeTypeInTargetPath;
        String cleanFileName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(MimeType.getFullFileName(string2, $this$postToUi$iv2 == null ? DocumentFileUtils.getMimeTypeByFileName($this$copyFileTo) : $this$postToUi$iv2)));
        FileCallback.ConflictResolution fileConflictResolution = DocumentFileUtils.handleFileConflict(context, writableTargetFolder, cleanFileName, callback);
        if (fileConflictResolution == FileCallback.ConflictResolution.SKIP) {
            return;
        }
        Thread thread = Thread.currentThread();
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, $this$copyFileTo, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FileCallback $callback$inlined;
            final /* synthetic */ DocumentFile $this_copyFileTo$inlined;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = fileCallback;
                this.$this_copyFileTo$inlined = documentFile;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$this_copyFileTo$inlined, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ DocumentFile $this_copyFileTo$inlined;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = fileCallback;
                                this.$this_copyFileTo$inlined = documentFile;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Long l;
                                        ResultKt.throwOnFailure((Object)object);
                                        Result.Companion companion = Result.Companion;
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        Long l2 = l = Boxing.boxLong((long)this.$callback$inlined.onStart(this.$this_copyFileTo$inlined, this.$thread$inlined));
                                        boolean bl2 = false;
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)l2));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        if (reportInterval < 0L) {
            return;
        }
        boolean watchProgress = reportInterval > 0L;
        try {
            String string3 = newMimeTypeInTargetPath;
            DocumentFile documentFile2 = DocumentFileUtils.createTargetFile(context, writableTargetFolder, cleanFileName, string3 == null ? DocumentFileUtils.getMimeTypeByFileName($this$copyFileTo) : string3, fileConflictResolution.toCreateMode(), callback);
            if (documentFile2 == null) {
                return;
            }
            DocumentFile targetFile = documentFile2;
            DocumentFileUtils.createFileStreams(context, $this$copyFileTo, targetFile, (BaseFileCallback)callback, (Function2<? super InputStream, ? super OutputStream, Unit>)((Function2)new Function2<InputStream, OutputStream, Unit>($this$copyFileTo, targetFile, watchProgress, reportInterval, callback){
                final /* synthetic */ DocumentFile $this_copyFileTo;
                final /* synthetic */ DocumentFile $targetFile;
                final /* synthetic */ boolean $watchProgress;
                final /* synthetic */ long $reportInterval;
                final /* synthetic */ FileCallback $callback;
                {
                    this.$this_copyFileTo = $receiver;
                    this.$targetFile = $targetFile;
                    this.$watchProgress = $watchProgress;
                    this.$reportInterval = $reportInterval;
                    this.$callback = $callback;
                    super(2);
                }

                public final void invoke(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
                    Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    DocumentFileUtils.access$copyFileStream(this.$this_copyFileTo, inputStream, outputStream, this.$targetFile, this.$watchProgress, this.$reportInterval, false, this.$callback);
                }
            }));
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
            boolean $i$f$postToUi3 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private static final DocumentFile doesMeetCopyRequirements(DocumentFile $this$doesMeetCopyRequirements, Context context, DocumentFile targetFolder, String newFilenameInTargetPath, FileCallback callback) {
        boolean bl;
        Object $this$postToUi$iv = callback.getUiScope();
        boolean $i$f$postToUi = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ FileCallback $callback$inlined;
            {
                this.$callback$inlined = fileCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onValidate();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        if (!$this$doesMeetCopyRequirements.isFile()) {
            $this$postToUi$iv = callback.getUiScope();
            $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        if (!targetFolder.isDirectory()) {
            $this$postToUi$iv = callback.getUiScope();
            $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FOLDER_NOT_FOUND);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        if (!$this$doesMeetCopyRequirements.canRead() || !DocumentFileUtils.isWritable(targetFolder, context)) {
            $this$postToUi$iv = callback.getUiScope();
            $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return null;
        }
        $this$postToUi$iv = $this$doesMeetCopyRequirements.getParentFile();
        if (Intrinsics.areEqual((Object)($this$postToUi$iv == null ? null : DocumentFileUtils.getAbsolutePath((DocumentFile)$this$postToUi$iv, context)), (Object)DocumentFileUtils.getAbsolutePath(targetFolder, context))) {
            $this$postToUi$iv = newFilenameInTargetPath;
            $i$f$postToUi = false;
            bl = false;
            if ($this$postToUi$iv == null || $this$postToUi$iv.length() == 0 || Intrinsics.areEqual((Object)$this$doesMeetCopyRequirements.getName(), (Object)newFilenameInTargetPath)) {
                $this$postToUi$iv = callback.getUiScope();
                $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FOLDER_CANNOT_HAVE_SAME_PATH_WITH_SOURCE_FOLDER);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return null;
            }
        }
        DocumentFile $i$f$postToUi2 = targetFolder;
        bl = false;
        boolean bl2 = false;
        DocumentFile it = $i$f$postToUi2;
        boolean bl3 = false;
        DocumentFile writableFolder = DocumentFileUtils.isDownloadsDocument(it) ? DocumentFileUtils.toWritableDownloadsDocumentFile(it, context) : it;
        if (writableFolder == null) {
            CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
            boolean $i$f$postToUi3 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return writableFolder;
    }

    private static final <Enum> void createFileStreams(Context context, DocumentFile sourceFile, DocumentFile targetFile, BaseFileCallback<Enum, ?, ?> callback, Function2<? super InputStream, ? super OutputStream, Unit> onStreamsReady) {
        OutputStream outputStream = DocumentFileUtils.openOutputStream$default(targetFile, context, false, 2, null);
        if (outputStream == null) {
            BaseFileCallback<Enum, ?, ?> baseFileCallback = callback;
            Enum errorCode = baseFileCallback instanceof MultipleFileCallback ? (Enum)MultipleFileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET : (baseFileCallback instanceof FolderCallback ? (Enum)FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET : (Enum)FileCallback.ErrorCode.TARGET_FILE_NOT_FOUND);
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, errorCode){
                int label;
                final /* synthetic */ BaseFileCallback $callback$inlined;
                final /* synthetic */ Enum $errorCode$inlined;
                {
                    this.$callback$inlined = baseFileCallback;
                    this.$errorCode$inlined = enum_;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(this.$errorCode$inlined);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        InputStream inputStream = DocumentFileUtils.openInputStream(sourceFile, context);
        if (inputStream == null) {
            IOUtils.closeStream(outputStream);
            BaseFileCallback<Enum, ?, ?> $i$f$postToUi = callback;
            Enum errorCode = $i$f$postToUi instanceof MultipleFileCallback ? (Enum)MultipleFileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND : ($i$f$postToUi instanceof FolderCallback ? (Enum)FolderCallback.ErrorCode.SOURCE_FILE_NOT_FOUND : (Enum)FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi2 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, errorCode){
                int label;
                final /* synthetic */ BaseFileCallback $callback$inlined;
                final /* synthetic */ Enum $errorCode$inlined;
                {
                    this.$callback$inlined = baseFileCallback;
                    this.$errorCode$inlined = enum_;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(this.$errorCode$inlined);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        onStreamsReady.invoke((Object)inputStream, (Object)outputStream);
    }

    private static final void createFileStreams(Context context, DocumentFile sourceFile, MediaFile targetFile, FileCallback callback, Function2<? super InputStream, ? super OutputStream, Unit> onStreamsReady) {
        boolean $i$f$createFileStreams = false;
        OutputStream outputStream = MediaFile.openOutputStream$default(targetFile, false, 1, null);
        if (outputStream == null) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FILE_NOT_FOUND);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invokeSuspend$$forInline(@NotNull Object $result) {
                    boolean bl = false;
                    this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FILE_NOT_FOUND);
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        InputStream inputStream = DocumentFileUtils.openInputStream(sourceFile, context);
        if (inputStream == null) {
            IOUtils.closeStream(outputStream);
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invokeSuspend$$forInline(@NotNull Object $result) {
                    boolean bl = false;
                    this.$callback$inlined.onFailed(FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        onStreamsReady.invoke((Object)inputStream, (Object)outputStream);
    }

    private static final DocumentFile createTargetFile(Context context, DocumentFile targetFolder, String newFilenameInTargetPath, String mimeType, CreateMode mode, FileCallback callback) {
        DocumentFile targetFile = DocumentFileUtils.makeFile(targetFolder, context, newFilenameInTargetPath, mimeType, mode);
        if (targetFile == null) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void copyFileStream(DocumentFile $this$copyFileStream, InputStream inputStream, OutputStream outputStream, Object targetFile, boolean watchProgress, long reportInterval, boolean deleteSourceFileWhenComplete, FileCallback callback) {
        block9: {
            Job job;
            block8: {
                Job timer2 = null;
                try {
                    Ref.LongRef bytesMoved = new Ref.LongRef();
                    Ref.IntRef writeSpeed = new Ref.IntRef();
                    long srcSize = $this$copyFileStream.length();
                    if (watchProgress && srcSize > 0xA00000L) {
                        timer2 = CoroutineExtKt.startCoroutineTimer$default(0L, reportInterval, false, (Function0)new Function0<Unit>(bytesMoved, srcSize, writeSpeed, callback){
                            final /* synthetic */ Ref.LongRef $bytesMoved;
                            final /* synthetic */ long $srcSize;
                            final /* synthetic */ Ref.IntRef $writeSpeed;
                            final /* synthetic */ FileCallback $callback;
                            {
                                this.$bytesMoved = $bytesMoved;
                                this.$srcSize = $srcSize;
                                this.$writeSpeed = $writeSpeed;
                                this.$callback = $callback;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                void $this$postToUi$iv;
                                FileCallback.Report report = new FileCallback.Report((float)this.$bytesMoved.element * 100.0f / (float)this.$srcSize, this.$bytesMoved.element, this.$writeSpeed.element);
                                CoroutineScope coroutineScope = this.$callback.getUiScope();
                                FileCallback fileCallback = this.$callback;
                                boolean $i$f$postToUi = false;
                                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, fileCallback, report){
                                    int label;
                                    final /* synthetic */ FileCallback $callback$inlined;
                                    final /* synthetic */ FileCallback.Report $report$inlined;
                                    {
                                        this.$callback$inlined = fileCallback;
                                        this.$report$inlined = report;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                boolean bl = false;
                                                this.$callback$inlined.onReport(this.$report$inlined);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)2, null);
                                this.$writeSpeed.element = 0;
                            }
                        }, 5, null);
                    }
                    byte[] buffer = new byte[1024];
                    int read = inputStream.read(buffer);
                    while (read != -1) {
                        outputStream.write(buffer, 0, read);
                        bytesMoved.element += (long)read;
                        writeSpeed.element += read;
                        read = inputStream.read(buffer);
                    }
                    Job job2 = timer2;
                    if (job2 != null) {
                        Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                    }
                    if (deleteSourceFileWhenComplete) {
                        $this$copyFileStream.delete();
                    }
                    if (targetFile instanceof MediaFile) {
                        ((MediaFile)targetFile).setLength(srcSize);
                    }
                    CoroutineScope $this$postToUi$iv = callback.getUiScope();
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, targetFile){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        final /* synthetic */ Object $targetFile$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            this.$targetFile$inlined = object;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onCompleted(this.$targetFile$inlined);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    job = timer2;
                    if (job != null) break block8;
                    break block9;
                }
                catch (Throwable throwable) {
                    Job job3 = timer2;
                    if (job3 != null) {
                        Job.DefaultImpls.cancel$default(job3, null, (int)1, null);
                    }
                    IOUtils.closeStream(inputStream);
                    IOUtils.closeStream(outputStream);
                    throw throwable;
                }
            }
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        IOUtils.closeStream(inputStream);
        IOUtils.closeStream(outputStream);
    }

    @WorkerThread
    public static final void moveFileTo(@NotNull DocumentFile $this$moveFileTo, @NotNull Context context, @NotNull File targetFolder, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String string2 = targetFolder.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetFolder.absolutePath");
        DocumentFileUtils.moveFileTo($this$moveFileTo, context, string2, fileDescription, callback);
    }

    public static /* synthetic */ void moveFileTo$default(DocumentFile documentFile, Context context, File file, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            fileDescription = null;
        }
        DocumentFileUtils.moveFileTo(documentFile, context, file, fileDescription, fileCallback);
    }

    @WorkerThread
    public static final void moveFileTo(@NotNull DocumentFile $this$moveFileTo, @NotNull Context context, @NotNull String targetFolderAbsolutePath, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolderAbsolutePath, (String)"targetFolderAbsolutePath");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFile targetFolder = DocumentFileCompat.mkdirs$default(context, targetFolderAbsolutePath, true, false, 8, null);
        if (targetFolder == null) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            DocumentFileUtils.moveFileTo($this$moveFileTo, context, targetFolder, fileDescription, callback);
        }
    }

    public static /* synthetic */ void moveFileTo$default(DocumentFile documentFile, Context context, String string2, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            fileDescription = null;
        }
        DocumentFileUtils.moveFileTo(documentFile, context, string2, fileDescription, fileCallback);
    }

    @WorkerThread
    public static final void moveFileTo(@NotNull DocumentFile $this$moveFileTo, @NotNull Context context, @NotNull DocumentFile targetFolder, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Object object = fileDescription;
        object = object == null ? null : ((FileDescription)object).getSubFolder();
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || object.length() == 0) {
            object = fileDescription;
            String string2 = object == null ? null : ((FileDescription)object).getName();
            object = fileDescription;
            DocumentFileUtils.moveFileTo($this$moveFileTo, context, targetFolder, string2, object == null ? null : ((FileDescription)object).getMimeType(), callback);
        } else {
            Object object2 = fileDescription;
            object2 = object2 == null ? null : ((FileDescription)object2).getSubFolder();
            bl2 = false;
            Object object3 = object2;
            if (object3 == null) {
                object3 = "";
            }
            DocumentFile targetDirectory = DocumentFileUtils.makeFolder(targetFolder, context, (String)object3, CreateMode.REUSE);
            if (targetDirectory == null) {
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                object2 = fileDescription;
                String string3 = object2 == null ? null : ((FileDescription)object2).getName();
                object2 = fileDescription;
                DocumentFileUtils.moveFileTo($this$moveFileTo, context, targetDirectory, string3, object2 == null ? null : ((FileDescription)object2).getMimeType(), callback);
            }
        }
    }

    public static /* synthetic */ void moveFileTo$default(DocumentFile documentFile, Context context, DocumentFile documentFile2, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 4) != 0) {
            fileDescription = null;
        }
        DocumentFileUtils.moveFileTo(documentFile, context, documentFile2, fileDescription, fileCallback);
    }

    private static final void moveFileTo(DocumentFile $this$moveFileTo, Context context, DocumentFile targetFolder, String newFilenameInTargetPath, String newMimeTypeInTargetPath, FileCallback callback) {
        boolean it2;
        Object $i$f$postToUi4;
        Object $this$postToUi$iv;
        File file;
        Object object;
        Object object2;
        DocumentFile documentFile = DocumentFileUtils.doesMeetCopyRequirements($this$moveFileTo, context, targetFolder, newFilenameInTargetPath, callback);
        if (documentFile == null) {
            return;
        }
        DocumentFile writableTargetFolder = documentFile;
        CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
        boolean $i$f$postToUi22 = false;
        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
            int label;
            final /* synthetic */ FileCallback $callback$inlined;
            {
                this.$callback$inlined = fileCallback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean bl = false;
                        this.$callback$inlined.onPrepare();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        String $i$f$postToUi22 = newFilenameInTargetPath;
        if ($i$f$postToUi22 == null) {
            object2 = $this$moveFileTo.getName();
            boolean bl = false;
            object = object2;
            if (object == null) {
                object = "";
            }
        } else {
            object = $i$f$postToUi22;
        }
        $i$f$postToUi22 = newMimeTypeInTargetPath;
        String cleanFileName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(MimeType.getFullFileName((String)object, $i$f$postToUi22 == null ? DocumentFileUtils.getMimeTypeByFileName($this$moveFileTo) : $i$f$postToUi22)));
        FileCallback.ConflictResolution fileConflictResolution = DocumentFileUtils.handleFileConflict(context, writableTargetFolder, cleanFileName, callback);
        if (fileConflictResolution == FileCallback.ConflictResolution.SKIP) {
            return;
        }
        if (DocumentFileUtils.inInternalStorage($this$moveFileTo, context) && (object2 = DocumentFileUtils.toRawFile($this$moveFileTo, context)) != null && (file = FileUtils.moveTo((File)object2, context, DocumentFileUtils.getAbsolutePath(writableTargetFolder, context), cleanFileName, fileConflictResolution)) != null) {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it2 = file2;
            boolean bl3 = false;
            CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
            boolean $i$f$postToUi3 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, it2){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ File $it$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$it$inlined = file;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            DocumentFile documentFile = DocumentFile.fromFile((File)this.$it$inlined);
                            Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(it)");
                            this.$callback$inlined.onCompleted(documentFile);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        String targetStorageId = DocumentFileUtils.getStorageId(writableTargetFolder, context);
        if (DocumentFileUtils.isExternalStorageManager($this$moveFileTo, context) && Intrinsics.areEqual((Object)DocumentFileUtils.getStorageId($this$moveFileTo, context), (Object)targetStorageId)) {
            File sourceFile = DocumentFileUtils.toRawFile($this$moveFileTo, context);
            if (sourceFile == null) {
                CoroutineScope $this$postToUi$iv4 = callback.getUiScope();
                boolean $i$f$postToUi4 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv4, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            $this$postToUi$iv = DocumentFileUtils.toRawFile(writableTargetFolder, context);
            if ($this$postToUi$iv != null) {
                $i$f$postToUi4 = $this$postToUi$iv;
                boolean bl = false;
                it2 = false;
                Object destinationFolder = $i$f$postToUi4;
                boolean bl4 = false;
                File $i$f$postToUi3 = FileUtils.moveTo(sourceFile, context, (File)destinationFolder, cleanFileName, fileConflictResolution);
                if ($i$f$postToUi3 != null) {
                    File file3 = $i$f$postToUi3;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    File it3 = file3;
                    boolean bl7 = false;
                    CoroutineScope $this$postToUi$iv5 = callback.getUiScope();
                    boolean $i$f$postToUi5 = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv5, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, it3){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        final /* synthetic */ File $it$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            this.$it$inlined = file;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    DocumentFile documentFile = DocumentFile.fromFile((File)this.$it$inlined);
                                    Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(it)");
                                    this.$callback$inlined.onCompleted(documentFile);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    return;
                }
            }
        }
        try {
            if (Build.VERSION.SDK_INT >= 24 && !DocumentFileUtils.isRawFile($this$moveFileTo) && DocumentFileUtils.isTreeDocumentFile(writableTargetFolder) && Intrinsics.areEqual((Object)DocumentFileUtils.getStorageId($this$moveFileTo, context), (Object)targetStorageId)) {
                Uri uri;
                $this$postToUi$iv = $this$moveFileTo.getParentFile();
                if ($this$postToUi$iv == null) {
                    uri = null;
                } else {
                    $i$f$postToUi4 = $this$postToUi$iv.getUri();
                    if ($i$f$postToUi4 == null) {
                        uri = null;
                    } else {
                        Object object3 = $i$f$postToUi4;
                        it2 = false;
                        boolean destinationFolder = false;
                        Object it4 = object3;
                        boolean bl = false;
                        uri = DocumentsContract.moveDocument((ContentResolver)context.getContentResolver(), (Uri)$this$moveFileTo.getUri(), (Uri)it4, (Uri)writableTargetFolder.getUri());
                    }
                }
                Uri movedFileUri = uri;
                if (movedFileUri != null) {
                    CoroutineScope $this$postToUi$iv6;
                    DocumentFile newFile = ContextUtils.fromTreeUri(context, movedFileUri);
                    if (newFile != null && newFile.isFile()) {
                        if (newFilenameInTargetPath != null) {
                            newFile.renameTo(cleanFileName);
                        }
                        $this$postToUi$iv6 = callback.getUiScope();
                        boolean $i$f$postToUi6 = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv6, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, newFile){
                            int label;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ DocumentFile $newFile$inlined;
                            {
                                this.$callback$inlined = fileCallback;
                                this.$newFile$inlined = documentFile;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onCompleted(this.$newFile$inlined);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    } else {
                        $this$postToUi$iv6 = callback.getUiScope();
                        boolean $i$f$postToUi7 = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv6, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                            int label;
                            final /* synthetic */ FileCallback $callback$inlined;
                            {
                                this.$callback$inlined = fileCallback;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FILE_NOT_FOUND);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                    return;
                }
            }
            if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context, targetStorageId), $this$moveFileTo.length())) {
                CoroutineScope $this$postToUi$iv7 = callback.getUiScope();
                boolean $i$f$postToUi8 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv7, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        catch (Throwable e) {
            $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi9 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Thread thread = Thread.currentThread();
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, $this$moveFileTo, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FileCallback $callback$inlined;
            final /* synthetic */ DocumentFile $this_moveFileTo$inlined;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = fileCallback;
                this.$this_moveFileTo$inlined = documentFile;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$this_moveFileTo$inlined, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ DocumentFile $this_moveFileTo$inlined;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = fileCallback;
                                this.$this_moveFileTo$inlined = documentFile;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Long l;
                                        ResultKt.throwOnFailure((Object)object);
                                        Result.Companion companion = Result.Companion;
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        Long l2 = l = Boxing.boxLong((long)this.$callback$inlined.onStart(this.$this_moveFileTo$inlined, this.$thread$inlined));
                                        boolean bl2 = false;
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)l2));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        if (reportInterval < 0L) {
            return;
        }
        boolean watchProgress = reportInterval > 0L;
        try {
            String it4 = newMimeTypeInTargetPath;
            DocumentFile destinationFolder = DocumentFileUtils.createTargetFile(context, writableTargetFolder, cleanFileName, it4 == null ? DocumentFileUtils.getMimeTypeByFileName($this$moveFileTo) : it4, fileConflictResolution.toCreateMode(), callback);
            if (destinationFolder == null) {
                return;
            }
            DocumentFile targetFile = destinationFolder;
            DocumentFileUtils.createFileStreams(context, $this$moveFileTo, targetFile, (BaseFileCallback)callback, (Function2<? super InputStream, ? super OutputStream, Unit>)((Function2)new Function2<InputStream, OutputStream, Unit>($this$moveFileTo, targetFile, watchProgress, reportInterval, callback){
                final /* synthetic */ DocumentFile $this_moveFileTo;
                final /* synthetic */ DocumentFile $targetFile;
                final /* synthetic */ boolean $watchProgress;
                final /* synthetic */ long $reportInterval;
                final /* synthetic */ FileCallback $callback;
                {
                    this.$this_moveFileTo = $receiver;
                    this.$targetFile = $targetFile;
                    this.$watchProgress = $watchProgress;
                    this.$reportInterval = $reportInterval;
                    this.$callback = $callback;
                    super(2);
                }

                public final void invoke(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
                    Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    DocumentFileUtils.access$copyFileStream(this.$this_moveFileTo, inputStream, outputStream, this.$targetFile, this.$watchProgress, this.$reportInterval, true, this.$callback);
                }
            }));
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv8 = callback.getUiScope();
            boolean $i$f$postToUi10 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv8, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private static final boolean simpleCheckSourceFile(DocumentFile $this$simpleCheckSourceFile, FileCallback callback) {
        if (!$this$simpleCheckSourceFile.isFile()) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return true;
        }
        if (!$this$simpleCheckSourceFile.canRead()) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return true;
        }
        return false;
    }

    private static final void copyFileToMedia(DocumentFile $this$copyFileToMedia, Context context, FileDescription fileDescription, FileCallback callback, PublicDirectory publicDirectory, boolean deleteSourceFileWhenComplete, CreateMode mode) {
        DocumentFile documentFile;
        if (DocumentFileUtils.simpleCheckSourceFile($this$copyFileToMedia, callback)) {
            return;
        }
        DocumentFile publicFolder = DocumentFileCompat.fromPublicFolder$default(context, publicDirectory, fileDescription.getSubFolder(), true, false, 16, null);
        if (Build.VERSION.SDK_INT < 29 || deleteSourceFileWhenComplete && !DocumentFileUtils.isRawFile($this$copyFileToMedia) && ((documentFile = publicFolder) == null ? false : DocumentFileUtils.isTreeDocumentFile(documentFile))) {
            CoroutineScope $this$postToUi$iv;
            if (publicFolder == null) {
                $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            $this$postToUi$iv = DocumentFileUtils.child$default(publicFolder, context, fileDescription.getFullName(), false, 4, null);
            if ($this$postToUi$iv != null) {
                CoroutineScope $i$f$postToUi = $this$postToUi$iv;
                boolean bl = false;
                boolean bl2 = false;
                CoroutineScope it = $i$f$postToUi;
                boolean bl3 = false;
                if (mode == CreateMode.REPLACE) {
                    if (!DocumentFileUtils.forceDelete$default((DocumentFile)it, context, false, 2, null)) {
                        CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
                        boolean $i$f$postToUi2 = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                            int label;
                            final /* synthetic */ FileCallback $callback$inlined;
                            {
                                this.$callback$inlined = fileCallback;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return;
                    }
                } else {
                    String string2 = it.getName();
                    boolean bl4 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        string3 = "";
                    }
                    fileDescription.setName(DocumentFileUtils.autoIncrementFileName(publicFolder, context, string3));
                }
            }
            fileDescription.setSubFolder("");
            if (deleteSourceFileWhenComplete) {
                DocumentFileUtils.moveFileTo($this$copyFileToMedia, context, publicFolder, fileDescription, callback);
            } else {
                DocumentFileUtils.copyFileTo($this$copyFileToMedia, context, publicFolder, fileDescription, callback);
            }
        } else {
            MediaFile mediaFile;
            CreateMode validMode = mode == CreateMode.REUSE ? CreateMode.CREATE_NEW : mode;
            MediaFile mediaFile2 = mediaFile = publicDirectory == PublicDirectory.DOWNLOADS ? MediaStoreCompat.createDownload(context, fileDescription, validMode) : MediaStoreCompat.createImage$default(context, fileDescription, null, validMode, 4, null);
            if (mediaFile == null) {
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                DocumentFileUtils.copyFileTo($this$copyFileToMedia, context, mediaFile, deleteSourceFileWhenComplete, callback);
            }
        }
    }

    @WorkerThread
    @JvmOverloads
    public static final void copyFileToDownloadMedia(@NotNull DocumentFile $this$copyFileToDownloadMedia, @NotNull Context context, @NotNull FileDescription fileDescription, @NotNull FileCallback callback, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFileToDownloadMedia, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescription, (String)"fileDescription");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        DocumentFileUtils.copyFileToMedia($this$copyFileToDownloadMedia, context, fileDescription, callback, PublicDirectory.DOWNLOADS, false, mode);
    }

    public static /* synthetic */ void copyFileToDownloadMedia$default(DocumentFile documentFile, Context context, FileDescription fileDescription, FileCallback fileCallback, CreateMode createMode, int n, Object object) {
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        DocumentFileUtils.copyFileToDownloadMedia(documentFile, context, fileDescription, fileCallback, createMode);
    }

    @WorkerThread
    @JvmOverloads
    public static final void copyFileToPictureMedia(@NotNull DocumentFile $this$copyFileToPictureMedia, @NotNull Context context, @NotNull FileDescription fileDescription, @NotNull FileCallback callback, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFileToPictureMedia, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescription, (String)"fileDescription");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        DocumentFileUtils.copyFileToMedia($this$copyFileToPictureMedia, context, fileDescription, callback, PublicDirectory.PICTURES, false, mode);
    }

    public static /* synthetic */ void copyFileToPictureMedia$default(DocumentFile documentFile, Context context, FileDescription fileDescription, FileCallback fileCallback, CreateMode createMode, int n, Object object) {
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        DocumentFileUtils.copyFileToPictureMedia(documentFile, context, fileDescription, fileCallback, createMode);
    }

    @WorkerThread
    @JvmOverloads
    public static final void moveFileToDownloadMedia(@NotNull DocumentFile $this$moveFileToDownloadMedia, @NotNull Context context, @NotNull FileDescription fileDescription, @NotNull FileCallback callback, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFileToDownloadMedia, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescription, (String)"fileDescription");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        DocumentFileUtils.copyFileToMedia($this$moveFileToDownloadMedia, context, fileDescription, callback, PublicDirectory.DOWNLOADS, true, mode);
    }

    public static /* synthetic */ void moveFileToDownloadMedia$default(DocumentFile documentFile, Context context, FileDescription fileDescription, FileCallback fileCallback, CreateMode createMode, int n, Object object) {
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        DocumentFileUtils.moveFileToDownloadMedia(documentFile, context, fileDescription, fileCallback, createMode);
    }

    @WorkerThread
    @JvmOverloads
    public static final void moveFileToPictureMedia(@NotNull DocumentFile $this$moveFileToPictureMedia, @NotNull Context context, @NotNull FileDescription fileDescription, @NotNull FileCallback callback, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFileToPictureMedia, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescription, (String)"fileDescription");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        DocumentFileUtils.copyFileToMedia($this$moveFileToPictureMedia, context, fileDescription, callback, PublicDirectory.PICTURES, true, mode);
    }

    public static /* synthetic */ void moveFileToPictureMedia$default(DocumentFile documentFile, Context context, FileDescription fileDescription, FileCallback fileCallback, CreateMode createMode, int n, Object object) {
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        DocumentFileUtils.moveFileToPictureMedia(documentFile, context, fileDescription, fileCallback, createMode);
    }

    @WorkerThread
    public static final void moveFileTo(@NotNull DocumentFile $this$moveFileTo, @NotNull Context context, @NotNull MediaFile targetFile, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.copyFileTo($this$moveFileTo, context, targetFile, true, callback);
    }

    @WorkerThread
    public static final void copyFileTo(@NotNull DocumentFile $this$copyFileTo, @NotNull Context context, @NotNull MediaFile targetFile, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFileTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.copyFileTo($this$copyFileTo, context, targetFile, false, callback);
    }

    /*
     * WARNING - void declaration
     */
    private static final void copyFileTo(DocumentFile $this$copyFileTo, Context context, MediaFile targetFile, boolean deleteSourceFileWhenComplete, FileCallback callback) {
        if (DocumentFileUtils.simpleCheckSourceFile($this$copyFileTo, callback)) {
            return;
        }
        try {
            if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context, "primary"), $this$copyFileTo.length())) {
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        catch (Throwable e) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Thread thread = Thread.currentThread();
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, $this$copyFileTo, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FileCallback $callback$inlined;
            final /* synthetic */ DocumentFile $this_copyFileTo$inlined;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = fileCallback;
                this.$this_copyFileTo$inlined = documentFile;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$this_copyFileTo$inlined, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ DocumentFile $this_copyFileTo$inlined;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = fileCallback;
                                this.$this_copyFileTo$inlined = documentFile;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Long l;
                                        ResultKt.throwOnFailure((Object)object);
                                        Result.Companion companion = Result.Companion;
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        Long l2 = l = Boxing.boxLong((long)this.$callback$inlined.onStart(this.$this_copyFileTo$inlined, this.$thread$inlined));
                                        boolean bl2 = false;
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)l2));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        if (reportInterval < 0L) {
            return;
        }
        boolean watchProgress = reportInterval > 0L;
        try {
            boolean $i$f$createFileStreams = false;
            OutputStream outputStream$iv = MediaFile.openOutputStream$default(targetFile, false, 1, null);
            if (outputStream$iv == null) {
                CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
            } else {
                InputStream inputStream$iv = DocumentFileUtils.openInputStream($this$copyFileTo, context);
                if (inputStream$iv == null) {
                    IOUtils.closeStream(outputStream$iv);
                    CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
                } else {
                    void outputStream;
                    OutputStream outputStream2 = outputStream$iv;
                    InputStream inputStream = inputStream$iv;
                    boolean bl = false;
                    DocumentFileUtils.copyFileStream($this$copyFileTo, inputStream, (OutputStream)outputStream, targetFile, watchProgress, reportInterval, deleteSourceFileWhenComplete, callback);
                }
            }
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @NotNull
    public static final FileCallback.ErrorCode toFileCallbackErrorCode(@NotNull Exception $this$toFileCallbackErrorCode) {
        Intrinsics.checkNotNullParameter((Object)$this$toFileCallbackErrorCode, (String)"<this>");
        Exception exception = $this$toFileCallbackErrorCode;
        return exception instanceof SecurityException ? FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED : ((exception instanceof InterruptedIOException ? true : exception instanceof InterruptedException) ? FileCallback.ErrorCode.CANCELED : FileCallback.ErrorCode.UNKNOWN_IO_ERROR);
    }

    private static final FileCallback.ConflictResolution handleFileConflict(Context context, DocumentFile targetFolder, String targetFileName, FileCallback callback) {
        DocumentFile documentFile = DocumentFileUtils.child$default(targetFolder, context, targetFileName, false, 4, null);
        if (documentFile != null) {
            DocumentFile documentFile2 = documentFile;
            boolean bl = false;
            boolean bl2 = false;
            DocumentFile targetFile = documentFile2;
            boolean bl3 = false;
            CoroutineScope uiScope$iv = callback.getUiScope();
            boolean $i$f$awaitUiResultWithPending = false;
            FileCallback.ConflictResolution resolution = (FileCallback.ConflictResolution)((Object)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileCallback.ConflictResolution>, Object>(uiScope$iv, null, callback, targetFile){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CoroutineScope $uiScope;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ DocumentFile $targetFile$inlined;
                {
                    this.$uiScope = $uiScope;
                    this.$callback$inlined = fileCallback;
                    this.$targetFile$inlined = documentFile;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope coroutineScope = this.$uiScope;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            this.L$0 = coroutineScope;
                            this.label = 1;
                            Continuation uCont$iv = (Continuation)this;
                            boolean bl = false;
                            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                            cancellable$iv.initCancellability();
                            CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                            boolean bl2 = false;
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$targetFile$inlined){
                                int label;
                                final /* synthetic */ CancellableContinuation $it;
                                final /* synthetic */ FileCallback $callback$inlined;
                                final /* synthetic */ DocumentFile $targetFile$inlined;
                                {
                                    this.$it = $it;
                                    this.$callback$inlined = fileCallback;
                                    this.$targetFile$inlined = documentFile;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            CancellableContinuation it = this.$it;
                                            boolean bl = false;
                                            this.$callback$inlined.onConflict(this.$targetFile$inlined, new FileCallback.FileConflictAction((CancellableContinuation<? super FileCallback.ConflictResolution>)it));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            Object object3 = cancellable$iv.getResult();
                            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                            }
                            Object object4 = object3;
                            if (object3 != object2) return object4;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return object4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super FileCallback.ConflictResolution> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null));
            if (resolution == FileCallback.ConflictResolution.REPLACE) {
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onDeleteConflictedFiles();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                if (!DocumentFileUtils.forceDelete$default(targetFile, context, false, 2, null)) {
                    $this$postToUi$iv = callback.getUiScope();
                    $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    return FileCallback.ConflictResolution.SKIP;
                }
            }
            return resolution;
        }
        return FileCallback.ConflictResolution.CREATE_NEW;
    }

    private static final FolderCallback.ConflictResolution handleParentFolderConflict(Context context, DocumentFile targetParentFolder, String targetFolderParentName, FolderCallback callback) {
        DocumentFile documentFile = DocumentFileUtils.child$default(targetParentFolder, context, targetFolderParentName, false, 4, null);
        if (documentFile != null) {
            FolderCallback.ConflictResolution resolution;
            DocumentFile documentFile2 = documentFile;
            boolean bl = false;
            boolean bl2 = false;
            DocumentFile targetFolder = documentFile2;
            boolean bl3 = false;
            boolean canMerge = targetFolder.isDirectory();
            if (canMerge && DocumentFileUtils.isEmpty(targetFolder, context)) {
                return FolderCallback.ConflictResolution.MERGE;
            }
            CoroutineScope uiScope$iv = callback.getUiScope();
            boolean $i$f$awaitUiResultWithPending = false;
            FolderCallback.ConflictResolution conflictResolution = resolution = (FolderCallback.ConflictResolution)((Object)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FolderCallback.ConflictResolution>, Object>(uiScope$iv, null, callback, targetFolder, canMerge){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CoroutineScope $uiScope;
                final /* synthetic */ FolderCallback $callback$inlined;
                final /* synthetic */ DocumentFile $targetFolder$inlined;
                final /* synthetic */ boolean $canMerge$inlined;
                {
                    this.$uiScope = $uiScope;
                    this.$callback$inlined = folderCallback;
                    this.$targetFolder$inlined = documentFile;
                    this.$canMerge$inlined = bl;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope coroutineScope = this.$uiScope;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            this.L$0 = coroutineScope;
                            this.label = 1;
                            Continuation uCont$iv = (Continuation)this;
                            boolean bl = false;
                            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                            cancellable$iv.initCancellability();
                            CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                            boolean bl2 = false;
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$targetFolder$inlined, this.$canMerge$inlined){
                                int label;
                                final /* synthetic */ CancellableContinuation $it;
                                final /* synthetic */ FolderCallback $callback$inlined;
                                final /* synthetic */ DocumentFile $targetFolder$inlined;
                                final /* synthetic */ boolean $canMerge$inlined;
                                {
                                    this.$it = $it;
                                    this.$callback$inlined = folderCallback;
                                    this.$targetFolder$inlined = documentFile;
                                    this.$canMerge$inlined = bl;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            CancellableContinuation it = this.$it;
                                            boolean bl = false;
                                            this.$callback$inlined.onParentConflict(this.$targetFolder$inlined, new FolderCallback.ParentFolderConflictAction((CancellableContinuation<? super FolderCallback.ConflictResolution>)it), this.$canMerge$inlined);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            Object object3 = cancellable$iv.getResult();
                            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                            }
                            Object object4 = object3;
                            if (object3 != object2) return object4;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return object4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super FolderCallback.ConflictResolution> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null));
            int n = WhenMappings.$EnumSwitchMapping$2[conflictResolution.ordinal()];
            switch (n) {
                case 1: {
                    CoroutineScope $this$postToUi$iv = callback.getUiScope();
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FolderCallback $callback$inlined;
                        {
                            this.$callback$inlined = folderCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onDeleteConflictedFiles();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    boolean isFolder = targetFolder.isDirectory();
                    if (DocumentFileUtils.forceDelete(targetFolder, context, true)) {
                        DocumentFile newFolder;
                        if (isFolder) break;
                        DocumentFile documentFile3 = targetFolder.getParentFile();
                        DocumentFile documentFile4 = newFolder = documentFile3 == null ? null : documentFile3.createDirectory(targetFolderParentName);
                        if (newFolder != null) break;
                        CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
                        boolean $i$f$postToUi2 = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                            int label;
                            final /* synthetic */ FolderCallback $callback$inlined;
                            {
                                this.$callback$inlined = folderCallback;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onFailed(FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return FolderCallback.ConflictResolution.SKIP;
                    }
                    CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
                    boolean $i$f$postToUi3 = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FolderCallback $callback$inlined;
                        {
                            this.$callback$inlined = folderCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    return FolderCallback.ConflictResolution.SKIP;
                }
                case 2: {
                    if (!targetFolder.isFile()) break;
                    if (targetFolder.delete()) {
                        DocumentFile newFolder;
                        DocumentFile $this$postToUi$iv3 = targetFolder.getParentFile();
                        DocumentFile documentFile5 = newFolder = $this$postToUi$iv3 == null ? null : $this$postToUi$iv3.createDirectory(targetFolderParentName);
                        if (newFolder != null) break;
                        $this$postToUi$iv3 = callback.getUiScope();
                        boolean $i$f$postToUi = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                            int label;
                            final /* synthetic */ FolderCallback $callback$inlined;
                            {
                                this.$callback$inlined = folderCallback;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onFailed(FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return FolderCallback.ConflictResolution.SKIP;
                    }
                    CoroutineScope $this$postToUi$iv = callback.getUiScope();
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FolderCallback $callback$inlined;
                        {
                            this.$callback$inlined = folderCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(FolderCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    return FolderCallback.ConflictResolution.SKIP;
                }
            }
            return resolution;
        }
        return FolderCallback.ConflictResolution.CREATE_NEW;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final List<MultipleFileCallback.ParentConflict> handleParentFolderConflict(List<? extends DocumentFile> $this$handleParentFolderConflict, Context context, DocumentFile targetParentFolder, MultipleFileCallback callback) {
        $this$map$iv = $this$handleParentFolderConflict;
        $i$f$map = false;
        var7_7 = $this$map$iv;
        destination$iv$iv = (Object[])new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_27 = (DocumentFile)item$iv$iv;
            var27_39 = destination$iv$iv;
            $i$a$-map-DocumentFileUtils$handleParentFolderConflict$sourceFileNames$1 = 0;
            var28_40 = it.getName();
            var27_39.add(var28_40);
        }
        sourceFileNames = (List)destination$iv$iv;
        $i$f$map = targetParentFolder.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map, (String)"targetParentFolder.listFiles()");
        $this$filter$iv = $i$f$map;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DocumentFile)element$iv$iv;
            $i$a$-filter-DocumentFileUtils$handleParentFolderConflict$conflictedFiles$1 = false;
            if (!sourceFileNames.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        conflictedFiles = (List)destination$iv$iv;
        $this$map$iv = conflictedFiles;
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block20: {
                element$iv$iv = (DocumentFile)item$iv$iv;
                var27_39 = destination$iv$iv /* !! */ ;
                $i$a$-map-DocumentFileUtils$handleParentFolderConflict$conflicts$1 = false;
                $this$first$iv = $this$handleParentFolderConflict;
                $i$f$first = false;
                for (T element$iv : $this$first$iv) {
                    src = (DocumentFile)element$iv /* !! */ ;
                    $i$a$-first-DocumentFileUtils$handleParentFolderConflict$conflicts$1$sourceFile$1 = false;
                    if (!Intrinsics.areEqual((Object)src.getName(), (Object)it.getName())) continue;
                    break block20;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            sourceFile = (DocumentFile)element$iv /* !! */ ;
            v0 = canMerge = sourceFile.isDirectory() != false && it.isDirectory() != false;
            if (!canMerge) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (DocumentFileUtils.isEmpty((DocumentFile)it, context)) {
                v1 = FolderCallback.ConflictResolution.MERGE;
            } else lbl-1000:
            // 2 sources

            {
                v1 = FolderCallback.ConflictResolution.CREATE_NEW;
            }
            solution = v1;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            var28_40 = new MultipleFileCallback.ParentConflict(sourceFile, (DocumentFile)it, canMerge, solution);
            var27_39.add(var28_40);
        }
        conflicts = (List)destination$iv$iv /* !! */ ;
        $this$filter$iv = conflicts;
        $i$f$filter = false;
        destination$iv$iv /* !! */  = $this$filter$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MultipleFileCallback.ParentConflict)element$iv$iv;
            $i$a$-filter-DocumentFileUtils$handleParentFolderConflict$unresolvedConflicts$1 = false;
            if (!(it.getSolution() != FolderCallback.ConflictResolution.MERGE)) continue;
            destination$iv$iv /* !! */ .add(element$iv$iv);
        }
        unresolvedConflicts = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv /* !! */ ));
        $this$filter$iv = unresolvedConflicts;
        $i$f$filter = false;
        if ($this$filter$iv.isEmpty() == false) {
            block21: {
                $this$filter$iv = unresolvedConflicts;
                $i$f$filter = false;
                destination$iv$iv /* !! */  = $this$filter$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$filterTo = false;
                for (E element$iv$iv : $this$filterTo$iv$iv) {
                    it = (MultipleFileCallback.ParentConflict)element$iv$iv;
                    $i$a$-filter-DocumentFileUtils$handleParentFolderConflict$unresolvedFiles$1 = false;
                    if (!it.getSource().isFile()) continue;
                    destination$iv$iv /* !! */ .add(element$iv$iv);
                }
                unresolvedFiles = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv /* !! */ ));
                $this$filter$iv = unresolvedConflicts;
                $i$f$filter = false;
                destination$iv$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (MultipleFileCallback.ParentConflict)element$iv$iv;
                    $i$a$-filter-DocumentFileUtils$handleParentFolderConflict$unresolvedFolders$1 = false;
                    if (!it.getSource().isDirectory()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                unresolvedFolders = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                uiScope$iv = callback.getUiScope();
                $i$f$awaitUiResultWithPending = false;
                resolution = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends MultipleFileCallback.ParentConflict>>, Object>(uiScope$iv, null, callback, targetParentFolder, unresolvedFolders, unresolvedFiles){
                    Object L$0;
                    Object L$1;
                    int label;
                    final /* synthetic */ CoroutineScope $uiScope;
                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                    final /* synthetic */ DocumentFile $targetParentFolder$inlined;
                    final /* synthetic */ List $unresolvedFolders$inlined;
                    final /* synthetic */ List $unresolvedFiles$inlined;
                    {
                        this.$uiScope = $uiScope;
                        this.$callback$inlined = multipleFileCallback;
                        this.$targetParentFolder$inlined = documentFile;
                        this.$unresolvedFolders$inlined = list;
                        this.$unresolvedFiles$inlined = list2;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope coroutineScope = this.$uiScope;
                                boolean $i$f$suspendCancellableCoroutine = false;
                                this.L$0 = coroutineScope;
                                this.label = 1;
                                Continuation uCont$iv = (Continuation)this;
                                boolean bl = false;
                                CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                                cancellable$iv.initCancellability();
                                CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                                boolean bl2 = false;
                                BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$targetParentFolder$inlined, this.$unresolvedFolders$inlined, this.$unresolvedFiles$inlined){
                                    int label;
                                    final /* synthetic */ CancellableContinuation $it;
                                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                                    final /* synthetic */ DocumentFile $targetParentFolder$inlined;
                                    final /* synthetic */ List $unresolvedFolders$inlined;
                                    final /* synthetic */ List $unresolvedFiles$inlined;
                                    {
                                        this.$it = $it;
                                        this.$callback$inlined = multipleFileCallback;
                                        this.$targetParentFolder$inlined = documentFile;
                                        this.$unresolvedFolders$inlined = list;
                                        this.$unresolvedFiles$inlined = list2;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                CancellableContinuation it = this.$it;
                                                boolean bl = false;
                                                this.$callback$inlined.onParentConflict(this.$targetParentFolder$inlined, this.$unresolvedFolders$inlined, this.$unresolvedFiles$inlined, new MultipleFileCallback.ParentFolderConflictAction((CancellableContinuation<? super List<MultipleFileCallback.ParentConflict>>)it));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)2, null);
                                Object object3 = cancellable$iv.getResult();
                                if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                                }
                                Object object4 = object3;
                                if (object3 != object2) return object4;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                boolean $i$f$suspendCancellableCoroutine = false;
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                return object4;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends MultipleFileCallback.ParentConflict>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                $this$any$iv = resolution;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (MultipleFileCallback.ParentConflict)element$iv;
                        $i$a$-any-DocumentFileUtils$handleParentFolderConflict$2 = false;
                        if (!(it.getSolution() == FolderCallback.ConflictResolution.REPLACE)) continue;
                        v2 = true;
                        break block21;
                    }
                    v2 = false;
                }
            }
            if (v2) {
                $this$postToUi$iv = callback.getUiScope();
                $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ MultipleFileCallback $callback$inlined;
                    {
                        this.$callback$inlined = multipleFileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onDeleteConflictedFiles();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            $this$forEach$iv = resolution;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                conflict = (MultipleFileCallback.ParentConflict)element$iv;
                $i$a$-forEach-DocumentFileUtils$handleParentFolderConflict$4 = false;
                var17_64 = conflict.getSolution();
                $i$a$-filter-DocumentFileUtils$handleParentFolderConflict$unresolvedFolders$1 = WhenMappings.$EnumSwitchMapping$2[var17_64.ordinal()];
                switch ($i$a$-filter-DocumentFileUtils$handleParentFolderConflict$unresolvedFolders$1) {
                    case 1: {
                        element$iv /* !! */  = conflict.getTarget();
                        src = false;
                        $i$a$-first-DocumentFileUtils$handleParentFolderConflict$conflicts$1$sourceFile$1 = false;
                        it /* !! */  = element$iv /* !! */ ;
                        $i$a$-let-DocumentFileUtils$handleParentFolderConflict$4$1 = false;
                        if (DocumentFileUtils.deleteRecursively(it /* !! */ , context, true) || !it /* !! */ .exists()) break;
                        $this$postToUi$iv = callback.getUiScope();
                        $i$f$postToUi = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                            int label;
                            final /* synthetic */ MultipleFileCallback $callback$inlined;
                            {
                                this.$callback$inlined = multipleFileCallback;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return null;
                    }
                    case 2: {
                        if (!conflict.getTarget().isFile() || conflict.getTarget().delete()) break;
                        $this$postToUi$iv = callback.getUiScope();
                        $i$f$postToUi = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                            int label;
                            final /* synthetic */ MultipleFileCallback $callback$inlined;
                            {
                                this.$callback$inlined = multipleFileCallback;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onFailed(MultipleFileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return null;
                    }
                }
            }
            var11_26 = CollectionsKt.toMutableList((Collection)resolution);
            var12_32 = false;
            var13_38 = false;
            $this$handleParentFolderConflict_u24lambda_u2d182 = var11_26;
            $i$a$-apply-DocumentFileUtils$handleParentFolderConflict$5 = false;
            $i$a$-forEach-DocumentFileUtils$handleParentFolderConflict$4 = conflicts;
            var17_65 = $this$handleParentFolderConflict_u24lambda_u2d182;
            $i$f$filter = false;
            $this$postToUi$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (MultipleFileCallback.ParentConflict)element$iv$iv;
                $i$a$-filter-DocumentFileUtils$handleParentFolderConflict$5$1 = false;
                if (!(it.getSolution() == FolderCallback.ConflictResolution.MERGE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var26_81 = (List)destination$iv$iv;
            var17_65.addAll(var26_81);
            return var11_26;
        }
        return CollectionsKt.emptyList();
    }

    @JvmOverloads
    @Nullable
    public static final DocumentFile child(@NotNull DocumentFile $this$child, @NotNull Context context, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DocumentFileUtils.child$default($this$child, context, path, false, 4, null);
    }

    @JvmOverloads
    @Nullable
    public static final DocumentFile getRootDocumentFile(@NotNull DocumentFile $this$getRootDocumentFile, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getRootDocumentFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileUtils.getRootDocumentFile$default($this$getRootDocumentFile, context, false, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final DocumentFile createBinaryFile(@NotNull DocumentFile $this$createBinaryFile, @NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$createBinaryFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DocumentFileUtils.createBinaryFile$default($this$createBinaryFile, context, name, null, 4, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final DocumentFile makeFile(@NotNull DocumentFile $this$makeFile, @NotNull Context context, @NotNull String name, @Nullable String mimeType) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DocumentFileUtils.makeFile$default($this$makeFile, context, name, mimeType, null, 8, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final DocumentFile makeFile(@NotNull DocumentFile $this$makeFile, @NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DocumentFileUtils.makeFile$default($this$makeFile, context, name, null, null, 12, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final DocumentFile makeFolder(@NotNull DocumentFile $this$makeFolder, @NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFolder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DocumentFileUtils.makeFolder$default($this$makeFolder, context, name, null, 4, null);
    }

    @JvmOverloads
    @WorkerThread
    @NotNull
    public static final List<DocumentFile> search(@NotNull DocumentFile $this$search, boolean recursive, @NotNull DocumentFileType documentType, @Nullable String[] mimeTypes, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$search, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DocumentFileUtils.search$default($this$search, recursive, documentType, mimeTypes, name, null, 16, null);
    }

    @JvmOverloads
    @WorkerThread
    @NotNull
    public static final List<DocumentFile> search(@NotNull DocumentFile $this$search, boolean recursive, @NotNull DocumentFileType documentType, @Nullable String[] mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$search, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileUtils.search$default($this$search, recursive, documentType, mimeTypes, null, null, 24, null);
    }

    @JvmOverloads
    @WorkerThread
    @NotNull
    public static final List<DocumentFile> search(@NotNull DocumentFile $this$search, boolean recursive, @NotNull DocumentFileType documentType) {
        Intrinsics.checkNotNullParameter((Object)$this$search, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileUtils.search$default($this$search, recursive, documentType, null, null, null, 28, null);
    }

    @JvmOverloads
    @WorkerThread
    @NotNull
    public static final List<DocumentFile> search(@NotNull DocumentFile $this$search, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)$this$search, (String)"<this>");
        return DocumentFileUtils.search$default($this$search, recursive, null, null, null, null, 30, null);
    }

    @JvmOverloads
    @WorkerThread
    @NotNull
    public static final List<DocumentFile> search(@NotNull DocumentFile $this$search) {
        Intrinsics.checkNotNullParameter((Object)$this$search, (String)"<this>");
        return DocumentFileUtils.search$default($this$search, false, null, null, null, null, 31, null);
    }

    @WorkerThread
    @JvmOverloads
    public static final boolean deleteRecursively(@NotNull DocumentFile $this$deleteRecursively, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileUtils.deleteRecursively$default($this$deleteRecursively, context, false, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    public static final boolean forceDelete(@NotNull DocumentFile $this$forceDelete, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$forceDelete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileUtils.forceDelete$default($this$forceDelete, context, false, 2, null);
    }

    @JvmOverloads
    @WorkerThread
    @Nullable
    public static final OutputStream openOutputStream(@NotNull DocumentFile $this$openOutputStream, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$openOutputStream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileUtils.openOutputStream$default($this$openOutputStream, context, false, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    public static final void copyFileToDownloadMedia(@NotNull DocumentFile $this$copyFileToDownloadMedia, @NotNull Context context, @NotNull FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFileToDownloadMedia, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescription, (String)"fileDescription");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.copyFileToDownloadMedia$default($this$copyFileToDownloadMedia, context, fileDescription, callback, null, 8, null);
    }

    @WorkerThread
    @JvmOverloads
    public static final void copyFileToPictureMedia(@NotNull DocumentFile $this$copyFileToPictureMedia, @NotNull Context context, @NotNull FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFileToPictureMedia, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescription, (String)"fileDescription");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.copyFileToPictureMedia$default($this$copyFileToPictureMedia, context, fileDescription, callback, null, 8, null);
    }

    @WorkerThread
    @JvmOverloads
    public static final void moveFileToDownloadMedia(@NotNull DocumentFile $this$moveFileToDownloadMedia, @NotNull Context context, @NotNull FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFileToDownloadMedia, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescription, (String)"fileDescription");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.moveFileToDownloadMedia$default($this$moveFileToDownloadMedia, context, fileDescription, callback, null, 8, null);
    }

    @WorkerThread
    @JvmOverloads
    public static final void moveFileToPictureMedia(@NotNull DocumentFile $this$moveFileToPictureMedia, @NotNull Context context, @NotNull FileDescription fileDescription, @NotNull FileCallback callback) {
        Intrinsics.checkNotNullParameter((Object)$this$moveFileToPictureMedia, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileDescription, (String)"fileDescription");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFileUtils.moveFileToPictureMedia$default($this$moveFileToPictureMedia, context, fileDescription, callback, null, 8, null);
    }

    public static final /* synthetic */ boolean access$matchesMimeTypes(DocumentFile $receiver, String[] filterMimeTypes) {
        return DocumentFileUtils.matchesMimeTypes($receiver, filterMimeTypes);
    }

    public static final /* synthetic */ void access$createFileStreams(Context context, DocumentFile sourceFile, DocumentFile targetFile, BaseFileCallback callback, Function2 onStreamsReady) {
        DocumentFileUtils.createFileStreams(context, sourceFile, targetFile, callback, (Function2<? super InputStream, ? super OutputStream, Unit>)onStreamsReady);
    }

    public static final /* synthetic */ MultipleFileCallback.ErrorCode access$toMultipleFileCallbackErrorCode(Exception $receiver) {
        return DocumentFileUtils.toMultipleFileCallbackErrorCode($receiver);
    }

    public static final /* synthetic */ FolderCallback.ErrorCode access$toFolderCallbackErrorCode(Exception $receiver) {
        return DocumentFileUtils.toFolderCallbackErrorCode($receiver);
    }

    public static final /* synthetic */ void access$copyFileStream(DocumentFile $receiver, InputStream inputStream, OutputStream outputStream, Object targetFile, boolean watchProgress, long reportInterval, boolean deleteSourceFileWhenComplete, FileCallback callback) {
        DocumentFileUtils.copyFileStream($receiver, inputStream, outputStream, targetFile, watchProgress, reportInterval, deleteSourceFileWhenComplete, callback);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[DocumentFileType.values().length];
            nArray[DocumentFileType.FILE.ordinal()] = 1;
            nArray[DocumentFileType.FOLDER.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FolderCallback.ErrorCode.values().length];
            nArray[FolderCallback.ErrorCode.INVALID_TARGET_FOLDER.ordinal()] = 1;
            nArray[FolderCallback.ErrorCode.STORAGE_PERMISSION_DENIED.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[FolderCallback.ConflictResolution.values().length];
            nArray[FolderCallback.ConflictResolution.REPLACE.ordinal()] = 1;
            nArray[FolderCallback.ConflictResolution.MERGE.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

