/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.RecoverableSecurityException;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.text.format.Formatter;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import androidx.core.content.FileProvider;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.callback.FileCallback;
import com.anggrayudi.storage.extension.CoroutineExtKt;
import com.anggrayudi.storage.extension.IOUtils;
import com.anggrayudi.storage.extension.PrimitivesExtKt;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.extension.UriUtils;
import com.anggrayudi.storage.file.CreateMode;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.MimeType;
import com.anggrayudi.storage.media.FileDescription;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001qB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ@\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020JH\u0002J$\u0010K\u001a\u00020?2\u0006\u0010L\u001a\u00020E2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010I\u001a\u00020JH\u0007J3\u0010O\u001a\u00020?2\u0006\u0010D\u001a\u00020E2\u0006\u0010I\u001a\u00020J2\u0018\u0010P\u001a\u0014\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020?0QH\u0082\bJ4\u0010R\u001a\u0004\u0018\u00010E2\u0006\u0010S\u001a\u00020E2\u0006\u0010T\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u00010\u000b2\u0006\u0010U\u001a\u00020V2\u0006\u0010I\u001a\u00020JH\u0002J\u0006\u0010W\u001a\u00020\u001aJ\u0013\u0010X\u001a\u00020\u001a2\b\u0010Y\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u000bH\u0002J\u0010\u0010]\u001a\u00020+2\u0006\u0010\\\u001a\u00020\u000bH\u0002J\u0012\u0010^\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\\\u001a\u00020\u000bH\u0002J \u0010_\u001a\u00020`2\u0006\u0010L\u001a\u00020E2\u0006\u0010T\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020JH\u0002J\u001c\u0010a\u001a\u00020?2\u0006\u0010b\u001a\u00020c2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010JH\u0002J\b\u0010d\u001a\u00020[H\u0016J$\u0010e\u001a\u00020?2\u0006\u0010L\u001a\u00020E2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010I\u001a\u00020JH\u0007J\u0010\u0010e\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u000bH\u0007J\u0010\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020\u000bH\u0007J\n\u0010i\u001a\u0004\u0018\u00010AH\u0007J\u0014\u0010j\u001a\u0004\u0018\u00010C2\b\b\u0002\u0010k\u001a\u00020\u001aH\u0007J\u000e\u0010l\u001a\u00020\u001a2\u0006\u0010m\u001a\u00020\u000bJ\b\u0010n\u001a\u0004\u0018\u00010EJ\n\u0010o\u001a\u0004\u0018\u00010\u0005H\u0007J\b\u0010p\u001a\u00020\u000bH\u0016R\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0016\u0010\u0002\u001a\n \u0018*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR\u0011\u0010\u001f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\rR\u0011\u0010!\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\rR\u0011\u0010#\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001cR\u0011\u0010$\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001cR$\u0010&\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001cR\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R$\u0010.\u001a\u00020+2\u0006\u0010%\u001a\u00020+8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010-\"\u0004\b0\u00101R\u0013\u00102\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\rR\u0013\u00104\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\rR\u0013\u00106\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\rR\u0011\u00108\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b9\u0010\rR\u0013\u0010:\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=\u00a8\u0006r"}, d2={"Lcom/anggrayudi/storage/media/MediaFile;", "", "context", "Landroid/content/Context;", "rawFile", "Ljava/io/File;", "(Landroid/content/Context;Ljava/io/File;)V", "uri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;)V", "absolutePath", "", "getAbsolutePath", "()Ljava/lang/String;", "accessCallback", "Lcom/anggrayudi/storage/media/MediaFile$AccessCallback;", "getAccessCallback", "()Lcom/anggrayudi/storage/media/MediaFile$AccessCallback;", "setAccessCallback", "(Lcom/anggrayudi/storage/media/MediaFile$AccessCallback;)V", "baseName", "getBaseName", "basePath", "getBasePath", "kotlin.jvm.PlatformType", "exists", "", "getExists", "()Z", "extension", "getExtension", "formattedSize", "getFormattedSize", "fullName", "getFullName", "isEmpty", "isMine", "value", "isPending", "setPending", "(Z)V", "isRawFile", "lastModified", "", "getLastModified", "()J", "length", "getLength", "setLength", "(J)V", "mimeType", "getMimeType", "name", "getName", "owner", "getOwner", "relativePath", "getRelativePath", "type", "getType", "getUri", "()Landroid/net/Uri;", "copyFileStream", "", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "targetFile", "Landroidx/documentfile/provider/DocumentFile;", "watchProgress", "reportInterval", "deleteSourceFileWhenComplete", "callback", "Lcom/anggrayudi/storage/callback/FileCallback;", "copyTo", "targetFolder", "fileDescription", "Lcom/anggrayudi/storage/media/FileDescription;", "createFileStreams", "onStreamsReady", "Lkotlin/Function2;", "createTargetFile", "targetDirectory", "fileName", "mode", "Lcom/anggrayudi/storage/file/CreateMode;", "delete", "equals", "other", "getColumnInfoInt", "", "column", "getColumnInfoLong", "getColumnInfoString", "handleFileConflict", "Lcom/anggrayudi/storage/callback/FileCallback$ConflictResolution;", "handleSecurityException", "e", "Ljava/lang/SecurityException;", "hashCode", "moveTo", "openFileIntent", "Landroid/content/Intent;", "authority", "openInputStream", "openOutputStream", "append", "renameTo", "newName", "toDocumentFile", "toRawFile", "toString", "AccessCallback", "storage_release"})
public final class MediaFile {
    @NotNull
    private final Uri uri;
    private final Context context;
    @Nullable
    private AccessCallback accessCallback;

    public MediaFile(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = uri;
        this.context = context.getApplicationContext();
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    public MediaFile(@NotNull Context context, @NotNull File rawFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)rawFile, (String)"rawFile");
        Uri uri = Uri.fromFile((File)rawFile);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(rawFile)");
        this(context, uri);
    }

    @Nullable
    public final AccessCallback getAccessCallback() {
        return this.accessCallback;
    }

    public final void setAccessCallback(@Nullable AccessCallback accessCallback) {
        this.accessCallback = accessCallback;
    }

    @NotNull
    public final String getFullName() {
        Object object;
        if (this.isRawFile()) {
            Object object2 = this.toRawFile();
            object2 = object2 == null ? null : ((File)object2).getName();
            boolean bl = false;
            object = object2;
            if (object == null) {
                object = "";
            }
        } else {
            String mimeType = this.getColumnInfoString("mime_type");
            String string2 = this.getColumnInfoString("_display_name");
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String displayName = string3;
            object = MimeType.getFullFileName(displayName, mimeType);
        }
        return object;
    }

    @Nullable
    public final String getName() {
        File file = this.toRawFile();
        String string2 = file == null ? null : file.getName();
        return string2 == null ? this.getColumnInfoString("_display_name") : string2;
    }

    @NotNull
    public final String getBaseName() {
        return StringsKt.substringBeforeLast$default((String)this.getFullName(), (char)'.', null, (int)2, null);
    }

    @NotNull
    public final String getExtension() {
        return StringsKt.substringAfterLast((String)this.getFullName(), (char)'.', (String)"");
    }

    @Nullable
    public final String getType() {
        String string2;
        File file = this.toRawFile();
        if (file == null) {
            string2 = null;
        } else {
            String string3 = file.getName();
            if (string3 == null) {
                string2 = null;
            } else {
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                string2 = MimeType.getMimeTypeFromExtension(StringsKt.substringAfterLast((String)it, (char)'.', (String)""));
            }
        }
        String string5 = string2;
        return string5 == null ? this.getColumnInfoString("mime_type") : string5;
    }

    @Nullable
    public final String getMimeType() {
        String string2;
        return this.getExists() ? ((string2 = this.getColumnInfoString("mime_type")) == null ? MimeType.getMimeTypeFromExtension(this.getExtension()) : string2) : null;
    }

    public final long getLength() {
        File file = this.toRawFile();
        Long l = file == null ? null : Long.valueOf(file.length());
        return l == null ? this.getColumnInfoLong("_size") : l.longValue();
    }

    public final void setLength(long value) {
        try {
            ContentValues contentValues = new ContentValues(1);
            boolean bl = false;
            boolean bl2 = false;
            ContentValues $this$_set_length__u24lambda_u2d1 = contentValues;
            boolean bl3 = false;
            $this$_set_length__u24lambda_u2d1.put("_size", Long.valueOf(value));
            ContentValues contentValues2 = contentValues;
            this.context.getContentResolver().update(this.uri, contentValues2, null, null);
        }
        catch (SecurityException e) {
            MediaFile.handleSecurityException$default(this, e, null, 2, null);
        }
    }

    @NotNull
    public final String getFormattedSize() {
        String string2 = Formatter.formatFileSize((Context)this.context, (long)this.getLength());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(context, length)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getExists() {
        boolean bl;
        Boolean bl2;
        Object object = this.toRawFile();
        Boolean bl3 = bl2 = object == null ? null : Boolean.valueOf(((File)object).exists());
        if (bl2 == null) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            object = UriUtils.openInputStream(this.uri, context);
            if (object == null) {
                bl = false;
            } else {
                boolean bl4;
                boolean bl5;
                Closeable closeable = (Closeable)object;
                boolean bl6 = false;
                boolean bl7 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl8 = false;
                    bl5 = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                bl = bl4 = bl5;
            }
        } else {
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        boolean bl;
        Cursor cursor = this.context.getContentResolver().query(this.uri, null, null, null, null);
        if (cursor == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            Closeable closeable = (Closeable)cursor;
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl6 = false;
                bl3 = it.getCount() > 0 && !this.getExists();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = bl2 = bl3;
        }
        return bl;
    }

    public final boolean isRawFile() {
        return UriUtils.isRawFile(this.uri);
    }

    public final long getLastModified() {
        File file = this.toRawFile();
        Long l = file == null ? null : Long.valueOf(file.lastModified());
        return l == null ? this.getColumnInfoLong("date_modified") : l.longValue();
    }

    @Nullable
    public final String getOwner() {
        return Build.VERSION.SDK_INT >= 29 ? this.getColumnInfoString("owner_package_name") : null;
    }

    public final boolean isMine() {
        return Intrinsics.areEqual((Object)this.getOwner(), (Object)this.context.getPackageName());
    }

    @Deprecated(message="Accessing files with java.io.File only works on app private directory since Android 10.")
    @Nullable
    public final File toRawFile() {
        File file;
        if (this.isRawFile()) {
            String string2 = this.uri.getPath();
            if (string2 == null) {
                file = null;
            } else {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                file = new File(it);
            }
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final DocumentFile toDocumentFile() {
        DocumentFile documentFile;
        String string2 = this.getAbsolutePath();
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        if (charSequence.length() == 0) {
            documentFile = null;
        } else {
            charSequence = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"context");
            documentFile = DocumentFileCompat.fromFullPath$default((Context)charSequence, it, null, false, false, 28, null);
        }
        return documentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"InlinedApi"})
    @NotNull
    public final String getAbsolutePath() {
        String string2;
        File file = this.toRawFile();
        if (file != null) {
            String string3 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
            string2 = string3;
        } else if (Build.VERSION.SDK_INT < 29) {
            String string4;
            try {
                String string5;
                Object object = new String[]{"_data"};
                string4 = this.context.getContentResolver().query(this.uri, object, null, null, null);
                if (string4 == null) {
                    string5 = null;
                } else {
                    object = (Closeable)((Object)string4);
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        Cursor cursor = (Cursor)object;
                        boolean bl3 = false;
                        String string6 = cursor.moveToFirst() ? cursor.getString(cursor.getColumnIndex("_data")) : "";
                        string5 = string6;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                }
                string4 = string5;
                boolean bl = false;
                String string7 = string4;
                if (string7 == null) {
                    string7 = "";
                }
                string4 = string7;
            }
            catch (Exception e) {
                string4 = "";
            }
            string2 = string4;
        } else {
            String string8;
            String[] stringArray = new String[]{"relative_path", "_display_name"};
            String[] projection = stringArray;
            stringArray = this.context.getContentResolver().query(this.uri, projection, null, null, null);
            if (stringArray == null) {
                string8 = null;
            } else {
                Closeable closeable = (Closeable)stringArray;
                boolean bl = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    String string9;
                    Cursor cursor = (Cursor)closeable;
                    boolean bl5 = false;
                    if (cursor.moveToFirst()) {
                        String string10 = cursor.getString(cursor.getColumnIndex("relative_path"));
                        if (string10 == null) {
                            String string11 = "";
                            return string11;
                        }
                        String relativePath = string10;
                        String name = cursor.getString(cursor.getColumnIndex("_display_name"));
                        char[] cArray = new char[]{'/'};
                        string9 = TextUtils.replaceCompletely(StringsKt.trimEnd((String)(SimpleStorage.Companion.getExternalStoragePath() + '/' + relativePath + '/' + name), (char[])cArray), "//", "/");
                    } else {
                        string9 = "";
                    }
                    String string12 = string9;
                    string8 = string12;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            stringArray = string8;
            boolean bl = false;
            string2 = stringArray;
            if (stringArray == null) {
                string2 = "";
            }
        }
        return string2;
    }

    @NotNull
    public final String getBasePath() {
        return TextUtils.trimFileSeparator(StringsKt.substringAfter$default((String)this.getAbsolutePath(), (String)SimpleStorage.Companion.getExternalStoragePath(), null, (int)2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"InlinedApi"})
    @NotNull
    public final String getRelativePath() {
        String string2;
        File file = this.toRawFile();
        if (file != null) {
            String string3 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
            string2 = Intrinsics.stringPlus((String)TextUtils.trimFileSeparator(StringsKt.replaceFirst$default((String)StringsKt.substringBeforeLast$default((String)string3, (char)'/', null, (int)2, null), (String)SimpleStorage.Companion.getExternalStoragePath(), (String)"", (boolean)false, (int)4, null)), (Object)"/");
        } else if (Build.VERSION.SDK_INT < 29) {
            String string4;
            try {
                String string5;
                Object object = new String[]{"_data"};
                string4 = this.context.getContentResolver().query(this.uri, object, null, null, null);
                if (string4 == null) {
                    string5 = null;
                } else {
                    object = (Closeable)((Object)string4);
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        String string6;
                        Cursor cursor = (Cursor)object;
                        boolean bl3 = false;
                        if (cursor.moveToFirst()) {
                            String string7 = cursor.getString(cursor.getColumnIndex("_data"));
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"cursor.getString(cursor.getColumnIndex(MediaStore.MediaColumns.DATA))");
                            String realFolderAbsolutePath = StringsKt.substringBeforeLast$default((String)string7, (char)'/', null, (int)2, null);
                            string6 = Intrinsics.stringPlus((String)TextUtils.trimFileSeparator(StringsKt.replaceFirst$default((String)realFolderAbsolutePath, (String)SimpleStorage.Companion.getExternalStoragePath(), (String)"", (boolean)false, (int)4, null)), (Object)"/");
                        } else {
                            string6 = "";
                        }
                        String string8 = string6;
                        string5 = string8;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                }
                string4 = string5;
                boolean bl = false;
                String string9 = string4;
                if (string9 == null) {
                    string9 = "";
                }
                string4 = string9;
            }
            catch (Exception e) {
                string4 = "";
            }
            string2 = string4;
        } else {
            String string10;
            String[] stringArray = new String[]{"relative_path"};
            String[] projection = stringArray;
            stringArray = this.context.getContentResolver().query(this.uri, projection, null, null, null);
            if (stringArray == null) {
                string10 = null;
            } else {
                Closeable closeable = (Closeable)stringArray;
                boolean bl = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl5 = false;
                    String string11 = cursor.moveToFirst() ? cursor.getString(cursor.getColumnIndex("relative_path")) : "";
                    string10 = string11;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            stringArray = string10;
            boolean bl = false;
            string2 = stringArray;
            if (stringArray == null) {
                string2 = "";
            }
        }
        return string2;
    }

    public final boolean delete() {
        boolean bl;
        File file = this.toRawFile();
        if (file != null) {
            bl = file.delete() || !file.exists();
        } else {
            boolean bl2;
            try {
                bl2 = this.context.getContentResolver().delete(this.uri, null, null) > 0;
            }
            catch (SecurityException e) {
                MediaFile.handleSecurityException$default(this, e, null, 2, null);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public final boolean renameTo(@NotNull String newName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        File file = this.toRawFile();
        ContentValues contentValues = new ContentValues(1);
        boolean bl2 = false;
        boolean bl3 = false;
        ContentValues $this$renameTo_u24lambda_u2d10 = contentValues;
        boolean bl4 = false;
        $this$renameTo_u24lambda_u2d10.put("_display_name", newName);
        ContentValues contentValues2 = contentValues;
        if (file != null) {
            bl = file.renameTo(new File(file.getParent(), newName)) && this.context.getContentResolver().update(this.uri, contentValues2, null, null) > 0;
        } else {
            boolean bl5;
            try {
                bl5 = this.context.getContentResolver().update(this.uri, contentValues2, null, null) > 0;
            }
            catch (SecurityException e) {
                MediaFile.handleSecurityException$default(this, e, null, 2, null);
                bl5 = false;
            }
            bl = bl5;
        }
        return bl;
    }

    @RequiresApi(value=29)
    public final boolean isPending() {
        return this.getColumnInfoInt("is_pending") == 1;
    }

    @RequiresApi(value=29)
    public final void setPending(boolean value) {
        ContentValues contentValues = new ContentValues(1);
        boolean bl = false;
        boolean bl2 = false;
        ContentValues $this$_set_isPending__u24lambda_u2d11 = contentValues;
        boolean bl3 = false;
        $this$_set_isPending__u24lambda_u2d11.put("is_pending", Integer.valueOf(PrimitivesExtKt.toInt(value)));
        ContentValues contentValues2 = contentValues;
        try {
            this.context.getContentResolver().update(this.uri, contentValues2, null, null);
        }
        catch (SecurityException e) {
            MediaFile.handleSecurityException$default(this, e, null, 2, null);
        }
    }

    private final void handleSecurityException(SecurityException e, FileCallback callback) {
        if (Build.VERSION.SDK_INT >= 29 && e instanceof RecoverableSecurityException) {
            AccessCallback accessCallback = this.accessCallback;
            if (accessCallback != null) {
                IntentSender intentSender = ((RecoverableSecurityException)e).getUserAction().getActionIntent().getIntentSender();
                Intrinsics.checkNotNullExpressionValue((Object)intentSender, (String)"e.userAction.actionIntent.intentSender");
                accessCallback.onWriteAccessDenied(this, intentSender);
            }
        } else {
            CoroutineScope coroutineScope;
            FileCallback fileCallback = callback;
            if (fileCallback != null && (coroutineScope = fileCallback.getUiScope()) != null) {
                CoroutineScope $this$postToUi$iv = coroutineScope;
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }
    }

    static /* synthetic */ void handleSecurityException$default(MediaFile mediaFile, SecurityException securityException, FileCallback fileCallback, int n, Object object) {
        if ((n & 2) != 0) {
            fileCallback = null;
        }
        mediaFile.handleSecurityException(securityException, fileCallback);
    }

    @UiThread
    @NotNull
    public final Intent openFileIntent(@NotNull String authority) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Intent intent = new Intent("android.intent.action.VIEW");
        if (this.isRawFile()) {
            String string2 = this.uri.getPath();
            Intrinsics.checkNotNull((Object)string2);
            uri = FileProvider.getUriForFile((Context)this.context, (String)authority, (File)new File(string2));
        } else {
            uri = this.uri;
        }
        Intent intent2 = intent.setData(uri).addFlags(1).addFlags(0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent(Intent.ACTION_VIEW)\n        .setData(if (isRawFile) FileProvider.getUriForFile(context, authority, File(uri.path!!)) else uri)\n        .addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)\n        .addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)");
        return intent2;
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final OutputStream openOutputStream(boolean append) {
        OutputStream outputStream;
        try {
            File file = this.toRawFile();
            outputStream = file != null ? (OutputStream)new FileOutputStream(file, append) : this.context.getContentResolver().openOutputStream(this.uri, append ? "wa" : "w");
        }
        catch (IOException e) {
            outputStream = null;
        }
        return outputStream;
    }

    public static /* synthetic */ OutputStream openOutputStream$default(MediaFile mediaFile, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return mediaFile.openOutputStream(bl);
    }

    @WorkerThread
    @Nullable
    public final InputStream openInputStream() {
        InputStream inputStream;
        try {
            File file = this.toRawFile();
            inputStream = file != null ? (InputStream)new FileInputStream(file) : this.context.getContentResolver().openInputStream(this.uri);
        }
        catch (IOException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @TargetApi(value=29)
    public final boolean moveTo(@NotNull String relativePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        ContentValues contentValues = new ContentValues(1);
        boolean bl2 = false;
        boolean bl3 = false;
        ContentValues $this$moveTo_u24lambda_u2d13 = contentValues;
        boolean bl4 = false;
        $this$moveTo_u24lambda_u2d13.put("relative_path", relativePath);
        ContentValues contentValues2 = contentValues;
        try {
            bl = this.context.getContentResolver().update(this.uri, contentValues2, null, null) > 0;
        }
        catch (SecurityException e) {
            MediaFile.handleSecurityException$default(this, e, null, 2, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final void moveTo(@NotNull DocumentFile targetFolder, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        Object object;
        String $this$postToUi$iv4;
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFile sourceFile = this.toDocumentFile();
        if (sourceFile != null) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            DocumentFileUtils.moveFileTo(sourceFile, context, targetFolder, fileDescription, callback);
            return;
        }
        try {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context context2 = context;
            context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context2, DocumentFileUtils.getStorageId(targetFolder, context)), this.getLength())) {
                CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        catch (Throwable e) {
            CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
            boolean $i$f$postToUi2 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Object $this$postToUi$iv3 = fileDescription;
        $this$postToUi$iv3 = $this$postToUi$iv3 == null ? null : ((FileDescription)$this$postToUi$iv3).getSubFolder();
        boolean $i$f$postToUi2 = false;
        boolean bl = false;
        if ($this$postToUi$iv3 == null || $this$postToUi$iv3.length() == 0) {
            documentFile = targetFolder;
        } else {
            Object $i$f$postToUi2 = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$postToUi2, (String)"context");
            Context context = $i$f$postToUi2;
            $i$f$postToUi2 = fileDescription;
            $i$f$postToUi2 = $i$f$postToUi2 == null ? null : ((FileDescription)$i$f$postToUi2).getSubFolder();
            bl = false;
            Object object2 = $i$f$postToUi2;
            if (object2 == null) {
                object2 = "";
            }
            DocumentFile directory = DocumentFileUtils.makeFolder(targetFolder, context, (String)object2, CreateMode.REUSE);
            if (directory == null) {
                CoroutineScope $this$postToUi$iv4 = callback.getUiScope();
                boolean $i$f$postToUi3 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv4, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            documentFile = directory;
        }
        DocumentFile targetDirectory = documentFile;
        Object $i$f$postToUi3 = fileDescription;
        String string2 = $this$postToUi$iv4 = $i$f$postToUi3 == null ? null : ((FileDescription)$i$f$postToUi3).getName();
        if ($this$postToUi$iv4 == null) {
            $i$f$postToUi3 = this.getName();
            boolean bl2 = false;
            object = $i$f$postToUi3;
            if (object == null) {
                object = "";
            }
        } else {
            object = $this$postToUi$iv4;
        }
        $i$f$postToUi3 = fileDescription;
        $this$postToUi$iv4 = $i$f$postToUi3 == null ? null : ((FileDescription)$i$f$postToUi3).getMimeType();
        String cleanFileName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(MimeType.getFullFileName((String)object, $this$postToUi$iv4 == null ? this.getType() : $this$postToUi$iv4)));
        FileCallback.ConflictResolution conflictResolution = this.handleFileConflict(targetDirectory, cleanFileName, callback);
        if (conflictResolution == FileCallback.ConflictResolution.SKIP) {
            return;
        }
        Thread thread = Thread.currentThread();
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, this, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FileCallback $callback$inlined;
            final /* synthetic */ MediaFile this$0;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = fileCallback;
                this.this$0 = mediaFile;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.this$0, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ MediaFile this$0;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = fileCallback;
                                this.this$0 = mediaFile;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Long l;
                                        ResultKt.throwOnFailure((Object)object);
                                        Result.Companion companion = Result.Companion;
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        Long l2 = l = Boxing.boxLong((long)this.$callback$inlined.onStart(this.this$0, this.$thread$inlined));
                                        boolean bl2 = false;
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)l2));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        boolean watchProgress = reportInterval > 0L;
        try {
            FileDescription fileDescription2 = fileDescription;
            String string3 = fileDescription2 == null ? null : fileDescription2.getMimeType();
            DocumentFile documentFile2 = this.createTargetFile(targetDirectory, cleanFileName, string3 == null ? this.getType() : string3, conflictResolution.toCreateMode(), callback);
            if (documentFile2 == null) {
                return;
            }
            DocumentFile targetFile = documentFile2;
            MediaFile this_$iv = this;
            boolean $i$f$createFileStreams = false;
            fileDescription2 = this_$iv.context;
            Intrinsics.checkNotNullExpressionValue((Object)fileDescription2, (String)"context");
            OutputStream outputStream$iv = DocumentFileUtils.openOutputStream$default(targetFile, (Context)fileDescription2, false, 2, null);
            if (outputStream$iv == null) {
                CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                boolean $i$f$postToUi4 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FILE_NOT_FOUND);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invokeSuspend$$forInline(@NotNull Object $result) {
                        boolean bl = false;
                        this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FILE_NOT_FOUND);
                        return Unit.INSTANCE;
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                InputStream inputStream$iv = this_$iv.openInputStream();
                if (inputStream$iv == null) {
                    CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                    boolean $i$f$postToUi5 = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @Nullable
                        public final Object invokeSuspend$$forInline(@NotNull Object $result) {
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
                            return Unit.INSTANCE;
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    IOUtils.closeStream(outputStream$iv);
                } else {
                    void outputStream;
                    OutputStream outputStream2 = outputStream$iv;
                    InputStream inputStream = inputStream$iv;
                    boolean bl3 = false;
                    this.copyFileStream(inputStream, (OutputStream)outputStream, targetFile, watchProgress, reportInterval, true, callback);
                }
            }
        }
        catch (SecurityException e) {
            this.handleSecurityException(e, callback);
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv5 = callback.getUiScope();
            boolean $i$f$postToUi6 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv5, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public static /* synthetic */ void moveTo$default(MediaFile mediaFile, DocumentFile documentFile, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 2) != 0) {
            fileDescription = null;
        }
        mediaFile.moveTo(documentFile, fileDescription, fileCallback);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final void copyTo(@NotNull DocumentFile targetFolder, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        Object object;
        String $this$postToUi$iv4;
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFile sourceFile = this.toDocumentFile();
        if (sourceFile != null) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            DocumentFileUtils.copyFileTo(sourceFile, context, targetFolder, fileDescription, callback);
            return;
        }
        try {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context context2 = context;
            context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context2, DocumentFileUtils.getStorageId(targetFolder, context)), this.getLength())) {
                CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
        }
        catch (Throwable e) {
            CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
            boolean $i$f$postToUi2 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Object $this$postToUi$iv3 = fileDescription;
        $this$postToUi$iv3 = $this$postToUi$iv3 == null ? null : ((FileDescription)$this$postToUi$iv3).getSubFolder();
        boolean $i$f$postToUi2 = false;
        boolean bl = false;
        if ($this$postToUi$iv3 == null || $this$postToUi$iv3.length() == 0) {
            documentFile = targetFolder;
        } else {
            Object $i$f$postToUi2 = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$postToUi2, (String)"context");
            Context context = $i$f$postToUi2;
            $i$f$postToUi2 = fileDescription;
            $i$f$postToUi2 = $i$f$postToUi2 == null ? null : ((FileDescription)$i$f$postToUi2).getSubFolder();
            bl = false;
            Object object2 = $i$f$postToUi2;
            if (object2 == null) {
                object2 = "";
            }
            DocumentFile directory = DocumentFileUtils.makeFolder(targetFolder, context, (String)object2, CreateMode.REUSE);
            if (directory == null) {
                CoroutineScope $this$postToUi$iv4 = callback.getUiScope();
                boolean $i$f$postToUi3 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv4, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            documentFile = directory;
        }
        DocumentFile targetDirectory = documentFile;
        Object $i$f$postToUi3 = fileDescription;
        String string2 = $this$postToUi$iv4 = $i$f$postToUi3 == null ? null : ((FileDescription)$i$f$postToUi3).getName();
        if ($this$postToUi$iv4 == null) {
            $i$f$postToUi3 = this.getName();
            boolean bl2 = false;
            object = $i$f$postToUi3;
            if (object == null) {
                object = "";
            }
        } else {
            object = $this$postToUi$iv4;
        }
        $i$f$postToUi3 = fileDescription;
        $this$postToUi$iv4 = $i$f$postToUi3 == null ? null : ((FileDescription)$i$f$postToUi3).getMimeType();
        String cleanFileName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(MimeType.getFullFileName((String)object, $this$postToUi$iv4 == null ? this.getType() : $this$postToUi$iv4)));
        FileCallback.ConflictResolution conflictResolution = this.handleFileConflict(targetDirectory, cleanFileName, callback);
        if (conflictResolution == FileCallback.ConflictResolution.SKIP) {
            return;
        }
        Thread thread = Thread.currentThread();
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, this, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FileCallback $callback$inlined;
            final /* synthetic */ MediaFile this$0;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = fileCallback;
                this.this$0 = mediaFile;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.this$0, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ MediaFile this$0;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = fileCallback;
                                this.this$0 = mediaFile;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Long l;
                                        ResultKt.throwOnFailure((Object)object);
                                        Result.Companion companion = Result.Companion;
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        Long l2 = l = Boxing.boxLong((long)this.$callback$inlined.onStart(this.this$0, this.$thread$inlined));
                                        boolean bl2 = false;
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)l2));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        boolean watchProgress = reportInterval > 0L;
        try {
            FileDescription fileDescription2 = fileDescription;
            String string3 = fileDescription2 == null ? null : fileDescription2.getMimeType();
            DocumentFile documentFile2 = this.createTargetFile(targetDirectory, cleanFileName, string3 == null ? this.getType() : string3, conflictResolution.toCreateMode(), callback);
            if (documentFile2 == null) {
                return;
            }
            DocumentFile targetFile = documentFile2;
            MediaFile this_$iv = this;
            boolean $i$f$createFileStreams = false;
            fileDescription2 = this_$iv.context;
            Intrinsics.checkNotNullExpressionValue((Object)fileDescription2, (String)"context");
            OutputStream outputStream$iv = DocumentFileUtils.openOutputStream$default(targetFile, (Context)fileDescription2, false, 2, null);
            if (outputStream$iv == null) {
                CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                boolean $i$f$postToUi4 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
            } else {
                InputStream inputStream$iv = this_$iv.openInputStream();
                if (inputStream$iv == null) {
                    CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                    boolean $i$f$postToUi5 = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
                    IOUtils.closeStream(outputStream$iv);
                } else {
                    void outputStream;
                    OutputStream outputStream2 = outputStream$iv;
                    InputStream inputStream = inputStream$iv;
                    boolean bl3 = false;
                    this.copyFileStream(inputStream, (OutputStream)outputStream, targetFile, watchProgress, reportInterval, false, callback);
                }
            }
        }
        catch (SecurityException e) {
            this.handleSecurityException(e, callback);
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv5 = callback.getUiScope();
            boolean $i$f$postToUi6 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv5, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public static /* synthetic */ void copyTo$default(MediaFile mediaFile, DocumentFile documentFile, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 2) != 0) {
            fileDescription = null;
        }
        mediaFile.copyTo(documentFile, fileDescription, fileCallback);
    }

    private final DocumentFile createTargetFile(DocumentFile targetDirectory, String fileName, String mimeType, CreateMode mode, FileCallback callback) {
        try {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context context2 = context;
            context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            String string2 = DocumentFileUtils.getStorageId(targetDirectory, context);
            context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            String absolutePath = DocumentFileCompat.buildAbsolutePath(context2, string2, DocumentFileUtils.getBasePath(targetDirectory, context));
            Context context3 = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
            DocumentFile targetFolder = DocumentFileCompat.mkdirs$default(context3, absolutePath, false, false, 12, null);
            if (targetFolder == null) {
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return null;
            }
            Context $i$f$postToUi = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$postToUi, (String)"context");
            DocumentFile targetFile = DocumentFileUtils.makeFile(targetFolder, $i$f$postToUi, fileName, mimeType, mode);
            if (targetFile != null) {
                return targetFile;
            }
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi2 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        catch (SecurityException e) {
            this.handleSecurityException(e, callback);
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return null;
    }

    private final void createFileStreams(DocumentFile targetFile, FileCallback callback, Function2<? super InputStream, ? super OutputStream, Unit> onStreamsReady) {
        boolean $i$f$createFileStreams = false;
        Context context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        OutputStream outputStream = DocumentFileUtils.openOutputStream$default(targetFile, context, false, 2, null);
        if (outputStream == null) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
            return;
        }
        InputStream inputStream = this.openInputStream();
        if (inputStream == null) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
            IOUtils.closeStream(outputStream);
            return;
        }
        onStreamsReady.invoke((Object)inputStream, (Object)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void copyFileStream(InputStream inputStream, OutputStream outputStream, DocumentFile targetFile, boolean watchProgress, long reportInterval, boolean deleteSourceFileWhenComplete, FileCallback callback) {
        block8: {
            Job job;
            block7: {
                Job timer2 = null;
                try {
                    Ref.LongRef bytesMoved = new Ref.LongRef();
                    Ref.IntRef writeSpeed = new Ref.IntRef();
                    long srcSize = this.getLength();
                    if (watchProgress && srcSize > 0xA00000L) {
                        timer2 = CoroutineExtKt.startCoroutineTimer$default(0L, reportInterval, false, (Function0)new Function0<Unit>(bytesMoved, srcSize, writeSpeed, callback){
                            final /* synthetic */ Ref.LongRef $bytesMoved;
                            final /* synthetic */ long $srcSize;
                            final /* synthetic */ Ref.IntRef $writeSpeed;
                            final /* synthetic */ FileCallback $callback;
                            {
                                this.$bytesMoved = $bytesMoved;
                                this.$srcSize = $srcSize;
                                this.$writeSpeed = $writeSpeed;
                                this.$callback = $callback;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                void $this$postToUi$iv;
                                FileCallback.Report report = new FileCallback.Report((float)this.$bytesMoved.element * 100.0f / (float)this.$srcSize, this.$bytesMoved.element, this.$writeSpeed.element);
                                CoroutineScope coroutineScope = this.$callback.getUiScope();
                                FileCallback fileCallback = this.$callback;
                                boolean $i$f$postToUi = false;
                                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, fileCallback, report){
                                    int label;
                                    final /* synthetic */ FileCallback $callback$inlined;
                                    final /* synthetic */ FileCallback.Report $report$inlined;
                                    {
                                        this.$callback$inlined = fileCallback;
                                        this.$report$inlined = report;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                boolean bl = false;
                                                this.$callback$inlined.onReport(this.$report$inlined);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)2, null);
                                this.$writeSpeed.element = 0;
                            }
                        }, 5, null);
                    }
                    byte[] buffer = new byte[1024];
                    int read = inputStream.read(buffer);
                    while (read != -1) {
                        outputStream.write(buffer, 0, read);
                        bytesMoved.element += (long)read;
                        writeSpeed.element += read;
                        read = inputStream.read(buffer);
                    }
                    Job job2 = timer2;
                    if (job2 != null) {
                        Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                    }
                    if (deleteSourceFileWhenComplete) {
                        this.delete();
                    }
                    CoroutineScope $this$postToUi$iv = callback.getUiScope();
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, targetFile){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        final /* synthetic */ DocumentFile $targetFile$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            this.$targetFile$inlined = documentFile;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onCompleted(this.$targetFile$inlined);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    job = timer2;
                    if (job != null) break block7;
                    break block8;
                }
                catch (Throwable throwable) {
                    Job job3 = timer2;
                    if (job3 != null) {
                        Job.DefaultImpls.cancel$default(job3, null, (int)1, null);
                    }
                    IOUtils.closeStream(inputStream);
                    IOUtils.closeStream(outputStream);
                    throw throwable;
                }
            }
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        IOUtils.closeStream(inputStream);
        IOUtils.closeStream(outputStream);
    }

    private final FileCallback.ConflictResolution handleFileConflict(DocumentFile targetFolder, String fileName, FileCallback callback) {
        Context context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        DocumentFile documentFile = DocumentFileUtils.child$default(targetFolder, context, fileName, false, 4, null);
        if (documentFile != null) {
            context = documentFile;
            boolean bl = false;
            boolean bl2 = false;
            Context targetFile = context;
            boolean bl3 = false;
            CoroutineScope uiScope$iv = callback.getUiScope();
            boolean $i$f$awaitUiResultWithPending = false;
            FileCallback.ConflictResolution resolution = (FileCallback.ConflictResolution)((Object)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileCallback.ConflictResolution>, Object>(uiScope$iv, null, callback, (DocumentFile)targetFile){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CoroutineScope $uiScope;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ DocumentFile $targetFile$inlined;
                {
                    this.$uiScope = $uiScope;
                    this.$callback$inlined = fileCallback;
                    this.$targetFile$inlined = documentFile;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope coroutineScope = this.$uiScope;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            this.L$0 = coroutineScope;
                            this.label = 1;
                            Continuation uCont$iv = (Continuation)this;
                            boolean bl = false;
                            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                            cancellable$iv.initCancellability();
                            CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                            boolean bl2 = false;
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$targetFile$inlined){
                                int label;
                                final /* synthetic */ CancellableContinuation $it;
                                final /* synthetic */ FileCallback $callback$inlined;
                                final /* synthetic */ DocumentFile $targetFile$inlined;
                                {
                                    this.$it = $it;
                                    this.$callback$inlined = fileCallback;
                                    this.$targetFile$inlined = documentFile;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            CancellableContinuation it = this.$it;
                                            boolean bl = false;
                                            this.$callback$inlined.onConflict(this.$targetFile$inlined, new FileCallback.FileConflictAction((CancellableContinuation<? super FileCallback.ConflictResolution>)it));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            Object object3 = cancellable$iv.getResult();
                            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                            }
                            Object object4 = object3;
                            if (object3 != object2) return object4;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return object4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super FileCallback.ConflictResolution> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null));
            if (resolution == FileCallback.ConflictResolution.REPLACE) {
                uiScope$iv = this.context;
                Intrinsics.checkNotNullExpressionValue((Object)uiScope$iv, (String)"context");
                if (!DocumentFileUtils.forceDelete$default((DocumentFile)targetFile, (Context)uiScope$iv, false, 2, null)) {
                    CoroutineScope $this$postToUi$iv = callback.getUiScope();
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    return FileCallback.ConflictResolution.SKIP;
                }
            }
            return resolution;
        }
        return FileCallback.ConflictResolution.CREATE_NEW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getColumnInfoString(String column) {
        Object object = new String[]{column};
        Cursor cursor = this.context.getContentResolver().query(this.uri, object, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                int columnIndex;
                Cursor cursor2 = (Cursor)object;
                boolean bl3 = false;
                if (cursor2.moveToFirst() && (columnIndex = cursor2.getColumnIndex(column)) != -1) {
                    String string2 = cursor2.getString(columnIndex);
                    return string2;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getColumnInfoLong(String column) {
        Object object = new String[]{column};
        Cursor cursor = this.context.getContentResolver().query(this.uri, object, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                int columnIndex;
                Cursor cursor2 = (Cursor)object;
                boolean bl3 = false;
                if (cursor2.moveToFirst() && (columnIndex = cursor2.getColumnIndex(column)) != -1) {
                    long l = cursor2.getLong(columnIndex);
                    return l;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getColumnInfoInt(String column) {
        Object object = new String[]{column};
        Cursor cursor = this.context.getContentResolver().query(this.uri, object, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                int columnIndex;
                Cursor cursor2 = (Cursor)object;
                boolean bl3 = false;
                if (cursor2.moveToFirst() && (columnIndex = cursor2.getColumnIndex(column)) != -1) {
                    int n = cursor2.getInt(columnIndex);
                    return n;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof MediaFile && Intrinsics.areEqual((Object)((MediaFile)other).uri, (Object)this.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @NotNull
    public String toString() {
        String string2 = this.uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
        return string2;
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final OutputStream openOutputStream() {
        return MediaFile.openOutputStream$default(this, false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/anggrayudi/storage/media/MediaFile$AccessCallback;", "", "onWriteAccessDenied", "", "mediaFile", "Lcom/anggrayudi/storage/media/MediaFile;", "sender", "Landroid/content/IntentSender;", "storage_release"})
    public static interface AccessCallback {
        public void onWriteAccessDenied(@NotNull MediaFile var1, @NotNull IntentSender var2);
    }
}

