/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.media;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.webkit.MimeTypeMap;
import androidx.annotation.RequiresApi;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.file.CreateMode;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.DocumentFileType;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.FileUtils;
import com.anggrayudi.storage.file.PublicDirectory;
import com.anggrayudi.storage.media.AudioMediaDirectory;
import com.anggrayudi.storage.media.FileDescription;
import com.anggrayudi.storage.media.ImageMediaDirectory;
import com.anggrayudi.storage.media.MediaFile;
import com.anggrayudi.storage.media.MediaType;
import com.anggrayudi.storage.media.VideoMediaDirectory;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J$\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J2\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u001b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\"\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\"\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0004H\u0007J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0004H\u0007J\"\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0007J\"\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0004H\u0007J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0004H\u0007J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0007J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0004H\u0007J\"\u0010-\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0007J\u0012\u00101\u001a\u0004\u0018\u00010\u00172\u0006\u00102\u001a\u00020\u0004H\u0003R\u001a\u0010\u0003\u001a\u00020\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00063"}, d2={"Lcom/anggrayudi/storage/media/MediaStoreCompat;", "", "()V", "volumeName", "", "getVolumeName$annotations", "getVolumeName", "()Ljava/lang/String;", "createAudio", "Lcom/anggrayudi/storage/media/MediaFile;", "context", "Landroid/content/Context;", "file", "Lcom/anggrayudi/storage/media/FileDescription;", "relativeParentDirectory", "Lcom/anggrayudi/storage/media/AudioMediaDirectory;", "mode", "Lcom/anggrayudi/storage/file/CreateMode;", "createDownload", "createImage", "Lcom/anggrayudi/storage/media/ImageMediaDirectory;", "createMedia", "mediaType", "Lcom/anggrayudi/storage/media/MediaType;", "folderName", "fullPath", "createVideo", "Lcom/anggrayudi/storage/media/VideoMediaDirectory;", "fromBasePath", "basePath", "fromCursorToMediaFile", "cursor", "Landroid/database/Cursor;", "fromCursorToMediaFiles", "", "fromFileName", "name", "fromFileNameContains", "containsName", "fromMediaId", "id", "", "fromMediaType", "fromMimeType", "mimeType", "fromRelativePath", "publicDirectory", "Lcom/anggrayudi/storage/file/PublicDirectory;", "relativePath", "mediaTypeFromRelativePath", "cleanRelativePath", "storage_release"})
public final class MediaStoreCompat {
    @NotNull
    public static final MediaStoreCompat INSTANCE = new MediaStoreCompat();

    private MediaStoreCompat() {
    }

    @SuppressLint(value={"InlinedApi"})
    @NotNull
    public static final String getVolumeName() {
        return Build.VERSION.SDK_INT < 29 ? "external" : "external_primary";
    }

    @JvmStatic
    public static /* synthetic */ void getVolumeName$annotations() {
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createDownload(@NotNull Context context, @NotNull FileDescription file, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        String string2 = Environment.DIRECTORY_DOWNLOADS;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DIRECTORY_DOWNLOADS");
        return INSTANCE.createMedia(context, MediaType.DOWNLOADS, string2, file, mode);
    }

    public static /* synthetic */ MediaFile createDownload$default(Context context, FileDescription fileDescription, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createDownload(context, fileDescription, createMode);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createImage(@NotNull Context context, @NotNull FileDescription file, @NotNull ImageMediaDirectory relativeParentDirectory, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return INSTANCE.createMedia(context, MediaType.IMAGE, relativeParentDirectory.getFolderName(), file, mode);
    }

    public static /* synthetic */ MediaFile createImage$default(Context context, FileDescription fileDescription, ImageMediaDirectory imageMediaDirectory, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            imageMediaDirectory = ImageMediaDirectory.PICTURES;
        }
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createImage(context, fileDescription, imageMediaDirectory, createMode);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createAudio(@NotNull Context context, @NotNull FileDescription file, @NotNull AudioMediaDirectory relativeParentDirectory, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return INSTANCE.createMedia(context, MediaType.AUDIO, relativeParentDirectory.getFolderName(), file, mode);
    }

    public static /* synthetic */ MediaFile createAudio$default(Context context, FileDescription fileDescription, AudioMediaDirectory audioMediaDirectory, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            audioMediaDirectory = AudioMediaDirectory.MUSIC;
        }
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createAudio(context, fileDescription, audioMediaDirectory, createMode);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createVideo(@NotNull Context context, @NotNull FileDescription file, @NotNull VideoMediaDirectory relativeParentDirectory, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return INSTANCE.createMedia(context, MediaType.VIDEO, relativeParentDirectory.getFolderName(), file, mode);
    }

    public static /* synthetic */ MediaFile createVideo$default(Context context, FileDescription fileDescription, VideoMediaDirectory videoMediaDirectory, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            videoMediaDirectory = VideoMediaDirectory.MOVIES;
        }
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createVideo(context, fileDescription, videoMediaDirectory, createMode);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createMedia(@NotNull Context context, @NotNull String fullPath, @NotNull FileDescription file, @NotNull CreateMode mode) {
        MediaType mediaType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        String basePath = TextUtils.trimFileSeparator(DocumentFileCompat.getBasePath(context, fullPath));
        CharSequence charSequence = basePath;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        String mediaFolder = StringsKt.substringBefore$default((String)basePath, (char)'/', null, (int)2, null);
        String string2 = mediaFolder;
        if (Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_DOWNLOADS)) {
            mediaType = MediaType.DOWNLOADS;
        } else {
            String string3;
            Enum it;
            Collection collection;
            Enum[] $this$mapTo$iv$iv;
            Enum[] $this$map$iv = ImageMediaDirectory.values();
            boolean $i$f$map = false;
            ImageMediaDirectory[] imageMediaDirectoryArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (Enum item$iv$iv : $this$mapTo$iv$iv) {
                void var17_18 = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                string3 = ((ImageMediaDirectory)it).getFolderName();
                collection.add(string3);
            }
            if (((List)destination$iv$iv).contains(string2)) {
                mediaType = MediaType.IMAGE;
            } else {
                int n;
                Enum item$iv$iv;
                $this$map$iv = AudioMediaDirectory.values();
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.length);
                $i$f$mapTo = false;
                Enum[] enumArray = $this$mapTo$iv$iv;
                int n2 = enumArray.length;
                for (n = 0; n < n2; ++n) {
                    it = item$iv$iv = enumArray[n];
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    string3 = ((AudioMediaDirectory)it).getFolderName();
                    collection.add(string3);
                }
                if (((List)destination$iv$iv).contains(string2)) {
                    mediaType = MediaType.AUDIO;
                } else {
                    $this$map$iv = VideoMediaDirectory.values();
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.length);
                    $i$f$mapTo = false;
                    enumArray = $this$mapTo$iv$iv;
                    n2 = enumArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = item$iv$iv = enumArray[n];
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        string3 = ((VideoMediaDirectory)it).getFolderName();
                        collection.add(string3);
                    }
                    if (((List)destination$iv$iv).contains(string2)) {
                        mediaType = MediaType.VIDEO;
                    } else {
                        return null;
                    }
                }
            }
        }
        MediaType mediaType2 = mediaType;
        String subFolder = StringsKt.substringAfter((String)basePath, (char)'/', (String)"");
        file.setSubFolder(TextUtils.trimFileSeparator(subFolder + '/' + file.getSubFolder()));
        return INSTANCE.createMedia(context, mediaType2, mediaFolder, file, mode);
    }

    public static /* synthetic */ MediaFile createMedia$default(Context context, String string2, FileDescription fileDescription, CreateMode createMode, int n, Object object) {
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createMedia(context, string2, fileDescription, createMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final MediaFile createMedia(Context context, MediaType mediaType, String folderName, FileDescription file, CreateMode mode) {
        MediaFile mediaFile;
        if (Build.VERSION.SDK_INT >= 29) {
            long dateCreated = System.currentTimeMillis();
            ContentValues contentValues = new ContentValues();
            boolean bl = false;
            boolean bl2 = false;
            ContentValues $this$createMedia_u24lambda_u2d522 = contentValues;
            boolean bl3 = false;
            $this$createMedia_u24lambda_u2d522.put("_display_name", file.getName());
            $this$createMedia_u24lambda_u2d522.put("mime_type", file.getMimeType());
            $this$createMedia_u24lambda_u2d522.put("date_added", Long.valueOf(dateCreated));
            $this$createMedia_u24lambda_u2d522.put("date_modified", Long.valueOf(dateCreated));
            ContentValues contentValues2 = contentValues;
            String relativePath = TextUtils.trimFileSeparator(folderName + '/' + file.getSubFolder());
            ContentValues contentValues3 = contentValues2;
            bl2 = false;
            boolean $this$createMedia_u24lambda_u2d522 = false;
            Object $this$createMedia_u24lambda_u2d4 = contentValues3;
            boolean bl4 = false;
            $this$createMedia_u24lambda_u2d4.put("owner_package_name", context.getPackageName());
            Object object = relativePath;
            boolean bl5 = false;
            if (!StringsKt.isBlank((CharSequence)object)) {
                $this$createMedia_u24lambda_u2d4.put("relative_path", relativePath);
            }
            MediaFile existingMedia = MediaStoreCompat.fromBasePath(context, mediaType, relativePath + '/' + file.getName());
            MediaFile mediaFile2 = existingMedia;
            if (mediaFile2 == null ? false : mediaFile2.isEmpty()) {
                mediaFile = existingMedia;
            } else {
                mediaFile2 = existingMedia;
                if (mediaFile2 == null ? false : mediaFile2.getExists()) {
                    boolean bl6;
                    Object object2;
                    Comparable comparable;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object it;
                    void $this$filterTo$iv$iv;
                    Object $this$filter$iv;
                    if (mode == CreateMode.REUSE) {
                        return existingMedia;
                    }
                    if (mode == CreateMode.REPLACE) {
                        existingMedia.delete();
                        ContentResolver contentResolver = context.getContentResolver();
                        Uri uri = mediaType.getWriteUri();
                        Intrinsics.checkNotNull((Object)uri);
                        Uri $this$createMedia_u24lambda_u2d522 = contentResolver.insert(uri, contentValues2);
                        if ($this$createMedia_u24lambda_u2d522 == null) {
                            return null;
                        }
                        mediaFile2 = $this$createMedia_u24lambda_u2d522;
                        return new MediaFile(context, (Uri)mediaFile2);
                    }
                    $this$createMedia_u24lambda_u2d4 = MimeTypeMap.getSingleton().getExtensionFromMimeType(file.getMimeType());
                    Object $this$createMedia_u24lambda_u2d522 = $this$createMedia_u24lambda_u2d4 == null ? StringsKt.substringAfterLast((String)file.getName(), (char)'.', (String)"") : $this$createMedia_u24lambda_u2d4;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$createMedia_u24lambda_u2d522, (String)"MimeTypeMap.getSingleton().getExtensionFromMimeType(file.mimeType) ?: file.name.substringAfterLast('.', \"\")");
                    Object ext = $this$createMedia_u24lambda_u2d522;
                    String baseName = StringsKt.substringBeforeLast$default((String)file.getName(), (char)'.', null, (int)2, null);
                    String prefix = Intrinsics.stringPlus((String)baseName, (Object)" (");
                    object = MediaStoreCompat.fromFileNameContains(context, mediaType, baseName);
                    boolean $i$f$filter = false;
                    Object object3 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (MediaFile)element$iv$iv;
                        boolean bl7 = false;
                        if (!(StringsKt.isBlank((CharSequence)relativePath) || Intrinsics.areEqual((Object)relativePath, (Object)StringsKt.removeSuffix((String)((MediaFile)it).getRelativePath(), (CharSequence)"/")))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        String string2;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = it.next();
                        boolean bl8 = false;
                        MediaFile it2 = (MediaFile)element$iv$iv;
                        boolean bl9 = false;
                        if (it2.getName() == null) continue;
                        boolean bl10 = false;
                        boolean bl11 = false;
                        String it$iv$iv = string2;
                        boolean bl12 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$filter = false;
                    $this$mapNotNullTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (String)element$iv$iv;
                        boolean bl13 = false;
                        boolean bl14 = StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null) && (DocumentFileCompat.INSTANCE.getFILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION().matches((CharSequence)it) || DocumentFileCompat.INSTANCE.getFILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION().matches((CharSequence)it));
                        if (!bl14) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    bl5 = false;
                    object3 = $this$filter$iv.iterator();
                    if (!object3.hasNext()) {
                        comparable = null;
                    } else {
                        String it3 = (String)object3.next();
                        boolean bl15 = false;
                        object2 = (Comparable)((Object)it3);
                        while (object3.hasNext()) {
                            String it4 = (String)object3.next();
                            $i$a$-maxOfOrNull-MediaStoreCompat$createMedia$lastFile$4 = false;
                            Comparable comparable2 = (Comparable)((Object)it4);
                            if (object2.compareTo(comparable2) >= 0) continue;
                            object2 = comparable2;
                        }
                        comparable = object2;
                    }
                    $this$filter$iv = (String)((Object)comparable);
                    bl5 = false;
                    Object object4 = $this$filter$iv;
                    if (object4 == null) {
                        object4 = "";
                    }
                    Object lastFile = object4;
                    Object object5 = StringsKt.toIntOrNull((String)StringsKt.substringBefore((String)StringsKt.substringAfterLast((String)lastFile, (char)'(', (String)""), (char)')', (String)""));
                    int count = object5 == null ? 0 : (Integer)object5;
                    object5 = new char[1];
                    object5[0] = 46;
                    existingMedia = MediaStoreCompat.fromFileName(context, mediaType, StringsKt.trimEnd((String)(baseName + " (" + count + ")." + (String)ext), (char[])object5));
                    object5 = existingMedia;
                    if (object5 == null) {
                        bl6 = false;
                    } else {
                        object3 = ((MediaFile)object5).openInputStream();
                        if (object3 == null) {
                            bl6 = false;
                        } else {
                            boolean bl16;
                            object2 = (Closeable)object3;
                            boolean bl17 = false;
                            boolean bl18 = false;
                            Throwable throwable = null;
                            try {
                                InputStream it5 = (InputStream)object2;
                                boolean bl19 = false;
                                bl16 = it5.available() == 0;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                            }
                            bl6 = bl16;
                        }
                    }
                    if (bl6) {
                        mediaFile = existingMedia;
                    } else {
                        object5 = new char[1];
                        object5[0] = 46;
                        contentValues2.put("_display_name", StringsKt.trimEnd((String)(baseName + " (" + ++count + ")." + (String)ext), (char[])object5));
                        ContentResolver contentResolver = context.getContentResolver();
                        Uri uri = mediaType.getWriteUri();
                        Intrinsics.checkNotNull((Object)uri);
                        object3 = contentResolver.insert(uri, contentValues2);
                        if (object3 == null) {
                            return null;
                        }
                        object5 = object3;
                        MediaFile mediaFile3 = new MediaFile(context, (Uri)object5);
                        mediaFile = mediaFile3;
                    }
                } else {
                    ContentResolver contentResolver = context.getContentResolver();
                    Uri uri = mediaType.getWriteUri();
                    Intrinsics.checkNotNull((Object)uri);
                    Uri uri2 = contentResolver.insert(uri, contentValues2);
                    if (uri2 == null) {
                        return null;
                    }
                    mediaFile2 = uri2;
                    MediaFile mediaFile4 = new MediaFile(context, (Uri)mediaFile2);
                    mediaFile = mediaFile4;
                }
            }
        } else {
            File publicDirectory = Environment.getExternalStoragePublicDirectory((String)folderName);
            Intrinsics.checkNotNullExpressionValue((Object)publicDirectory, (String)"publicDirectory");
            if (FileUtils.canModify(publicDirectory, context)) {
                String filename = file.getFullName();
                File media = new File(publicDirectory + '/' + file.getSubFolder(), filename);
                File file2 = media.getParentFile();
                if (file2 == null) {
                    return null;
                }
                File parentFile = file2;
                parentFile.mkdirs();
                if (media.exists() && mode == CreateMode.CREATE_NEW) {
                    media = FileUtils.child(parentFile, FileUtils.autoIncrementFileName(parentFile, filename));
                }
                if (mode == CreateMode.REPLACE && !FileUtils.recreateFile(media)) {
                    return null;
                }
                mediaFile = FileUtils.createNewFileIfPossible(media) ? (media.canRead() ? new MediaFile(context, media) : null) : null;
            } else {
                mediaFile = null;
            }
        }
        return mediaFile;
    }

    @JvmStatic
    @Nullable
    public static final MediaFile fromMediaId(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String id) {
        MediaFile mediaFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Uri uri = mediaType.getWriteUri();
        if (uri == null) {
            mediaFile = null;
        } else {
            Uri uri2 = uri;
            boolean bl = false;
            boolean bl2 = false;
            Uri it = uri2;
            boolean bl3 = false;
            Uri uri3 = it.buildUpon().appendPath(id).build();
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"it.buildUpon().appendPath(id).build()");
            MediaFile mediaFile2 = new MediaFile(context, uri3);
            mediaFile = mediaFile2;
        }
        return mediaFile;
    }

    @JvmStatic
    @Nullable
    public static final MediaFile fromMediaId(@NotNull Context context, @NotNull MediaType mediaType, long id) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        return MediaStoreCompat.fromMediaId(context, mediaType, String.valueOf(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final MediaFile fromFileName(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String name) {
        MediaFile mediaFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Build.VERSION.SDK_INT < 29) {
            File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), name);
            boolean bl = false;
            boolean bl2 = false;
            File it = file;
            boolean bl3 = false;
            mediaFile = it.isFile() && it.canRead() ? new MediaFile(context, it) : null;
        } else {
            String selection = "_display_name = ?";
            Object object = mediaType.getReadUri();
            if (object == null) {
                return null;
            }
            String[] stringArray = object;
            object = new String[]{"_id"};
            String[] stringArray2 = object;
            object = new String[]{name};
            Cursor cursor = context.getContentResolver().query((Uri)stringArray, stringArray2, selection, object, null);
            if (cursor == null) {
                mediaFile = null;
            } else {
                object = (Closeable)cursor;
                boolean bl = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl5 = false;
                    MediaFile mediaFile2 = INSTANCE.fromCursorToMediaFile(context, mediaType, it);
                    mediaFile = mediaFile2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }
        return mediaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final MediaFile fromBasePath(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String basePath) {
        MediaFile mediaFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        String cleanBasePath = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(basePath));
        if (Build.VERSION.SDK_INT < 29) {
            File file = new File(Environment.getExternalStorageDirectory(), cleanBasePath);
            boolean bl = false;
            boolean bl2 = false;
            File it = file;
            boolean bl3 = false;
            mediaFile = it.isFile() && it.canRead() ? new MediaFile(context, it) : null;
        } else {
            String relativePath = StringsKt.substringBeforeLast((String)cleanBasePath, (char)'/', (String)"");
            CharSequence charSequence = relativePath;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return null;
            }
            String filename = StringsKt.substringAfterLast$default((String)cleanBasePath, (char)'/', null, (int)2, null);
            String selection = "_display_name = ? AND relative_path = ?";
            Object object = mediaType.getReadUri();
            if (object == null) {
                return null;
            }
            String[] stringArray = object;
            object = new String[]{"_id"};
            String[] stringArray2 = object;
            object = new String[]{filename, Intrinsics.stringPlus((String)relativePath, (Object)"/")};
            Cursor cursor = context.getContentResolver().query((Uri)stringArray, stringArray2, selection, object, null);
            if (cursor == null) {
                mediaFile = null;
            } else {
                object = (Closeable)cursor;
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl6 = false;
                    MediaFile mediaFile2 = INSTANCE.fromCursorToMediaFile(context, mediaType, it);
                    mediaFile = mediaFile2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }
        return mediaFile;
    }

    @RequiresApi(value=29)
    private final MediaType mediaTypeFromRelativePath(String cleanRelativePath) {
        String string2 = cleanRelativePath;
        return (Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_DCIM) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_PICTURES)) ? MediaType.IMAGE : ((Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_MOVIES) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_DCIM)) ? MediaType.VIDEO : (((((Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_MUSIC) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_PODCASTS)) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_RINGTONES)) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_ALARMS)) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_NOTIFICATIONS)) ? MediaType.AUDIO : (Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_DOWNLOADS) ? MediaType.DOWNLOADS : null)));
    }

    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromRelativePath(@NotNull Context context, @NotNull PublicDirectory publicDirectory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)publicDirectory), (String)"publicDirectory");
        return MediaStoreCompat.fromRelativePath(context, publicDirectory.getFolderName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromRelativePath(@NotNull Context context, @NotNull String relativePath) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String cleanRelativePath = TextUtils.trimFileSeparator(relativePath);
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            DocumentFile documentFile = DocumentFile.fromFile((File)new File(Environment.getExternalStorageDirectory(), cleanRelativePath));
            Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(File(Environment.getExternalStorageDirectory(), cleanRelativePath))");
            Iterable $this$map$iv = DocumentFileUtils.search$default(documentFile, true, DocumentFileType.FILE, null, null, null, 28, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DocumentFile documentFile2 = (DocumentFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                MediaFile mediaFile = new MediaFile(context, new File(string2));
                collection.add(mediaFile);
            }
        } else {
            List<MediaFile> list;
            MediaType $i$f$map = INSTANCE.mediaTypeFromRelativePath(cleanRelativePath);
            if ($i$f$map == null) {
                return CollectionsKt.emptyList();
            }
            MediaType mediaType = $i$f$map;
            char[] $this$mapTo$iv$iv = new char[]{'/'};
            String relativePathWithSlashSuffix = Intrinsics.stringPlus((String)StringsKt.trimEnd((String)relativePath, (char[])$this$mapTo$iv$iv), (Object)"/");
            String selection = "relative_path IN(?, ?)";
            String[] stringArray = new String[]{relativePathWithSlashSuffix, cleanRelativePath};
            String[] selectionArgs = stringArray;
            Object object = mediaType.getReadUri();
            if (object == null) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray2 = object;
            object = new String[]{"_id"};
            stringArray = context.getContentResolver().query((Uri)stringArray2, object, selection, selectionArgs, null);
            if (stringArray == null) {
                list = null;
            } else {
                object = (Closeable)stringArray;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl3 = false;
                    List<MediaFile> list2 = INSTANCE.fromCursorToMediaFiles(context, mediaType, it);
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            stringArray = list;
            boolean bl = false;
            Object object2 = stringArray;
            if (stringArray == null) {
                object2 = CollectionsKt.emptyList();
            }
            return object2;
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MediaFile fromRelativePath(@NotNull Context context, @NotNull String relativePath, @NotNull String name) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String cleanRelativePath = TextUtils.trimFileSeparator(relativePath);
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = DocumentFile.fromFile((File)new File(Environment.getExternalStorageDirectory(), cleanRelativePath));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromFile(File(Environment.getExternalStorageDirectory(), cleanRelativePath))");
            object = DocumentFileUtils.search$default(object, true, DocumentFileType.FILE, null, name, null, 20, null);
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DocumentFile documentFile = (DocumentFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                MediaFile mediaFile = new MediaFile(context, new File(string2));
                collection.add(mediaFile);
            }
        } else {
            MediaFile mediaFile;
            MediaType $i$f$map = INSTANCE.mediaTypeFromRelativePath(cleanRelativePath);
            if ($i$f$map == null) {
                return null;
            }
            MediaType mediaType = $i$f$map;
            char[] $this$mapTo$iv$iv = new char[]{'/'};
            String relativePathWithSlashSuffix = Intrinsics.stringPlus((String)StringsKt.trimEnd((String)relativePath, (char[])$this$mapTo$iv$iv), (Object)"/");
            String selection = "_display_name = ? AND relative_path IN(?, ?)";
            String[] stringArray = new String[]{name, relativePathWithSlashSuffix, cleanRelativePath};
            String[] selectionArgs = stringArray;
            Object object = mediaType.getReadUri();
            if (object == null) {
                return null;
            }
            String[] stringArray2 = object;
            object = new String[]{"_id"};
            stringArray = context.getContentResolver().query((Uri)stringArray2, object, selection, selectionArgs, null);
            if (stringArray == null) {
                mediaFile = null;
            } else {
                object = (Closeable)stringArray;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl3 = false;
                    MediaFile mediaFile2 = INSTANCE.fromCursorToMediaFile(context, mediaType, it);
                    mediaFile = mediaFile2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            return mediaFile;
        }
        return (MediaFile)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromFileNameContains(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String containsName) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)containsName, (String)"containsName");
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = mediaType.getDirectories();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void directory;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = new Regex("^.*" + containsName + ".*$");
                DocumentFile documentFile = new DocumentFile[]{mediaType.getMimeType()};
                DocumentFile documentFile2 = documentFile;
                documentFile = DocumentFile.fromFile((File)directory);
                Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(directory)");
                object = DocumentFileUtils.search$default(documentFile, true, null, (String[])documentFile2, null, object, 10, null);
                boolean $i$f$map2 = false;
                documentFile = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    DocumentFile documentFile3 = (DocumentFile)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = it.getUri().getPath();
                    Intrinsics.checkNotNull((Object)string2);
                    MediaFile mediaFile = new MediaFile(context, new File(string2));
                    collection2.add(mediaFile);
                }
                List list = (List)destination$iv$iv2;
                collection.add(list);
            }
        } else {
            List<MediaFile> list;
            String selection = "_display_name LIKE '%" + containsName + "%'";
            Object object = mediaType.getReadUri();
            if (object == null) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray = object;
            object = new String[]{"_id"};
            Cursor cursor = context.getContentResolver().query((Uri)stringArray, object, selection, null, null);
            if (cursor == null) {
                list = null;
            } else {
                object = (Closeable)cursor;
                boolean bl = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl4 = false;
                    List<MediaFile> list2 = INSTANCE.fromCursorToMediaFiles(context, mediaType, it);
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            cursor = list;
            boolean bl = false;
            Object object2 = cursor;
            if (object2 == null) {
                object2 = CollectionsKt.emptyList();
            }
            return object2;
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromMimeType(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String mimeType) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = mediaType.getDirectories();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void directory;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = DocumentFile.fromFile((File)directory);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromFile(directory)");
                String[] stringArray = object;
                object = new String[]{mimeType};
                object = DocumentFileUtils.search$default((DocumentFile)stringArray, true, DocumentFileType.FILE, object, null, null, 24, null);
                boolean $i$f$map2 = false;
                void var14_25 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    DocumentFile documentFile = (DocumentFile)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = it.getUri().getPath();
                    Intrinsics.checkNotNull((Object)string2);
                    MediaFile mediaFile = new MediaFile(context, new File(string2));
                    collection2.add(mediaFile);
                }
                List list = (List)destination$iv$iv2;
                collection.add(list);
            }
        } else {
            List<MediaFile> list;
            String selection = "mime_type = ?";
            Object object = mediaType.getReadUri();
            if (object == null) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray = object;
            object = new String[]{"_id"};
            String[] stringArray2 = object;
            object = new String[]{mimeType};
            Cursor cursor = context.getContentResolver().query((Uri)stringArray, stringArray2, selection, object, null);
            if (cursor == null) {
                list = null;
            } else {
                object = (Closeable)cursor;
                boolean bl = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl4 = false;
                    List<MediaFile> list2 = INSTANCE.fromCursorToMediaFiles(context, mediaType, it);
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            cursor = list;
            boolean bl = false;
            Object object2 = cursor;
            if (object2 == null) {
                object2 = CollectionsKt.emptyList();
            }
            return object2;
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromMediaType(@NotNull Context context, @NotNull MediaType mediaType) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = mediaType.getDirectories();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void directory;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = DocumentFile.fromFile((File)directory);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromFile(directory)");
                String[] stringArray = object;
                object = new String[]{mediaType.getMimeType()};
                object = DocumentFileUtils.search$default((DocumentFile)stringArray, true, null, object, null, null, 26, null);
                boolean $i$f$map2 = false;
                void var13_23 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    DocumentFile documentFile = (DocumentFile)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = it.getUri().getPath();
                    Intrinsics.checkNotNull((Object)string2);
                    MediaFile mediaFile = new MediaFile(context, new File(string2));
                    collection2.add(mediaFile);
                }
                List list = (List)destination$iv$iv2;
                collection.add(list);
            }
        } else {
            List<MediaFile> list;
            Object object = mediaType.getReadUri();
            if (object == null) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray = object;
            object = new String[]{"_id"};
            Cursor cursor = context.getContentResolver().query((Uri)stringArray, object, null, null, null);
            if (cursor == null) {
                list = null;
            } else {
                object = (Closeable)cursor;
                boolean bl = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl4 = false;
                    List<MediaFile> list2 = INSTANCE.fromCursorToMediaFiles(context, mediaType, it);
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            cursor = list;
            boolean bl = false;
            Object object2 = cursor;
            if (object2 == null) {
                object2 = CollectionsKt.emptyList();
            }
            return object2;
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    private final List<MediaFile> fromCursorToMediaFiles(Context context, MediaType mediaType, Cursor cursor) {
        if (cursor.moveToFirst()) {
            int columnId = cursor.getColumnIndex("_id");
            ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(cursor.getCount());
            do {
                String mediaId = cursor.getString(columnId);
                Intrinsics.checkNotNullExpressionValue((Object)mediaId, (String)"mediaId");
                MediaFile mediaFile = MediaStoreCompat.fromMediaId(context, mediaType, mediaId);
                if (mediaFile == null) continue;
                MediaFile mediaFile2 = mediaFile;
                boolean bl = false;
                boolean bl2 = false;
                MediaFile it = mediaFile2;
                boolean bl3 = false;
                mediaFiles.add(it);
            } while (cursor.moveToNext());
            return mediaFiles;
        }
        return CollectionsKt.emptyList();
    }

    private final MediaFile fromCursorToMediaFile(Context context, MediaType mediaType, Cursor cursor) {
        MediaFile mediaFile;
        if (cursor.moveToFirst()) {
            String mediaId = cursor.getString(cursor.getColumnIndex("_id"));
            Intrinsics.checkNotNullExpressionValue((Object)mediaId, (String)"mediaId");
            mediaFile = MediaStoreCompat.fromMediaId(context, mediaType, mediaId);
        } else {
            mediaFile = null;
        }
        return mediaFile;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createDownload(@NotNull Context context, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createDownload$default(context, file, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createImage(@NotNull Context context, @NotNull FileDescription file, @NotNull ImageMediaDirectory relativeParentDirectory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        return MediaStoreCompat.createImage$default(context, file, relativeParentDirectory, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createImage(@NotNull Context context, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createImage$default(context, file, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createAudio(@NotNull Context context, @NotNull FileDescription file, @NotNull AudioMediaDirectory relativeParentDirectory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        return MediaStoreCompat.createAudio$default(context, file, relativeParentDirectory, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createAudio(@NotNull Context context, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createAudio$default(context, file, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createVideo(@NotNull Context context, @NotNull FileDescription file, @NotNull VideoMediaDirectory relativeParentDirectory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        return MediaStoreCompat.createVideo$default(context, file, relativeParentDirectory, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createVideo(@NotNull Context context, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createVideo$default(context, file, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createMedia(@NotNull Context context, @NotNull String fullPath, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createMedia$default(context, fullPath, file, null, 8, null);
    }
}

