/*
 * Decompiled with CFR 0.152.
 */
package com.animotionsoftware.lib.reactor.viewmodel;

import androidx.annotation.CallSuper;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModel;
import com.animotionsoftware.lib.reactor.util.IdGenerator;
import com.animotionsoftware.lib.reactor.viewmodel.ReactorEvent;
import com.animotionsoftware.lib.reactor.viewmodel.ReactorState;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\"\u001a\u00020\f\"\n\b\u0002\u0010#\u0018\u0001*\u00028\u00002\u0012\b\b\u0010$\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0084\b\u00f8\u0001\u0000J8\u0010\"\u001a\u00020\f\"\n\b\u0002\u0010#\u0018\u0001*\u00028\u00002\u001e\b\b\u0010$\u001a\u0018\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\f0\u0012j\b\u0012\u0004\u0012\u0002H#`\u0013H\u0084\b\u00f8\u0001\u0000J\u001f\u0010%\u001a\u00020\f\"\b\b\u0002\u0010#*\u00028\u00002\u0006\u0010&\u001a\u0002H#H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010*\u001a\u00020\fH\u0015RD\u0010\b\u001a2\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\tj\u0018\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r`\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\\\u0010\u0011\u001aJ\u0012\u0004\u0012\u00020\n\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u0012j\b\u0012\u0004\u0012\u00020\u0002`\u00130\tj$\u0012\u0004\u0012\u00020\n\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u0012j\b\u0012\u0004\u0012\u00020\u0002`\u0013`\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u001a\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00190\u001bj\b\u0012\u0004\u0012\u00028\u0001`\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00028\u00018F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"Lcom/animotionsoftware/lib/reactor/viewmodel/ReactorViewModel;", "Event", "Lcom/animotionsoftware/lib/reactor/viewmodel/ReactorEvent;", "State", "Landroidx/lifecycle/ViewModel;", "initialState", "<init>", "(Ljava/lang/Object;)V", "events", "Ljava/util/HashMap;", "", "Lkotlin/Function0;", "", "Lcom/animotionsoftware/lib/reactor/util/EventHandler;", "Lkotlin/collections/HashMap;", "getEvents", "()Ljava/util/HashMap;", "eventsWithArgs", "Lkotlin/Function1;", "Lcom/animotionsoftware/lib/reactor/util/EventHandlerWithArgs;", "getEventsWithArgs", "idGenerator", "Lcom/animotionsoftware/lib/reactor/util/IdGenerator;", "mutableFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/animotionsoftware/lib/reactor/viewmodel/ReactorState;", "flow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/animotionsoftware/lib/reactor/util/ReactorFlow;", "getFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "state", "getState", "()Ljava/lang/Object;", "on", "T", "handler", "onEvent", "event", "(Lcom/animotionsoftware/lib/reactor/viewmodel/ReactorEvent;)V", "emit", "newState", "onCleared", "reactor_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReactorViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactorViewModel.kt\ncom/animotionsoftware/lib/reactor/viewmodel/ReactorViewModel\n+ 2 Functions.kt\ncom/animotionsoftware/lib/reactor/util/FunctionsKt\n*L\n1#1,140:1\n3#2:141\n*S KotlinDebug\n*F\n+ 1 ReactorViewModel.kt\ncom/animotionsoftware/lib/reactor/viewmodel/ReactorViewModel\n*L\n82#1:141\n*E\n"})
public abstract class ReactorViewModel<Event extends ReactorEvent, State>
extends ViewModel {
    @NotNull
    private final HashMap<String, Function0<Unit>> events = new HashMap();
    @NotNull
    private final HashMap<String, Function1<ReactorEvent, Unit>> eventsWithArgs = new HashMap();
    @NotNull
    private final IdGenerator idGenerator = new IdGenerator();
    @NotNull
    private final MutableStateFlow<ReactorState<State>> mutableFlow;
    @NotNull
    private final StateFlow<ReactorState<State>> flow;
    public static final int $stable = 8;

    public ReactorViewModel(State initialState) {
        this.mutableFlow = StateFlowKt.MutableStateFlow(new ReactorState<State>(0, initialState));
        this.flow = FlowKt.asStateFlow(this.mutableFlow);
    }

    @NotNull
    protected final HashMap<String, Function0<Unit>> getEvents() {
        return this.events;
    }

    @NotNull
    protected final HashMap<String, Function1<ReactorEvent, Unit>> getEventsWithArgs() {
        return this.eventsWithArgs;
    }

    @NotNull
    public final StateFlow<ReactorState<State>> getFlow() {
        return this.flow;
    }

    public final State getState() {
        return (State)((ReactorState)this.flow.getValue()).getState();
    }

    protected final /* synthetic */ <T extends Event> void on(Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$on = false;
        Map map = this.events;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        map.put(ReactorEvent.class.getName(), handler);
    }

    protected final /* synthetic */ <T extends Event> void on(Function1<? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$on = false;
        Map map = this.eventsWithArgs;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = ReactorEvent.class.getName();
        boolean $i$f$cast = false;
        Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(handler, (int)1);
        map.put(string, function1);
    }

    public <T extends Event> void onEvent(@NotNull T event) {
        block1: {
            String eventName;
            block0: {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                eventName = event.getClass().getName();
                Function0<Unit> function0 = this.events.get(eventName);
                if (function0 == null) break block0;
                function0.invoke();
                break block1;
            }
            Function1<ReactorEvent, Unit> function1 = this.eventsWithArgs.get(eventName);
            if (function1 == null) break block1;
            function1.invoke(event);
        }
    }

    protected final void emit(State newState) {
        this.mutableFlow.setValue(new ReactorState<State>(this.idGenerator.nextId(), newState));
    }

    @CallSuper
    protected void onCleared() {
        this.events.clear();
        this.eventsWithArgs.clear();
    }
}

