/*
 * Decompiled with CFR 0.152.
 */
package com.anji.captcha.service.impl;

import com.anji.captcha.model.common.RepCodeEnum;
import com.anji.captcha.model.common.ResponseModel;
import com.anji.captcha.model.vo.CaptchaVO;
import com.anji.captcha.service.CaptchaCacheService;
import com.anji.captcha.util.StringUtils;
import java.util.Objects;
import java.util.Properties;

public interface FrequencyLimitHandler {
    public static final String LIMIT_KEY = "AJ.CAPTCHA.REQ.LIMIT-%s-%s";

    public ResponseModel validateGet(CaptchaVO var1);

    public ResponseModel validateCheck(CaptchaVO var1);

    public ResponseModel validateVerify(CaptchaVO var1);

    public static class DefaultLimitHandler
    implements FrequencyLimitHandler {
        private Properties config;
        private CaptchaCacheService cacheService;

        public DefaultLimitHandler(Properties config, CaptchaCacheService cacheService) {
            this.config = config;
            this.cacheService = cacheService;
        }

        private String getClientCId(CaptchaVO input, String type) {
            return String.format(FrequencyLimitHandler.LIMIT_KEY, type, input.getClientUid());
        }

        @Override
        public ResponseModel validateGet(CaptchaVO d) {
            if (StringUtils.isEmpty(d.getClientUid())) {
                return null;
            }
            String getKey = this.getClientCId(d, "GET");
            String lockKey = this.getClientCId(d, "LOCK");
            if (Objects.nonNull(this.cacheService.get(lockKey))) {
                return ResponseModel.errorMsg(RepCodeEnum.API_REQ_LOCK_GET_ERROR);
            }
            Long getCounts = this.cacheService.increment(getKey, 1L);
            if (getCounts <= 1L) {
                this.cacheService.set(getKey, "1", 60L);
            }
            if (getCounts > Long.parseLong(this.config.getProperty("captcha.req.get.minute.limit", "120"))) {
                return ResponseModel.errorMsg(RepCodeEnum.API_REQ_LIMIT_GET_ERROR);
            }
            String failKey = this.getClientCId(d, "FAIL");
            String failCnts = this.cacheService.get(failKey);
            if (Objects.isNull(failCnts)) {
                return null;
            }
            if (Long.parseLong(failCnts) > Long.parseLong(this.config.getProperty("captcha.req.get.lock.limit", "5"))) {
                this.cacheService.set(lockKey, "1", Long.parseLong(this.config.getProperty("captcha.req.get.lock.seconds", "300")));
                return ResponseModel.errorMsg(RepCodeEnum.API_REQ_LOCK_GET_ERROR);
            }
            return null;
        }

        @Override
        public ResponseModel validateCheck(CaptchaVO d) {
            if (StringUtils.isEmpty(d.getClientUid())) {
                return null;
            }
            String key = this.getClientCId(d, "CHECK");
            Long getCounts = this.cacheService.increment(key, 1L);
            if (getCounts <= 1L) {
                this.cacheService.set(key, "1", 60L);
            }
            if (getCounts > Long.parseLong(this.config.getProperty("captcha.req.check.minute.limit", "600"))) {
                return ResponseModel.errorMsg(RepCodeEnum.API_REQ_LIMIT_CHECK_ERROR);
            }
            return null;
        }

        @Override
        public ResponseModel validateVerify(CaptchaVO d) {
            String key = this.getClientCId(d, "VERIFY");
            Long getCounts = this.cacheService.increment(key, 1L);
            if (getCounts <= 1L) {
                this.cacheService.set(key, "1", 60L);
            }
            if (getCounts > Long.parseLong(this.config.getProperty("captcha.req.verify.minute.limit", "600"))) {
                return ResponseModel.errorMsg(RepCodeEnum.API_REQ_LIMIT_VERIFY_ERROR);
            }
            return null;
        }
    }
}

