/*
 * Decompiled with CFR 0.152.
 */
package com.anji.captcha.service.impl;

import com.anji.captcha.model.common.CaptchaTypeEnum;
import com.anji.captcha.model.common.RepCodeEnum;
import com.anji.captcha.model.common.ResponseModel;
import com.anji.captcha.model.vo.CaptchaVO;
import com.anji.captcha.service.impl.AbstractCaptchaService;
import com.anji.captcha.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class RotatePuzzleCaptchaServiceImpl
extends AbstractCaptchaService {
    @Override
    public String captchaType() {
        return CaptchaTypeEnum.ROTATEPUZZLE.getCodeValue();
    }

    @Override
    public void init(Properties config) {
        super.init(config);
    }

    @Override
    public void destroy(Properties config) {
        this.logger.info("start-clear-history-data:{}", (Object)this.captchaType());
    }

    @Override
    public ResponseModel get(CaptchaVO captchaVO) {
        ResponseModel r = super.get(captchaVO);
        if (!this.validatedReq(r)) {
            return r;
        }
        BufferedImage rotateImage = ImageUtils.getRotate();
        if (null == rotateImage) {
            this.logger.error("\u65cb\u8f6c\u62fc\u56fe\u5e95\u56fe\u672a\u521d\u59cb\u5316\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84");
            return ResponseModel.errorMsg(RepCodeEnum.API_CAPTCHA_BASEMAP_NULL);
        }
        String rotateBlockImageBase64 = ImageUtils.getRotateBlock();
        BufferedImage rotateBlockImage = ImageUtils.getBase64StrToImage(rotateBlockImageBase64);
        if (null == rotateBlockImage) {
            this.logger.error("\u65cb\u8f6c\u62fc\u56fe\u65cb\u8f6c\u5757\u5e95\u56fe\u672a\u521d\u59cb\u5316\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84");
            return ResponseModel.errorMsg(RepCodeEnum.API_CAPTCHA_BASEMAP_NULL);
        }
        return super.get(captchaVO);
    }

    @Override
    public ResponseModel check(CaptchaVO captchaVO) {
        ResponseModel r = super.check(captchaVO);
        if (!this.validatedReq(r)) {
            return r;
        }
        return super.check(captchaVO);
    }
}

