/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.oss.utils;

import com.anji.plus.gaea.oss.exceptions.GaeaOSSException;
import com.anji.plus.gaea.oss.utils.StringPatternUtil;
import java.net.URLEncoder;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;

public class ResponseUtil {
    public static ResponseEntity<byte[]> writeBody(String fileObjectName, byte[] fileBytes, boolean isIEBrowser) {
        try {
            if (StringUtils.isEmpty((Object)fileObjectName) || !fileObjectName.contains(".")) {
                throw new GaeaOSSException("original file name or type is empty");
            }
            String fileSuffixName = fileObjectName.substring(fileObjectName.lastIndexOf("."));
            ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
            builder.contentLength((long)fileBytes.length);
            String pattern1 = "(.png|.jpg|.jpeg|.bmp|.gif|.icon)";
            String pattern2 = "(.flv|.swf|.mkv|.avi|.rm|.rmvb|.mpeg|.mpg|.ogg|.ogv|.mov|.wmv|.mp4|.webm|.wav|.mid|.mp3|.aac)";
            if (StringPatternUtil.StringMatchIgnoreCase(fileSuffixName, pattern1)) {
                ((ResponseEntity.BodyBuilder)builder.cacheControl(CacheControl.noCache())).contentType(MediaType.IMAGE_PNG);
            } else if (StringPatternUtil.StringMatchIgnoreCase(fileSuffixName, pattern2)) {
                builder.header("Content-Type", new String[]{"video/mp4; charset=UTF-8"});
            } else {
                builder.contentType(MediaType.APPLICATION_OCTET_STREAM);
                fileObjectName = URLEncoder.encode(fileObjectName, "UTF-8");
                if (isIEBrowser) {
                    builder.header("Content-Disposition", new String[]{"attachment; filename=" + fileObjectName});
                } else {
                    builder.header("Content-Disposition", new String[]{"attacher; filename*=UTF-8''" + fileObjectName});
                }
            }
            return builder.body((Object)fileBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

