/*
 * Decompiled with CFR 0.152.
 */
package com.anjlab.android.iab.v3;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import com.anjlab.android.iab.v3.BillingBase;
import com.anjlab.android.iab.v3.BillingCache;
import com.anjlab.android.iab.v3.PurchaseInfo;
import com.anjlab.android.iab.v3.Security;
import com.anjlab.android.iab.v3.SkuDetails;
import com.anjlab.android.iab.v3.TransactionDetails;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

public class BillingProcessor
extends BillingBase {
    private static final Date DATE_MERCHANT_LIMIT_1;
    private static final Date DATE_MERCHANT_LIMIT_2;
    private static final int PURCHASE_FLOW_REQUEST_CODE = 32459;
    private static final String LOG_TAG = "iabv3";
    private static final String SETTINGS_VERSION = ".v2_6";
    private static final String RESTORE_KEY = ".products.restored.v2_6";
    private static final String MANAGED_PRODUCTS_CACHE_KEY = ".products.cache.v2_6";
    private static final String SUBSCRIPTIONS_CACHE_KEY = ".subscriptions.cache.v2_6";
    private static final String PURCHASE_PAYLOAD_CACHE_KEY = ".purchase.last.v2_6";
    private IInAppBillingService billingService;
    private String contextPackageName;
    private String signatureBase64;
    private BillingCache cachedProducts;
    private BillingCache cachedSubscriptions;
    private IBillingHandler eventHandler;
    private String developerMerchantId;
    private boolean isOneTimePurchasesSupported;
    private boolean isSubsUpdateSupported;
    private boolean isSubscriptionExtraParamsSupported;
    private boolean isOneTimePurchaseExtraParamsSupported;
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            BillingProcessor.this.billingService = null;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            BillingProcessor.this.billingService = IInAppBillingService.Stub.asInterface((IBinder)service);
            new HistoryInitializationTask().execute(new Void[0]);
        }
    };

    public static BillingProcessor newBillingProcessor(Context context, String licenseKey, IBillingHandler handler) {
        return BillingProcessor.newBillingProcessor(context, licenseKey, null, handler);
    }

    public static BillingProcessor newBillingProcessor(Context context, String licenseKey, String merchantId, IBillingHandler handler) {
        return new BillingProcessor(context, licenseKey, merchantId, handler, false);
    }

    public BillingProcessor(Context context, String licenseKey, IBillingHandler handler) {
        this(context, licenseKey, null, handler);
    }

    public BillingProcessor(Context context, String licenseKey, String merchantId, IBillingHandler handler) {
        this(context, licenseKey, merchantId, handler, true);
    }

    private BillingProcessor(Context context, String licenseKey, String merchantId, IBillingHandler handler, boolean bindImmediately) {
        super(context.getApplicationContext());
        this.signatureBase64 = licenseKey;
        this.eventHandler = handler;
        this.contextPackageName = this.getContext().getPackageName();
        this.cachedProducts = new BillingCache(this.getContext(), MANAGED_PRODUCTS_CACHE_KEY);
        this.cachedSubscriptions = new BillingCache(this.getContext(), SUBSCRIPTIONS_CACHE_KEY);
        this.developerMerchantId = merchantId;
        if (bindImmediately) {
            this.bindPlayServices();
        }
    }

    public void initialize() {
        this.bindPlayServices();
    }

    private static Intent getBindServiceIntent() {
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        intent.setPackage("com.android.vending");
        return intent;
    }

    private void bindPlayServices() {
        try {
            this.getContext().bindService(BillingProcessor.getBindServiceIntent(), this.serviceConnection, 1);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"error in bindPlayServices", (Throwable)e);
            this.reportBillingError(113, e);
        }
    }

    public static boolean isIabServiceAvailable(Context context) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(BillingProcessor.getBindServiceIntent(), 0);
        return list != null && list.size() > 0;
    }

    public void release() {
        if (this.isInitialized() && this.serviceConnection != null) {
            try {
                this.getContext().unbindService(this.serviceConnection);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"Error in release", (Throwable)e);
            }
            this.billingService = null;
        }
    }

    public boolean isInitialized() {
        return this.billingService != null;
    }

    public boolean isPurchased(String productId) {
        return this.cachedProducts.includesProduct(productId);
    }

    public boolean isSubscribed(String productId) {
        return this.cachedSubscriptions.includesProduct(productId);
    }

    public List<String> listOwnedProducts() {
        return this.cachedProducts.getContents();
    }

    public List<String> listOwnedSubscriptions() {
        return this.cachedSubscriptions.getContents();
    }

    private boolean loadPurchasesByType(String type, BillingCache cacheStorage) {
        if (!this.isInitialized()) {
            return false;
        }
        try {
            Bundle bundle = this.billingService.getPurchases(3, this.contextPackageName, type, null);
            if (bundle.getInt("RESPONSE_CODE") == 0) {
                cacheStorage.clear();
                ArrayList purchaseList = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
                ArrayList signatureList = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
                if (purchaseList != null) {
                    for (int i = 0; i < purchaseList.size(); ++i) {
                        String jsonData = (String)purchaseList.get(i);
                        if (TextUtils.isEmpty((CharSequence)jsonData)) continue;
                        JSONObject purchase = new JSONObject(jsonData);
                        String signature = signatureList != null && signatureList.size() > i ? (String)signatureList.get(i) : null;
                        cacheStorage.put(purchase.getString("productId"), jsonData, signature);
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            this.reportBillingError(100, e);
            Log.e((String)LOG_TAG, (String)"Error in loadPurchasesByType", (Throwable)e);
        }
        return false;
    }

    public boolean loadOwnedPurchasesFromGoogle() {
        return this.loadPurchasesByType("inapp", this.cachedProducts) && this.loadPurchasesByType("subs", this.cachedSubscriptions);
    }

    public boolean purchase(Activity activity, String productId) {
        return this.purchase(activity, null, productId, "inapp", null);
    }

    public boolean subscribe(Activity activity, String productId) {
        return this.purchase(activity, null, productId, "subs", null);
    }

    public boolean purchase(Activity activity, String productId, String developerPayload) {
        return this.purchase(activity, productId, "inapp", developerPayload);
    }

    public boolean subscribe(Activity activity, String productId, String developerPayload) {
        return this.purchase(activity, productId, "subs", developerPayload);
    }

    public boolean purchase(Activity activity, String productId, String developerPayload, Bundle extraParams) {
        if (!this.isOneTimePurchaseWithExtraParamsSupported(extraParams)) {
            return this.purchase(activity, productId, developerPayload);
        }
        return this.purchase(activity, null, productId, "inapp", developerPayload, extraParams);
    }

    public boolean subscribe(Activity activity, String productId, String developerPayload, Bundle extraParams) {
        return this.purchase(activity, null, productId, "subs", developerPayload, (Bundle)(this.isSubscriptionWithExtraParamsSupported(extraParams) ? extraParams : null));
    }

    public boolean isOneTimePurchaseSupported() {
        if (!this.isInitialized()) {
            Log.e((String)LOG_TAG, (String)"Make sure BillingProcessor was initialized before calling isOneTimePurchaseSupported()");
            return false;
        }
        if (this.isOneTimePurchasesSupported) {
            return true;
        }
        try {
            int response = this.billingService.isBillingSupported(3, this.contextPackageName, "inapp");
            this.isOneTimePurchasesSupported = response == 0;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.isOneTimePurchasesSupported;
    }

    public boolean isSubscriptionUpdateSupported() {
        if (this.isSubsUpdateSupported) {
            return true;
        }
        try {
            int response = this.billingService.isBillingSupported(5, this.contextPackageName, "subs");
            this.isSubsUpdateSupported = response == 0;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.isSubsUpdateSupported;
    }

    public boolean isSubscriptionWithExtraParamsSupported(Bundle extraParams) {
        if (this.isSubscriptionExtraParamsSupported) {
            return true;
        }
        try {
            int response = this.billingService.isBillingSupportedExtraParams(7, this.contextPackageName, "subs", extraParams);
            this.isSubscriptionExtraParamsSupported = response == 0;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.isSubscriptionExtraParamsSupported;
    }

    public boolean isOneTimePurchaseWithExtraParamsSupported(Bundle extraParams) {
        if (this.isOneTimePurchaseExtraParamsSupported) {
            return true;
        }
        try {
            int response = this.billingService.isBillingSupportedExtraParams(7, this.contextPackageName, "inapp", extraParams);
            this.isOneTimePurchaseExtraParamsSupported = response == 0;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.isOneTimePurchaseExtraParamsSupported;
    }

    public boolean updateSubscription(Activity activity, String oldProductId, String productId) {
        return this.updateSubscription(activity, oldProductId, productId, null);
    }

    public boolean updateSubscription(Activity activity, String oldProductId, String productId, String developerPayload) {
        List<String> oldProductIds = null;
        if (!TextUtils.isEmpty((CharSequence)oldProductId)) {
            oldProductIds = Collections.singletonList(oldProductId);
        }
        return this.updateSubscription(activity, oldProductIds, productId, developerPayload);
    }

    public boolean updateSubscription(Activity activity, List<String> oldProductIds, String productId) {
        return this.updateSubscription(activity, oldProductIds, productId, null);
    }

    public boolean updateSubscription(Activity activity, List<String> oldProductIds, String productId, String developerPayload) {
        if (oldProductIds != null && !this.isSubscriptionUpdateSupported()) {
            return false;
        }
        return this.purchase(activity, oldProductIds, productId, "subs", developerPayload);
    }

    public boolean updateSubscription(Activity activity, List<String> oldProductIds, String productId, String developerPayload, Bundle extraParams) {
        if (oldProductIds != null && !this.isSubscriptionUpdateSupported()) {
            return false;
        }
        if (!this.isSubscriptionWithExtraParamsSupported(extraParams)) {
            return this.updateSubscription(activity, oldProductIds, productId, developerPayload);
        }
        return this.purchase(activity, oldProductIds, productId, "subs", developerPayload, extraParams);
    }

    private boolean purchase(Activity activity, String productId, String purchaseType, String developerPayload) {
        return this.purchase(activity, null, productId, purchaseType, developerPayload);
    }

    private boolean purchase(Activity activity, List<String> oldProductIds, String productId, String purchaseType, String developerPayload) {
        return this.purchase(activity, oldProductIds, productId, purchaseType, developerPayload, null);
    }

    private boolean purchase(Activity activity, List<String> oldProductIds, String productId, String purchaseType, String developerPayload, Bundle extraParamsBundle) {
        if (!this.isInitialized() || TextUtils.isEmpty((CharSequence)productId) || TextUtils.isEmpty((CharSequence)purchaseType)) {
            return false;
        }
        try {
            Bundle bundle;
            String purchasePayload = purchaseType + ":" + productId;
            if (!purchaseType.equals("subs")) {
                purchasePayload = purchasePayload + ":" + UUID.randomUUID().toString();
            }
            if (developerPayload != null) {
                purchasePayload = purchasePayload + ":" + developerPayload;
            }
            this.savePurchasePayload(purchasePayload);
            if (oldProductIds != null && purchaseType.equals("subs")) {
                if (extraParamsBundle == null) {
                    bundle = this.billingService.getBuyIntentToReplaceSkus(5, this.contextPackageName, oldProductIds, productId, purchaseType, purchasePayload);
                } else {
                    if (!extraParamsBundle.containsKey("skusToReplace")) {
                        extraParamsBundle.putStringArrayList("skusToReplace", new ArrayList<String>(oldProductIds));
                    }
                    bundle = this.billingService.getBuyIntentExtraParams(7, this.contextPackageName, productId, purchaseType, purchasePayload, extraParamsBundle);
                }
            } else {
                bundle = extraParamsBundle == null ? this.billingService.getBuyIntent(3, this.contextPackageName, productId, purchaseType, purchasePayload) : this.billingService.getBuyIntentExtraParams(7, this.contextPackageName, productId, purchaseType, purchasePayload, extraParamsBundle);
            }
            if (bundle != null) {
                int response = bundle.getInt("RESPONSE_CODE");
                if (response == 0) {
                    PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("BUY_INTENT");
                    if (activity != null && pendingIntent != null) {
                        activity.startIntentSenderForResult(pendingIntent.getIntentSender(), 32459, new Intent(), 0, 0, 0);
                    } else {
                        this.reportBillingError(103, null);
                    }
                } else if (response == 7) {
                    TransactionDetails details;
                    if (!this.isPurchased(productId) && !this.isSubscribed(productId)) {
                        this.loadOwnedPurchasesFromGoogle();
                    }
                    if (!this.checkMerchant(details = this.getPurchaseTransactionDetails(productId))) {
                        Log.i((String)LOG_TAG, (String)"Invalid or tampered merchant id!");
                        this.reportBillingError(104, null);
                        return false;
                    }
                    if (this.eventHandler != null) {
                        if (details == null) {
                            details = this.getSubscriptionTransactionDetails(productId);
                        }
                        this.eventHandler.onProductPurchased(productId, details);
                    }
                } else {
                    this.reportBillingError(101, null);
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Error in purchase", (Throwable)e);
            this.reportBillingError(110, e);
            return false;
        }
    }

    private boolean checkMerchant(TransactionDetails details) {
        if (this.developerMerchantId == null) {
            return true;
        }
        if (details.purchaseInfo.purchaseData.purchaseTime.before(DATE_MERCHANT_LIMIT_1)) {
            return true;
        }
        if (details.purchaseInfo.purchaseData.purchaseTime.after(DATE_MERCHANT_LIMIT_2)) {
            return true;
        }
        if (details.purchaseInfo.purchaseData.orderId == null || details.purchaseInfo.purchaseData.orderId.trim().length() == 0) {
            return false;
        }
        int index = details.purchaseInfo.purchaseData.orderId.indexOf(46);
        if (index <= 0) {
            return false;
        }
        String merchantId = details.purchaseInfo.purchaseData.orderId.substring(0, index);
        return merchantId.compareTo(this.developerMerchantId) == 0;
    }

    @Nullable
    private TransactionDetails getPurchaseTransactionDetails(String productId, BillingCache cache) {
        PurchaseInfo details = cache.getDetails(productId);
        if (details != null && !TextUtils.isEmpty((CharSequence)details.responseData)) {
            return new TransactionDetails(details);
        }
        return null;
    }

    public boolean consumePurchase(String productId) {
        if (!this.isInitialized()) {
            return false;
        }
        try {
            TransactionDetails transaction = this.getPurchaseTransactionDetails(productId, this.cachedProducts);
            if (transaction != null && !TextUtils.isEmpty((CharSequence)transaction.purchaseInfo.purchaseData.purchaseToken)) {
                int response = this.billingService.consumePurchase(3, this.contextPackageName, transaction.purchaseInfo.purchaseData.purchaseToken);
                if (response == 0) {
                    this.cachedProducts.remove(productId);
                    Log.d((String)LOG_TAG, (String)("Successfully consumed " + productId + " purchase."));
                    return true;
                }
                this.reportBillingError(response, null);
                Log.e((String)LOG_TAG, (String)String.format("Failed to consume %s: %d", productId, response));
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Error in consumePurchase", (Throwable)e);
            this.reportBillingError(111, e);
        }
        return false;
    }

    private SkuDetails getSkuDetails(String productId, String purchaseType) {
        ArrayList<String> productIdList = new ArrayList<String>();
        productIdList.add(productId);
        List<SkuDetails> skuDetailsList = this.getSkuDetails(productIdList, purchaseType);
        if (skuDetailsList != null && skuDetailsList.size() > 0) {
            return skuDetailsList.get(0);
        }
        return null;
    }

    private List<SkuDetails> getSkuDetails(ArrayList<String> productIdList, String purchaseType) {
        if (this.billingService != null && productIdList != null && productIdList.size() > 0) {
            try {
                Bundle products = new Bundle();
                products.putStringArrayList("ITEM_ID_LIST", productIdList);
                Bundle skuDetails = this.billingService.getSkuDetails(3, this.contextPackageName, purchaseType, products);
                int response = skuDetails.getInt("RESPONSE_CODE");
                if (response == 0) {
                    ArrayList<SkuDetails> productDetails = new ArrayList<SkuDetails>();
                    ArrayList detailsList = skuDetails.getStringArrayList("DETAILS_LIST");
                    if (detailsList != null) {
                        for (String responseLine : detailsList) {
                            JSONObject object = new JSONObject(responseLine);
                            SkuDetails product = new SkuDetails(object);
                            productDetails.add(product);
                        }
                    }
                    return productDetails;
                }
                this.reportBillingError(response, null);
                Log.e((String)LOG_TAG, (String)String.format("Failed to retrieve info for %d products, %d", productIdList.size(), response));
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"Failed to call getSkuDetails", (Throwable)e);
                this.reportBillingError(112, e);
            }
        }
        return null;
    }

    public SkuDetails getPurchaseListingDetails(String productId) {
        return this.getSkuDetails(productId, "inapp");
    }

    public SkuDetails getSubscriptionListingDetails(String productId) {
        return this.getSkuDetails(productId, "subs");
    }

    public List<SkuDetails> getPurchaseListingDetails(ArrayList<String> productIdList) {
        return this.getSkuDetails(productIdList, "inapp");
    }

    public List<SkuDetails> getSubscriptionListingDetails(ArrayList<String> productIdList) {
        return this.getSkuDetails(productIdList, "subs");
    }

    @Nullable
    public TransactionDetails getPurchaseTransactionDetails(String productId) {
        return this.getPurchaseTransactionDetails(productId, this.cachedProducts);
    }

    @Nullable
    public TransactionDetails getSubscriptionTransactionDetails(String productId) {
        return this.getPurchaseTransactionDetails(productId, this.cachedSubscriptions);
    }

    private String detectPurchaseTypeFromPurchaseResponseData(JSONObject purchase) {
        String purchasePayload = this.getPurchasePayload();
        if (!TextUtils.isEmpty((CharSequence)purchasePayload) && purchasePayload.startsWith("subs")) {
            return "subs";
        }
        if (purchase != null && purchase.has("autoRenewing")) {
            return "subs";
        }
        return "inapp";
    }

    public boolean handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 32459) {
            return false;
        }
        if (data == null) {
            Log.e((String)LOG_TAG, (String)"handleActivityResult: data is null!");
            return false;
        }
        int responseCode = data.getIntExtra("RESPONSE_CODE", 0);
        Log.d((String)LOG_TAG, (String)String.format("resultCode = %d, responseCode = %d", resultCode, responseCode));
        if (resultCode == -1 && responseCode == 0) {
            String purchaseData = data.getStringExtra("INAPP_PURCHASE_DATA");
            String dataSignature = data.getStringExtra("INAPP_DATA_SIGNATURE");
            try {
                JSONObject purchase = new JSONObject(purchaseData);
                String productId = purchase.getString("productId");
                if (this.verifyPurchaseSignature(productId, purchaseData, dataSignature)) {
                    String purchaseType = this.detectPurchaseTypeFromPurchaseResponseData(purchase);
                    BillingCache cache = purchaseType.equals("subs") ? this.cachedSubscriptions : this.cachedProducts;
                    cache.put(productId, purchaseData, dataSignature);
                    if (this.eventHandler != null) {
                        this.eventHandler.onProductPurchased(productId, new TransactionDetails(new PurchaseInfo(purchaseData, dataSignature)));
                    }
                } else {
                    Log.e((String)LOG_TAG, (String)"Public key signature doesn't match!");
                    this.reportBillingError(102, null);
                }
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"Error in handleActivityResult", (Throwable)e);
                this.reportBillingError(110, e);
            }
            this.savePurchasePayload(null);
        } else {
            this.reportBillingError(responseCode, null);
        }
        return true;
    }

    private boolean verifyPurchaseSignature(String productId, String purchaseData, String dataSignature) {
        try {
            return TextUtils.isEmpty((CharSequence)this.signatureBase64) || Security.verifyPurchase(productId, this.signatureBase64, purchaseData, dataSignature);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidTransactionDetails(TransactionDetails transactionDetails) {
        return this.verifyPurchaseSignature(transactionDetails.purchaseInfo.purchaseData.productId, transactionDetails.purchaseInfo.responseData, transactionDetails.purchaseInfo.signature) && this.checkMerchant(transactionDetails);
    }

    private boolean isPurchaseHistoryRestored() {
        return this.loadBoolean(this.getPreferencesBaseKey() + RESTORE_KEY, false);
    }

    private void setPurchaseHistoryRestored() {
        this.saveBoolean(this.getPreferencesBaseKey() + RESTORE_KEY, true);
    }

    private void savePurchasePayload(String value) {
        this.saveString(this.getPreferencesBaseKey() + PURCHASE_PAYLOAD_CACHE_KEY, value);
    }

    private String getPurchasePayload() {
        return this.loadString(this.getPreferencesBaseKey() + PURCHASE_PAYLOAD_CACHE_KEY, null);
    }

    private void reportBillingError(int errorCode, Throwable error) {
        if (this.eventHandler != null) {
            this.eventHandler.onBillingError(errorCode, error);
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2012, 11, 5);
        DATE_MERCHANT_LIMIT_1 = calendar.getTime();
        calendar.set(2015, 6, 21);
        DATE_MERCHANT_LIMIT_2 = calendar.getTime();
    }

    private class HistoryInitializationTask
    extends AsyncTask<Void, Void, Boolean> {
        private HistoryInitializationTask() {
        }

        protected Boolean doInBackground(Void ... nothing) {
            if (!BillingProcessor.this.isPurchaseHistoryRestored()) {
                BillingProcessor.this.loadOwnedPurchasesFromGoogle();
                return true;
            }
            return false;
        }

        protected void onPostExecute(Boolean restored) {
            if (restored.booleanValue()) {
                BillingProcessor.this.setPurchaseHistoryRestored();
                if (BillingProcessor.this.eventHandler != null) {
                    BillingProcessor.this.eventHandler.onPurchaseHistoryRestored();
                }
            }
            if (BillingProcessor.this.eventHandler != null) {
                BillingProcessor.this.eventHandler.onBillingInitialized();
            }
        }
    }

    public static interface IBillingHandler {
        public void onProductPurchased(@NonNull String var1, @Nullable TransactionDetails var2);

        public void onPurchaseHistoryRestored();

        public void onBillingError(int var1, @Nullable Throwable var2);

        public void onBillingInitialized();
    }
}

