/*
 * Decompiled with CFR 0.152.
 */
package com.anjlab.android.iab.v3;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.anjlab.android.iab.v3.PurchaseData;
import com.anjlab.android.iab.v3.PurchaseState;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class PurchaseInfo
implements Parcelable {
    private static final String LOG_TAG = "iabv3.purchaseInfo";
    public final String responseData;
    public final String signature;
    public final PurchaseData purchaseData;
    public static final Parcelable.Creator<PurchaseInfo> CREATOR = new Parcelable.Creator<PurchaseInfo>(){

        public PurchaseInfo createFromParcel(Parcel source) {
            return new PurchaseInfo(source);
        }

        public PurchaseInfo[] newArray(int size) {
            return new PurchaseInfo[size];
        }
    };

    public PurchaseInfo(String responseData, String signature) {
        this.responseData = responseData;
        this.signature = signature;
        this.purchaseData = this.parseResponseDataImpl();
    }

    @Deprecated
    public PurchaseData parseResponseData() {
        return this.parseResponseDataImpl();
    }

    PurchaseData parseResponseDataImpl() {
        try {
            JSONObject json = new JSONObject(this.responseData);
            PurchaseData data = new PurchaseData();
            data.orderId = json.optString("orderId");
            data.packageName = json.optString("packageName");
            data.productId = json.optString("productId");
            long purchaseTimeMillis = json.optLong("purchaseTime", 0L);
            data.purchaseTime = purchaseTimeMillis != 0L ? new Date(purchaseTimeMillis) : null;
            data.purchaseState = PurchaseState.values()[json.optInt("purchaseState", 1)];
            data.developerPayload = json.optString("developerPayload");
            data.purchaseToken = json.getString("purchaseToken");
            data.autoRenewing = json.optBoolean("autoRenewing");
            return data;
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)"Failed to parse response data", (Throwable)e);
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.responseData);
        dest.writeString(this.signature);
    }

    protected PurchaseInfo(Parcel in) {
        this.responseData = in.readString();
        this.signature = in.readString();
        this.purchaseData = this.parseResponseDataImpl();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PurchaseInfo)) {
            return false;
        }
        PurchaseInfo other = (PurchaseInfo)o;
        return this.responseData.equals(other.responseData) && this.signature.equals(other.signature) && this.purchaseData.purchaseToken.equals(other.purchaseData.purchaseToken) && this.purchaseData.purchaseTime.equals(other.purchaseData.purchaseTime);
    }
}

