/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Collector;
import com.annimon.stream.Collectors;
import com.annimon.stream.LazyIterator;
import com.annimon.stream.LsaExtIterator;
import com.annimon.stream.LsaIterator;
import com.annimon.stream.Optional;
import com.annimon.stream.function.BiConsumer;
import com.annimon.stream.function.BiFunction;
import com.annimon.stream.function.BinaryOperator;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IntFunction;
import com.annimon.stream.function.Predicate;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.UnaryOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class Stream<T> {
    static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    static final String BAD_SIZE = "Stream size exceeds max array size";
    private final Iterator<? extends T> iterator;
    private static final int MATCH_ANY = 0;
    private static final int MATCH_ALL = 1;
    private static final int MATCH_NONE = 2;

    public static <T> Stream<T> empty() {
        return Stream.of(Collections.EMPTY_LIST);
    }

    public static <K, V> Stream<Map.Entry<K, V>> of(Map<K, V> map) {
        return new Stream<Map.Entry<K, V>>(map.entrySet());
    }

    public static <T> Stream<T> of(List<? extends T> list) {
        return Stream.of(list);
    }

    public static <T> Stream<T> of(Iterator<? extends T> iterator) {
        return new Stream<T>(iterator);
    }

    public static <T> Stream<T> of(Iterable<? extends T> iterable) {
        return new Stream<T>(iterable);
    }

    public static <T> Stream<T> of(final T ... elements) {
        return new Stream<T>(new LsaIterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < elements.length;
            }

            @Override
            public T nextIteration() {
                return elements[this.index++];
            }
        });
    }

    public static Stream<Integer> range(final int from, final int to) {
        return new Stream<Integer>(new LsaIterator<Integer>(){
            private int index;
            {
                this.index = from;
            }

            @Override
            public boolean hasNext() {
                return this.index < to;
            }

            @Override
            public Integer nextIteration() {
                return this.index++;
            }
        });
    }

    @Deprecated
    public static Stream<Integer> ofRange(int from, int to) {
        return Stream.range(from, to);
    }

    public static Stream<Long> range(final long from, final long to) {
        return new Stream<Long>(new LsaIterator<Long>(){
            private long index;
            {
                this.index = from;
            }

            @Override
            public boolean hasNext() {
                return this.index < to;
            }

            @Override
            public Long nextIteration() {
                return this.index++;
            }
        });
    }

    @Deprecated
    public static Stream<Long> ofRange(long from, long to) {
        return Stream.range(from, to);
    }

    public static Stream<Integer> rangeClosed(final int from, final int to) {
        return new Stream<Integer>(new LsaIterator<Integer>(){
            private int index;
            private boolean hasNext;
            {
                this.index = from;
                this.hasNext = this.index <= to;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Integer nextIteration() {
                if (this.index >= to) {
                    this.hasNext = false;
                    return to;
                }
                return this.index++;
            }
        });
    }

    @Deprecated
    public static Stream<Integer> ofRangeClosed(int from, int to) {
        return Stream.rangeClosed(from, to);
    }

    public static Stream<Long> rangeClosed(final long from, final long to) {
        return new Stream<Long>(new LsaIterator<Long>(){
            private long index;
            private boolean hasNext;
            {
                this.index = from;
                this.hasNext = this.index <= to;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Long nextIteration() {
                if (this.index >= to) {
                    this.hasNext = false;
                    return to;
                }
                return this.index++;
            }
        });
    }

    @Deprecated
    public static Stream<Long> ofRangeClosed(long from, long to) {
        return Stream.rangeClosed(from, to);
    }

    public static <T> Stream<T> generate(final Supplier<T> supplier) {
        return new Stream<T>(new LsaIterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T nextIteration() {
                return supplier.get();
            }
        });
    }

    public static <T> Stream<T> iterate(final T seed, final UnaryOperator<T> op) {
        return new Stream<T>(new LsaIterator<T>(){
            private boolean firstRun = true;
            private T t;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T nextIteration() {
                if (this.firstRun) {
                    this.firstRun = false;
                    this.t = seed;
                } else {
                    this.t = op.apply(this.t);
                }
                return this.t;
            }
        });
    }

    public static <T> Stream<T> concat(Stream<? extends T> stream1, Stream<? extends T> stream2) {
        final Iterator<? extends T> it1 = stream1.iterator;
        final Iterator<? extends T> it2 = stream2.iterator;
        return new Stream<T>(new LsaExtIterator<T>(){

            @Override
            protected void nextIteration() {
                if (it1.hasNext()) {
                    this.next = it1.next();
                    this.hasNext = true;
                    return;
                }
                if (it2.hasNext()) {
                    this.next = it2.next();
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        });
    }

    public static <F, S, R> Stream<R> zip(Stream<? extends F> stream1, Stream<? extends S> stream2, final BiFunction<? super F, ? super S, ? extends R> combiner) {
        final Iterator it1 = stream1.iterator;
        final Iterator it2 = stream2.iterator;
        return new Stream(new LsaIterator<R>(){

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext();
            }

            @Override
            public R nextIteration() {
                return combiner.apply(it1.next(), it2.next());
            }
        });
    }

    private Stream(Iterator<? extends T> iterator) {
        this.iterator = iterator;
    }

    private Stream(Iterable<? extends T> iterable) {
        this(new LazyIterator<T>(iterable));
    }

    public Iterator<? extends T> getIterator() {
        return this.iterator;
    }

    public <R> R custom(Function<Stream<T>, R> function) {
        return function.apply(this);
    }

    public Stream<T> filter(final Predicate<? super T> predicate) {
        return new Stream<T>(new LsaExtIterator<T>(){

            @Override
            protected void nextIteration() {
                while (Stream.this.iterator.hasNext()) {
                    this.next = Stream.this.iterator.next();
                    if (!predicate.test(this.next)) continue;
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        });
    }

    public Stream<T> filterNot(Predicate<? super T> predicate) {
        return this.filter(Predicate.Util.negate(predicate));
    }

    public <TT> Stream<TT> select(final Class<TT> clazz) {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return clazz.isInstance(value);
            }
        });
    }

    public <R> Stream<R> map(final Function<? super T, ? extends R> mapper) {
        return new Stream<T>(new LsaIterator<R>(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public R nextIteration() {
                return mapper.apply(Stream.this.iterator.next());
            }
        });
    }

    public <R> Stream<R> flatMap(final Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new Stream<T>(new LsaExtIterator<R>(){
            private Iterator<? extends R> inner;

            @Override
            protected void nextIteration() {
                if (this.inner != null && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                while (Stream.this.iterator.hasNext()) {
                    Object arg;
                    Stream result;
                    if (!(this.inner != null && this.inner.hasNext() || (result = (Stream)mapper.apply(arg = Stream.this.iterator.next())) == null)) {
                        this.inner = result.iterator;
                    }
                    if (this.inner == null || !this.inner.hasNext()) continue;
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        });
    }

    public Stream<T> distinct() {
        return new Stream<T>(new LsaExtIterator<T>(){
            private Iterator<T> distinctIterator;

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    HashSet set = new HashSet();
                    while (Stream.this.iterator.hasNext()) {
                        set.add(Stream.this.iterator.next());
                    }
                    this.distinctIterator = set.iterator();
                }
                this.hasNext = this.distinctIterator.hasNext();
                if (this.hasNext) {
                    this.next = this.distinctIterator.next();
                }
            }
        });
    }

    public Stream<T> sorted() {
        return this.sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
        });
    }

    public Stream<T> sorted(final Comparator<? super T> comparator) {
        return new Stream<T>(new LsaExtIterator<T>(){
            private Iterator<T> sortedIterator;

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    List list = Stream.this.collectToList();
                    Collections.sort(list, comparator);
                    this.sortedIterator = list.iterator();
                }
                this.hasNext = this.sortedIterator.hasNext();
                if (this.hasNext) {
                    this.next = this.sortedIterator.next();
                }
            }
        });
    }

    public <R extends Comparable<? super R>> Stream<T> sortBy(final Function<? super T, ? extends R> f) {
        return this.sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)f.apply(o1)).compareTo(f.apply(o2));
            }
        });
    }

    public <K> Stream<Map.Entry<K, List<T>>> groupBy(Function<? super T, ? extends K> classifier) {
        return Stream.of(this.collect(Collectors.groupingBy(classifier)));
    }

    public <K> Stream<List<T>> chunkBy(final Function<? super T, ? extends K> classifier) {
        return new Stream<List<T>>(new LsaIterator<List<T>>(){
            private T next;
            private boolean peekedNext;

            @Override
            public boolean hasNext() {
                return this.peekedNext || Stream.this.iterator.hasNext();
            }

            @Override
            public List<T> nextIteration() {
                Object key = classifier.apply(this.peek());
                ArrayList list = new ArrayList();
                do {
                    list.add(this.takeNext());
                } while (Stream.this.iterator.hasNext() && key.equals(classifier.apply(this.peek())));
                return list;
            }

            private T takeNext() {
                Object element = this.peek();
                this.peekedNext = false;
                return element;
            }

            private T peek() {
                if (!this.peekedNext) {
                    this.next = Stream.this.iterator.next();
                    this.peekedNext = true;
                }
                return this.next;
            }
        });
    }

    public Stream<T> sample(int stepWidth) {
        return this.slidingWindow(1, stepWidth).map(new Function<List<T>, T>(){

            @Override
            public T apply(List<T> list) {
                return list.get(0);
            }
        });
    }

    public Stream<List<T>> slidingWindow(int windowSize) {
        return this.slidingWindow(windowSize, 1);
    }

    public Stream<List<T>> slidingWindow(final int windowSize, final int stepWidth) {
        return new Stream<List<T>>(new LsaIterator<List<T>>(){
            private final Queue<T> queue = new LinkedList();

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public List<T> nextIteration() {
                int j;
                for (int i = this.queue.size(); Stream.this.iterator.hasNext() && i < windowSize; ++i) {
                    this.queue.offer(Stream.this.iterator.next());
                }
                ArrayList list = new ArrayList(this.queue);
                int queueSize = this.queue.size();
                for (j = 0; j < stepWidth && j < queueSize; ++j) {
                    this.queue.poll();
                }
                for (j = windowSize; Stream.this.iterator.hasNext() && j < stepWidth; ++j) {
                    Stream.this.iterator.next();
                }
                return list;
            }
        });
    }

    public Stream<T> peek(final Consumer<? super T> action) {
        return new Stream<T>(new LsaIterator<T>(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public T nextIteration() {
                Object value = Stream.this.iterator.next();
                action.accept(value);
                return value;
            }
        });
    }

    public Stream<T> takeWhile(final Predicate<? super T> predicate) {
        return new Stream<T>(new LsaExtIterator<T>(){

            @Override
            protected void nextIteration() {
                this.hasNext = Stream.this.iterator.hasNext() && predicate.test(this.next = Stream.this.iterator.next());
            }
        });
    }

    public Stream<T> dropWhile(final Predicate<? super T> predicate) {
        return new Stream<T>(new LsaExtIterator<T>(){

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    while (this.hasNext = Stream.this.iterator.hasNext()) {
                        this.next = Stream.this.iterator.next();
                        if (predicate.test(this.next)) continue;
                        return;
                    }
                }
                boolean bl = this.hasNext = this.hasNext && Stream.this.iterator.hasNext();
                if (!this.hasNext) {
                    return;
                }
                this.next = Stream.this.iterator.next();
            }
        });
    }

    public Stream<T> limit(final long maxSize) {
        return new Stream<T>(new LsaIterator<T>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < maxSize && Stream.this.iterator.hasNext();
            }

            @Override
            public T nextIteration() {
                ++this.index;
                return Stream.this.iterator.next();
            }
        });
    }

    public Stream<T> skip(final long n) {
        return new Stream<T>(new LsaIterator<T>(){
            private long skippedCount;

            @Override
            public boolean hasNext() {
                if (this.skippedCount < n) {
                    while (this.skippedCount < n) {
                        if (!Stream.this.iterator.hasNext()) {
                            return false;
                        }
                        Stream.this.iterator.next();
                        ++this.skippedCount;
                    }
                }
                return Stream.this.iterator.hasNext();
            }

            @Override
            public T nextIteration() {
                return Stream.this.iterator.next();
            }
        });
    }

    public void forEach(Consumer<? super T> action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
        }
    }

    public <R> R reduce(R identity, BiFunction<? super R, ? super T, ? extends R> accumulator) {
        R result = identity;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            result = accumulator.apply(result, value);
        }
        return result;
    }

    public Optional<T> reduce(BiFunction<T, T, T> accumulator) {
        boolean foundAny = false;
        Object result = null;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.apply(result, value);
        }
        return foundAny ? Optional.of(result) : Optional.empty();
    }

    public Object[] toArray() {
        return this.toArray((IntFunction<R[]>)new IntFunction<Object[]>(){

            @Override
            public Object[] apply(int value) {
                return new Object[value];
            }
        });
    }

    public <R> R[] toArray(IntFunction<R[]> generator) {
        List<Object> container = this.collectToList();
        int size = container.size();
        if ((long)size >= 0x7FFFFFF7L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
        Object[] source = container.toArray(Stream.newArray(size, new Object[0]));
        R[] boxed = generator.apply(size);
        System.arraycopy(source, 0, boxed, 0, size);
        return boxed;
    }

    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            accumulator.accept(result, value);
        }
        return result;
    }

    public <R, A> R collect(Collector<? super T, A, R> collector) {
        A container = collector.supplier().get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            collector.accumulator().accept(container, value);
        }
        if (collector.finisher() != null) {
            return collector.finisher().apply(container);
        }
        return Collectors.castIdentity().apply(container);
    }

    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.minBy(comparator));
    }

    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.maxBy(comparator));
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.next();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 0);
    }

    public boolean allMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 1);
    }

    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 2);
    }

    public Optional<T> findFirst() {
        if (this.iterator.hasNext()) {
            return Optional.of(this.iterator.next());
        }
        return Optional.empty();
    }

    private boolean match(Predicate<? super T> predicate, int matchKind) {
        boolean kindAll;
        boolean kindAny = matchKind == 0;
        boolean bl = kindAll = matchKind == 1;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            boolean match = predicate.test(value);
            if (!(match ^ kindAll)) continue;
            return kindAny && match;
        }
        return !kindAny;
    }

    @SafeVarargs
    static <E> E[] newArray(int length, E ... array) {
        return Arrays.copyOf(array, length);
    }

    private List<T> collectToList() {
        ArrayList<T> container = new ArrayList<T>();
        while (this.iterator.hasNext()) {
            container.add(this.iterator.next());
        }
        return container;
    }
}

