/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;

final class Compat {
    Compat() {
    }

    static <T> Queue<T> queue() {
        try {
            return new ArrayDeque();
        }
        catch (NoClassDefFoundError nce) {
            return new LinkedList();
        }
    }

    @SafeVarargs
    static <E> E[] newArray(int length, E ... array) {
        try {
            return Arrays.copyOf(array, length);
        }
        catch (NoSuchMethodError nme) {
            return Compat.newArrayCompat(array, length);
        }
    }

    static <E> E[] newArrayCompat(E[] array, int length) {
        Object[] res = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        System.arraycopy(array, 0, res, 0, Math.min(length, array.length));
        return res;
    }
}

