/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.IntStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.LsaIterator;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalDouble;
import com.annimon.stream.PrimitiveExtIterator;
import com.annimon.stream.PrimitiveIterator;
import com.annimon.stream.SpinedBuffer;
import com.annimon.stream.Stream;
import com.annimon.stream.function.DoubleBinaryOperator;
import com.annimon.stream.function.DoubleConsumer;
import com.annimon.stream.function.DoubleFunction;
import com.annimon.stream.function.DoublePredicate;
import com.annimon.stream.function.DoubleSupplier;
import com.annimon.stream.function.DoubleToIntFunction;
import com.annimon.stream.function.DoubleToLongFunction;
import com.annimon.stream.function.DoubleUnaryOperator;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.ObjDoubleConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToDoubleFunction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public final class DoubleStream {
    private static final DoubleStream EMPTY = new DoubleStream(new PrimitiveIterator.OfDouble(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public double nextDouble() {
            return 0.0;
        }
    });
    private final PrimitiveIterator.OfDouble iterator;
    private static final ToDoubleFunction<Double> UNBOX_FUNCTION = new ToDoubleFunction<Double>(){

        @Override
        public double applyAsDouble(Double t) {
            return t;
        }
    };

    public static DoubleStream empty() {
        return EMPTY;
    }

    public static DoubleStream of(PrimitiveIterator.OfDouble iterator) {
        Objects.requireNonNull(iterator);
        return new DoubleStream(iterator);
    }

    public static DoubleStream of(final double ... values) {
        Objects.requireNonNull(values);
        return new DoubleStream(new PrimitiveIterator.OfDouble(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < values.length;
            }

            @Override
            public double nextDouble() {
                return values[this.index++];
            }
        });
    }

    public static DoubleStream of(final double t) {
        return new DoubleStream(new PrimitiveIterator.OfDouble(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index == 0;
            }

            @Override
            public double nextDouble() {
                ++this.index;
                return t;
            }
        });
    }

    public static DoubleStream generate(final DoubleSupplier s) {
        Objects.requireNonNull(s);
        return new DoubleStream(new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public double nextDouble() {
                return s.getAsDouble();
            }
        });
    }

    public static DoubleStream iterate(final double seed, final DoubleUnaryOperator f) {
        Objects.requireNonNull(f);
        return new DoubleStream(new PrimitiveIterator.OfDouble(){
            private double current;
            {
                this.current = seed;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public double nextDouble() {
                double old = this.current;
                this.current = f.applyAsDouble(this.current);
                return old;
            }
        });
    }

    public static DoubleStream concat(DoubleStream a, DoubleStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        final PrimitiveIterator.OfDouble it1 = a.iterator;
        final PrimitiveIterator.OfDouble it2 = b.iterator;
        return new DoubleStream(new PrimitiveIterator.OfDouble(){
            private boolean firstStreamIsCurrent = true;

            @Override
            public boolean hasNext() {
                if (this.firstStreamIsCurrent) {
                    if (it1.hasNext()) {
                        return true;
                    }
                    this.firstStreamIsCurrent = false;
                }
                return it2.hasNext();
            }

            @Override
            public double nextDouble() {
                return this.firstStreamIsCurrent ? it1.nextDouble() : it2.nextDouble();
            }
        });
    }

    private DoubleStream(PrimitiveIterator.OfDouble iterator) {
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfDouble iterator() {
        return this.iterator;
    }

    public <R> R custom(Function<DoubleStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public Stream<Double> boxed() {
        return Stream.of(this.iterator);
    }

    public DoubleStream filter(final DoublePredicate predicate) {
        return new DoubleStream(new PrimitiveIterator.OfDouble(){
            private double next;

            @Override
            public boolean hasNext() {
                while (DoubleStream.this.iterator.hasNext()) {
                    this.next = DoubleStream.this.iterator.next();
                    if (!predicate.test(this.next)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public double nextDouble() {
                return this.next;
            }
        });
    }

    public DoubleStream filterNot(DoublePredicate predicate) {
        return this.filter(DoublePredicate.Util.negate(predicate));
    }

    public DoubleStream map(final DoubleUnaryOperator mapper) {
        return new DoubleStream(new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return DoubleStream.this.iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                return mapper.applyAsDouble(DoubleStream.this.iterator.nextDouble());
            }
        });
    }

    public <R> Stream<R> mapToObj(final DoubleFunction<? extends R> mapper) {
        return Stream.of(new LsaIterator<R>(){

            @Override
            public boolean hasNext() {
                return DoubleStream.this.iterator.hasNext();
            }

            @Override
            public R nextIteration() {
                return mapper.apply(DoubleStream.this.iterator.nextDouble());
            }
        });
    }

    public IntStream mapToInt(final DoubleToIntFunction mapper) {
        return IntStream.of(new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return DoubleStream.this.iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return mapper.applyAsInt(DoubleStream.this.iterator.nextDouble());
            }
        });
    }

    public LongStream mapToLong(final DoubleToLongFunction mapper) {
        return LongStream.of(new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return DoubleStream.this.iterator.hasNext();
            }

            @Override
            public long nextLong() {
                return mapper.applyAsLong(DoubleStream.this.iterator.nextDouble());
            }
        });
    }

    public DoubleStream flatMap(final DoubleFunction<? extends DoubleStream> mapper) {
        return new DoubleStream(new PrimitiveIterator.OfDouble(){
            private PrimitiveIterator.OfDouble inner;

            @Override
            public boolean hasNext() {
                if (this.inner != null && this.inner.hasNext()) {
                    return true;
                }
                while (DoubleStream.this.iterator.hasNext()) {
                    double arg = DoubleStream.this.iterator.next();
                    DoubleStream result = (DoubleStream)mapper.apply(arg);
                    if (result == null || !result.iterator.hasNext()) continue;
                    this.inner = result.iterator;
                    return true;
                }
                return false;
            }

            @Override
            public double nextDouble() {
                return this.inner.nextDouble();
            }
        });
    }

    public DoubleStream distinct() {
        return this.boxed().distinct().mapToDouble(UNBOX_FUNCTION);
    }

    public DoubleStream sorted() {
        return new DoubleStream(new PrimitiveExtIterator.OfDouble(){
            private int index = 0;
            private double[] array;

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    this.array = DoubleStream.this.toArray();
                    Arrays.sort(this.array);
                }
                boolean bl = this.hasNext = this.index < this.array.length;
                if (this.hasNext) {
                    this.next = this.array[this.index++];
                }
            }
        });
    }

    public DoubleStream sorted(Comparator<Double> comparator) {
        return this.boxed().sorted(comparator).mapToDouble(UNBOX_FUNCTION);
    }

    public DoubleStream sample(final int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new DoubleStream(new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return DoubleStream.this.iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                double result = DoubleStream.this.iterator.nextDouble();
                for (int skip = 1; skip < stepWidth && DoubleStream.this.iterator.hasNext(); ++skip) {
                    DoubleStream.this.iterator.nextDouble();
                }
                return result;
            }
        });
    }

    public DoubleStream peek(final DoubleConsumer action) {
        return new DoubleStream(new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return DoubleStream.this.iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                double value = DoubleStream.this.iterator.nextDouble();
                action.accept(value);
                return value;
            }
        });
    }

    public DoubleStream takeWhile(final DoublePredicate predicate) {
        return new DoubleStream(new PrimitiveExtIterator.OfDouble(){

            @Override
            protected void nextIteration() {
                this.hasNext = DoubleStream.this.iterator.hasNext() && predicate.test(this.next = DoubleStream.this.iterator.next().doubleValue());
            }
        });
    }

    public DoubleStream dropWhile(final DoublePredicate predicate) {
        return new DoubleStream(new PrimitiveExtIterator.OfDouble(){

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    while (this.hasNext = DoubleStream.this.iterator.hasNext()) {
                        this.next = DoubleStream.this.iterator.next();
                        if (predicate.test(this.next)) continue;
                        return;
                    }
                }
                boolean bl = this.hasNext = this.hasNext && DoubleStream.this.iterator.hasNext();
                if (!this.hasNext) {
                    return;
                }
                this.next = DoubleStream.this.iterator.next();
            }
        });
    }

    public DoubleStream limit(final long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return DoubleStream.empty();
        }
        return new DoubleStream(new PrimitiveIterator.OfDouble(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < maxSize && DoubleStream.this.iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                ++this.index;
                return DoubleStream.this.iterator.nextDouble();
            }
        });
    }

    public DoubleStream skip(final long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new DoubleStream(new PrimitiveIterator.OfDouble(){
            private long skippedCount = 0L;

            @Override
            public boolean hasNext() {
                while (DoubleStream.this.iterator.hasNext() && this.skippedCount != n) {
                    DoubleStream.this.iterator.nextDouble();
                    ++this.skippedCount;
                }
                return DoubleStream.this.iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                return DoubleStream.this.iterator.nextDouble();
            }
        });
    }

    public void forEach(DoubleConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextDouble());
        }
    }

    public double reduce(double identity, DoubleBinaryOperator accumulator) {
        double result = identity;
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            result = accumulator.applyAsDouble(result, value);
        }
        return result;
    }

    public OptionalDouble reduce(DoubleBinaryOperator accumulator) {
        boolean foundAny = false;
        double result = 0.0;
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.applyAsDouble(result, value);
        }
        return foundAny ? OptionalDouble.of(result) : OptionalDouble.empty();
    }

    public double[] toArray() {
        SpinedBuffer.OfDouble b = new SpinedBuffer.OfDouble();
        this.forEach(b);
        return (double[])b.asPrimitiveArray();
    }

    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            accumulator.accept(result, value);
        }
        return result;
    }

    public double sum() {
        double sum = 0.0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextDouble();
        }
        return sum;
    }

    public OptionalDouble min() {
        return this.reduce(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double left, double right) {
                return Math.min(left, right);
            }
        });
    }

    public OptionalDouble max() {
        return this.reduce(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double left, double right) {
                return Math.max(left, right);
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextDouble();
            ++count;
        }
        return count;
    }

    public OptionalDouble average() {
        long count = 0L;
        double sum = 0.0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextDouble();
            ++count;
        }
        if (count == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(sum / (double)count);
    }

    public boolean anyMatch(DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextDouble())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    public OptionalDouble findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalDouble.of(this.iterator.nextDouble());
        }
        return OptionalDouble.empty();
    }

    public double single() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException("DoubleStream contains no element");
        }
        double singleCandidate = this.iterator.next();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("DoubleStream contains more than one element");
        }
        return singleCandidate;
    }

    public OptionalDouble findSingle() {
        if (!this.iterator.hasNext()) {
            return OptionalDouble.empty();
        }
        double singleCandidate = this.iterator.next();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("DoubleStream contains more than one element");
        }
        return OptionalDouble.of(singleCandidate);
    }
}

