/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Collector;
import com.annimon.stream.Collectors;
import com.annimon.stream.Compat;
import com.annimon.stream.DoubleStream;
import com.annimon.stream.IntPair;
import com.annimon.stream.IntStream;
import com.annimon.stream.LazyIterator;
import com.annimon.stream.LongStream;
import com.annimon.stream.LsaExtIterator;
import com.annimon.stream.LsaIterator;
import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.PrimitiveExtIterator;
import com.annimon.stream.PrimitiveIterator;
import com.annimon.stream.function.BiConsumer;
import com.annimon.stream.function.BiFunction;
import com.annimon.stream.function.BinaryOperator;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IntFunction;
import com.annimon.stream.function.Predicate;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.function.ToLongFunction;
import com.annimon.stream.function.UnaryOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;

public final class Stream<T> {
    static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    static final String BAD_SIZE = "Stream size exceeds max array size";
    private final Iterator<? extends T> iterator;
    private static final int MATCH_ANY = 0;
    private static final int MATCH_ALL = 1;
    private static final int MATCH_NONE = 2;

    public static <T> Stream<T> empty() {
        return Stream.of(Collections.emptyList());
    }

    public static <K, V> Stream<Map.Entry<K, V>> of(Map<K, V> map) {
        Objects.requireNonNull(map);
        return new Stream<Map.Entry<K, V>>(map.entrySet());
    }

    public static <T> Stream<T> of(Iterator<? extends T> iterator) {
        Objects.requireNonNull(iterator);
        return new Stream<T>(iterator);
    }

    public static <T> Stream<T> of(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        return new Stream<T>(iterable);
    }

    public static <T> Stream<T> of(final T ... elements) {
        Objects.requireNonNull(elements);
        return new Stream<T>(new LsaIterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < elements.length;
            }

            @Override
            public T nextIteration() {
                return elements[this.index++];
            }
        });
    }

    public static <T> Stream<T> ofNullable(T element) {
        return element == null ? Stream.empty() : Stream.of(element);
    }

    public static <T> Stream<T> ofNullable(Iterable<? extends T> iterable) {
        return iterable == null ? Stream.empty() : Stream.of(iterable);
    }

    public static Stream<Integer> range(int from, int to) {
        return IntStream.range(from, to).boxed();
    }

    @Deprecated
    public static Stream<Integer> ofRange(int from, int to) {
        return Stream.range(from, to);
    }

    public static Stream<Long> range(long from, long to) {
        return LongStream.range(from, to).boxed();
    }

    @Deprecated
    public static Stream<Long> ofRange(long from, long to) {
        return Stream.range(from, to);
    }

    public static Stream<Integer> rangeClosed(int from, int to) {
        return IntStream.rangeClosed(from, to).boxed();
    }

    @Deprecated
    public static Stream<Integer> ofRangeClosed(int from, int to) {
        return Stream.rangeClosed(from, to);
    }

    public static Stream<Long> rangeClosed(long from, long to) {
        return LongStream.rangeClosed(from, to).boxed();
    }

    @Deprecated
    public static Stream<Long> ofRangeClosed(long from, long to) {
        return Stream.rangeClosed(from, to);
    }

    public static <T> Stream<T> generate(final Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return new Stream<T>(new LsaIterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T nextIteration() {
                return supplier.get();
            }
        });
    }

    public static <T> Stream<T> iterate(final T seed, final UnaryOperator<T> op) {
        Objects.requireNonNull(op);
        return new Stream<T>(new LsaIterator<T>(){
            private boolean firstRun = true;
            private T t;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T nextIteration() {
                if (this.firstRun) {
                    this.firstRun = false;
                    this.t = seed;
                } else {
                    this.t = op.apply(this.t);
                }
                return this.t;
            }
        });
    }

    public static <T> Stream<T> iterate(T seed, Predicate<? super T> predicate, UnaryOperator<T> op) {
        Objects.requireNonNull(predicate);
        return Stream.iterate(seed, op).takeWhile(predicate);
    }

    public static <T> Stream<T> concat(Stream<? extends T> stream1, Stream<? extends T> stream2) {
        Objects.requireNonNull(stream1);
        Objects.requireNonNull(stream2);
        final Iterator<? extends T> it1 = stream1.iterator;
        final Iterator<? extends T> it2 = stream2.iterator;
        return new Stream<T>(new LsaExtIterator<T>(){

            @Override
            protected void nextIteration() {
                if (it1.hasNext()) {
                    this.next = it1.next();
                    this.hasNext = true;
                    return;
                }
                if (it2.hasNext()) {
                    this.next = it2.next();
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        });
    }

    public static <F, S, R> Stream<R> zip(Stream<? extends F> stream1, Stream<? extends S> stream2, BiFunction<? super F, ? super S, ? extends R> combiner) {
        Objects.requireNonNull(stream1);
        Objects.requireNonNull(stream2);
        return Stream.zip(stream1.iterator, stream2.iterator, combiner);
    }

    public static <F, S, R> Stream<R> zip(final Iterator<? extends F> iterator1, final Iterator<? extends S> iterator2, final BiFunction<? super F, ? super S, ? extends R> combiner) {
        Objects.requireNonNull(iterator1);
        Objects.requireNonNull(iterator2);
        return new Stream(new LsaIterator<R>(){

            @Override
            public boolean hasNext() {
                return iterator1.hasNext() && iterator2.hasNext();
            }

            @Override
            public R nextIteration() {
                return combiner.apply(iterator1.next(), iterator2.next());
            }
        });
    }

    private Stream(Iterator<? extends T> iterator) {
        this.iterator = iterator;
    }

    private Stream(Iterable<? extends T> iterable) {
        this(new LazyIterator<T>(iterable));
    }

    @Deprecated
    public Iterator<? extends T> getIterator() {
        return this.iterator;
    }

    public Iterator<? extends T> iterator() {
        return this.iterator;
    }

    public <R> R custom(Function<Stream<T>, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public Stream<T> filter(final Predicate<? super T> predicate) {
        return new Stream<T>(new Iterator<T>(){
            private boolean hasNext;
            private boolean hasNextEvaluated;
            private T next;

            @Override
            public boolean hasNext() {
                if (!this.hasNextEvaluated) {
                    this.nextIteration();
                    this.hasNextEvaluated = true;
                }
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNextEvaluated) {
                    this.hasNext = this.hasNext();
                }
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNextEvaluated = false;
                return this.next;
            }

            private void nextIteration() {
                while (Stream.this.iterator.hasNext()) {
                    this.next = Stream.this.iterator.next();
                    if (!predicate.test(this.next)) continue;
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        });
    }

    public Stream<T> filterNot(Predicate<? super T> predicate) {
        return this.filter(Predicate.Util.negate(predicate));
    }

    public <TT> Stream<TT> select(final Class<TT> clazz) {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return clazz.isInstance(value);
            }
        });
    }

    public <R> Stream<R> map(final Function<? super T, ? extends R> mapper) {
        return new Stream<T>(new LsaIterator<R>(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public R nextIteration() {
                return mapper.apply(Stream.this.iterator.next());
            }
        });
    }

    public IntStream mapToInt(final ToIntFunction<? super T> mapper) {
        return IntStream.of(new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return mapper.applyAsInt(Stream.this.iterator.next());
            }
        });
    }

    public LongStream mapToLong(final ToLongFunction<? super T> mapper) {
        return LongStream.of(new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public long nextLong() {
                return mapper.applyAsLong(Stream.this.iterator.next());
            }
        });
    }

    public DoubleStream mapToDouble(final ToDoubleFunction<? super T> mapper) {
        return DoubleStream.of(new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                return mapper.applyAsDouble(Stream.this.iterator.next());
            }
        });
    }

    public <R> Stream<R> flatMap(final Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new Stream<T>(new LsaExtIterator<R>(){
            private Iterator<? extends R> inner;

            @Override
            protected void nextIteration() {
                if (this.inner != null && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                while (Stream.this.iterator.hasNext()) {
                    Object arg;
                    Stream result;
                    if (!(this.inner != null && this.inner.hasNext() || (result = (Stream)mapper.apply(arg = Stream.this.iterator.next())) == null)) {
                        this.inner = result.iterator;
                    }
                    if (this.inner == null || !this.inner.hasNext()) continue;
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        });
    }

    public IntStream flatMapToInt(final Function<? super T, ? extends IntStream> mapper) {
        return IntStream.of(new PrimitiveExtIterator.OfInt(){
            private PrimitiveIterator.OfInt inner;

            @Override
            protected void nextIteration() {
                if (this.inner != null && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                while (Stream.this.iterator.hasNext()) {
                    Object arg;
                    IntStream result;
                    if (!(this.inner != null && this.inner.hasNext() || (result = (IntStream)mapper.apply(arg = Stream.this.iterator.next())) == null)) {
                        this.inner = result.iterator();
                    }
                    if (this.inner == null || !this.inner.hasNext()) continue;
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        });
    }

    public LongStream flatMapToLong(final Function<? super T, ? extends LongStream> mapper) {
        return LongStream.of(new PrimitiveExtIterator.OfLong(){
            private PrimitiveIterator.OfLong inner;

            @Override
            protected void nextIteration() {
                if (this.inner != null && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                while (Stream.this.iterator.hasNext()) {
                    Object arg;
                    LongStream result;
                    if (!(this.inner != null && this.inner.hasNext() || (result = (LongStream)mapper.apply(arg = Stream.this.iterator.next())) == null)) {
                        this.inner = result.iterator();
                    }
                    if (this.inner == null || !this.inner.hasNext()) continue;
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        });
    }

    public DoubleStream flatMapToDouble(final Function<? super T, ? extends DoubleStream> mapper) {
        return DoubleStream.of(new PrimitiveExtIterator.OfDouble(){
            private PrimitiveIterator.OfDouble inner;

            @Override
            protected void nextIteration() {
                if (this.inner != null && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                while (Stream.this.iterator.hasNext()) {
                    Object arg;
                    DoubleStream result;
                    if (!(this.inner != null && this.inner.hasNext() || (result = (DoubleStream)mapper.apply(arg = Stream.this.iterator.next())) == null)) {
                        this.inner = result.iterator();
                    }
                    if (this.inner == null || !this.inner.hasNext()) continue;
                    this.next = this.inner.next();
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        });
    }

    public Stream<IntPair<T>> indexed() {
        return this.indexed(0, 1);
    }

    public Stream<IntPair<T>> indexed(final int from, final int step) {
        return this.map(new Function<T, IntPair<T>>(){
            private int index;
            {
                this.index = from - step;
            }

            @Override
            public IntPair<T> apply(T value) {
                return new IntPair(this.index += step, value);
            }
        });
    }

    public Stream<T> distinct() {
        return new Stream<T>(new LsaExtIterator<T>(){
            private final Set<T> set = new HashSet();

            @Override
            protected void nextIteration() {
                while (this.hasNext = Stream.this.iterator.hasNext()) {
                    this.next = Stream.this.iterator.next();
                    if (this.set.contains(this.next)) continue;
                    this.set.add(this.next);
                    return;
                }
            }
        });
    }

    public Stream<T> sorted() {
        return this.sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
        });
    }

    public Stream<T> sorted(final Comparator<? super T> comparator) {
        return new Stream<T>(new LsaExtIterator<T>(){
            private Iterator<T> sortedIterator;

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    List list = Stream.this.toList();
                    Collections.sort(list, comparator);
                    this.sortedIterator = list.iterator();
                }
                this.hasNext = this.sortedIterator.hasNext();
                if (this.hasNext) {
                    this.next = this.sortedIterator.next();
                }
            }
        });
    }

    public <R extends Comparable<? super R>> Stream<T> sortBy(final Function<? super T, ? extends R> f) {
        return this.sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)f.apply(o1)).compareTo(f.apply(o2));
            }
        });
    }

    public <K> Stream<Map.Entry<K, List<T>>> groupBy(Function<? super T, ? extends K> classifier) {
        return Stream.of(this.collect(Collectors.groupingBy(classifier)));
    }

    public <K> Stream<List<T>> chunkBy(final Function<? super T, ? extends K> classifier) {
        return new Stream<List<T>>(new LsaIterator<List<T>>(){
            private T next;
            private boolean peekedNext;

            @Override
            public boolean hasNext() {
                return this.peekedNext || Stream.this.iterator.hasNext();
            }

            @Override
            public List<T> nextIteration() {
                Object key = classifier.apply(this.peek());
                ArrayList list = new ArrayList();
                do {
                    list.add(this.takeNext());
                } while (Stream.this.iterator.hasNext() && key.equals(classifier.apply(this.peek())));
                return list;
            }

            private T takeNext() {
                Object element = this.peek();
                this.peekedNext = false;
                return element;
            }

            private T peek() {
                if (!this.peekedNext) {
                    this.next = Stream.this.iterator.next();
                    this.peekedNext = true;
                }
                return this.next;
            }
        });
    }

    public Stream<T> sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return this.slidingWindow(1, stepWidth).map(new Function<List<T>, T>(){

            @Override
            public T apply(List<T> list) {
                return list.get(0);
            }
        });
    }

    public Stream<List<T>> slidingWindow(int windowSize) {
        return this.slidingWindow(windowSize, 1);
    }

    public Stream<List<T>> slidingWindow(final int windowSize, final int stepWidth) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("windowSize cannot be zero or negative");
        }
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        return new Stream<List<T>>(new LsaIterator<List<T>>(){
            private final Queue<T> queue = Compat.queue();

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public List<T> nextIteration() {
                int j;
                for (int i = this.queue.size(); i < windowSize && Stream.this.iterator.hasNext(); ++i) {
                    this.queue.offer(Stream.this.iterator.next());
                }
                ArrayList list = new ArrayList(this.queue);
                int pollCount = Math.min(this.queue.size(), stepWidth);
                for (j = 0; j < pollCount; ++j) {
                    this.queue.poll();
                }
                for (j = windowSize; j < stepWidth && Stream.this.iterator.hasNext(); ++j) {
                    Stream.this.iterator.next();
                }
                return list;
            }
        });
    }

    public Stream<T> peek(final Consumer<? super T> action) {
        return new Stream<T>(new LsaIterator<T>(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public T nextIteration() {
                Object value = Stream.this.iterator.next();
                action.accept(value);
                return value;
            }
        });
    }

    public Stream<T> takeWhile(final Predicate<? super T> predicate) {
        return new Stream<T>(new LsaExtIterator<T>(){

            @Override
            protected void nextIteration() {
                this.hasNext = Stream.this.iterator.hasNext() && predicate.test(this.next = Stream.this.iterator.next());
            }
        });
    }

    public Stream<T> dropWhile(final Predicate<? super T> predicate) {
        return new Stream<T>(new LsaExtIterator<T>(){

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    while (this.hasNext = Stream.this.iterator.hasNext()) {
                        this.next = Stream.this.iterator.next();
                        if (predicate.test(this.next)) continue;
                        return;
                    }
                }
                boolean bl = this.hasNext = this.hasNext && Stream.this.iterator.hasNext();
                if (!this.hasNext) {
                    return;
                }
                this.next = Stream.this.iterator.next();
            }
        });
    }

    public Stream<T> limit(final long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return Stream.empty();
        }
        return new Stream<T>(new LsaIterator<T>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < maxSize && Stream.this.iterator.hasNext();
            }

            @Override
            public T nextIteration() {
                ++this.index;
                return Stream.this.iterator.next();
            }
        });
    }

    public Stream<T> skip(final long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new Stream<T>(new LsaIterator<T>(){
            private long skippedCount;

            @Override
            public boolean hasNext() {
                while (this.skippedCount < n) {
                    if (!Stream.this.iterator.hasNext()) {
                        return false;
                    }
                    Stream.this.iterator.next();
                    ++this.skippedCount;
                }
                return Stream.this.iterator.hasNext();
            }

            @Override
            public T nextIteration() {
                return Stream.this.iterator.next();
            }
        });
    }

    public void forEach(Consumer<? super T> action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
        }
    }

    public <R> R reduce(R identity, BiFunction<? super R, ? super T, ? extends R> accumulator) {
        R result = identity;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            result = accumulator.apply(result, value);
        }
        return result;
    }

    public Optional<T> reduce(BiFunction<T, T, T> accumulator) {
        boolean foundAny = false;
        Object result = null;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.apply(result, value);
        }
        return foundAny ? Optional.of(result) : Optional.empty();
    }

    public Object[] toArray() {
        return this.toArray((IntFunction<R[]>)new IntFunction<Object[]>(){

            @Override
            public Object[] apply(int value) {
                return new Object[value];
            }
        });
    }

    public <R> R[] toArray(IntFunction<R[]> generator) {
        List<Object> container = this.toList();
        int size = container.size();
        if ((long)size >= 0x7FFFFFF7L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
        Object[] source = container.toArray(Compat.newArray(size, new Object[0]));
        R[] boxed = generator.apply(size);
        System.arraycopy(source, 0, boxed, 0, size);
        return boxed;
    }

    public List<T> toList() {
        ArrayList<T> result = new ArrayList<T>();
        while (this.iterator.hasNext()) {
            result.add(this.iterator.next());
        }
        return result;
    }

    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            accumulator.accept(result, value);
        }
        return result;
    }

    public <R, A> R collect(Collector<? super T, A, R> collector) {
        A container = collector.supplier().get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            collector.accumulator().accept(container, value);
        }
        if (collector.finisher() != null) {
            return collector.finisher().apply(container);
        }
        return Collectors.castIdentity().apply(container);
    }

    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.minBy(comparator));
    }

    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.maxBy(comparator));
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.next();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 0);
    }

    public boolean allMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 1);
    }

    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 2);
    }

    public Optional<T> findFirst() {
        if (this.iterator.hasNext()) {
            return Optional.of(this.iterator.next());
        }
        return Optional.empty();
    }

    public T single() {
        if (this.iterator.hasNext()) {
            T singleCandidate = this.iterator.next();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("Stream contains more than one element");
            }
            return singleCandidate;
        }
        throw new NoSuchElementException("Stream contains no element");
    }

    public Optional<T> findSingle() {
        if (this.iterator.hasNext()) {
            T singleCandidate = this.iterator.next();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("Stream contains more than one element");
            }
            return Optional.of(singleCandidate);
        }
        return Optional.empty();
    }

    private boolean match(Predicate<? super T> predicate, int matchKind) {
        boolean kindAll;
        boolean kindAny = matchKind == 0;
        boolean bl = kindAll = matchKind == 1;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            boolean match = predicate.test(value);
            if (!(match ^ kindAll)) continue;
            return kindAny && match;
        }
        return !kindAny;
    }
}

