/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.function.FunctionalInterface;

@FunctionalInterface
public interface DoublePredicate {
    public boolean test(double var1);

    public static class Util {
        private Util() {
        }

        public static DoublePredicate and(final DoublePredicate p1, final DoublePredicate p2) {
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static DoublePredicate or(final DoublePredicate p1, final DoublePredicate p2) {
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static DoublePredicate xor(final DoublePredicate p1, final DoublePredicate p2) {
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static DoublePredicate negate(final DoublePredicate p1) {
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return !p1.test(value);
                }
            };
        }
    }
}

