/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.FunctionalInterface;
import com.annimon.stream.function.IntConsumer;

@FunctionalInterface
public interface IndexedConsumer<T> {
    public void accept(int var1, T var2);

    public static class Util {
        private Util() {
        }

        public static <T> IndexedConsumer<T> wrap(final Consumer<? super T> consumer) {
            Objects.requireNonNull(consumer);
            return new IndexedConsumer<T>(){

                @Override
                public void accept(int index, T t) {
                    consumer.accept(t);
                }
            };
        }

        public static <T> IndexedConsumer<T> accept(final IntConsumer c1, final Consumer<? super T> c2) {
            return new IndexedConsumer<T>(){

                @Override
                public void accept(int index, T value) {
                    if (c1 != null) {
                        c1.accept(index);
                    }
                    if (c2 != null) {
                        c2.accept(value);
                    }
                }
            };
        }
    }
}

