/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.function.FunctionalInterface;
import com.annimon.stream.function.ThrowablePredicate;

@FunctionalInterface
public interface Predicate<T> {
    public boolean test(T var1);

    public static class Util {
        private Util() {
        }

        public static <T> Predicate<T> and(final Predicate<? super T> p1, final Predicate<? super T> p2) {
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static <T> Predicate<T> or(final Predicate<? super T> p1, final Predicate<? super T> p2) {
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static <T> Predicate<T> xor(final Predicate<? super T> p1, final Predicate<? super T> p2) {
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static <T> Predicate<T> negate(final Predicate<? super T> p1) {
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return !p1.test(value);
                }
            };
        }

        public static <T> Predicate<T> notNull() {
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return value != null;
                }
            };
        }

        public static <T> Predicate<T> safe(ThrowablePredicate<? super T, Throwable> throwablePredicate) {
            return Util.safe(throwablePredicate, false);
        }

        public static <T> Predicate<T> safe(final ThrowablePredicate<? super T, Throwable> throwablePredicate, final boolean resultIfFailed) {
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    try {
                        return throwablePredicate.test(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

