/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.function.FunctionalInterface;
import com.annimon.stream.function.ThrowableIntPredicate;

@FunctionalInterface
public interface IntPredicate {
    public boolean test(int var1);

    public static class Util {
        private Util() {
        }

        public static IntPredicate and(final IntPredicate p1, final IntPredicate p2) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static IntPredicate or(final IntPredicate p1, final IntPredicate p2) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static IntPredicate xor(final IntPredicate p1, final IntPredicate p2) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static IntPredicate negate(final IntPredicate p1) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return !p1.test(value);
                }
            };
        }

        public static IntPredicate safe(ThrowableIntPredicate<Throwable> throwablePredicate) {
            return Util.safe(throwablePredicate, false);
        }

        public static IntPredicate safe(final ThrowableIntPredicate<Throwable> throwablePredicate, final boolean resultIfFailed) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    try {
                        return throwablePredicate.test(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

