/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.IntStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalDouble;
import com.annimon.stream.Stream;
import com.annimon.stream.function.DoubleBinaryOperator;
import com.annimon.stream.function.DoubleConsumer;
import com.annimon.stream.function.DoubleFunction;
import com.annimon.stream.function.DoublePredicate;
import com.annimon.stream.function.DoubleSupplier;
import com.annimon.stream.function.DoubleToIntFunction;
import com.annimon.stream.function.DoubleToLongFunction;
import com.annimon.stream.function.DoubleUnaryOperator;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IndexedDoubleConsumer;
import com.annimon.stream.function.IndexedDoublePredicate;
import com.annimon.stream.function.IndexedDoubleUnaryOperator;
import com.annimon.stream.function.ObjDoubleConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.internal.Compose;
import com.annimon.stream.internal.Operators;
import com.annimon.stream.internal.Params;
import com.annimon.stream.internal.SpinedBuffer;
import com.annimon.stream.iterator.PrimitiveIndexedIterator;
import com.annimon.stream.iterator.PrimitiveIterator;
import com.annimon.stream.operator.DoubleArray;
import com.annimon.stream.operator.DoubleConcat;
import com.annimon.stream.operator.DoubleDropWhile;
import com.annimon.stream.operator.DoubleFilter;
import com.annimon.stream.operator.DoubleFilterIndexed;
import com.annimon.stream.operator.DoubleFlatMap;
import com.annimon.stream.operator.DoubleGenerate;
import com.annimon.stream.operator.DoubleIterate;
import com.annimon.stream.operator.DoubleLimit;
import com.annimon.stream.operator.DoubleMap;
import com.annimon.stream.operator.DoubleMapIndexed;
import com.annimon.stream.operator.DoubleMapToInt;
import com.annimon.stream.operator.DoubleMapToLong;
import com.annimon.stream.operator.DoubleMapToObj;
import com.annimon.stream.operator.DoublePeek;
import com.annimon.stream.operator.DoubleSample;
import com.annimon.stream.operator.DoubleScan;
import com.annimon.stream.operator.DoubleScanIdentity;
import com.annimon.stream.operator.DoubleSkip;
import com.annimon.stream.operator.DoubleSorted;
import com.annimon.stream.operator.DoubleTakeUntil;
import com.annimon.stream.operator.DoubleTakeWhile;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DoubleStream
implements Closeable {
    private static final DoubleStream EMPTY = new DoubleStream(new PrimitiveIterator.OfDouble(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public double nextDouble() {
            return 0.0;
        }
    });
    private final PrimitiveIterator.OfDouble iterator;
    private final Params params;
    private static final ToDoubleFunction<Double> UNBOX_FUNCTION = new ToDoubleFunction<Double>(){

        @Override
        public double applyAsDouble(Double t) {
            return t;
        }
    };

    @NotNull
    public static DoubleStream empty() {
        return EMPTY;
    }

    @NotNull
    public static DoubleStream of(@NotNull PrimitiveIterator.OfDouble iterator) {
        Objects.requireNonNull(iterator);
        return new DoubleStream(iterator);
    }

    @NotNull
    public static DoubleStream of(double ... values) {
        Objects.requireNonNull(values);
        if (values.length == 0) {
            return DoubleStream.empty();
        }
        return new DoubleStream(new DoubleArray(values));
    }

    @NotNull
    public static DoubleStream of(double t) {
        return new DoubleStream(new DoubleArray(new double[]{t}));
    }

    @NotNull
    public static DoubleStream generate(@NotNull DoubleSupplier s) {
        Objects.requireNonNull(s);
        return new DoubleStream(new DoubleGenerate(s));
    }

    @NotNull
    public static DoubleStream iterate(double seed, @NotNull DoubleUnaryOperator f) {
        Objects.requireNonNull(f);
        return new DoubleStream(new DoubleIterate(seed, f));
    }

    @NotNull
    public static DoubleStream iterate(double seed, @NotNull DoublePredicate predicate, @NotNull DoubleUnaryOperator op) {
        Objects.requireNonNull(predicate);
        return DoubleStream.iterate(seed, op).takeWhile(predicate);
    }

    @NotNull
    public static DoubleStream concat(@NotNull DoubleStream a, @NotNull DoubleStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        DoubleStream result = new DoubleStream(new DoubleConcat(a.iterator, b.iterator));
        return result.onClose(Compose.closeables(a, b));
    }

    @NotNull
    public static DoubleStream concat(@NotNull DoubleStream a, @NotNull DoubleStream b, DoubleStream ... rest) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Objects.requireNonNull(rest);
        ArrayList<PrimitiveIterator.OfDouble> iterators = new ArrayList<PrimitiveIterator.OfDouble>(rest.length + 2);
        ArrayList<DoubleStream> closeables = new ArrayList<DoubleStream>(rest.length + 2);
        Collections.addAll(iterators, a.iterator, b.iterator);
        Collections.addAll(closeables, a, b);
        for (DoubleStream stream : rest) {
            iterators.add(stream.iterator);
            closeables.add(stream);
        }
        DoubleStream result = new DoubleStream(new DoubleConcat(iterators));
        return result.onClose(Compose.closeables(closeables));
    }

    private DoubleStream(PrimitiveIterator.OfDouble iterator) {
        this(null, iterator);
    }

    DoubleStream(Params params, PrimitiveIterator.OfDouble iterator) {
        this.params = params;
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfDouble iterator() {
        return this.iterator;
    }

    @Nullable
    public <R> R custom(@NotNull Function<DoubleStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public Stream<Double> boxed() {
        return new Stream<Double>(this.params, this.iterator);
    }

    @NotNull
    public DoubleStream prepend(@NotNull DoubleStream stream) {
        return DoubleStream.concat(stream, this);
    }

    @NotNull
    public DoubleStream append(@NotNull DoubleStream stream) {
        return DoubleStream.concat(this, stream);
    }

    @NotNull
    public DoubleStream filter(@NotNull DoublePredicate predicate) {
        return new DoubleStream(this.params, new DoubleFilter(this.iterator, predicate));
    }

    @NotNull
    public DoubleStream filterIndexed(@NotNull IndexedDoublePredicate predicate) {
        return this.filterIndexed(0, 1, predicate);
    }

    @NotNull
    public DoubleStream filterIndexed(int from, int step, @NotNull IndexedDoublePredicate predicate) {
        return new DoubleStream(this.params, new DoubleFilterIndexed(new PrimitiveIndexedIterator.OfDouble(from, step, this.iterator), predicate));
    }

    @NotNull
    public DoubleStream filterNot(@NotNull DoublePredicate predicate) {
        return this.filter(DoublePredicate.Util.negate(predicate));
    }

    @NotNull
    public DoubleStream map(@NotNull DoubleUnaryOperator mapper) {
        return new DoubleStream(this.params, new DoubleMap(this.iterator, mapper));
    }

    @NotNull
    public DoubleStream mapIndexed(@NotNull IndexedDoubleUnaryOperator mapper) {
        return this.mapIndexed(0, 1, mapper);
    }

    @NotNull
    public DoubleStream mapIndexed(int from, int step, @NotNull IndexedDoubleUnaryOperator mapper) {
        return new DoubleStream(this.params, new DoubleMapIndexed(new PrimitiveIndexedIterator.OfDouble(from, step, this.iterator), mapper));
    }

    @NotNull
    public <R> Stream<R> mapToObj(@NotNull DoubleFunction<? extends R> mapper) {
        return new Stream<R>(this.params, new DoubleMapToObj<R>(this.iterator, mapper));
    }

    @NotNull
    public IntStream mapToInt(@NotNull DoubleToIntFunction mapper) {
        return new IntStream(this.params, new DoubleMapToInt(this.iterator, mapper));
    }

    @NotNull
    public LongStream mapToLong(@NotNull DoubleToLongFunction mapper) {
        return new LongStream(this.params, new DoubleMapToLong(this.iterator, mapper));
    }

    @NotNull
    public DoubleStream flatMap(@NotNull DoubleFunction<? extends DoubleStream> mapper) {
        return new DoubleStream(this.params, new DoubleFlatMap(this.iterator, mapper));
    }

    @NotNull
    public DoubleStream mapMulti(final @NotNull DoubleMapMultiConsumer mapper) {
        return this.flatMap((DoubleFunction<? extends DoubleStream>)new DoubleFunction<DoubleStream>(){

            @Override
            public DoubleStream apply(double value) {
                SpinedBuffer.OfDouble buffer = new SpinedBuffer.OfDouble();
                mapper.accept(value, buffer);
                return DoubleStream.of(buffer.iterator());
            }
        });
    }

    @NotNull
    public DoubleStream distinct() {
        return this.boxed().distinct().mapToDouble(UNBOX_FUNCTION);
    }

    @NotNull
    public DoubleStream sorted() {
        return new DoubleStream(this.params, new DoubleSorted(this.iterator));
    }

    @NotNull
    public DoubleStream sorted(@Nullable Comparator<Double> comparator) {
        return this.boxed().sorted(comparator).mapToDouble(UNBOX_FUNCTION);
    }

    @NotNull
    public DoubleStream sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new DoubleStream(this.params, new DoubleSample(this.iterator, stepWidth));
    }

    @NotNull
    public DoubleStream peek(@NotNull DoubleConsumer action) {
        return new DoubleStream(this.params, new DoublePeek(this.iterator, action));
    }

    @NotNull
    public DoubleStream scan(@NotNull DoubleBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new DoubleStream(this.params, new DoubleScan(this.iterator, accumulator));
    }

    @NotNull
    public DoubleStream scan(double identity, @NotNull DoubleBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new DoubleStream(this.params, new DoubleScanIdentity(this.iterator, identity, accumulator));
    }

    @NotNull
    public DoubleStream takeWhile(@NotNull DoublePredicate predicate) {
        return new DoubleStream(this.params, new DoubleTakeWhile(this.iterator, predicate));
    }

    @NotNull
    public DoubleStream takeUntil(@NotNull DoublePredicate stopPredicate) {
        return new DoubleStream(this.params, new DoubleTakeUntil(this.iterator, stopPredicate));
    }

    @NotNull
    public DoubleStream dropWhile(@NotNull DoublePredicate predicate) {
        return new DoubleStream(this.params, new DoubleDropWhile(this.iterator, predicate));
    }

    @NotNull
    public DoubleStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return DoubleStream.empty();
        }
        return new DoubleStream(this.params, new DoubleLimit(this.iterator, maxSize));
    }

    @NotNull
    public DoubleStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new DoubleStream(this.params, new DoubleSkip(this.iterator, n));
    }

    public void forEach(@NotNull DoubleConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextDouble());
        }
    }

    public void forEachIndexed(@NotNull IndexedDoubleConsumer action) {
        this.forEachIndexed(0, 1, action);
    }

    public void forEachIndexed(int from, int step, @NotNull IndexedDoubleConsumer action) {
        int index = from;
        while (this.iterator.hasNext()) {
            action.accept(index, this.iterator.nextDouble());
            index += step;
        }
    }

    public double reduce(double identity, @NotNull DoubleBinaryOperator accumulator) {
        double result = identity;
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            result = accumulator.applyAsDouble(result, value);
        }
        return result;
    }

    @NotNull
    public OptionalDouble reduce(@NotNull DoubleBinaryOperator accumulator) {
        boolean foundAny = false;
        double result = 0.0;
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.applyAsDouble(result, value);
        }
        return foundAny ? OptionalDouble.of(result) : OptionalDouble.empty();
    }

    @NotNull
    public double[] toArray() {
        return Operators.toDoubleArray(this.iterator);
    }

    @Nullable
    public <R> R collect(@NotNull Supplier<R> supplier, @NotNull ObjDoubleConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            accumulator.accept(result, value);
        }
        return result;
    }

    public double sum() {
        double sum = 0.0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextDouble();
        }
        return sum;
    }

    @NotNull
    public OptionalDouble min() {
        return this.reduce(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double left, double right) {
                return Math.min(left, right);
            }
        });
    }

    @NotNull
    public OptionalDouble max() {
        return this.reduce(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double left, double right) {
                return Math.max(left, right);
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextDouble();
            ++count;
        }
        return count;
    }

    @NotNull
    public OptionalDouble average() {
        long count = 0L;
        double sum = 0.0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextDouble();
            ++count;
        }
        if (count == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(sum / (double)count);
    }

    public boolean anyMatch(@NotNull DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextDouble())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(@NotNull DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(@NotNull DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public OptionalDouble findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalDouble.of(this.iterator.nextDouble());
        }
        return OptionalDouble.empty();
    }

    public double findFirstOrElse(double other) {
        if (this.iterator.hasNext()) {
            return this.iterator.nextDouble();
        }
        return other;
    }

    @NotNull
    public OptionalDouble findLast() {
        return this.reduce(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double left, double right) {
                return right;
            }
        });
    }

    public double single() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException("DoubleStream contains no element");
        }
        double singleCandidate = this.iterator.nextDouble();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("DoubleStream contains more than one element");
        }
        return singleCandidate;
    }

    @NotNull
    public OptionalDouble findSingle() {
        if (!this.iterator.hasNext()) {
            return OptionalDouble.empty();
        }
        double singleCandidate = this.iterator.nextDouble();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("DoubleStream contains more than one element");
        }
        return OptionalDouble.of(singleCandidate);
    }

    @NotNull
    public DoubleStream onClose(@NotNull Runnable closeHandler) {
        Objects.requireNonNull(closeHandler);
        Params newParams = Params.wrapWithCloseHandler(this.params, closeHandler);
        return new DoubleStream(newParams, this.iterator);
    }

    @Override
    public void close() {
        if (this.params != null && this.params.closeHandler != null) {
            this.params.closeHandler.run();
            this.params.closeHandler = null;
        }
    }

    public static interface DoubleMapMultiConsumer {
        public void accept(double var1, DoubleConsumer var3);
    }
}

