/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ThrowableFunction;
import com.annimon.stream.function.ThrowableSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Exceptional<T> {
    private final T value;
    private final Throwable throwable;

    @NotNull
    public static <T> Exceptional<T> of(@NotNull ThrowableSupplier<T, Throwable> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return new Exceptional<T>(supplier.get(), null);
        }
        catch (Throwable throwable) {
            return Exceptional.of(throwable);
        }
    }

    @NotNull
    @Contract(value="_ -> new")
    public static <T> Exceptional<T> of(@NotNull Throwable throwable) {
        Objects.requireNonNull(throwable);
        return new Exceptional<Object>(null, throwable);
    }

    private Exceptional(@Nullable T value, @Nullable Throwable throwable) {
        this.value = value;
        this.throwable = throwable;
    }

    @Nullable
    public T get() {
        return this.value;
    }

    public boolean isPresent() {
        return this.throwable == null;
    }

    @Nullable
    public T getOrElse(@Nullable T other) {
        return this.throwable == null ? this.value : other;
    }

    @Nullable
    public T getOrElse(@NotNull Supplier<? extends T> other) {
        return this.throwable == null ? this.value : other.get();
    }

    @NotNull
    public Optional<T> getOptional() {
        return Optional.ofNullable(this.value);
    }

    @Nullable
    public Throwable getException() {
        return this.throwable;
    }

    @Nullable
    public T getOrThrow() throws Throwable {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.value;
    }

    @Nullable
    public T getOrThrowRuntimeException() throws RuntimeException {
        if (this.throwable != null) {
            throw new RuntimeException(this.throwable);
        }
        return this.value;
    }

    @Nullable
    public <E extends Throwable> T getOrThrow(@NotNull E exception) throws E {
        if (this.throwable != null) {
            exception.initCause(this.throwable);
            throw exception;
        }
        return this.value;
    }

    @NotNull
    public Exceptional<T> or(@NotNull Supplier<Exceptional<T>> supplier) {
        if (this.throwable == null) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    @Nullable
    public <R> R custom(@NotNull Function<Exceptional<T>, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public <U> Exceptional<U> map(@NotNull ThrowableFunction<? super T, ? extends U, Throwable> mapper) {
        if (this.throwable != null) {
            return Exceptional.of(this.throwable);
        }
        Objects.requireNonNull(mapper);
        try {
            return new Exceptional<U>(mapper.apply(this.value), null);
        }
        catch (Throwable t) {
            return Exceptional.of(t);
        }
    }

    @NotNull
    public Exceptional<T> ifPresent(@NotNull Consumer<? super T> consumer) {
        if (this.throwable == null) {
            consumer.accept(this.value);
        }
        return this;
    }

    @NotNull
    public Exceptional<T> ifException(@NotNull Consumer<Throwable> consumer) {
        if (this.throwable != null) {
            consumer.accept(this.throwable);
        }
        return this;
    }

    @NotNull
    public <E extends Throwable> Exceptional<T> ifExceptionIs(@NotNull Class<E> throwableClass, @NotNull Consumer<? super E> consumer) {
        if (this.throwable != null && throwableClass.isAssignableFrom(this.throwable.getClass())) {
            consumer.accept(this.throwable);
        }
        return this;
    }

    @NotNull
    public Exceptional<T> recover(@NotNull ThrowableFunction<Throwable, ? extends T, Throwable> function) {
        if (this.throwable == null) {
            return this;
        }
        Objects.requireNonNull(function);
        try {
            return new Exceptional<T>(function.apply(this.throwable), null);
        }
        catch (Throwable throwable) {
            return Exceptional.of(throwable);
        }
    }

    @NotNull
    public Exceptional<T> recoverWith(@NotNull Function<Throwable, ? extends Exceptional<T>> function) {
        if (this.throwable == null) {
            return this;
        }
        Objects.requireNonNull(function);
        return Objects.requireNonNull(function.apply(this.throwable));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Exceptional)) {
            return false;
        }
        Exceptional other = (Exceptional)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.throwable, other.throwable);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.throwable);
    }

    @NotNull
    public String toString() {
        return this.throwable == null ? String.format("Exceptional value %s", this.value) : String.format("Exceptional throwable %s", this.throwable);
    }
}

