/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.IntStream;
import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.OptionalDouble;
import com.annimon.stream.OptionalLong;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IntConsumer;
import com.annimon.stream.function.IntFunction;
import com.annimon.stream.function.IntPredicate;
import com.annimon.stream.function.IntSupplier;
import com.annimon.stream.function.IntToDoubleFunction;
import com.annimon.stream.function.IntToLongFunction;
import com.annimon.stream.function.IntUnaryOperator;
import com.annimon.stream.function.Supplier;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalInt {
    private static final OptionalInt EMPTY = new OptionalInt();
    private final boolean isPresent;
    private final int value;

    private OptionalInt() {
        this.isPresent = false;
        this.value = 0;
    }

    @NotNull
    public static OptionalInt empty() {
        return EMPTY;
    }

    private OptionalInt(int value) {
        this.isPresent = true;
        this.value = value;
    }

    @NotNull
    public static OptionalInt of(int value) {
        return new OptionalInt(value);
    }

    @NotNull
    public static OptionalInt ofNullable(@Nullable Integer value) {
        return value == null ? EMPTY : new OptionalInt(value);
    }

    public int getAsInt() {
        return this.orElseThrow();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(@NotNull IntConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(@NotNull IntConsumer consumer, @NotNull Runnable emptyAction) {
        if (this.isPresent) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    @NotNull
    public OptionalInt executeIfPresent(@NotNull IntConsumer consumer) {
        this.ifPresent(consumer);
        return this;
    }

    @NotNull
    public OptionalInt executeIfAbsent(@NotNull Runnable action) {
        if (!this.isPresent()) {
            action.run();
        }
        return this;
    }

    @Nullable
    public <R> R custom(@NotNull Function<OptionalInt, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public OptionalInt filter(@NotNull IntPredicate predicate) {
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalInt.empty();
    }

    @NotNull
    public OptionalInt filterNot(@NotNull IntPredicate predicate) {
        return this.filter(IntPredicate.Util.negate(predicate));
    }

    @NotNull
    public OptionalInt map(@NotNull IntUnaryOperator mapper) {
        if (!this.isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(mapper.applyAsInt(this.value));
    }

    @NotNull
    public <U> Optional<U> mapToObj(@NotNull IntFunction<U> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value));
    }

    @NotNull
    public OptionalLong mapToLong(@NotNull IntToLongFunction mapper) {
        if (!this.isPresent()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(mapper.applyAsLong(this.value));
    }

    @NotNull
    public OptionalDouble mapToDouble(@NotNull IntToDoubleFunction mapper) {
        if (!this.isPresent()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(mapper.applyAsDouble(this.value));
    }

    @NotNull
    public IntStream stream() {
        if (!this.isPresent()) {
            return IntStream.empty();
        }
        return IntStream.of(this.value);
    }

    @NotNull
    public OptionalInt or(@NotNull Supplier<OptionalInt> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public int orElse(int other) {
        return this.isPresent ? this.value : other;
    }

    public int orElseGet(@NotNull IntSupplier other) {
        return this.isPresent ? this.value : other.getAsInt();
    }

    public int orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> int orElseThrow(@NotNull Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalInt)) {
            return false;
        }
        OptionalInt other = (OptionalInt)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? this.value : 0;
    }

    @NotNull
    public String toString() {
        return this.isPresent ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }
}

