/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Collector;
import com.annimon.stream.Collectors;
import com.annimon.stream.ComparatorCompat;
import com.annimon.stream.DoubleStream;
import com.annimon.stream.IntPair;
import com.annimon.stream.IntStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.function.BiConsumer;
import com.annimon.stream.function.BiFunction;
import com.annimon.stream.function.BinaryOperator;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.DoubleConsumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IndexedBiFunction;
import com.annimon.stream.function.IndexedConsumer;
import com.annimon.stream.function.IndexedFunction;
import com.annimon.stream.function.IndexedPredicate;
import com.annimon.stream.function.IntConsumer;
import com.annimon.stream.function.IntFunction;
import com.annimon.stream.function.LongConsumer;
import com.annimon.stream.function.Predicate;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.function.ToLongFunction;
import com.annimon.stream.function.UnaryOperator;
import com.annimon.stream.internal.Compose;
import com.annimon.stream.internal.Operators;
import com.annimon.stream.internal.Params;
import com.annimon.stream.internal.SpinedBuffer;
import com.annimon.stream.iterator.IndexedIterator;
import com.annimon.stream.iterator.LazyIterator;
import com.annimon.stream.operator.ObjArray;
import com.annimon.stream.operator.ObjChunkBy;
import com.annimon.stream.operator.ObjConcat;
import com.annimon.stream.operator.ObjDistinct;
import com.annimon.stream.operator.ObjDistinctBy;
import com.annimon.stream.operator.ObjDropWhile;
import com.annimon.stream.operator.ObjDropWhileIndexed;
import com.annimon.stream.operator.ObjFilter;
import com.annimon.stream.operator.ObjFilterIndexed;
import com.annimon.stream.operator.ObjFlatMap;
import com.annimon.stream.operator.ObjFlatMapToDouble;
import com.annimon.stream.operator.ObjFlatMapToInt;
import com.annimon.stream.operator.ObjFlatMapToLong;
import com.annimon.stream.operator.ObjGenerate;
import com.annimon.stream.operator.ObjIterate;
import com.annimon.stream.operator.ObjLimit;
import com.annimon.stream.operator.ObjMap;
import com.annimon.stream.operator.ObjMapIndexed;
import com.annimon.stream.operator.ObjMapToDouble;
import com.annimon.stream.operator.ObjMapToInt;
import com.annimon.stream.operator.ObjMapToLong;
import com.annimon.stream.operator.ObjMerge;
import com.annimon.stream.operator.ObjPeek;
import com.annimon.stream.operator.ObjScan;
import com.annimon.stream.operator.ObjScanIdentity;
import com.annimon.stream.operator.ObjSkip;
import com.annimon.stream.operator.ObjSlidingWindow;
import com.annimon.stream.operator.ObjSorted;
import com.annimon.stream.operator.ObjTakeUntil;
import com.annimon.stream.operator.ObjTakeUntilIndexed;
import com.annimon.stream.operator.ObjTakeWhile;
import com.annimon.stream.operator.ObjTakeWhileIndexed;
import com.annimon.stream.operator.ObjZip;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Stream<T>
implements Closeable {
    private final Iterator<? extends T> iterator;
    private final Params params;
    private static final int MATCH_ANY = 0;
    private static final int MATCH_ALL = 1;
    private static final int MATCH_NONE = 2;

    @NotNull
    public static <T> Stream<T> empty() {
        return Stream.of(Collections.emptyList());
    }

    @NotNull
    public static <K, V> Stream<Map.Entry<K, V>> of(@NotNull Map<K, V> map) {
        Objects.requireNonNull(map);
        return new Stream<Map.Entry<K, V>>(map.entrySet());
    }

    @NotNull
    public static <T> Stream<T> of(@NotNull Iterator<? extends T> iterator) {
        Objects.requireNonNull(iterator);
        return new Stream<T>(iterator);
    }

    @NotNull
    public static <T> Stream<T> of(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        return new Stream<T>(iterable);
    }

    @NotNull
    public static <T> Stream<T> of(T ... elements) {
        Objects.requireNonNull(elements);
        if (elements.length == 0) {
            return Stream.empty();
        }
        return new Stream<T>(new ObjArray<T>(elements));
    }

    @NotNull
    public static <T> Stream<T> ofNullable(@Nullable T element) {
        return element == null ? Stream.empty() : Stream.of(element);
    }

    @NotNull
    public static <T> Stream<T> ofNullable(@Nullable T[] array) {
        return array == null ? Stream.empty() : Stream.of(array);
    }

    @NotNull
    public static <K, V> Stream<Map.Entry<K, V>> ofNullable(@Nullable Map<K, V> map) {
        return map == null ? Stream.empty() : Stream.of(map);
    }

    @NotNull
    public static <T> Stream<T> ofNullable(@Nullable Iterator<? extends T> iterator) {
        return iterator == null ? Stream.empty() : Stream.of(iterator);
    }

    @NotNull
    public static <T> Stream<T> ofNullable(@Nullable Iterable<? extends T> iterable) {
        return iterable == null ? Stream.empty() : Stream.of(iterable);
    }

    @NotNull
    public static Stream<Integer> range(int from, int to) {
        return IntStream.range(from, to).boxed();
    }

    @NotNull
    public static Stream<Long> range(long from, long to) {
        return LongStream.range(from, to).boxed();
    }

    @NotNull
    public static Stream<Integer> rangeClosed(int from, int to) {
        return IntStream.rangeClosed(from, to).boxed();
    }

    @NotNull
    public static Stream<Long> rangeClosed(long from, long to) {
        return LongStream.rangeClosed(from, to).boxed();
    }

    @NotNull
    public static <T> Stream<T> generate(@NotNull Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return new Stream<T>(new ObjGenerate<T>(supplier));
    }

    @NotNull
    public static <T> Stream<T> iterate(@Nullable T seed, @NotNull UnaryOperator<T> op) {
        Objects.requireNonNull(op);
        return new Stream<T>(new ObjIterate<T>(seed, op));
    }

    @NotNull
    public static <T> Stream<T> iterate(@Nullable T seed, @NotNull Predicate<? super T> predicate, @NotNull UnaryOperator<T> op) {
        Objects.requireNonNull(predicate);
        return Stream.iterate(seed, op).takeWhile(predicate);
    }

    @NotNull
    public static <T> Stream<T> concat(@NotNull Stream<? extends T> stream1, @NotNull Stream<? extends T> stream2) {
        Objects.requireNonNull(stream1);
        Objects.requireNonNull(stream2);
        Stream<T> result = new Stream<T>(new ObjConcat<T>(stream1.iterator, stream2.iterator));
        return result.onClose(Compose.closeables(stream1, stream2));
    }

    @NotNull
    public static <T> Stream<T> concat(@NotNull List<? extends Stream<? extends T>> streams) {
        Objects.requireNonNull(streams);
        int size = streams.size();
        ArrayList<Iterator<? extends T>> iterators = new ArrayList<Iterator<? extends T>>(size);
        ArrayList<Stream<T>> closeables = new ArrayList<Stream<T>>(size);
        for (Stream<T> stream : streams) {
            iterators.add(stream.iterator);
            closeables.add(stream);
        }
        Stream result = new Stream(new ObjConcat(iterators));
        return result.onClose(Compose.closeables(closeables));
    }

    @NotNull
    public static <T> Stream<T> concat(@NotNull Iterator<? extends T> iterator1, @NotNull Iterator<? extends T> iterator2) {
        Objects.requireNonNull(iterator1);
        Objects.requireNonNull(iterator2);
        return new Stream<T>(new ObjConcat<T>(iterator1, iterator2));
    }

    @NotNull
    public static <T> Stream<T> concat(@NotNull Iterator<? extends T> iterator1, @NotNull Iterator<? extends T> iterator2, Iterator<? extends T> ... rest) {
        Objects.requireNonNull(iterator1);
        Objects.requireNonNull(iterator2);
        Objects.requireNonNull(rest);
        ArrayList iterators = new ArrayList(rest.length + 2);
        Collections.addAll(iterators, iterator1, iterator2);
        Collections.addAll(iterators, rest);
        return new Stream(new ObjConcat(iterators));
    }

    @NotNull
    public static <F, S, R> Stream<R> zip(@NotNull Stream<? extends F> stream1, @NotNull Stream<? extends S> stream2, @NotNull BiFunction<? super F, ? super S, ? extends R> combiner) {
        Objects.requireNonNull(stream1);
        Objects.requireNonNull(stream2);
        return Stream.zip(stream1.iterator, stream2.iterator, combiner);
    }

    @NotNull
    public static <F, S, R> Stream<R> zip(@NotNull Iterator<? extends F> iterator1, @NotNull Iterator<? extends S> iterator2, @NotNull BiFunction<? super F, ? super S, ? extends R> combiner) {
        Objects.requireNonNull(iterator1);
        Objects.requireNonNull(iterator2);
        return new Stream(new ObjZip<F, S, R>(iterator1, iterator2, combiner));
    }

    @NotNull
    public static <T> Stream<T> merge(@NotNull Stream<? extends T> stream1, @NotNull Stream<? extends T> stream2, @NotNull BiFunction<? super T, ? super T, ObjMerge.MergeResult> selector) {
        Objects.requireNonNull(stream1);
        Objects.requireNonNull(stream2);
        return Stream.merge(stream1.iterator, stream2.iterator, selector);
    }

    public static <T> Stream<T> merge(@NotNull Iterator<? extends T> iterator1, @NotNull Iterator<? extends T> iterator2, @NotNull BiFunction<? super T, ? super T, ObjMerge.MergeResult> selector) {
        Objects.requireNonNull(iterator1);
        Objects.requireNonNull(iterator2);
        return new Stream<T>(new ObjMerge<T>(iterator1, iterator2, selector));
    }

    private Stream(Iterator<? extends T> iterator) {
        this(null, iterator);
    }

    private Stream(Iterable<? extends T> iterable) {
        this(null, new LazyIterator<T>(iterable));
    }

    private Stream(Params params, Iterable<? extends T> iterable) {
        this(params, new LazyIterator<T>(iterable));
    }

    Stream(Params params, Iterator<? extends T> iterator) {
        this.params = params;
        this.iterator = iterator;
    }

    public Iterator<? extends T> iterator() {
        return this.iterator;
    }

    @Nullable
    public <R> R custom(@NotNull Function<Stream<T>, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public Stream<T> prepend(@NotNull Stream<? extends T> stream) {
        return Stream.concat(stream, this);
    }

    @NotNull
    public Stream<T> append(@NotNull Stream<? extends T> stream) {
        return Stream.concat(this, stream);
    }

    @NotNull
    public Stream<T> filter(@NotNull Predicate<? super T> predicate) {
        return new Stream<T>(this.params, new ObjFilter<T>(this.iterator, predicate));
    }

    @NotNull
    public Stream<T> filterIndexed(@NotNull IndexedPredicate<? super T> predicate) {
        return this.filterIndexed(0, 1, predicate);
    }

    @NotNull
    public Stream<T> filterIndexed(int from, int step, @NotNull IndexedPredicate<? super T> predicate) {
        return new Stream<T>(this.params, new ObjFilterIndexed<T>(new IndexedIterator<T>(from, step, this.iterator), predicate));
    }

    @NotNull
    public Stream<T> filterNot(@NotNull Predicate<? super T> predicate) {
        return this.filter(Predicate.Util.negate(predicate));
    }

    @NotNull
    public <TT> Stream<TT> select(final @NotNull Class<TT> clazz) {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return clazz.isInstance(value);
            }
        });
    }

    @NotNull
    public Stream<T> withoutNulls() {
        return this.filter(Predicate.Util.notNull());
    }

    @NotNull
    public Stream<T> nullsOnly() {
        return this.filterNot(Predicate.Util.notNull());
    }

    @NotNull
    public Stream<T> equalsOnly(final @Nullable T object) {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return Objects.equals(value, object);
            }
        });
    }

    @NotNull
    public <R> Stream<R> map(@NotNull Function<? super T, ? extends R> mapper) {
        return new Stream<T>(this.params, new ObjMap<T, R>(this.iterator, mapper));
    }

    @NotNull
    public <R> Stream<R> mapIndexed(@NotNull IndexedFunction<? super T, ? extends R> mapper) {
        return this.mapIndexed(0, 1, mapper);
    }

    @NotNull
    public <R> Stream<R> mapIndexed(int from, int step, @NotNull IndexedFunction<? super T, ? extends R> mapper) {
        return new Stream<T>(this.params, new ObjMapIndexed<T, R>(new IndexedIterator<T>(from, step, this.iterator), mapper));
    }

    @NotNull
    public IntStream mapToInt(@NotNull ToIntFunction<? super T> mapper) {
        return new IntStream(this.params, new ObjMapToInt<T>(this.iterator, mapper));
    }

    @NotNull
    public LongStream mapToLong(@NotNull ToLongFunction<? super T> mapper) {
        return new LongStream(this.params, new ObjMapToLong<T>(this.iterator, mapper));
    }

    @NotNull
    public DoubleStream mapToDouble(@NotNull ToDoubleFunction<? super T> mapper) {
        return new DoubleStream(this.params, new ObjMapToDouble<T>(this.iterator, mapper));
    }

    @NotNull
    public <R> Stream<R> flatMap(@NotNull Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new Stream<T>(this.params, new ObjFlatMap(this.iterator, mapper));
    }

    @NotNull
    public IntStream flatMapToInt(@NotNull Function<? super T, ? extends IntStream> mapper) {
        return new IntStream(this.params, new ObjFlatMapToInt<T>(this.iterator, mapper));
    }

    @NotNull
    public LongStream flatMapToLong(@NotNull Function<? super T, ? extends LongStream> mapper) {
        return new LongStream(this.params, new ObjFlatMapToLong<T>(this.iterator, mapper));
    }

    @NotNull
    public DoubleStream flatMapToDouble(@NotNull Function<? super T, ? extends DoubleStream> mapper) {
        return new DoubleStream(this.params, new ObjFlatMapToDouble<T>(this.iterator, mapper));
    }

    @NotNull
    public <R> Stream<R> mapMulti(final @NotNull BiConsumer<? super T, ? super Consumer<R>> mapper) {
        return this.flatMap(new Function<T, Stream<? extends R>>(){

            @Override
            public Stream<? extends R> apply(T t) {
                SpinedBuffer.Of buffer = new SpinedBuffer.Of();
                mapper.accept(t, buffer);
                return Stream.of(buffer.iterator());
            }
        });
    }

    @NotNull
    public IntStream mapMultiToInt(final @NotNull BiConsumer<? super T, ? super IntConsumer> mapper) {
        return this.flatMapToInt(new Function<T, IntStream>(){

            @Override
            public IntStream apply(T t) {
                SpinedBuffer.OfInt buffer = new SpinedBuffer.OfInt();
                mapper.accept(t, buffer);
                return IntStream.of(buffer.iterator());
            }
        });
    }

    @NotNull
    public LongStream mapMultiToLong(final @NotNull BiConsumer<? super T, ? super LongConsumer> mapper) {
        return this.flatMapToLong(new Function<T, LongStream>(){

            @Override
            public LongStream apply(T t) {
                SpinedBuffer.OfLong buffer = new SpinedBuffer.OfLong();
                mapper.accept(t, buffer);
                return LongStream.of(buffer.iterator());
            }
        });
    }

    @NotNull
    public DoubleStream mapMultiToDouble(final @NotNull BiConsumer<? super T, ? super DoubleConsumer> mapper) {
        return this.flatMapToDouble(new Function<T, DoubleStream>(){

            @Override
            public DoubleStream apply(T t) {
                SpinedBuffer.OfDouble buffer = new SpinedBuffer.OfDouble();
                mapper.accept(t, buffer);
                return DoubleStream.of(buffer.iterator());
            }
        });
    }

    @NotNull
    public Stream<IntPair<T>> indexed() {
        return this.indexed(0, 1);
    }

    @NotNull
    public Stream<IntPair<T>> indexed(int from, int step) {
        return this.mapIndexed(from, step, new IndexedFunction<T, IntPair<T>>(){

            @Override
            @NotNull
            public IntPair<T> apply(int index, T t) {
                return new IntPair(index, t);
            }
        });
    }

    @NotNull
    public Stream<T> distinct() {
        return new Stream<T>(this.params, new ObjDistinct<T>(this.iterator));
    }

    @NotNull
    public <K> Stream<T> distinctBy(@NotNull Function<? super T, ? extends K> classifier) {
        return new Stream<T>(this.params, new ObjDistinctBy<T, K>(this.iterator, classifier));
    }

    @NotNull
    public Stream<T> sorted() {
        return this.sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
        });
    }

    @NotNull
    public Stream<T> sorted(@Nullable Comparator<? super T> comparator) {
        return new Stream<T>(this.params, new ObjSorted<T>(this.iterator, comparator));
    }

    @NotNull
    public <R extends Comparable<? super R>> Stream<T> sortBy(@NotNull Function<? super T, ? extends R> f) {
        return this.sorted(ComparatorCompat.comparing(f));
    }

    @NotNull
    public <K> Stream<Map.Entry<K, List<T>>> groupBy(@NotNull Function<? super T, ? extends K> classifier) {
        Map<K, List<T>> map = this.collect(Collectors.groupingBy(classifier));
        return new Stream<Map.Entry<K, List<T>>>(this.params, map.entrySet());
    }

    @NotNull
    public <K> Stream<List<T>> chunkBy(@NotNull Function<? super T, ? extends K> classifier) {
        return new Stream<List<T>>(this.params, new ObjChunkBy<T, K>(this.iterator, classifier));
    }

    @NotNull
    public Stream<T> sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return this.slidingWindow(1, stepWidth).map(new Function<List<T>, T>(){

            @Override
            public T apply(@NotNull List<T> list) {
                return list.get(0);
            }
        });
    }

    @NotNull
    public Stream<List<T>> slidingWindow(int windowSize) {
        return this.slidingWindow(windowSize, 1);
    }

    @NotNull
    public Stream<List<T>> slidingWindow(int windowSize, int stepWidth) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("windowSize cannot be zero or negative");
        }
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        return new Stream<T>(this.params, new ObjSlidingWindow<T>(this.iterator, windowSize, stepWidth));
    }

    @NotNull
    public Stream<T> peek(@NotNull Consumer<? super T> action) {
        return new Stream<T>(this.params, new ObjPeek<T>(this.iterator, action));
    }

    @NotNull
    public Stream<T> scan(@NotNull BiFunction<T, T, T> accumulator) {
        Objects.requireNonNull(accumulator);
        return new Stream<T>(this.params, new ObjScan<T>(this.iterator, accumulator));
    }

    @NotNull
    public <R> Stream<R> scan(@Nullable R identity, @NotNull BiFunction<? super R, ? super T, ? extends R> accumulator) {
        Objects.requireNonNull(accumulator);
        return new Stream<T>(this.params, new ObjScanIdentity<T, R>(this.iterator, identity, accumulator));
    }

    @NotNull
    public Stream<T> takeWhile(@NotNull Predicate<? super T> predicate) {
        return new Stream<T>(this.params, new ObjTakeWhile<T>(this.iterator, predicate));
    }

    @NotNull
    public Stream<T> takeWhileIndexed(@NotNull IndexedPredicate<? super T> predicate) {
        return this.takeWhileIndexed(0, 1, predicate);
    }

    @NotNull
    public Stream<T> takeWhileIndexed(int from, int step, @NotNull IndexedPredicate<? super T> predicate) {
        return new Stream<T>(this.params, new ObjTakeWhileIndexed<T>(new IndexedIterator<T>(from, step, this.iterator), predicate));
    }

    @NotNull
    public Stream<T> takeUntil(@NotNull Predicate<? super T> stopPredicate) {
        return new Stream<T>(this.params, new ObjTakeUntil<T>(this.iterator, stopPredicate));
    }

    @NotNull
    public Stream<T> takeUntilIndexed(@NotNull IndexedPredicate<? super T> stopPredicate) {
        return this.takeUntilIndexed(0, 1, stopPredicate);
    }

    @NotNull
    public Stream<T> takeUntilIndexed(int from, int step, @NotNull IndexedPredicate<? super T> stopPredicate) {
        return new Stream<T>(this.params, new ObjTakeUntilIndexed<T>(new IndexedIterator<T>(from, step, this.iterator), stopPredicate));
    }

    @NotNull
    public Stream<T> dropWhile(@NotNull Predicate<? super T> predicate) {
        return new Stream<T>(this.params, new ObjDropWhile<T>(this.iterator, predicate));
    }

    @NotNull
    public Stream<T> dropWhileIndexed(@NotNull IndexedPredicate<? super T> predicate) {
        return this.dropWhileIndexed(0, 1, predicate);
    }

    @NotNull
    public Stream<T> dropWhileIndexed(int from, int step, @NotNull IndexedPredicate<? super T> predicate) {
        return new Stream<T>(this.params, new ObjDropWhileIndexed<T>(new IndexedIterator<T>(from, step, this.iterator), predicate));
    }

    @NotNull
    public Stream<T> limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return Stream.empty();
        }
        return new Stream<T>(this.params, new ObjLimit<T>(this.iterator, maxSize));
    }

    @NotNull
    public Stream<T> skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new Stream<T>(this.params, new ObjSkip<T>(this.iterator, n));
    }

    public void forEach(@NotNull Consumer<? super T> action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
        }
    }

    public void forEachIndexed(@NotNull IndexedConsumer<? super T> action) {
        this.forEachIndexed(0, 1, action);
    }

    public void forEachIndexed(int from, int step, @NotNull IndexedConsumer<? super T> action) {
        int index = from;
        while (this.iterator.hasNext()) {
            action.accept(index, this.iterator.next());
            index += step;
        }
    }

    @Nullable
    public <R> R reduce(@Nullable R identity, @NotNull BiFunction<? super R, ? super T, ? extends R> accumulator) {
        R result = identity;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            result = accumulator.apply(result, value);
        }
        return result;
    }

    @Nullable
    public <R> R reduceIndexed(@Nullable R identity, @NotNull IndexedBiFunction<? super R, ? super T, ? extends R> accumulator) {
        return this.reduceIndexed(0, 1, identity, accumulator);
    }

    @Nullable
    public <R> R reduceIndexed(int from, int step, @Nullable R identity, @NotNull IndexedBiFunction<? super R, ? super T, ? extends R> accumulator) {
        R result = identity;
        int index = from;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            result = accumulator.apply(index, result, value);
            index += step;
        }
        return result;
    }

    @NotNull
    public Optional<T> reduce(@NotNull BiFunction<T, T, T> accumulator) {
        boolean foundAny = false;
        Object result = null;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.apply(result, value);
        }
        return foundAny ? Optional.of(result) : Optional.empty();
    }

    @NotNull
    public Object[] toArray() {
        return this.toArray((IntFunction<R[]>)new IntFunction<Object[]>(){

            @Override
            @NotNull
            public Object[] apply(int value) {
                return new Object[value];
            }
        });
    }

    @NotNull
    public <R> R[] toArray(@NotNull IntFunction<R[]> generator) {
        return Operators.toArray(this.iterator, generator);
    }

    @NotNull
    public List<T> toList() {
        ArrayList<T> result = new ArrayList<T>();
        while (this.iterator.hasNext()) {
            result.add(this.iterator.next());
        }
        return result;
    }

    @Nullable
    public <R> R collect(@NotNull Supplier<R> supplier, @NotNull BiConsumer<R, ? super T> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            accumulator.accept(result, value);
        }
        return result;
    }

    @Nullable
    public <R, A> R collect(@NotNull Collector<? super T, A, R> collector) {
        A container = collector.supplier().get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            collector.accumulator().accept(container, value);
        }
        return collector.finisher().apply(container);
    }

    @NotNull
    public Optional<T> min(@NotNull Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.minBy(comparator));
    }

    @NotNull
    public Optional<T> max(@NotNull Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.maxBy(comparator));
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.next();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(@NotNull Predicate<? super T> predicate) {
        return this.match(predicate, 0);
    }

    public boolean allMatch(@NotNull Predicate<? super T> predicate) {
        return this.match(predicate, 1);
    }

    public boolean noneMatch(@NotNull Predicate<? super T> predicate) {
        return this.match(predicate, 2);
    }

    @NotNull
    public Optional<IntPair<T>> findIndexed(@NotNull IndexedPredicate<? super T> predicate) {
        return this.findIndexed(0, 1, predicate);
    }

    @NotNull
    public Optional<IntPair<T>> findIndexed(int from, int step, @NotNull IndexedPredicate<? super T> predicate) {
        int index = from;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            if (predicate.test(index, value)) {
                return Optional.of(new IntPair<T>(index, value));
            }
            index += step;
        }
        return Optional.empty();
    }

    @NotNull
    public Optional<T> findFirst() {
        if (this.iterator.hasNext()) {
            return Optional.of(this.iterator.next());
        }
        return Optional.empty();
    }

    @Nullable
    public T findFirstOrElse(@Nullable T other) {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        return other;
    }

    @NotNull
    public Optional<T> findLast() {
        return this.reduce(new BinaryOperator<T>(){

            @Override
            public T apply(T left, T right) {
                return right;
            }
        });
    }

    @Nullable
    public T single() {
        if (this.iterator.hasNext()) {
            T singleCandidate = this.iterator.next();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("Stream contains more than one element");
            }
            return singleCandidate;
        }
        throw new NoSuchElementException("Stream contains no element");
    }

    @NotNull
    public Optional<T> findSingle() {
        if (this.iterator.hasNext()) {
            T singleCandidate = this.iterator.next();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("Stream contains more than one element");
            }
            return Optional.of(singleCandidate);
        }
        return Optional.empty();
    }

    @NotNull
    public Stream<T> onClose(@NotNull Runnable closeHandler) {
        Objects.requireNonNull(closeHandler);
        Params newParams = Params.wrapWithCloseHandler(this.params, closeHandler);
        return new Stream<T>(newParams, this.iterator);
    }

    @Override
    public void close() {
        if (this.params != null && this.params.closeHandler != null) {
            this.params.closeHandler.run();
            this.params.closeHandler = null;
        }
    }

    private boolean match(@NotNull Predicate<? super T> predicate, int matchKind) {
        boolean kindAll;
        boolean kindAny = matchKind == 0;
        boolean bl = kindAll = matchKind == 1;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            boolean match = predicate.test(value);
            if (!(match ^ kindAll)) continue;
            return kindAny && match;
        }
        return !kindAny;
    }
}

