/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableDoubleFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DoubleFunction<R> {
    public R apply(double var1);

    public static class Util {
        private Util() {
        }

        public static <R> DoubleFunction<R> safe(@NotNull ThrowableDoubleFunction<? extends R, Throwable> throwableFunction) {
            return Util.safe(throwableFunction, null);
        }

        public static <R> DoubleFunction<R> safe(final @NotNull ThrowableDoubleFunction<? extends R, Throwable> throwableFunction, final @Nullable R resultIfFailed) {
            Objects.requireNonNull(throwableFunction);
            return new DoubleFunction<R>(){

                @Override
                public R apply(double value) {
                    try {
                        return throwableFunction.apply(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

