/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.IntConsumer;
import com.annimon.stream.function.LongConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IndexedLongConsumer {
    public void accept(int var1, long var2);

    public static class Util {
        private Util() {
        }

        public static IndexedLongConsumer andThen(final @NotNull IndexedLongConsumer c1, final @NotNull IndexedLongConsumer c2) {
            Objects.requireNonNull(c1, "c1");
            Objects.requireNonNull(c2, "c2");
            return new IndexedLongConsumer(){

                @Override
                public void accept(int index, long value) {
                    c1.accept(index, value);
                    c2.accept(index, value);
                }
            };
        }

        public static IndexedLongConsumer accept(final @Nullable IntConsumer c1, final @Nullable LongConsumer c2) {
            return new IndexedLongConsumer(){

                @Override
                public void accept(int index, long value) {
                    if (c1 != null) {
                        c1.accept(index);
                    }
                    if (c2 != null) {
                        c2.accept(value);
                    }
                }
            };
        }
    }
}

