/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Supplier<T> {
    public T get();

    public static class Util {
        private Util() {
        }

        public static <T> Supplier<T> safe(@NotNull ThrowableSupplier<? extends T, Throwable> throwableSupplier) {
            return Util.safe(throwableSupplier, null);
        }

        public static <T> Supplier<T> safe(final @NotNull ThrowableSupplier<? extends T, Throwable> throwableSupplier, final @Nullable T resultIfFailed) {
            Objects.requireNonNull(throwableSupplier);
            return new Supplier<T>(){

                @Override
                public T get() {
                    try {
                        return throwableSupplier.get();
                    }
                    catch (Throwable ex) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

