/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.operator;

import com.annimon.stream.function.BiFunction;
import com.annimon.stream.iterator.LsaIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class ObjMerge<T>
extends LsaIterator<T> {
    private final Iterator<? extends T> iterator1;
    private final Iterator<? extends T> iterator2;
    private final BiFunction<? super T, ? super T, MergeResult> selector;
    private final Queue<T> buffer1;
    private final Queue<T> buffer2;

    public ObjMerge(@NotNull Iterator<? extends T> iterator1, @NotNull Iterator<? extends T> iterator2, @NotNull BiFunction<? super T, ? super T, MergeResult> selector) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.selector = selector;
        this.buffer1 = new LinkedList<T>();
        this.buffer2 = new LinkedList<T>();
    }

    @Override
    public boolean hasNext() {
        return !this.buffer1.isEmpty() || !this.buffer2.isEmpty() || this.iterator1.hasNext() || this.iterator2.hasNext();
    }

    @Override
    public T nextIteration() {
        if (!this.buffer1.isEmpty()) {
            T v1 = this.buffer1.poll();
            if (this.iterator2.hasNext()) {
                return this.select(v1, this.iterator2.next());
            }
            return v1;
        }
        if (!this.buffer2.isEmpty()) {
            T v2 = this.buffer2.poll();
            if (this.iterator1.hasNext()) {
                return this.select(this.iterator1.next(), v2);
            }
            return v2;
        }
        if (!this.iterator1.hasNext()) {
            return this.iterator2.next();
        }
        if (!this.iterator2.hasNext()) {
            return this.iterator1.next();
        }
        return this.select(this.iterator1.next(), this.iterator2.next());
    }

    private T select(T v1, T v2) {
        MergeResult result = this.selector.apply(v1, v2);
        switch (result) {
            case TAKE_FIRST: {
                this.buffer2.add(v2);
                return v1;
            }
        }
        this.buffer1.add(v1);
        return v2;
    }

    public static enum MergeResult {
        TAKE_FIRST,
        TAKE_SECOND;

    }
}

